/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * 22-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Fixed to not include machine/param.h.
 *
 * 30-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 

#define	ROSETTA_0

#ifdef	KERNEL
#define	KDB	1
/*#define	DEBUG	1*/
#define	SYMBOLIC	1
#endif	KERNEL

#if	KDB
#include "mach.h"
#endif	KDB

/*      defs.h  4.3     82/12/19        */
/*
 * adb - vax string table version; common definitions
 */

#ifdef	KERNEL
#if	MACH
#include "../h/types.h"
#include "../vm/vm_map.h"
#else	MACH
#include "../machine/pte.h"
#endif	MACH
#else	KERNEL
#include <machine/pte.h>
#endif	KERNEL

#ifdef	KDB
#include "../ca/kdb/kdbdefine.h"
#endif	KDB

#ifdef	KERNEL
#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#else	KERNEL
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <a.out.h>
#endif	KERNEL

#include <ctype.h>

#include "../ca/kdb/kdb_mac.h"
#include "../ca/kdb/kdb_mode.h"
#include "../ca/kdb/kdb_head.h"
#include "../ca/kdb/kdb_symtab.h"

/*#define	page_mask	0xfff		/*XXX*/

#ifdef	KDB
#define	BUFSIZ	1024	/* from stdio.h */

#include <setjmp.h>
jmp_buf exitbuffer;
/*extern int	exit_rval;*/
#define setexit() (setjmp(exitbuffer) ? kdbexit_rval : 0) 
#define reset(i)  { kdbexit_rval = (i); longjmp(exitbuffer); }
#ifdef	notdef
#define setexit()	setjmp(exitbuffer)
#define reset(i)	longjmp(exitbuffer,(i))
#endif	notdef

#include "../ca/scr.h"
#endif	KDB

#ifdef	CMU
#ifdef	KDB
#define DBNAME	"kdb"
#else	KDB
#define DBNAME	"adb"
#endif	KDB
#endif	CMU

/* access modes */
#define RD      0
#define WT      1
#define NSP     0	/* = */
#define ISP     1	/* ? */
#define DSP     2	/* / */
#define STAR    4
#define STARCOM 0200
/*
 * Symbol types, used internally in calls to findsym routine.
 * On the VAX this all degenerates since I & D symbols are indistinct.
 * Basically we get NSYM==0 for = command, ISYM==DSYM otherwise.
 */
#define NSYM    0
#define DSYM    1               /* Data space symbol */
#define ISYM    DSYM            /* Instruction space symbol == DSYM on VAX */

#define BKPTSET 1
#define BKPTEXEC 2

#define USERPS  PSL
#define USERPC  PC

#define BPT 0xBD00                  /* trap (breakpoint) inst */
#define BPMASK 0xFFFF               /* mask for clearing word to OR in BPT */

/* These values must match the switch statement in kernel routine procxmt */

#define SETTRC  0
#define RDUSER  2
#define RIUSER  1
#define WDUSER  5
#define WIUSER  4
#define RUREGS  3
#define WUREGS  6
#define CONTIN  7
#define EXIT    8
#define SINGLE  9

/* variables in the u area are accessed by their offset into the u area */

#define USTRUCT (UPAGES*NBPG - sizeof(struct user))

#ifdef	KDB
#else	KDB
#include "offsets.h"	/* offsets from USTRUCT constructed by Mkoffset */
#endif	KDB
#define R0 (USTRUCT - 18*sizeof(int))
#define R1 (R0 + sizeof(int))
#define R2 (R1 + sizeof(int))
#define R3 (R2 + sizeof(int))
#define R4 (R3 + sizeof(int))
#define R5 (R4 + sizeof(int))
#define R6 (R5 + sizeof(int))
#define R7 (R6 + sizeof(int))
#define R8 (R7 + sizeof(int))
#define R9 (R8 + sizeof(int))
#define R10 (R9 + sizeof(int))
#define R11 (R10 + sizeof(int))
#define R12 (R11 + sizeof(int))
#define R13 (R12 + sizeof(int))
#define R14 (R13 + sizeof(int))
#define R15 (R14 + sizeof(int))

#define IAR (R15 + sizeof(int))
#define MQ (IAR + sizeof(int))
#define ICSCS (R0 - sizeof(int))

#define PC IAR

/* here's some mystical stuff */

#ifdef	romp	/* a nice large offset from symbols */
#define MAXOFF  0xffff
#else	romp
#define MAXOFF  0x8000
#endif	romp
#define MAXPOS  80
#define MAXLIN  128
#define EOR     '\n'
#define QUOTE   0200
#define EVEN    (-2)

#define ONEBYTE(i) ((unsigned)(i)>>24)  /* assumes argument is a long */

#define shorten(a)      ((short)(a))

/* result type declarations */

L_INT           inkdot();
POS             get();
POS             chkget();
STRING          exform();
L_INT           round();
BKPTR           scanbkpt();
VOID            fault();
ADDR		traceOffStack();

#if	KDB
#if	MACH
vm_map_t	*curmap;	/* vm map for selected process */
struct  pcb     *curpcb;        /* pcb for selected process */
int             curpid;         /* process id when entering debugger */
#endif	MACH
struct nlist	*cursym;		/* current symbol */
struct nlist 	*symtab, *esymtab;	/* begin. and end of symbol table */
#endif	KDB

struct  pcb     pcb;

#ifdef	KDB
#else	KDB
struct  proc     proc;
#endif	KDB

int     kernel;
int     kcore;
struct  pte *sbr;
int     slr;
int     masterpcbb;
#ifdef	romp
#include <machine/mmu.h>
int RTA_HASHMASK;
int physmem;	 /* in clicks */
struct hatipt_entry *RTA_HATIPT;
#endif	romp

ADDR StackBottom;	/* Kernel's view of Bottom (low addr) of stack for
			 *running process. */

ADDR DataTop;		/* Kernel's view of highest virtual data address. */

ADDR AddrR15;		/* Stack address of saved link register
			 * for current frame. Set as a side effect in
			 * searchForRegs() */

ADDR CalledFromAddr;	/* Address current function was called from.
			 * Assignment is side effect in validSavedLink. */

#ifdef	KDB
#define	symTableIsPresent(dummy)	(symtab)
#else	KDB
#define symTableIsPresent(dummy)	filhdr.a_syms
#endif	KDB

int 	debug;
#ifdef DEBUG
#define dprintf(x)	if(debug) printf x
#else
#define dprintf(x)
#endif


