/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: machine.h,v 5.0 86/01/31 20:44:18 ibmacis ibm42a $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/machine.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidmachine = "$ Header: machine.h,v 5.0 86/01/31 20:44:18 ibmacis ibm42a $";
#endif

/*      machine.h       4.1     81/05/14        */
#ifdef	KDB
#else	KDB
#include <sys/vm.h>
#define PAGSIZ (NBPG*CLSIZE)
#define DBNAME "adb\n"
#define TXTRNDSIZ PAGSIZ
#endif	KDB

#define LPRMODE "%R"
#define OFFMODE "+%R"
#define MAXINT  0x7fffffff
#define MAXFILE 0xffffffff
/*
 * INKERNEL tells whether its argument is a kernel space address.
 * KVTOPH trims a kernel virtal address back to its offset
 * in the kernel address space.
 */
#ifdef	romp
#define INKERNEL(x) (0)
#else	romp
#define INKERNEL(x) ((unsigned)(x) >= SYSBASE)
#endif	romp
#ifdef	KDB
#else	KDB
#define KVTOPH(x)   ((x) & 0x0fffffff)
#endif	KDB

#define WORDALIGN(a) ((a) & ~3)


/* A structure describing everything we'd like to know about a routine
   from its in-text trace table. */
typedef struct rtn_descr {
	int	rtype;			/* type of routine */
	int	first_gpr;		/* First saved register. */
	int	param_words;		/* Number of parameter words. */
	int	local_offset;		/* Words from FP to top of stack.
					 * Converted to bytes in unPack. */
	int	frame_reg;		/* Register containing frame ptr. */
	char	wflg;			/* w field present if !0. */
	char	xflg;			/* x field present if !0. */
	char	yflg;			/* y field present if !0. */
	char	zflg;			/* z field present if !0. */
	char	offset_size;		/* Size of offset field. */
					/* > 0 => register number */
} TTABLE;

TTABLE TraceTable;	/* The global trace table. */

