/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: main.c,v 5.0 86/01/31 20:44:32 ibmacis ibm42a $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/main.c,v $ */

#ifndef lint
static char *rcsid = "$ Header: main.c,v 5.0 86/01/31 20:44:32 ibmacis ibm42a $";
#endif

/*
 * adb - main command loop and error/interrupt handling
 */
#include "../ca/kdb/kdb_defs.h"
#ifdef	KDB
#else	KDB
#include <setjmp.h>
jmp_buf env;
#endif	KDB

int	kdbexit_rval;

#ifdef	KDB
L_INT		dot;
#endif	KDB

MSG             NOEOR;
INT             mkfault;
INT             executing;
INT             infile;
CHAR            *lp;
L_INT           maxoff;
L_INT           maxpos;
ADDR            sigint;
ADDR            sigqit;
INT             wtflag;
L_INT           maxfile;
STRING          errflg;
L_INT           exitflg;
CHAR            lastc;
INT             eof;
INT             lastcom;
long    maxoff = MAXOFF;
long    maxpos = MAXPOS;
#ifdef	KDB
#else	KDB
char    *Ipath = "/usr/lib/adb";
extern char *date;
#endif	KDB

#ifdef	KDB
kdb(type, curproc)
	int		type;
	struct proc	*curproc;
#else	KDB
main(argc, argv)
        register char **argv;
        int argc;
#endif	KDB
{
#ifdef	KDB
	{
	    extern ADDR userpc;
	    extern int pid;
	    extern int kdbintr;

#ifdef	notdef
	    userpc = dot = pcb.pcb_regs.r_pc;
#endif	notdef
#if	MACH
	    if (curproc) {
		
		/*
	     	 *	Get the map for the current process
		 */
		kdbgetprocess(curproc, &curmap, &curpcb);
		curpid = curproc->p_pid;
		var[varchk('m')] = (int)curmap;
	    }
	    else {
		/*
		 *	if there's no process...
		 */
		curmap = NULL;	/* take our chances */
		curpid = 1;	/* fake */
	    }
	    /*
	     *	But the pcb is the saved set of registers
	     */
	    userpc = dot = pcb.pcb_iar;
	    pid    = curpid;
	    curpcb = &pcb;
#else	MACH
	    pid = 1;
#endif	MACH
#ifdef	notdef
	    var[varchk('t')] = (int)trapsp;
#endif	notdef
	}
	maxoff = 0x100000;
	wtflag = 1;
	kcore = 1;
	flushbuf();
#ifdef	DEBUG
	{
		extern long loopcnt;
		printf("loop=%d\n", loopcnt);
	}
#endif	DEBUG
	switch (setexit())
	{
	    case SINGLE:
#ifdef	DEBUG
		printf("S ");
#endif	DEBUG
#ifdef	notdef
		pcb.pcb_regs.r_sr |= PSL_T;
#endif	notdef
		pcb.pcb_icscs |= ICSCS_INSTSTEP;
		kdbintr = 1;
		/* fall through */
	    case CONTIN:
#ifdef	DEBUG
		printf("CONT=>\n");
#endif	DEBUG
		return(1);
	    case 0:
#ifdef	DEBUG
		printf("nextpcs(%d)\n", 0);
#endif	DEBUG
		if (nextpcs(0, 0))
		    printf("breakpoint%16t");
		else
		    printf("stopped at%16t");
		printpc();
	}
#else	KDB
/*	mach_init(); XXX */
another:
        if (argc>1) {
                if (eqstr("-w", argv[1])) {
                        wtflag = 2;             /* suitable for open() */
                        argc--, argv++;
                        goto another;
                }
                if (eqstr("-k", argv[1])) {
                        kernel = 1;
                        argc--, argv++;
                        goto another;
		}
                if (eqstr("-d", argv[1])) {
                        debug = 1;	/* put out debugging printfs */
                        argc--, argv++;
                        goto another;
		}
		if (argv[1][0] == '-' && argv[1][1] == 'I') {
                        Ipath = argv[1]+2;
                        argc--, argv++;
                }
        }
        if (argc > 1)
                symfil = argv[1];
        if (argc > 2)
                corfil = argv[2];
        xargc = argc;
	printf("adb version of %s.\n",date);
        setsym(); setcor(); setvar();
        if ((sigint=signal(SIGINT,SIG_IGN)) != SIG_IGN) {
                sigint = fault;
                signal(SIGINT, fault);
        }
        sigqit = signal(SIGQUIT, SIG_IGN);
        setjmp(env);
#endif	KDB
        if (executing)
                delbp();
        executing = 0;
        for (;;) {
                flushbuf();
                if (errflg) {
                        printf("%s\n", errflg);
                        exitflg = 1 /*errflg*/;
                        errflg = 0;
                }
                if (mkfault) {
                        mkfault=0;
                        printc('\n');
                        prints(DBNAME);
                }
                lp=0; rdc(); lp--;
                if (eof) {
#ifdef	KDB
			return(1);
#else	KDB
                        if (infile) {
                                iclose(-1, 0); eof=0; longjmp(env,0);
                        } else
                                done();
#endif	KDB
                } else
                        exitflg = 0;
                command(0, lastcom);
                if (lp && lastc!='\n')
                        error(NOEOR);
        }
}

#ifdef	KDB
#else	KDB
done()
{
        endpcs();
        exit(exitflg);
}
#endif	KDB

L_INT
round(a,b)
REG L_INT a, b;
{
        REG L_INT w;
        w = (a/b)*b;
        IF a!=w THEN w += b; FI
        return(w);
}
/*
 * If there has been an error or a fault, take the error.
 */
chkerr()
{
        if (errflg || mkfault)
                error(errflg);
}
/*
 * An error occurred; save the message for later printing,
 * close open files, and reset to main command loop.
 */
error(n)
        char *n;
{
        errflg = n;
#ifdef	KDB
	reset(1);
#else	KDB
        iclose(0, 1); oclose();
        longjmp(env,0);
#endif	KDB
}

#ifdef	KDB
#else	KDB
/*
 * An interrupt occurred; reset the interrupt
 * catch, seek to the end of the current file
 * and remember that there was a fault.
 */
fault(a)
{
        signal(a, fault);
        lseek(infile, 0L, 2);
        mkfault++;
}
#endif	KDB

