/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: opset.c,v 5.0 86/01/31 20:45:46 ibmacis ibm42a $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/opset.c,v $ */

#ifndef lint
static char *rcsid = "$ Header: opset.c,v 5.0 86/01/31 20:45:46 ibmacis ibm42a $";
#endif

/*
 *      UNIX debugger
 *      Instruction printing routines.
 *      MACHINE DEPENDENT
 */
#include "../ca/kdb/kdb_defs.h"
 
INT dotinc;
 
printins( insadr, ins )
  long insadr;
  long ins;
{
  char ibuf[80];
  register char *cp;
  register lens, i;
 
  lens = unasm( ins, insadr, ibuf );
  cp = ibuf+22;
  for( i = (lens>>3)-22-3; i-- > 0; )
    printc( *cp++ );
  dotinc = lens & 7;
}
