/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * $Log:	kdb_output.c,v $
 * Revision 2.2  88/07/20  16:13:03  rpd
 * Support for varying the length of symbol names.  Allow for %.*s format.
 * 
 * 20-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed variable 'signed' to 'Signed' to avoid conflicts
 *	with the ansi-C keyword, as recognized by the metaware
 *	C compiler.
 *
 * 29-Mar-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Fixed a couple of compiler warnings.
 *
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: output.c,v 5.2 86/02/17 17:25:11 ibmacis Exp $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/output.c,v $ */

#ifndef lint
static char *rcsid = "$ Header: output.c,v 5.2 86/02/17 17:25:11 zittin Exp $";
#endif

/*
 *
 *      UNIX debugger
 *
 */
#include "../ca/kdb/kdb_defs.h"
#ifdef	KDB
#else	KDB
#include <stdio.h>
#endif	KDB

INT             mkfault;
INT             infile;
INT             outfile = 1;
L_INT           maxpos;
L_INT           maxoff;
INT             radix = 16;
CHAR            printbuf[MAXLIN];
CHAR            *printptr = printbuf;
CHAR            *digitptr;
MSG             TOODEEP;

STRING		prtdest;	/* flag for sprintf/sprintf */

#define	PRINTC(c)	if (prtdest) *prtdest++ = c; else printc(c)

eqstr(s1, s2)
        REG STRING      s1, s2;
{
        REG STRING       es1;
        WHILE *s1++ == *s2
        DO IF *s2++ == 0
           THEN return(1);
           FI
        OD
        return(0);
}
length(s)
        REG STRING              s;
{
        INT             n = 0;
        WHILE *s++ DO n++; OD
        return(n);
}
printc(c)
        CHAR            c;
{
        CHAR            d;
        STRING          q;
        INT             posn, tabs, p;
        IF mkfault
        THEN    return;
        ELIF (*printptr=c)==EOR
        THEN tabs=0; posn=0; q=printbuf;
             FOR p=0; p<printptr-printbuf; p++
             DO d=printbuf[p];
                IF (p&7)==0 ANDF posn
                THEN tabs++; posn=0;
                FI
                IF d==SP
                THEN posn++;
                ELSE WHILE tabs>0 DO *q++=TB; tabs--; OD
                     WHILE posn>0 DO *q++=SP; posn--; OD
                     *q++=d;
                FI
             OD
             *q++=EOR;
#ifdef EDDT
	     printptr=printbuf; do putchar(*printptr++); while (printptr<q);
#else
             write(outfile,printbuf,q-printbuf);
#endif
             printptr=printbuf;
        ELIF c==TB
        THEN *printptr++=SP;
             WHILE (printptr-printbuf)&7 DO *printptr++=SP; OD
        ELIF c
        THEN printptr++;
        FI
        IF printptr >= &printbuf[MAXLIN-9] THEN
                write(outfile, printbuf, printptr - printbuf);
                printptr = printbuf;
        FI
}
charpos()
{       return(printptr-printbuf);
}
flushbuf()
{       IF printptr!=printbuf
        THEN PRINTC(EOR);
        FI
}

/* VARARGS */
printf(fmat,a1,a2,a3)
        STRING          fmat;
        STRING          *a1,*a2,*a3;
{
	prtdest = 0;
	genprintf(fmat,a1,a2,a3);
}

/* VARARGS */
sprintf(dest,fmat,a1,a2,a3)
	STRING		dest;
        STRING          fmat;
        STRING          *a1,*a2,*a3;
{
	prtdest = dest;
	genprintf(fmat,a1,a2,a3);
	*prtdest = '\0';
	prtdest = 0;
}

/* VARARGS */
genprintf(fmat,a1,a2,a3)	/* hack to implement sprintf and printf */
        STRING          fmat;
        STRING          *a1,*a2,*a3;
{
        STRING          fptr, s;
        L_INT           *dptr;
        L_REAL          *rptr;
        INT             width, prec;
        CHAR            c, adj;
        INT             x, decpt, n;
        L_INT           lx;
        CHAR            digits[64];
	INT		Signed;
        fptr = fmat; dptr = (L_INT *)&a1;
        WHILE c = *fptr++
        DO  IF c!='%'
            THEN PRINTC(c);
            ELSE IF *fptr=='-'
                 THEN adj='l'; fptr++;
                 ELSE adj='r';
                 FI
                 width=convert(&fptr);
                 IF *fptr=='.'
                 THEN fptr++;
		      IF *fptr=='*'
		      THEN fptr++;
			   prec = *dptr++;
		      ELSE prec=convert(&fptr);
		      FI
                 ELSE prec = -1;
                 FI
		 IF *fptr=='+'
		 THEN fptr++; Signed = 1;
		 ELSE Signed = 0;
		 FI
                 digitptr=digits;
                 rptr=(L_REAL *)dptr;
                 x = lx = *dptr++;
                 s=0;
                 switch (c = *fptr++) {
                    case 'd':
                    case 'u':
                        printnum(x,c,10); break;
                    case 'o':
/*			sprintf(s=digits, "%#o", lx); */
			printoct(lx,0); break;
                    case 'q':
                        lx=x; printoct(lx,-1); break;
                    case 'x':
/*			sprintf(s=digits, "%#06x", lx); */
			printhex(lx); break;
                    case 'r':
/*                        printdbl(lx=x,c,radix); */
			if (Signed)
				printnum(lx=x,'+',radix);
			else
				printnum(lx=x,c,radix);
			break;
                    case 'R':
/*                        printdbl(lx,c,radix); */
			printnum(lx,(Signed ? '+' : c),radix);
			break;
                    case 'Y':
                        printdate(lx); break;
                    case 'D':
                    case 'U':
/*			sprintf(s=digits, "%u", lx); */
			printnum(lx,c,10); break;
                    case 'O':
                        printoct(lx,0); break;
                    case 'Q':
                        printoct(lx,-1); break;
                    case 'X':
/*			sprintf(s=digits, "%#010x", lx); */
			printhex(lx); break;
                    case 'c':
                        PRINTC( (x>127 || x<32) ? '_' : x ); break;
                    case 's':
                        s=(STRING)lx; break;
#ifdef	notdef
/* don't want to figure out how to print floating point nums  DPJ */
                    case 'f':
                        dptr++;
                        sprintf(s=digits,"%.8g",*rptr);
                        prec= -1;
                        break;
                    case 'F':
                        dptr++;
                        sprintf(s=digits,"%.17g",*rptr);
                        prec= -1;
                        break;
#endif	notdef
                    case 'm':
                        break;
                    case 'M':
                        width=x; break;
                    case 'T':
                    case 't':
                        IF c=='T'
                        THEN width=x;
                        ELSE dptr--;
                        FI
                        IF width
                        THEN width -= charpos()%width;
                        FI
                        break;
                    default:
                        PRINTC(c); dptr--;
                }
                IF s==0
                THEN *digitptr=0; s=digits;
                FI
                n=length(s);
                n=(prec<n ANDF prec>=0 ? prec : n);
                width -= n;
                IF adj=='r'
                THEN WHILE width-- > 0
                     DO PRINTC(SP); OD
                FI
                WHILE n-- DO PRINTC(*s++); OD
                WHILE width-- > 0 DO PRINTC(SP); OD
                digitptr=digits;
            FI
        OD
}
 
printdate(tvec)
        L_INT           tvec;
{
        REG INT         i;
        REG STRING      timeptr;
#ifdef	KDB
	timeptr = "???";
#else	KDB
#ifndef EDDT
        timeptr = ctime(&tvec);
#else
        timeptr="????????????????????????";
#endif
#endif	KDB
        FOR i=20; i<24; i++ DO *digitptr++ = *(timeptr+i); OD
        FOR i=3; i<19; i++ DO *digitptr++ = *(timeptr+i); OD
}
 
prints(s)
        char *s;
{
        printf("%s",s);
}
 
newline()
{
        PRINTC(EOR);
}
 
convert(cp)
        REG STRING      *cp;
{
        REG CHAR        c;
        INT             n = 0;
 
        WHILE ((c = *(*cp)++)>='0') ANDF (c<='9') DO n=n*10+c-'0'; OD
        (*cp)--;
        return(n);
}
 
printnum(n,fmat,base)
#if	KDB
	int n;
	char fmat;
	int base;
{
	register int k;
	register unsigned un;
	char digs[15];
	register char *dptr = digs;

	/*
	 * if signs are wanted, put 'em out
	 */
	switch(fmat){
	case 'r':
	case 'R':
		if (base != 10) break;
	case '+':
	case 'd':
	case 'D':
	case 'q':
	case 'Q':
		if (n < 0) {
			n = -n;
			*digitptr++ = '-';
		}
		break;
	}
	/*
	 * put out radix
	 */
	switch(base) {
	default:
		break;
	case 010:
		*digitptr++ = '0';
		break;
	case 0x10:
		*digitptr++ = '0';
		*digitptr++ = 'x';
		break;
	}
	un = n;
	while (un) {
		*dptr++ = un % base;
		un /= base;
	}
	if (dptr == digs)
		*dptr++ = 0;
	while (dptr != digs) {
		k = *--dptr;
		*digitptr++ = k + (k <= 9 ? '0' : 'a'-10);
	}
}

#else	KDB
        REG INT         n;
{
        REG CHAR        k;
        REG INT         *dptr;
        INT             digs[15];
 
        dptr=digs;
        IF n<0 ANDF fmat=='d' THEN n = -n; *digitptr++ = '-'; FI
        n &= 0xffff;
        WHILE n
        DO  *dptr++ = ((POS)(n&0xffff))%base;
            n=((POS)(n&0xffff))/base;
        OD
        IF dptr==digs THEN *dptr++=0; FI
        WHILE dptr!=digs
        DO  k = *--dptr;
            *digitptr++ = (k+(k<=9 ? '0' : 'a'-10));
        OD
}
#endif	KDB
 
printoct(o,s)
        L_INT           o;
        INT             s;
{
        INT             i;
        L_INT           po = o;
        CHAR            digs[12];
 
        IF s
        THEN IF po<0
             THEN po = -po; *digitptr++='-';
             ELSE IF s>0 THEN *digitptr++='+'; FI
             FI
        FI
        FOR i=0;i<=11;i++
        DO digs[i] = po&7; po >>= 3; OD
        digs[10] &= 03; digs[11]=0;
        FOR i=11;i>=0;i--
        DO IF digs[i] THEN break; FI OD
        FOR i++;i>=0;i--
        DO *digitptr++=digs[i]+'0'; OD
}
 
printhex( x )
	register int x;
{
	int i;
	char digs[8];
	static char hexe[]="0123456789abcdef";

	for (i = 0; i<=7; i++) {
		digs[i] = x & 0xf;
		x >>= 4;
	}
	for (i = 7; i > 0; i--)
		if (digs[i])
			break;
	for (i; i>=0; i--)
		*digitptr++ = hexe[digs[i]];
}

#ifdef	notdef
printdbl(lxy,fmat,base)
        L_INT lxy;
        char fmat;
        int base;
{
        int digs[20];
        int *dptr;
        char k;
 
        register char *cp1 = digs;
        if( (lxy&0xFFFF0000L) == 0xFFFF0000L ){
                *cp1++='-';
                lxy= -lxy;
        }
        sprintf( cp1, (base==16 ? "%#x" : "%D"), lxy );
        FOR cp1 = digs; *digitptr++ = *cp1++; DO OD
        --digitptr;
}
#endif	notdef
 
#define MAXIFD  5
struct {
        int     fd;
        int     r9;
} istack[MAXIFD];
int     ifiledepth;
 
#ifdef	KDB
#else	KDB
iclose(stack, err)
{
        IF err
        THEN    IF infile
                THEN    close(infile); infile=0;
                FI
                WHILE --ifiledepth >= 0
                DO      IF istack[ifiledepth].fd
                        THEN    close(istack[ifiledepth].fd);
                        FI
                OD
                ifiledepth = 0;
        ELIF stack == 0
        THEN    IF infile
                THEN    close(infile); infile=0;
                FI
        ELIF stack > 0
        THEN    IF ifiledepth >= MAXIFD
                THEN    error(TOODEEP);
                FI
                istack[ifiledepth].fd = infile;
                istack[ifiledepth].r9 = var[9];
                ifiledepth++;
                infile = 0;
        ELSE    IF infile
                THEN    close(infile); infile=0;
                FI
                IF ifiledepth > 0
                THEN    infile = istack[--ifiledepth].fd;
                        var[9] = istack[ifiledepth].r9;
                FI
        FI
}
 
oclose()
{
        IF outfile!=1
        THEN    flushbuf(); close(outfile); outfile=1;
        FI
}
#endif	KDB
 
endline()
{
        if (maxpos <= charpos())
                printf("\n");
}
