/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * 13-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Implemented :J.
 *
 * 29-Mar-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Fixed a couple of compiler warnings.
 *
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: pcs.c,v 5.0 86/01/31 20:46:47 ibmacis ibm42a $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/pcs.c,v $ */

#ifndef lint
static char *rcsid = "$ Header: pcs.c,v 5.0 86/01/31 20:46:47 ibmacis ibm42a $";
#endif

#ifndef lint
static	char sccsid[] = "@(#)pcs.c	4.2 8/11/83";
#endif
/*
 *
 *	UNIX debugger
 *
 */

#include "../ca/kdb/kdb_defs.h"
#ifdef	KDB
#include	"../ca/kdb/kdb_pcs.h"
#endif	KDB

MSG		NOBKPT;
MSG		SZBKPT;
MSG		EXBKPT;
MSG		NOPCS;
MSG		BADMOD;

/* breakpoints */
BKPTR		bkpthead;

CHAR		*lp;
CHAR		lastc;

INT		signo;
L_INT		dot;
INT		pid;
L_INT		cntval;
L_INT		loopcnt;

L_INT		entrypt;
INT		adrflg;



/* sub process control */

subpcs(modif)
{
	REG INT		check;
	INT		execsig,runmode;
	REG BKPTR	bkptr;
	STRING		comptr;
	execsig=0; loopcnt=cntval;

	switch (modif) {

	    /* delete breakpoint */
#ifdef	KDB
	    case 'd':
#else	KDB
	    case 'd': case 'D':
#endif	KDB
		IF (bkptr=scanbkpt(dot))
		THEN bkptr->flag=0; return;
		ELSE error(NOBKPT);
		FI

	    /* set breakpoint */
#ifdef	KDB
	    case 'b':
#else	KDB
	    case 'b': case 'B':
#endif	KDB
		IF (bkptr=scanbkpt(dot))
		THEN bkptr->flag=0;
		FI
		FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
		DO IF bkptr->flag == 0
		   THEN break;
		   FI
		OD
		IF bkptr==0
		THEN IF (bkptr=(BKPTR)sbrk(sizeof *bkptr)) == (BKPTR)(-1)
		     THEN error(SZBKPT);
		     ELSE bkptr->nxtbkpt=bkpthead;
			  bkpthead=bkptr;
		     FI
		FI
		bkptr->loc = dot;
		bkptr->initcnt = bkptr->count = cntval;
		bkptr->flag = BKPTSET;
		check=MAXCOM-1; comptr=bkptr->comm; rdc(); lp--;
		REP *comptr++ = readchar();
		PER check-- ANDF lastc!=EOR DONE
		*comptr=0; lp--;
		IF check
		THEN return;
		ELSE error(EXBKPT);
		FI

#ifdef	KDB
#else	KDB
	    /* exit */
	    case 'k' :case 'K':
		IF pid
		THEN printf("%d: killed", pid); endpcs(); return;
		FI
		error(NOPCS);

	    /* run program */
	    case 'r': case 'R':
		endpcs();
		setup(); runmode=CONTIN;
		IF adrflg 
		THEN IF !scanbkpt(dot) THEN loopcnt++; FI
		ELSE IF !scanbkpt(entrypt+2) THEN loopcnt++; FI
		FI
		break;
#endif	KDB

	    /* single step */
	    case 's': case 'S':
#ifdef	KDB
#ifdef	DEBUG
		printf("subpcs: single-step\n");
#endif	DEBUG
		execsig = getsig(signo);
		sstepmode = STEP_NORM;
		runmode = SINGLE;
#else	KDB
		IF pid
		THEN
			runmode=SINGLE; execsig=getsig(signo);
		ELSE setup(); loopcnt--;
		FI
#endif	KDB
		break;

#ifdef	KDB
	    case 'p': case 'P':
		runmode = SINGLE;
		execsig = getsig(signo);
		sstepmode = STEP_PRINT;
		break;

	    case 'j': 
	    case 'J':
		runmode = SINGLE;
		execsig = getsig(signo);
		sstepmode = isupper(modif) ? STEP_RETURN : STEP_CALLT;
		call_depth = 1;
		icount = 0;
		break;
#endif	KDB

	    /* continue with optional signal */
#ifdef	KDB
	    case 'c':
#else	KDB
	    case 'c': case 'C': case 0:
		IF pid==0 THEN error(NOPCS); FI
#endif	KDB
		runmode=CONTIN; execsig=getsig(signo);
#ifdef	KDB
		sstepmode = STEP_NONE;
#endif	KDB
		break;

	    default: error(BADMOD);
	}

#ifdef	KDB
	IF loopcnt > 0 THEN
#ifdef	DEBUG
		printf("subpcs: runpcs(%d, 0)\n", runmode);
#endif	DEBUG
		runpcs(runmode, 0);
	FI
#else	KDB
	IF loopcnt>0 ANDF runpcs(runmode,execsig)
	THEN printf("breakpoint%16t");
	ELSE printf("stopped at%16t");
	FI
	delbp();
	printpc();
#endif	KDB
}

