/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * 25-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Fixed :J.
 *
 * 13-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Fixed :j to understand brx r15. Implemented :J.
 *
 * 11-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Avoid printing "kernel: running" when in single-step mode, so as
 *	not to annoy Bill.
 *
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: runpcs.c,v 5.0 86/01/31 20:48:25 ibmacis ibm42a $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/runpcs.c,v $ */

#ifndef lint
static char *rcsid = "$ Header: runpcs.c,v 5.0 86/01/31 20:48:25 ibmacis ibm42a $";
#endif

/*
 *
 *      UNIX debugger
 *
 */
#include "../ca/kdb/kdb_defs.h"
#include "../ca/kdb/kdb_pcs.h"

#ifdef	KDB
INT		mkfault;
#define		PCFUDGE		(0)
int		pcfudge = 0;
#endif	KDB
extern  MAP     txtmap;
MSG             NOFORK;
MSG             ENDPCS;
MSG             BADWAIT;
CHAR            *lp;
ADDR            sigint;
ADDR            sigqit;
/* breakpoints */
BKPTR           bkpthead;
REGLIST         reglist[];
CHAR            lastc;
INT             fcor;
INT             fsym;
STRING          errflg;
L_INT           errno;
INT             signo;
INT             sigcode;
L_INT           dot;
STRING          symfil;
INT             wtflag;
INT             pid;
L_INT           expv;
INT             adrflg;
L_INT           loopcnt;

extern int kdbexit_rval;

#ifdef PTRACEDEBUG
#include <stdio.h>
#define PTRACE(a,b,c,d) DEBUG_ptrace(a,b,c,d,__LINE__,__FILE__)
int DEBUG_ptrace(a,b,c,d,l,f)
int a, b, *c, d, l;
char *f;
{
int ret_val;
fprintf(stderr,"ptrace:%d:%s:%d %x %x\n",l,f,a,c,d);
ret_val = ptrace(a,b,c,d);
if (ret_val != 0) perror("ptrace");
return(ret_val);
}
#else
#define PTRACE(a,b,c,d) ptrace(a,b,c,d)
#endif

/* service routines for sub process control */
getsig(sig)
{       return(expr(0) ? expv : sig);
}
ADDR userpc = 1;
runpcs(runmode,execsig)
{
        INT             rc;
        REG BKPTR       bkpt;
        IF adrflg THEN userpc=dot; FI
#if	KDB
	if (runmode == CONTIN) {
		printf("kernel: running\n");
	}
#else	KDB
        printf("%s: running\n", symfil);
        WHILE --loopcnt>=0
        DO
#endif	KDB
#ifdef DEBUG
                if(debug) printf("\ncontinue %x %d\n",userpc,execsig);
#endif
                IF runmode==SINGLE
                THEN delbp(); /* hardware handles single-stepping */
                ELSE /* continuing from a breakpoint is hard */
#ifdef	KDB
#ifdef	notdef
			IF runmode == CONTIN
			THEN
#ifdef	DEBUG
				printf("runpcs: setting pcfudge to %d\n", PCFUDGE);
#endif	DEBUG
				pcfudge = PCFUDGE;
			FI
#endif	notdef
#endif	KDB
                        IF bkpt=scanbkpt(userpc)
                        THEN execbkpt(bkpt,execsig); execsig=0;
                        FI
                        setbp();
                FI
#ifdef	KDB
#ifdef	DEBUG
		printf("reset(%d) from runpcs()\n", runmode);
#endif	DEBUG
		reset(runmode);
}
#else	KDB
                PTRACE(runmode,pid,userpc,execsig);
                bpwait(); chkerr(); execsig=0; delbp(); readregs();
                IF (signo==0) ANDF (bkpt=scanbkpt(userpc))
                THEN /* stopped by BPT instruction */
                        dot=bkpt->loc;
                        IF bkpt->flag==BKPTEXEC
                        ORF ((bkpt->flag=BKPTEXEC)
                                ANDF bkpt->comm[0]!=EOR
                                ANDF command(bkpt->comm,':')
                                ANDF --bkpt->count)
                        THEN execbkpt(bkpt,execsig); execsig=0; loopcnt++;
                        ELSE bkpt->count=bkpt->initcnt; rc=1;
                        FI
                ELSE execsig=signo; rc=0;
                FI
        OD
        return(rc);
}
#endif	KDB

#ifdef	KDB
int execbkptf = 0;

/*
 * determines whether to stop, and what to print if so
 * flag:	1 if entered by trace trap
 * execsig:	(seems not to be used by kernel debugger)
 *
 * exits:
 *	skipping breakpoint (execbkptf != 0):
 *		runpcs(CONTIN)
 *      next iteration of breakpoint:
 *		runpcs(CONTIN)
 *	next iteration of single-step:
 *		runpcs(SINGLE)
 *
 *	stopped by breakpoint:
 *		returns 1
 *	stopped by single-step, or
 *		by CALL/RET:
 *		returns 0
 *
 *	normal return MUST reset sstepmode!
 */

nextpcs(flag, execsig)
{
	int			rc;
	REG BKPTR		bkpt;

#ifdef	notdef
	curpcb->pcb_regs.r_sr &= ~SR_TRACE;
#endif	notdef
	curpcb->pcb_icscs &= ~ICSCS_INSTSTEP;
	signo = flag?SIGTRAP:0;
#ifdef	notdef
	/*
	 *	Fudge the PC if we hit a breakpoint
	 */
#ifdef	DEBUG
		printf("nextpcs: signo = %d, pcfudge = %d\n", signo, pcfudge);
#endif	DEBUG
	if (signo == 0 && pcfudge){
		userpc = curpcb->pcb_iar;
#ifdef	DEBUG
		printf("nextpcs: fudging PC 0x%x by %d\n", userpc, pcfudge);
#endif	DEBUG
		userpc += pcfudge;
		pc_cheat(userpc);
		pcfudge = 0;
	}
#endif	notdef
	delbp();
	if (execbkptf)
	{
	    execbkptf = 0;
	    runpcs(CONTIN, 1);
	}

	if (signo == 0 && (bkpt = scanbkpt(userpc))) {
		dot = bkpt->loc;
		if (
		      (bkpt->comm[0] == '\n' || /* HACK HERE */
		      command(bkpt->comm, ':')) && --bkpt->count) {
			loopcnt++;
			execbkpt(bkpt, execsig);
			execsig = 0;
		} else {
			bkpt->count = bkpt->initcnt;
			rc = 1;
		}
	} else {
		execsig = signo;
		rc = 0;
	}
	if (mkfault) return(rc);

        if (--loopcnt > 0) {
		if (sstepmode == STEP_PRINT){
			printf("%16t");
			printpc();
		}
#ifdef	DEBUG
		printf("nextpcs: runpcs(%d, 1)\n",
			rc?CONTIN:SINGLE);
#endif	DEBUG
		runpcs(rc?CONTIN:SINGLE, 1);
	}
	if (sstepmode == STEP_RETURN){
		/* keep going until matching return */
		int	ins;
		int	insop;
		int	i;

		ins = (chkget(dot,ISP) >> 16) & 0xffff;
		insop = ins & M_BLINK;
		switch(insop) {
			case I_BALA:
			case I_BALAX:
			case I_BALI:
			case I_BALIX:
			case I_BALR:
			case I_BALRX:
				printf("[after %6d]     ", icount);
				for (i = call_depth; --i > 0;)
					printf("  ");
				printpc();
				call_depth++;
				loopcnt++;
				icount++;
				runpcs(SINGLE, 1);
				break;

			default:
				if ((ins == I_BR15) || (ins == I_BRX15)) {
					if (--call_depth == 0) {
						printf("%d instructions executed\n", icount);
					} else {
						printf("[after %6d]     ", icount);
						for (i = call_depth; --i > 0;)
							printf("  ");
						printpc();
						loopcnt++;
						icount++;
						runpcs(SINGLE, 1);
					}
				}
				else {
					loopcnt++;
					icount++;
					runpcs(SINGLE, 1);
				}
				break;
		}
	}
	if (sstepmode == STEP_CALLT){
		/* keep going until CALL or RETURN */
		int	ins;
		int	insop;

		ins = (chkget(dot,ISP) >> 16) & 0xffff;
		insop = ins & M_BLINK;
		switch(insop) {
			case I_BALA:
			case I_BALAX:
			case I_BALI:
			case I_BALIX:
			case I_BALR:
			case I_BALRX:
				printf("%d instructions executed\n", icount);
				break;

			default:
				if ((ins == I_BR15) || (ins == I_BRX15)) {
					printf("%d instructions executed\n", icount);
				}
				else {
					loopcnt++;
					icount++;
					runpcs(SINGLE, 1);
				}
				break;
		}
	}
	sstepmode = STEP_NONE;	/* don't wait for CALL/RET */
	return (rc);
}
#endif	KDB

#define BPOUT 0
#define BPIN 1
INT bpstate = BPOUT;

#ifdef	KDB
#else	KDB
endpcs()
{
        REG BKPTR       bkptr;
        IF pid
        THEN PTRACE(EXIT,pid,0,0); pid=0; userpc=1;
             FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
             DO IF bkptr->flag
                THEN bkptr->flag=BKPTSET;
                FI
             OD
        FI
        bpstate=BPOUT;
}
#endif	KDB
#ifdef VFORK
nullsig()
{
}
#endif

#ifdef	KDB
#else	KDB
setup()
{
        close(fsym); fsym = -1;
#ifndef VFORK
        IF (pid = fork()) == 0
#else
        IF (pid = vfork()) == 0
#endif
        THEN PTRACE(SETTRC,0,0,0);
#ifdef VFORK
             signal(SIGTRAP,nullsig);
#endif
             signal(SIGINT,sigint); signal(SIGQUIT,sigqit);
             doexec(); exit(0);
        ELIF pid == -1
        THEN error(NOFORK);
        ELSE bpwait(); readregs(); lp[0]=EOR; lp[1]=0;
             fsym=open(symfil,wtflag);
             IF errflg
             THEN printf("%s: cannot execute\n",symfil);
                  endpcs(); error(0);
             FI
        FI
        bpstate=BPOUT;
}
#endif	KDB

execbkpt(bkptr,execsig)
BKPTR   bkptr;
{
#ifdef DEBUG
        if(debug) printf("exbkpt: %d\n",bkptr->count);
#endif
        delbp();
#ifdef	KDB
	bkptr->flag = BKPTSET;
	execbkptf++;
#ifdef	DEBUG
	printf("reset(%d) from execbkpt()\n", SINGLE);
#endif	DEBUG
	reset(SINGLE);
#else	KDB
        PTRACE(SINGLE,pid,bkptr->loc,execsig);
        bkptr->flag=BKPTSET;
        bpwait(); chkerr(); readregs();
#endif	KDB
}

#ifdef	KDB
#else	KDB
doexec()
{
        STRING          argl[MAXARG];
        CHAR            args[LINSIZ];
        STRING          p, *ap, filnam;
        extern STRING environ;
        ap=argl; p=args;
        *ap++=symfil;
        REP     IF rdc()==EOR THEN break; FI
                *ap = p;
                /*
                 * First thing is to look for direction characters
                 * and get filename.  Do not use up the args for filenames.
                 * Then get rid of spaces before next args.
                 */
                IF lastc=='<'
                THEN    REP readchar(); PER lastc==SP ORF lastc==TB DONE
                        filnam = p;
                        WHILE lastc!=EOR ANDF lastc!=SP ANDF lastc!=TB ANDF lastc!='>'
                                DO *p++=lastc; readchar(); OD
                        *p = 0;
                        close(0);
                        IF open(filnam,0)<0
                        THEN    printf("%s: cannot open\n",filnam); _exit(0);
                        FI
                        p = *ap;
                ELIF lastc=='>'
                THEN    REP readchar(); PER lastc==SP ORF lastc==TB DONE
                        filnam = p;
                        WHILE lastc!=EOR ANDF lastc!=SP ANDF lastc!=TB ANDF lastc!='<'
                                DO *p++=lastc; readchar(); OD
                        *p = '\0';
                        close(1);
                        IF creat(filnam,0666)<0
                        THEN    printf("%s: cannot create\n",filnam); _exit(0);
                        FI
                        p = *ap;
                ELSE
                        WHILE lastc!=EOR ANDF lastc!=SP ANDF lastc!=TB ANDF lastc!='>' ANDF lastc!='<'
                                DO *p++=lastc; readchar(); OD
                        *p++ = '\0';
                        ap++;
                FI
        PER lastc!=EOR DONE
        *ap++=0;
        exect(symfil, argl, environ);
        perror(symfil);
}
#endif	KDB

BKPTR   scanbkpt(adr)
ADDR adr;
{
        REG BKPTR       bkptr;
        FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
        DO IF bkptr->flag ANDF bkptr->loc==adr
           THEN break;
           FI
        OD
        return(bkptr);
}

delbp()
{
        REG BKPTR       bkptr;
        REG INT         wspace;
 
        IF bpstate!=BPOUT
        THEN FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt DO
                 IF bkptr->flag
#ifdef	KDB
                 THEN 
	/* XXX */
			register ADDR a = bkptr->loc;

			put(a, ISP, (bkptr->ins&~0xffff)|(get(a, ISP)&0xffff));
                 FI
#else	KDB
		 THEN wspace = (bkptr->loc < txtmap.e1) ? WIUSER : WDUSER;
                      PTRACE( wspace, pid, WORDALIGN(bkptr->loc), bkptr->ins );
                 FI
#endif	KDB
              OD
              bpstate=BPOUT;
        FI
}

setbp()
{
        REG ADDR        a;
        REG BKPTR       bkptr;
        REG INT         rspace, wspace, s;
 
        IF bpstate!=BPIN
        THEN FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt DO
                 IF bkptr->flag
#ifdef	KDB
		 THEN
			register ADDR a;

			a = bkptr->loc;
			bkptr->ins = get(a, ISP);
			put(a, ISP, (I_BPT << 16) | (bkptr->ins)&0xffff);
		 FI
#else	KDB
                 THEN IF bkptr->loc < txtmap.e1
                      THEN rspace = RIUSER;
                           wspace = WIUSER;
                      ELSE rspace = RDUSER;
                           wspace = WDUSER;
                      FI
                      a = WORDALIGN(bkptr->loc);
                      bkptr->ins = PTRACE( rspace, pid, a, 0 );
                      s = 8 * (bkptr->loc - a);
                      PTRACE( wspace, pid, a,
                        (BPT << (16-s)) | (bkptr->ins & (BPMASK << s)) );
                      IF errno
                      THEN prints("cannot set breakpoint: ");
                           psymoff( bkptr->loc, ISYM, "\n" );
                      FI
                 FI
#endif	KDB
             OD
             bpstate=BPIN;
        FI
}

#ifdef	KDB
#else	KDB
bpwait()
{
        REG ADDR w;
        ADDR stat;
        signal(SIGINT, 1);
        WHILE (w = wait(&stat))!=pid ANDF w != -1 DONE
        signal(SIGINT,sigint);
        IF w == -1
        THEN pid=0;
             errflg=BADWAIT;
        ELIF (stat & 0177) != 0177
        THEN sigcode = 0;
             IF signo = stat&0177
             THEN sigprint();
             FI
             IF stat&0200
             THEN prints(" - core dumped");
                  close(fcor);
                  setcor();
             FI
             pid=0;
             errflg=ENDPCS;
        ELSE signo = stat>>8;
             sigcode = PTRACE(RUREGS, pid, &((struct user *)0)->u_code, 0);
             IF signo!=SIGTRAP
             THEN sigprint();
             ELSE signo=0;
             FI
             flushbuf();
        FI
}
#endif	KDB

#ifdef	KDB
#else	KDB
readregs()
{
        /*get REG values from pcs*/
        REG i;
        FOR i=24; --i>=0;
        DO *(ADDR *)(((ADDR)&u)+reglist[i].roffs) =
                    PTRACE(RUREGS, pid, reglist[i].roffs, 0);
        OD
/* Get some miscellenea from the u area: */
        userpc= *(ADDR *)(((ADDR)&u)+PC);
	errno = 0;
	StackBottom = PTRACE(RUREGS, pid, U_SSIZE, 0); /* Not yet bottom. */
	if(StackBottom == -1 && errno != 0)
		printf("Bad stacksiz from u area.\n");
	StackBottom = USRSTACK - ctob(StackBottom);	/* Now bottom. */
	DataTop = PTRACE(RUREGS, pid, U_DSIZE, 0);	/* Not yet top. */
	if(DataTop == -1 && errno != 0)
		printf("Bad data size from u area.\n");
	DataTop = DATABASE + ctob(DataTop);		/* Now top. */
	dprintf(("\t+DataTop from u area=%X(hex)\n", DataTop));
}
#endif	KDB
