/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * $Log:	kdb_sym.c,v $
 * Revision 2.2  88/07/20  16:14:16  rpd
 * Support for varying the length of symbol names.
 * 
 * 13-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Disabled call to valpr in psymoff, so that we always
 *	get some output.
 *
 * 31-Jan-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for kernel debugger KDB.
 *
 **********************************************************************
 */ 
/* $ Header: sym.c,v 5.1 86/02/17 17:23:17 ibmacis Exp $ */
/* $ Source: /ibm/acis/usr/src/bin/adb_ca/RCS/sym.c,v $ */

#ifndef lint
static char *rcsid = "$ Header: sym.c,v 5.1 86/02/17 17:23:17 zittin Exp $";
#endif

static	char sccsid[] = "@(#)sym.c 4.1 5/14/81";
/*
 * adb - symbol table routines
 */
#include "../ca/kdb/kdb_defs.h"
#include "../ca/vm_param.h"

#ifdef	KDB
#else	KDB
#include <stab.h>
#endif	KDB

/*
 * Lookup a symbol by name.
 */
struct nlist *
lookup(userSymStr)
	char *userSymStr;
{
	register struct nlist *sp;
	register char *name;
	register int underScore = '_';
	struct nlist *tmpSymPtr = (struct nlist *) 0;
	/* 
	 * User wants _x,  give him _x.
	 * User wants _.x, give him _.x.
	 * User wants x, if _.x is present give it to him, else give _x.
	 * Assume that the symbol table is in no special order.
	 */
	if (symtab)
#ifdef	KDB
	for (ALLSYMS(sp)) {
		name = sp->n_un.n_name;
		if (eqsym(name,userSymStr,underScore)) {
#else	KDB
	for (sp = symtab; sp < esymtab; sp++) {
		name = sp->n_un.n_name;
		if ((sp->n_type&N_STAB) == 0
			&& eqsym(name,userSymStr,underScore)) {
#endif	KDB
			if(userSymStr[0] == underScore)
				return(cursym = sp);
			else	/* if(userSymStr[0] != '_') */
				if(name[1] == '.' || name[0] != underScore)
					return(cursym = sp);
				else
					tmpSymPtr = sp;
		}
	}
	return (cursym = tmpSymPtr);
}

/*
 * Find the closest symbol to val, and return
 * the difference between val and the symbol found.
 * Leave a pointer to the symbol found as cursym.
 */
findsym(val, type)
	long val;
	int type;
{
	long diff;
	register struct nlist *sp;

	cursym = 0;
	diff = MAXINT;
	if (type == NSYM || symtab == 0)
		return (diff);
#ifdef	KDB
	for (ALLSYMS(sp)) {
#else	KDB
	for (sp = symtab; sp < esymtab; sp++) {
		if ((sp->n_type&N_EXT) == 0 || sp->n_type&N_STAB)
			continue;
#endif	KDB
#ifdef	KDB
		/*
		 *	Ignore symbols below kernel start
		 */
		if (SYMVAL(sp->n_value) < VM_MIN_KERNEL_ADDRESS)
			continue;
#endif	KDB
		if (val - SYMVAL(sp->n_value) < diff && val >= SYMVAL(sp->n_value)) {
			diff = val - SYMVAL(sp->n_value);
			cursym = sp;
			if (diff == 0)
				break;
		}
	}
	return (diff);
}

/* Like findsym(), but finds symbol table entries for
 * static and global functions. */
staticSym(val)
	long val;
{
	register struct nlist *found = (struct nlist *) 0, *sp;
	register long diff = MAXINT;
	register int len;
	register char *np;

#ifdef	KDB
	for (ALLSYMS(sp)) {
#else	KDB
	for (sp = symtab; sp < esymtab; sp++) {
		if((sp->n_value == 0 && (sp->n_type&N_EXT)==0) /* Start. */
			|| (sp->n_type&(N_EXT|N_TEXT)) == 0
			|| sp->n_type&N_STAB)
				continue;
#endif	KDB
		if (val - SYMVAL(sp->n_value) < diff && val >= SYMVAL(sp->n_value)) {
#ifdef	KDB
#else	KDB
			np = sp->n_name;
			len = strlen(np);
			if(np[len-2] == '.' && np[len-1] == 'o'
				&& (len == 3 && np[0] != '_'))	/* I.e. x.o */
					continue;
#endif	KDB
			diff = val - SYMVAL(sp->n_value);
			found = sp;
			if (diff == 0)
				break;
		}
	}
	cursym = (sp == symtab) ? (struct nlist *)0 : found;
	return (diff);
}

/*
 * Advance cursym to the next local variable.
 * Leave its value in localval as a side effect.
 * Return 0 at end of file.
 */
localsym(cframe, cargp)
	ADDR cframe, cargp;
{
#ifdef	KDB
#else	KDB
	register int type;
	register struct nlist *sp;

	if (cursym)
	for (sp = cursym; ++sp < esymtab; ) {
/**/		printf("next sym = %s\n", sp->n_un.n_name);
		if (sp->n_un.n_name[0] =='_' || sp->n_type == N_FN)
			return (0);
		type = sp->n_type;
		switch (sp->n_type) {

		case N_TEXT:
		case N_TEXT|N_EXT:
		case N_DATA:
		case N_DATA|N_EXT:
		case N_BSS:
		case N_BSS|N_EXT:
			localval = sp->n_value;
			cursym = sp;
			return (1);

		case N_LSYM:
			localval = cframe - sp->n_value;
			cursym = sp;
			return (1);

		case N_PSYM:
			/* code below works since n_value > 0 */
		case N_ABS:
			if (sp->n_value < 0)
				localval = cframe + sp->n_value;
			else
				localval = cargp + sp->n_value;
			cursym = sp;
			return (1);
		}
	}
#endif	KDB
	cursym = 0;
	return (0);
}

/*
 * Print value v and then the string s.
 * If v is not zero, then we look for a nearby symbol
 * and print name+offset if we find a symbol for which
 * offset is small enough.
 *
 * For values which are just into kernel address space
 * that they match exactly or that they be more than maxoff
 * bytes into kernel space.
 */
psymoff(v, type, s)
	long v;
	int type;
	char *s;
{
	long w;
#ifdef	notdef
	if(symTableIsPresent() && v && type == ISP)
		valpr(v, type);
	else {
#endif	notdef
		if (v) 
			w = findsym(v, type);
#if	1
		if (v==0 || w >= maxoff)
#else	1
		if (v==0 || w >= maxoff || (KVTOPH(v) < maxoff && w))
#endif	1
			printf(LPRMODE, v);
		else {
#ifdef	KDB
			printf("%.*s", SYMNAMELEN, cursym->n_un.n_name);
#else	KDB
			printf("%s", cursym->n_un.n_name);
#endif	KDB
			if (w)
				printf(OFFMODE, w);
		}
#ifdef	notdef
	}
#endif	notdef
	printf(s);
}

/*
 * Print value v symbolically if it has a reasonable
 * interpretation as name+offset.  If not, print nothing.
 * Used in printing out registers $r.
 */
valpr(v, idsp)
	register long v;
{
	off_t d;

	d = (idsp == ISP) ? staticSym(v) : findsym(v,idsp);
#ifdef	notdef	
	dprintf(("\t+psymoff:idsp=%X d=%D v=%X\n",idsp,d,v));
#endif	notdef	
	if(d >= maxoff)
		return;
#ifdef	KDB
	printf("%.*s", SYMNAMELEN, cursym->n_un.n_name);
#else	KDB
	printf("%s", cursym->n_un.n_name);
#endif	KDB
	if (cursym)
		printf(OFFMODE, d);
}
