/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * $Log:	kdb_symtab.h,v $
 * Revision 2.2  88/07/20  16:14:40  rpd
 * Support for varying the length of symbol names.
 * 
 *  1-Feb-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Created for kernel debugger KDB.
 *
 **********************************************************************
 */ 

#ifdef	KDB
/*
 *	Definitions for the kernel symbol table.
 *
 * 	We use a fake nlist overlaying the real symbol table, and
 *	have a special format to deal with limited strings.
 *	We also use a special macro to convert kernel physical
 *	addresses to virtual space.
 *	
 */

#define SYMNAMELEN	20

struct	nlist {
	union {
		char	n_name[SYMNAMELEN];
	} n_un;
unsigned long	n_value;
};

#define ALLSYMS(s) s=symtab; s && s->n_un.n_name[0]; ++s

#define	SYMFMT		%.20s
#define	SYMVAL(v)	((v & 0xf0000000) ? v : (v | 0xe0000000))
#else	KDB
#define	SYMFMT		%s
#define	SYMVAL(v)	(v)
#endif	KDB
