/* 
 **********************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 **********************************************************************
 * HISTORY
 * $Log:	kdb_trace.c,v $
 * Revision 2.2  88/07/20  16:15:06  rpd
 * Support for varying the length of symbol names.
 * 
 * 20-Aug-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified traceback() to use a pcb given as argument to find the
 *	registers.
 *
 *  5-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	HIGHC: modified to deal with code produced by the
 *	Metaware C compiler.
 *
 *  8-Mar-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Created from rdb module trace.c.
 *
 **********************************************************************
 */ 
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include "kdb_defs.h"
#include "machine/pcb.h"
#define	NCS	1
#define	HIGHC	1
static int	err_flag = 0;

#define AI_R1_R1	0xC111
#define STM_X_R1	0xd901
#define STM_X_MASK	0xff0f
#define AIS_R1		0x9010
#define SIS_R1		0x9210
#define BALRX_R15	0x8df0
#define CAS		0x6000
#define ST		0xdd00
#define STS		0x3000
#define SHORT_MASK	0xfff0
#define MAX_LEVEL	25
#define REG_FLAG	0x10	/* flag if parameter ended up in register */
#define PROLOG_SIZE	4	/* until saved R15 is available */
#define	FP		13

int trflag = 0;

/*
 * Get the given register from the given PCB.
 */
int	regval(num,regpcb)
int num;
struct pcb *regpcb;
{
	switch(num) {
	case 0:
		return (chkget(&(regpcb->pcb_r0),DSP));
	case 1:
		return (chkget(&(regpcb->pcb_r1),DSP));
	case 2:
		return (chkget(&(regpcb->pcb_r2),DSP));
	case 3:
		return (chkget(&(regpcb->pcb_r3),DSP));
	case 4:
		return (chkget(&(regpcb->pcb_r4),DSP));
	case 5:
		return (chkget(&(regpcb->pcb_r5),DSP));
	case 6:
		return (chkget(&(regpcb->pcb_r6),DSP));
	case 7:
		return (chkget(&(regpcb->pcb_r7),DSP));
	case 8:
		return (chkget(&(regpcb->pcb_r8),DSP));
	case 9:
		return (chkget(&(regpcb->pcb_r9),DSP));
	case 10:
		return (chkget(&(regpcb->pcb_r10),DSP));
	case 11:
		return (chkget(&(regpcb->pcb_r11),DSP));
	case 12:
		return (chkget(&(regpcb->pcb_r12),DSP));
	case 13:
		return (chkget(&(regpcb->pcb_r13),DSP));
	case 14:
		return (chkget(&(regpcb->pcb_r14),DSP));
	case 15:
		return (chkget(&(regpcb->pcb_r15),DSP));
	}			
}


/*
 * trace back thru the stack frames and print out the names and
 * arguments to the various functions called.
 * the entry to a C procedure looks like:
 * entry: ai r1,r1,-framesize		| create stack frame
 *	stm	Rnnn,Vnnn(r1)		| save registers
 * on entry to a function: the stack looks like:
 * n*4	arg n
 * ...  ...
 * 8	arg 3
 * 4	arg 2
 * 0	arg 1	<== sp
 * after the stack push and stm the stack looks like:
 * framesize+8	arg 3
 * framesize+4	arg 2
 * framesize+0	arg 1
 * framesize-4	saved r15	(or Vnnn + (15 - Rnnn) * 4)
 * ...
 * Vnnn		saved Rnnn
 * n		local n
 * 0		local 0
 *
 */
traceback(iar,sp,regpcb) 
register int sp, iar;
struct pcb *regpcb;
{
short framesize,stacksize;
#if	HIGHC
short r1off, r13off;	/* offsets of r1 and r13 from their initial vialues */
short r1valid, r13valid;
#endif	HIGHC
int prolog1, prolog2, prolog1_size;
register int level;
register int entry;
register int i;
int offset;
int nargs;
int	Rnnn,	/* number of registers saved */
        Lnnn,	/* local variables */
        Vnnn;	/* space for register variables */
#ifdef NCS
int	regs[16];	/* current register values */
int	protect;

for (i=0; i<16; ++i)
	regs[i] = regval(i,regpcb);
#endif NCS
for (level=0;err_flag == 0 && level < MAX_LEVEL;++level)
        {
        printf("level %d: sp=%x iar=%x ",level,sp,iar);
        if ((iar == 0) || (iar == 1) || ((iar & 0xf0000000) != 0xe0000000))
                break;
	offset = findsym(iar,ISYM);
        if (cursym == 0)
                {
                printf("no symbol found near %x\n",iar);
                break;
                }
        entry = SYMVAL(cursym->n_value);
        printf(" routine %.*s + %d (0x%x)\n", SYMNAMELEN, cursym->n_un.n_name,offset,offset);
#ifndef NCS
        prolog1 = h_fetch(entry);
        if (prolog1 == AI_R1_R1) {
                framesize = - h_fetch(entry+2);
                prolog1_size=4;
        } else if ((prolog1 & SHORT_MASK) == SIS_R1) {
                framesize = prolog1 & 0x000f;
                prolog1_size=2;
        } else if ((prolog1 & SHORT_MASK) == AIS_R1) {
                framesize =16 - (prolog1 & 0x000f);
                prolog1_size=2;
        } else {
                printf("*** Invalid Prolog\n");
                break;
        }

        prolog2 = h_fetch(entry+prolog1_size);
#else NCS
        prolog2 = h_fetch(entry);
        framesize = 0;
        prolog1_size = 0;
#endif
        if ((prolog2 & STM_X_MASK) != STM_X_R1) {
                printf("*** Invalid Prolog\n");
                break;
        }
        Rnnn = (prolog2 >> 4) & 0xf;
        Vnnn = (h_fetch(entry+prolog1_size+2) << 16) >> 16;
        stacksize=0;
#if	HIGHC
	r1off = 0;
	r13off = 0;
	r1valid	= 1;
	r13valid = 0;
#endif	HIGHC

/*
 * interrupt service routines (by convention) have an AI just before the
 * entry point that has the amount of extra stack protection required
 */
	if (h_fetch(entry-4) == AI_R1_R1)
		protect = (h_fetch(entry-2) << 16) >> 16;
	else
		protect = 0;		/* normally no extra protect amount */

        {

        register int iar_temp,instr;

	/* scan thru code between entry point and iar and look for stack
	 * pushes and pops.
	 * IS THIS NECESSARY FOR NCS?? 
	 */
        for (iar_temp=entry; iar_temp < iar ; iar_temp+=2) {
                instr=h_fetch(iar_temp);
                if ((instr <= 0x8fff ) && (instr >= 0x8800)) iar_temp+=2;
                if ((instr <= 0xdfff ) && (instr >= 0xc000)) iar_temp+=2;
#if	HIGHC
		switch(instr) {
		    	case 0xc111:	/* ai r1,r1,x */
				r1off += h_fetch(iar_temp);
				break;

			case 0xc11d:	/* ai r1,r13,x */
				r1off = r13off + h_fetch(iar_temp);
				r1valid = r13valid;
				break;

			case 0xc1d1:	/* ai r13,r1,x */
				r13off = r1off + h_fetch(iar_temp);
				r13valid = r1valid;
				break;

			case 0xc1dd:	/* ai r13,r13,x */
				r13off += h_fetch(iar_temp);
				break;

			case 0xc811:	/* cal r1,x(r1) */
				r1off += h_fetch(iar_temp);
				break;

			case 0xc81d:	/* cal r1,x(r13) */
				r1off = r13off + h_fetch(iar_temp);
				r1valid = r13valid;
				break;

			case 0xc8d1:	/* cal r13,x(r1) */
				r13off = r1off + h_fetch(iar_temp);
				r13valid = r1valid;
				break;

			case 0xc8dd:	/* cal r13,x(r13) */
				r13off += h_fetch(iar_temp);
				break;

			case 0x61d0:	/* cas r1,r13,r0 */
			case 0x610d:	/* cas r1,r0,r13 */
				r1off = r13off;
				r1valid = r13valid;
				break;

			case 0x6d10:	/* cas r13,r1,r0 */
			case 0x6d01:	/* cas r13,r0,r1 */
				r13off = r1off;
				r13valid = r1valid;
				break;

			default:
				switch(instr & SHORT_MASK) {
				    	case 0x9010:	/* ais r1,x */
						r1off += instr & 0x000f;
						break;

				    	case 0x90d0:	/* ais r13,x */
						r13off += instr & 0x000f;
						break;

				    	case 0x9210:	/* sis r1,x */
						r1off -= instr & 0x000f;
						break;

				    	case 0x92d0:	/* sis r13,x */
						r13off -= instr & 0x000f;
						break;

					default:
						/* not interesting */
						break;
				}
				break;
		}
#else	HIGHC
                if (instr == AI_R1_R1) {
                        stacksize+= h_fetch(iar_temp);
                        if (trflag) printf ("AI R1,R1,%d\n",framesize);
                  }
                else if ((instr & SHORT_MASK) == SIS_R1) {
                        stacksize-= instr & 0x000f;
                        if (trflag) printf ("SIS R1,%d\n",framesize);
                  }

                else if ((instr & SHORT_MASK) == AIS_R1)  {
                        stacksize+= instr & 0x000f;
                        if (trflag) printf( "AIS R1,%d\n",framesize);
                  }
#endif	HIGHC
	}
	}
#if	HIGHC
	if (trflag) {
	    	printf("r1off=0x%x, r13off=0x%x, Vnnn=0x%x\n", r1off, r13off, Vnnn);
	    	printf(" Rnnn=%d, protect=0x%x\n", Rnnn, protect);
	}
#else	HIGHC
        if (trflag) printf ("framesize=%d (0x%x), Vnnn=%d (0x%x), Rnnn = %d (0x%x)",stacksize,stacksize,Vnnn,Vnnn,Rnnn,Rnnn);
#endif	HIGHC
#if	HIGHC
	if ((!r1valid) || (r1off > 0)) {
	    	printf("*** Cannot retrace sp! ***\n");
		return;
	}
	sp -= r1off;
#else	HIGHC
        if (stacksize+framesize < 0) sp -=framesize+stacksize;
#endif	HIGHC

        if (offset < PROLOG_SIZE)
                iar = regval(15,regpcb);	/* use current value of R15 */
        else
                iar = w_fetch(sp + ((15 - Rnnn) << 2) + Vnnn);
#ifndef NCS
        if (offset >= prolog1_size)   /* Change SP only if PUSH has executed */ 
                sp += framesize;	/* the previous value of sp */

        i = h_fetch(iar);
        if ((i&0xfff0) == AIS_R1)
                nargs = (i & 0xf);
        else if (i == AI_R1_R1)
                nargs = h_fetch(iar+2);
        else 
                nargs = 0;
#else NCS
	{
	int temp, length;
	int regno;
	/* look for a parameter storing or moving instruction (up to 8 past entry) */
	entry += 8;		/* at least 8 bytes of prolog */
	for (i=0; i<8; ++i) {
		regno = move_arg(entry,&temp,&length);
	    	if (trflag) {
		    	printf("instruction at 0x%x -> regno=%d, addr=0x%x, ", entry, regno, temp);
		    	printf(" length=0x%x\n", length);
		}
		if (regno || (length == 0))
			break;
		else
			entry += length&0xf;
	}
        nargs=4*4;		/* assume 4 arguments for now */
	}
#endif NCS	
        printf("	%.*s(",SYMNAMELEN,cursym->n_un.n_name);
        for (i=0; i < nargs; i += 4)
                {
		int temp, length;
		int regno;
#ifdef NCS
		if (trflag) printf("Considering register %d\n", (i>>2)+2);
		regno = move_arg(entry, &temp, &length);
	    	if (trflag) {
		    	printf("instruction at 0x%x -> regno=%d, addr=0x%x, ", entry, regno, temp);
		    	printf(" length=0x%x\n", length);
		}
		if (regno != (i>>2)+2)
			break;
		entry += length & 0xf;
		if (length & REG_FLAG) {
		    	if (trflag) printf("Getting value from register %d\n", temp);
			temp = regs[temp];	/* get the register value */
		}
		else {
			if (trflag) printf("Getting value from 0x%x(0x%x)\n",temp, regs[FP]);
			temp = w_fetch(regs[FP] + temp);
		}
#else
		temp = w_fetch(sp + i );
#endif
                printf("%s%x",i ? "," : "" ,temp);
                if (err_flag)
                        break;
                }
	printf(")");
	if (protect)
		printf(" *** INTERRUPT SERVICE ROUTINE ***");
        printf("\n");
	for (i=Rnnn ; i<16 ; ++i, Vnnn += 4)
		regs[i] = w_fetch(sp + Vnnn);	/* pick up register values */
#ifdef NCS
	sp -= protect;		/* adjust for protected area */
#endif
        }
printf("\n");
}

/*
 * test the instruction at "addr" and return the register number that
 * is either being stored or moved.
 * offset is the location (on stack) being stored into or the register
 * variable number.
 * return into *length the length of the current instruction.
 */
move_arg(addr,offset,length)
register int addr;
register int *offset;
register int *length;
{
	register int instn = h_fetch(addr);
	register int arg;

	if ((instn>>12) == (STS>>12))
		{
		*length = 2;
		arg = (instn >> 4) & 0xf;
		if (arg < 2 || arg > 5)
			arg = 0;
		else
			*offset = (instn>>8) * 4;
		}
	else if ((instn >> 8) == (ST >> 8))
		{
		arg = (instn >> 4) & 0xf;
		if (arg < 2 || arg > 5)
			arg = 0;
		else
			*offset = h_fetch(addr+2);
		*length = 4;
		}
	else if ((instn>>12) == (CAS>>12))
		{
		*length = 2 + REG_FLAG;	/* length=2; register variable */
		arg =  (instn >> 4) & 0xf;
		if (arg < 2 || arg > 5)
			arg = 0;
		else
			{
			*offset = ((instn >> 8) & 0xf);
			}
		}
	else if ((instn>>4) == (BALRX_R15>>4))
		{
		*length = 0;
		arg = 0;
		}
	else {
		arg = 0;
		*length = 2;
	}
	*offset = (*offset << 16) >> 16;
	return(arg);
}

h_fetch(addr) register int addr;
{
register int n = 0;

if (trflag>2)
	printf(" [%x] ",addr);
n = (chkget(addr,ISP) >> 16) & 0xffff;
if (trflag>2) printf("=%x ",n);
return(n);
}



w_fetch(addr)
{
	register int n = chkget(addr,ISP);
	if (trflag>2)
		printf(" ==> %x ",n);
	return(n);
}

#ifdef	notdef
/*
 * scan thru memory looking for the entry sequence before "addr"
 * and find the C prolog. In particular we look for the AI ... STM
 * and then look backwards for the <name> in memory.
 */
struct symtab *scansym(addr,offset) register int addr, offset;
{
register int start = addr - (offset >> 4);
static struct symtab sym;		/* the symbol to return */
register int p, c;
register int i, len;
register int endptr;

for (; addr > start && !err_flag; addr -= 2)
        {
#ifdef NCS
        if ((h_fetch(addr-4) & STM_X_MASK) == STM_X_R1 && h_fetch(addr) == AI_R1_R1)
#else
        if ((h_fetch(addr) & STM_X_MASK) == STM_X_R1 && h_fetch(addr-4) == AI_R1_R1)
#endif NCS
                {
                addr -= 4;		/* point to "entry point" */
                if (trflag>1)
                        printf("found candidate at %x\n",addr);
#ifdef NCS
                p = addr - 1;
#else
                p = addr - 9;	/* adjust for the 2 words of pointers */
#endif
                while (( c = b_fetch(p)) == 0 && err_flag == 0)
                        --p;
                if (c != '>')
                        continue;	/* not us */
                endptr = p;
                while ((c = b_fetch(p)) && c != '<')
                        --p;
                ++p;			/* point to first character */
                len = endptr - p;
                if (len > MAXSYMLEN)
                        len = MAXSYMLEN;
                for  (i=0; i<len;++i , ++p)
                        sym.symbol[i] = b_fetch(p);
                sym.symbol[i] = 0;	/* may clobber 'value' */
                sym.value = addr;	/* the address */
                return(&sym);
                }
        }
return(0);
}


/*
 * fetch bytes by fetching halfwords and getting proper byte (yetch!)
 */
b_fetch(addr) register int addr;
{
union {
short x;
char cx[2];
} un;
register int n;

un.x = h_fetch(addr & ~1);	/* get from even address */

n = un.cx[addr&1];
if (trflag > 1)
        {
        printf("byte = %x ",n);
        if (n >= ' ' && n < 0x7f)
                printf("'%c'",n);
        printf("\n");
        }
return(n);
}

#endif	notdef
