/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	ca/locache.s
 *
 *	RT Version:
 *
 *	Assembly language Fast cache lookups for shared memory pages.
 *
 *	Author:	Richard N. Sanzi Jr.
 *
 * HISTORY $Log:	locache.s,v $
 * Revision 2.3  88/10/10  15:45:12  sanzi
 * 	Set _cache_use_ok to 1.  Fix bogus use of .using construct.
 * 
# Revision 2.2  88/10/06  13:46:22  sanzi
# 	Smashed out lots of unnecessary register pushes.  Use new lo_remap routine
# 	for absolute fastest possible remapping.  Touch this code at your own risk.
# 
 * 22-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Created. 
 */
	.globl	.oVncs
	.set	.oVncs,0
	.globl	_lo_lookup
	.globl	_headers
	.globl	_cache_size
	.globl	_alias
	.globl	_cache_use_ok
	.globl 	_mi_page_mask	
	.align	2

_headers:	.long	0
_alias:		.long	0
_cache_size:	.long 	0	/* set by cache_init */
_mapin_dp:	.long	_mapin
_mapout_dp:	.long	_mapout
_cache_use_ok:	.long	1
_mi_page_mask:	.long	0
#include "cache.h"

#if	CACHE_STATISTICS
	/* 
	 * keep some statistics. 
	 */
_lo_tries:	.long	0
_lo_hits:	.long	0
_lo_prot_fault: .long 	0
#endif	CACHE_STATISTICS
#define	SET_PRIORITY	1

#define	SPL_VM		2	/* priority level for vm */
 /* 
  * Register Defines:
  * first 	--- first register saved on stack.
  * sid	  	--- value of segment id register 
  * vpage 	--- virtual page index
  * ftype 	--- UW or UR only (no kernel mode faults supported)
  * addrtag	--- value of address tag ( as used in hardware page table)
  * header	--- the header pointer into the cache lookup table
  * index	--- the index into the hash header table
  * ppage	--- the physical page corresponding to the vpage/sid 
  * entry	--- the current working entry in the cache.
  * atag	--- the address tag for entry
  * prot	--- the protection on entry
  * basereg	--- the base register (for accessing globals. )
  */
#define	first	r2	/* must save all registers if we call C code! */
#define	seginfo	r3	/* the info parameter */
#define	basereg	r6
#define	index	r7	
#define	ppage	r7
#define	sid	r8	/* must actually fetch sid from Rosetta */
#define	addrtag	r9
#define	header	r10
#define	ftype	r11	/* must do some processing */
#define	entry	r12
#define	atag	r13
#define	prot	r13
#define	vpage	r14 	/* this is initially an address */

#define	DDEBUG	1
/*
 * lo_lookup(mcs_pcs,info,&regs)
 *
 * This depends on 2K pages (note the shift of vpage below)
 */
	.globl	lo_lookup
	.globl	_lo_lookup
#if	CACHE_STATISTICS	
	.globl	_lo_tries
	.globl	_lo_hits
	.globl	_lo_prot_fault
#endif	CACHE_STATISTICS		

#if	ROMP_RDB
	ai	sp,sp,FRM_PROTECT	#makes rdb happy
#endif	ROMP_RDB
eye_catcher(lo_lookup):
_lo_lookup:
#if	USE_ASSEMBLY
#define	FRAMESIZE 	25*4 /* SAVEAREA + 1 local variable */
#define	SPL_OFFSET	56   /* save local variable after registers */
	ai	sp,sp,-FRAMESIZE	# bump stack
	sts	r2,0(sp)		# save all parameters 
	sts	r3,4(sp)
	sts	r4,8(sp)
	sts	r5,12(sp)	
	st	r15,52(sp)	# save return address
#else	USE_ASSEMBLY
/*
 * SAVEAREA -- includes 14 registers on stack + 9 words for stack frame
 * FRAMESIZE -- include SAVEAREA + 1 extra parameter to C code (mapin) 
 *			+ 1 stack variable
 */

#define	SAVEAREA        23*4 /* 23 = 9 (words at top of frame) + 14 regs */
#define	FRAMESIZE 	25*4 /* SAVEAREA + 1 local variable + 1 out arg */
#define	SPL_OFFSET	4	/* stack offset to save priority level */
	stm	first,-SAVEAREA(sp)	# save registers now
	ai	sp,sp,-FRAMESIZE	# bump stack	
#endif	USE_ASSEMBLY	

 # fetch sid
 	mr 	sid,seginfo		# find seg value
	sri16	sid,28-16		# get sid
	get	basereg,$RTA_SEGREG0	# get rosetta base
	cas	basereg,basereg,sid	# get io addr of segment register
	ior	sid,0(basereg)		# load segment register
	sri	sid,2			# drop protection bits
	nilz	sid,sid,0x0fff		# zero all but sid bits
 # prepare fault type
	mttbil 	seginfo,29-16		# get RTA_EX_HACK bit (uggh!)
	mftbil  seginfo,31-16		# copy it into low order bit
	oil	ftype,seginfo,0x02	# set user mode bit
	nilz	ftype,ftype,0x0003	# zero all but lower two bits
 # prepare vpage index	
	niuo	vpage,seginfo,0x0fff	# strip off segment bits
	sri	vpage,11		# make it a page index
 # declare base register	
	.using	lo_lookup_base,basereg
	bali	basereg,lo_lookup_base
lo_lookup_base:	
#if	DDEBUG	
 # bail out if necessary
 	l	r2,_cache_use_ok
	cis	r2,0
	beq	lookup_return
#endif	DDEBUG	
#if	SET_PRIORITY
 # set priority level
 	mfs	scr_ics,r2		# get current status
	ni	r3,r2,-8		# get all but priority in r3
	oil	r3,r3,SPL_VM		# set spl_vm priority level
	mts	scr_ics,r3		# write new priority level	
	nilz	r2,r2,7			# strip upper bits
	sts	r2,SPL_OFFSET(sp)	# save old priority level
	clrsb	scr_ics,INTMASK-16	# enable interrupts now
 # priority level now set	
#endif	SET_PRIORITY 
#if	CACHE_STATISTICS	
	get	header,_lo_tries	# bump counter
	inc	header,1		
	st	header,_lo_tries
#endif	CACHE_STATISTICS	
	get	r2,_mi_page_mask	# get machine independent page mask 
	n	vpage,r2		# round to nearest 4K page
	get	header,_headers		# get header table	
	mr	addrtag,sid		# compute address tag
	sli16	addrtag,1		# addrtag = addrtag << SID_VPAGE_BITS
	o	addrtag,vpage		# addrtag |= vpage
	mr	index,sid		# index = sid
	x	index,vpage		# index = (sid ^ vpage) 
	get	atag,_cache_size	# load cache_size ( for mask )
	si	atag,1			# subtract one
	n	index,atag		# mask off unwanted bits
	sli	index,CACHE_ENTRY_SHIFT	# compute index into header
	cas	entry,index,header	# entry = &header[index]
 #
 # this loop fits into the APC loopback cache.
 #
searchloop:
	ls	entry,8(entry)		# get entry->next pointer
	cis	entry,0			# loads don't set condition codes!
	je	endloop			# is it null? 
	ls	atag,0(entry)		# get address_tag
	c	atag,addrtag		# compare them
	jne	searchloop	
 # found an entry with a matching addrtag
	lh	prot,6(entry)		# get protection
    /*
     * Allow the following fault/protections
     *
     *	Fault Type	Protection	Allowable Fault
     *		
     *	  UR(3)		  UR(3)		Yes
     *	  UR(3)		  UW(2)		Yes
     *	  UW(2)		  UR(3)		No
     *	  UW(2)		  UW(2)		Yes
     *
     *	Kernel faults are not allowed.
     */
 	c	ftype,prot		# is ftype >= prot ?
	jl	prot_failure			# no, punt
	lh	ppage,4(entry)		# get physical page
#if	CACHE_STATISTICS
	get	r2,_lo_hits		# bump counter
	inc	r2,1			
	st	r2,_lo_hits
#endif	CACHE_STATISTICS
#if	PMAP_STATISTICS
	mr	r2,ppage		# get ppage
	l	r3,a_active_pmap	# get current pmap
	l	r4,a_last_pmap		# get last pmap for this page
	l	r4,0(r4)		# 
	sli	r2,2			# make it a byte offset
	cas	r2,r2,r4		# have &last_pmap[ppage]
	ls	r4,0(r2)		# have last_pmap for this page
	ls	r3,0(r3)		# have pointer to current pmap
	l	r5,PMAP_RSS_STATS(r4)	# last_pmap[atop(ppage)]->stats.rss--;
	si	r5,1			# decrement 
	st	r5,PMAP_RSS_STATS(r4)	# and store it
	l	r5,PMAP_RSS_STATS(r3)	# active_pmap->stats.resident_count++;
	ai	r5,1			# increment it 
	st	r5,PMAP_RSS_STATS(r3)	# and store it	
	st	r3,0(r2)		# store new value for last_pmap[ppage]
#endif	PMAP_STATISTICS
#if	USE_ASSEMBLY	
 # call lo_remap
 # lo_remap(sid,vpage,ppage,prot)
	mr 	r2,sid
	mr 	r3,vpage
	mr	r4,ppage
	mr	r5,prot
	get	r14,$(_lo_remap)	# this blasts the value of vpage
	l	r15,0(r14)		
	balrx	r15,r15
	mr	r0,r14
#else	USE_ASSEMBLY	
 # call remap
 # remap(sid,vpage,ppage,prot)
	mr 	r2,sid
	mr 	r3,vpage
	mr	r4,ppage
	mr	r5,prot
	get	r14,$(_remap)		# this blasts the value of vpage
	l	r15,0(r14)		
	balrx	r15,r15
	mr	r0,r14
#endif	USE_ASSEMBLY		
 # basereg is no longer valid here, reload it.
1: 	.using 	1b
	mfs	scr_iar,basereg		 # load base register	
2:	.using	2b,basereg
 # return to user mode (setup for a call to go() )
	setsb	scr_ics,INTMASK-16	# mask interrupts
 	ai	sp,sp,FRAMESIZE		# pop our register frame
 	l	r14,FAULT_IAR(sp)	# get fault time iar
	l	r15,FAULT_ICS_CS(sp)	# get fault time ics_cs
	stm	r14,low_ps		# store for go to use
	l	r15,FAULT_MQ(r1)	# get mq
	mts	scr_mq,r15		# store mq
	l	r14,FAULT_R1(sp)	# get fault time sp
	st	r14,low_save1		# store stack pointer for go
	l	r15,FAULT_R15(r1)	# get r15
	st	r15,low_save15		# save for go	
	l	r0,FAULT_R0(r1)		# get r0 (on stack)
#if	ROMP_APC	
	l	r11,FAULT_CNT(sp)	# get exception count
	cis	r11,0			# any exception packets present?
	bne	ecr_restore		# yes, re-issue them
#endif	ROMP_APC	
	lm	r2,FAULT_R2(sp)		# get regs
	mfs	scr_iar,r15		# need addressibility 
1:	.using 	1b,r15		
	lps	0,go_ps			# finally back to the user!
1: 	.using	1b
prot_failure:
#if	CACHE_STATISTICS && DDEBUG
	mfs	scr_iar,basereg		# need addressibility
1:	.using 	1b,basereg			
	get	r2,_lo_prot_fault	# bump counter
	inc	r2,1			#
	st	r2,_lo_prot_fault	#
1: 	.using	1b	
#endif	CACHE_STATISTICS && DDEBUG
endloop:
#if	SET_PRIORITY
 # reset priority level
 	l	r3,SPL_OFFSET(sp)	# get old priority value
 	mfs	scr_ics,r2		# get current status
	ni	r2,r2,-8		# get all but priority in r2
	o	r3,r2			# or in old priority level
	mts	scr_ics,r3		# restore priority level	
#endif	SET_PRIORITY	
lookup_return:
 # priority level returned to initial value
	setsb	scr_ics,INTMASK-16	# disable interrupts now 
#if	USE_ASSEMBLY	
	ls	r2,0(sp)			# restore all parameters 
	ls	r3,4(sp)
	ls	r4,8(sp)
	ls	r5,12(sp)	
	l	r15,52(sp)		# save return address
	ai	r1,r1,FRAMESIZE		# fix sp		
#else	USE_ASSEMBLY	
	ai	r1,r1,FRAMESIZE		# fix sp		
	lm	r2,-SAVEAREA(sp)	# get regs back
#endif	USE_ASSEMBLY	
	br	r15			# return
1:	.using 	1b	
.long	0xdf02df60
#undef	seginfo	

/* 
 * struct cache_entry *
 * cache_lookup_entry(sid,vpage)
 * vm_offset_t sid, vpage;
 *
 *	This routine is a C-callable version of the above which
 *	just performs a fast lookup and returns the entry.
 */
eye_profil(cache_lookup_entry_):
	stm	r6,-76(sp)		# save all regs used by C
	ai	sp,sp,-76		# move sp.
	mr	sid,r2			# get sid parameter
	mr	vpage,r3		# get vpage parameter
 # declare base register
 	.using cle_base,basereg
	bali	basereg,cle_base
cle_base:	
	get	header,_headers		# get header table	
	mr	addrtag,sid		# compute address tag
	sli16	addrtag,1		# addrtag = addrtag << SID_VPAGE_BITS
	o	addrtag,vpage		# addrtag |= vpage
	mr	index,sid		# index = sid
	x	index,vpage		# index = (sid ^ vpage) 
	get	atag,_cache_size	# load cache_size ( for mask )
	si	atag,1			# subtract one
	n	index,atag		# mask off unwanted bits
	sli	index,CACHE_ENTRY_SHIFT	# compute index into header
	cas	entry,index,header	# entry = &header[index]
 #
 # this loop fits into the APC loopback cache.
 #
cle_search:
	ls	entry,8(entry)		# get entry->next pointer
	cis	entry,0			# loads don't set condition codes!
	je	cle_return		# is it null? 
	ls	atag,0(entry)		# get address_tag
	c	atag,addrtag		# compare them
	jne	cle_search	
 #
 # found an entry with a matching addrtag
 #   if the loop fails, entry == 0
 #
cle_return:
	mr	r2,entry		# return the entry
	ai	sp,sp,76		# reset stack  
	lm	r6,-76(sp)		# restore registers
	br 	r15			# return
.long	0xdf02df60

#undef	first	
#undef	basereg	
#undef	index	
#undef	ppage	
#undef	sid	
#undef	addrtag	
#undef	header	
#undef	ftype	
#undef	entry	
#undef	atag	
#undef	prot	
#undef	vpage	

#ifdef	notdef
 # call mapout
 # mapout(ppage)
	mr	r2,ppage		# get ppage
	l	r3,_ppages_per_vmpage	# how many ppages to unmap.
	get	r4,$(_lo_mapout)	# get dap
	l	r15,0(r4)		# get entry point 
	balrx	r15,r15			# 
	mr	r0,r4				
 # call mapin
 # mapin(ppage,vpage,prot,2,sid)
#define	SID_OFFSET	0	/* stack offset	to 5th param to mapin */ 
 	sts	sid,SID_OFFSET(r1)	# store 5th parameter
	mr 	r2,ppage
	mr	r3,vpage
	mr	r4,prot
	l	r5,_ppages_per_vmpage	# how many ppages to remap.
	get	r14,$(_lo_mapin)	# this blasts the value of vpage
	l	r15,0(r14)		
	balrx	r15,r15
	mr	r0,r14	
#endif	notdef	
