/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 ***********************************************************************
 * HISTORY
 * $Log:	locore.c,v $
 * Revision 2.10  88/11/23  16:23:08  rpd
 * 	Changed includes to the new style.
 * 	Picked up 135 support from Acis.
 * 	[88/11/04  17:10:12  rpd]
 * 
 * Revision 2.9  88/10/06  13:48:34  sanzi
 * 	Use register r5 instead of r8 for cache_lookup.
 * 
 * Revision 2.8  88/08/24  01:40:44  mwyoung
 * 	Fix CS_KDB references to use CMUCS_KDB.
 * 	[88/08/23            mwyoung]
 * 	
 * 	Corrected include file references.
 * 	[88/08/22            mwyoung]
 * 
 * Revision 2.7  88/08/06  18:05:01  rpd
 * Added definition of master_cpu variable.
 * 
 * Revision 2.6  88/08/04  11:13:25  dorr
 * replace after_svc_call_c label, remove bad load
 * from syscall bounce sequence.
 * 
 * Revision 2.5  88/07/29  03:17:24  rpd
 * Fixed single-user boot.
 * 
 * Revision 2.4  88/07/20  16:16:14  rpd
 * Merged in Dan Julin's changes:  "Moved RDB and the symbol table
 * to allow for a bigger symbol table."  Need bigger symbol table
 * to support longer names in the symbol table.
 * 
 * 21-Mar-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	ROMP_CACHE changes.  Deleted whichqs and qs (unused scheduling
 *	variables). 
 *
 * 24-Dec-87  David Golub (dbg) at Carnegie-Mellon University
 *	Remove NEW_SCHED conditional.
 *
 * 22-Dec-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added macro for FLIPMODE.  (Inspired by ACIS macro).
 *
 *  7-Dec-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Fixed flipmode to again protect the kernel correctly.
 *
 *  8-Oct-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added (from ACIS) check for latest APC configuration which has
 *	no memory on the processor card.
 *
 *  2-Oct-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	In fault(), if the user is single stepping, then set the single
 *	step bit in the user's ics_cs.  This used to be r4, but r4 is no
 *	longer used that way, thus we must fetch the value from the saved
 *	area on the stack.
 *
 *  8-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Changed to start_init() to work correctly with the new stack
 *	layout.
 *
 * 26-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added declarations of intrcnt and eintrcnt from ACIS (of dubious
 *	value).
 *
 * 20-Jul-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Install change from Bill Bolosky to check for kernel stack
 *	fault and loop in the DDS display when detected.
 *	[ V5.1(XF14) ]
 *
 *  5-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Deleted ROMP_FPA option.
 *
 *  3-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_APC: added APC support ala ACIS code.  Also modified 
 *	things (like svc code) to correspond more closely with ACIS
 *	stuff.  
 *
 * 18-Apr-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added routine start_init under MACH.  Also purged all usages
 *	of KERNSTACK under MACH.  
 *
 *  1-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Start MACH support.
 *
 *  2-Feb-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added support for KDB.
 *
 *  9-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Update for MACH.
 *
 *  2-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Add definition of INCLUDE_VERSION as a global.
 *
 * 26-Jan-87  Moose Lodge (dpj, dbg, wjb) at Carnegie-Mellon University
 *	Fixed new icode to load R0..R6 for initial program.
 *
 * 15-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Push SVC stack frame for call to main - get initial PC and SP
 *	from stack frame afterwards (instead of old icode).
 *
 * 13-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Removed include of "mach_shm.h".
 *
 **********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <romp_135.h>
#include <romp_apc.h>
#include <romp_cache.h>
#include <romp_debug.h>
#include <romp_rdb.h>
#include <romp_nfl.h>
#include <mach_load.h>
#include <mach.h>
#include <cmucs_kdb.h>
#include <ca/rdb.h>

#include <ca/cpu.h>
#if	ROMP_APC
#include <ca/ioim.h>
#endif	ROMP_APC
#include <ca/frame.h>
#include <ca/fpa.h>
#include <ca/float.h>
#if	MACH
#include <ca/vm_param.h>
#endif	MACH

	.globl	.oVncs
	.set	.oVncs , 0

 #  This module contains the low level code for Mach/4.3 running on the
 #  IBM AUSTIN SAILBOAT prototype workstation.
 #  This is a modification of the Original YORKTOWN port for a PC/XT ROMP
 #  configuration by IRIS at Brown University.
 #  The major functions of this code are:
 #
 #  . Initialize the ROMP after a "power on reset"
 #  . Intercept program checks, machine checks, and trap instructions.
 #  . Field and route processor interrupts.
 #  . Provide subroutines to access the special machine registers.
 #  . Provide highly efficient subroutines for some common functions.
 #
 # An interface it provided to a debugger (originally "RDB") that
 # co-operates with the kernel in order to provide a debugging
 # environment with the kernel.
 # the debugger is linked to run in real mode, while the kernel is linked
 # for virtual mode. the addresses are allocated as follows:
 # (when the debugger is present)
 # 0-ff          not really used much
 # 100-1af       interrupt vectors (shared)
 # 1b0-200       unused
 # 200-800       debugger stack (runs down from 800)
 # 800-fff       POST (must be preserved for control-alt-del to work)
 # 1000-5fff     kernel locore code
 # 6000-22fff   debugger (DEBUG, used to be RDB)
 # 2300-2efff    kernel symbol table
 # ...           rest of the kernel (C code)
 #
 # the interrupt vectors are shared as follows:
 # 1. the kernel initializes then statically
 # 2. the debugger takes over 100, 170, 180, 190, 1a0 (pseudo vector)
 # 3. the kernel takes back   100, 170, 180, 190 and remembers the
 #       debuggers values so that it can pass control to the debugger
 #         
 # when the debugger is not present then the original static values
 # remain in effect.
 #


#include <sys/version.h>
	.globl	_INCLUDE_VERSION
	.set	_INCLUDE_VERSION,INCLUDE_VERSION

         .text                   # everything goes into text (even data)

 # locore.h defines constants etc. but does not generate any code/data.
#include <ca/locore.h>
#include <ca/pmap.h>		# useful #defines
#include <ca/lofault.h>
#include <ca/led.h>

 # lointpsw sets up the interrupt vectors and leaves space for POST,
 # debugger etc.

#include <ca/lointpsw.s>
 #       JUMP TO the REAL Locore START .....  WHEREEVER THAT MAY BE
 #
 #       following code normally lands at 0x1000 (on Model).
 #
	.globl _start
#if	!ROMP_RDB
_start:
#endif	ROMP_RDB
	.using	real0,r0	# tell the assembler to use r0 as base
	cal16	r15,start	# use 'cal16' to ignore segment number
	balr	r15,r15		# transfer control to real 'start'
origin: .short 0x8080            # trap for undefined external references
	.align	2

#include <ca/scr.h>
#include <ca/rosetta.h>
#include <assym.s>

 
#define USTRUCT ENDOFP1-USIZE
 
	/* From h/msgbuf.h */
#define MSGBUFPAGES 2		/* Size of console message buffer in pages */

	/* From h/mbuf.h */
#define NMBCLUSTERS 256		/* Number of memory buffer clusters */

	/* Should be in h/buf.h! */
#define MAXBUFFERPAGES 512	/* 1MB worth of buffers should be enough */

/* There's probably more than this */
/****************************************************************************/
 
 #==================| hardware related constants |==================|
 
#define SEGSIZE  0x10000000		/* 256M bytes per rosetta segment */

#define MAXPHYSMEM  0x1000000		/* (bytes) Not more than 16M real mem */
 
#define UPPER 0x10000			/* scale factor for UPPER instructions */
	
 #==============| HAT-IPT - Located in the last pages of memory |=============|
 
#define HATIPTSIZE 16                  /* size of one HAT IPT entry */
#define LOG2HATIPTSIZE  4               /* shift for HAT IPT entry */
 
 #  fields of a HAT-IPT entry:
 
#define SYS_ADDRTAG RTA_SID_SYSTEM<<RTA_VPAGE_BITS 
						/* k1,k2 = 0; sid = system */

#define IPTADDRTAG  0                   /* offset of IPT ADDR TAG field */
#define IPTHATPTR  4                    /* offset of IPT HAT PTR field */
#define IPTIPTPTR  6                    /* offset of IPT IPT PTR field */
#define IPTLOCK  8                      /* offset of IPT LOCK WORD field */

#define BALA		0x8a000000	/* a BALA instruction base */

 #=====================| constants and variables |======================|

#if	ROMP_DEBUG
/*BJB*/	.globl	_active_ints
#endif	ROMP_DEBUG
        .globl	_RTA_HATIPT
	.globl	_RTA_HASHMASK
	.globl	_is_in
        .globl	_firstaddr
	.globl	_maxmem
	.globl	_physmem
	.globl	_holestart
	.globl	_holeEnd
	.globl	_freemem
        .globl	_nrpages
        .globl	_noproc
	.globl	_runrun
	.globl	_boothowto
	.globl	_memconfig
	.globl _fpa_curreg
	.globl _float_hardware
#if	ROMP_APC
	.globl	_mc881_thread
	.globl	_cpu_model
#endif	ROMP_APC
	.globl	_master_cpu
	.globl	_ser
	.globl	_sear
	.globl	__trap
	.globl	_trap
	.globl	_rose_page_size
	.globl	_rose_page_shift
	.globl	_ast
	.globl	_ppages_per_vmpage
	.globl	_ioim2
         .align 2		# *tjm
 # 
 #  Masterpaddr is the p->p_addr of the running process on the master
 #  processor.  When a multiprocessor system, the slave processors will have
 #  an array of slavepaddr's.
 #
	.globl	_masterpaddr
_masterpaddr:
	.long	0
	.globl	_slave_proc
_slave_proc:
	.long	0
	.long	0
	.long	0
	.long	0
	.globl	_master_idle
_master_idle:
	.long	0
 #
 # note: autoconfig will change the value of _trap to intercept
 # traps during autoconfig that would confuse the regular
 # trap routine.
 # it will reset it back before returning control to the caller
 #
__trap:	.long	_trap		# address of trap routine
	.globl	_cnt
__cnt:	.long	_cnt		# address of cnt
#if	ROMP_DEBUG
_active_ints:
	.long	0
#endif	ROMP_DEBUG
 # hatipt is used in non-translated code, _RTA_HATIPT when translate on
 # note: following 16 words are set to zero at 'start' time.
 #

hatipt:		.long	0		# real address of hatipt
_RTA_HATIPT:	.long	0		# virtual address of hatipt
_RTA_HASHMASK:	.long	0		# mask for virt addr hashing
_is_in:		.long	0		# bitvector for physical pages
_nrpages:	.long	0		# number of pages installed
_firstaddr:	.long	0		# first page past static kernel
_maxmem:	.long	0		# top of available memory (pages)
_physmem:	.long	0		# size of installed memory (pages)
_freemem:	.long	0		# size of allocatable memory (pages)
_holestart:	.long	0		# beginning of memory hole
_holeEnd:	.long	0		# end of memory hole
_noproc:	.long	0		# no process running now
__lc_dummy_1:	.long	0		# dummy place holder
__lc_dummy_2:	.long	0		# dummy place holder
__lc_dummy_3:	.long	0		# dummy place holder
__lc_dummy_4:	.long	0		# dummy place holder
_boothowto:	.long	0		# passed from boot to init (in r11)
_memconfig:	.long	0		# software memory config
_rose_page_size:  .long	0		# hardware page size
_rose_page_shift: .long	0		# shift for hardware page #
_ast:		.long	0		# vax ast simulation hack
_fpa_curreg:	.long	FPA_NONE	#current FPA register set
_float_hardware: .long 0
_ppages_per_vmpage:	.long	0	# initialized by pmap_bootstrap()
#if	ROMP_APC
_mc881_thread:	.long	-1		# nobody using it now
_cpu_model:	.long	CPU_SGP		# assume old until reset
#endif	ROMP_APC
_master_cpu:	.long	0		# no uP RTs
_ser:		.long	0		# SER from last trap
_sear:		.long	0		# SEAR from last trap
_ioim2:		.long	0		
_cnt:		.fill 32,4,0		# meter counts (see h/vmmeter.h)
	.globl	_intrcnt		# interrupt counts 
	.globl	_eintrcnt		# end of counts
_intrcnt:	.fill	26,4,0
_eintrcnt:	.long	0


#if	ROMP_APC
 # place the kernel exception stack here where it is in read-write
 # memory
	.globl	_ecrstack
_ecrlimit:
	.fill	4*4,4,0		# room for 4 exceptions 
_ecrstack:
	.long	0		# spacer
#define ECR_STACK (_ecrstack-real0)
#endif	ROMP_APC

#if	CMUCS_KDB
	.globl	_kdbintr		# flag for KDB entry from interrupt level 0
_kdbintr:
	.long	0
#endif	CMUCS_KDB
	 
#if	ROMP_RDB
#define RDBADRLOC  0x210	/* Address where rdb's address will be storred by build */
callrdb_ps:
	.long  RDBADRLOC		# new iar (Will be set to rdb's addr)
	.short NOTRANS_ICS+INT_PRI0	# new ics: xlate off, int level 0
	.short 0			# reserved
#endif	ROMP_RDB
	 
callmain_ps:
	 .long  _.main
         .short TRANS_ICS+INT_PRI7  # new ics: xlate on, int level 7
         .short 0                   # reserved
go_callslih:
         .long  callslih            # new iar
         .short TRANS_ICS           # new ics: xlate on
         .short 0                   # reserved
go_afterslih:
         .long  afterslih-real0     # new iar
         .short NOTRANS_ICS+INT_PRI1# new ics: xlate off, PRIO 1
         .short 0                   # reserved
go_ps:
         .long  go - real0          # new iar
         .short NOTRANS_ICS+INTMASK_ICS+INT_PRI1 # new ics: xlate off, interrupts off
         .short 0                   # reserved
#if	ROMP_APC
go2_ps:
         .long  go2 - real0		# new iar
         .short NOTRANS_ICS+INTMASK_ICS	# new ics: xlate off, interrupts off
         .short 0			# reserved
#endif	ROMP_APC
fault_ps:
         .long  fault               # new iar
         .short TRANS_ICS+INTMASK_ICS # new ics: xlate on, interrupts off
         .short 0                   # reserved
svc_ps2:
         .long  _svc                 # new iar
         .short TRANS_ICS+INTMASK_ICS+INT_PRI7 # new ics: xlate on, int off
         .short 0                   # reserved
display_ps:
	.int 	display_go-real0
	.short	NOTRANS_ICS+INT_PRI0
	.short	0
display_ps2:
	.int 	display_go2
	.short	TRANS_ICS		# previous ics stored here
	.short	0

callsetup_ps:
	 .long  _.setup_main
         .short TRANS_ICS+INT_PRI1  # new ics: xlate on, int level 1
         .short 0                   # reserved
callrompinit_ps:
         .long  _.romp_init               # new iar
         .short TRANS_ICS+INT_PRI1  # new ics: xlate on, int level 1
         .short 0                   # reserved

	.globl	_low_ps		# fault() debugging  
_low_ps:	
 #  register save areas:

low_ps     :.long 0,0           # addressable space for lps
 # WARNING: code in the return from interrupt routines relies on these being
 # in this order with nothing in between....change it at your own risk!
low_save0  :.long 0             # save for r0
low_save1  :.long 0             # save for r1
low_save2  :.long 0             # save for r2
low_save3  :.long 0             # save for r3
low_save4  :.long 0             # save for r4
low_save5  :.long 0             # save for r5
low_save6  :.long 0             # save for r6
low_save7  :.long 0             # save for r7
low_save8  :.long 0             # save for r8
low_save9  :.long 0             # save for r9
low_save10 :.long 0             # save for r10
low_save11 :.long 0             # save for r11
low_save12 :.long 0             # save for r12
low_save13 :.long 0             # save for r13
low_save14 :.long 0             # save for r14
low_save15 :.long 0             # save for r15

flipsave   :.long 0,0,0,0       # save for flipmode subroutine
/*
 *	The VM system initializes the sigcode out of setup_main, so it
 *	needs to be global.
 */
	.globl	_sigcode
_sigcode:
 # Signal trampoline code
sigcode: svc   139(r0)              # template moved to u area for signals

 # External I/O Interrupt Save Area Storage
 # Moved here from lointr for addressability
	.align 2
		.globl  _iosavep
_iosavep:
iosavep:	.long	iounmask-real0	# Interrupt Level Stack Pointer
					# (Initially Points to iounmask)
iosavea:	.space  40*IOSAVEL 	# Interrupt Level Save Area Stack
iounmask:	.long	0xFFFFFFFF	# Main Level "Interrupt Enable" Mask
					# (Must Immediately Follow iosavea)
ioenable:	.long   SETIO		# Master Interrupt Enable Word
iosave6:	.long	0x00000000	# R6 save Area for I/O Interrupts

	.globl	_kern_fpm
	.globl  KERN_FPM
_kern_fpm:
KERN_FPM: .space FPM_STATUS # save space for FP emulator
	     .long  FP_S_UNSGD  # initialize fpm.status
	     .space FPMACHSIZE-FPM_STATUS-4
 
 
 #  kernel profiling data
 
#define kpf_base 0x3000         /* base address of kernel profiling vector */
#define kpf_hz    10            /* (profiling ticks) / (Unix hardclock ints) */
           .globl _kpf_onoff
_kpf_onoff :
kpf_onoff  :.long 0             # kernel profiling on/off (initially off)
kpf_ticks  :.long 0             # counter
 
 #  literals:

_origin$   :.long  origin       # base address of locore
_edata$    :.long  _edata
_end$      :.long  _end
#if	ROMP_RDB
_szsymtbl$ :.long  0x200	# Hard wired address of size of symbol tbl.
#endif	ROMP_RDB
	   .globl  _loadpt
_loadpt    :.long  SYSBASE_ADDR	# Load point address 
_trap$     :.long  _trap
aftermain$ :.long  aftermain
_printf$   :.long  _printf
_panic$    :.long  _panic
real0$    :.long  real0
 a_tmp_stk:
	.long	tmp_stack
 a_after_init:
	.long	after_init
 a_after_setup:
	.long	after_setup
 a_active_threads:
	.long	_active_threads
 a_active_pmap:
	.long	_active_pmap
#if	PMAP_STATISTICS	
 a_last_pmap:
	.long	_last_pmap
#endif	PMAP_STATISTICS		
 a_load_context:
	.long	_.load_context

	.globl 	_saved_kernel_stk
 _saved_kernel_stk:	
 saved_kernel_stk:	.long	0

 
        .globl start
eye_catcher(start):

 #  zero registers (as after a POR reset)
 
	st	r11,_boothowto		# save first reg arg for init
 s r0,r0;s r1,r1;s r2,r2;s r3,r3;s r4,r4;s r5,r5;s r6,r6
 s r7,r7;s r8,r8;s r9,r9;s r10,r10;s r11,r11;s r12,r12
 s r13,r13;s r14,r14;s r15,r15
 
         mts scr_ts,r15			# reset romp timer status
#if	ROMP_RDB
	stm	r0,hatipt		# reset initial values
#ifdef	notdef	
	stm	r0,_qs			# clear 16 entries
	stm	r0,_qs+(64*1)		# clear 16 entries
	stm	r0,_qs+(64*2)		# clear 16 entries
	stm	r0,_qs+(64*3)		# clear 16 entries
	stm	r0,_qs+(64*4)		# clear 16 entries
	stm	r0,_qs+(64*5)		# clear 16 entries
	stm	r0,_qs+(64*6)		# clear 16 entries
	stm	r0,_qs+(64*7)		# clear 16 entries
#endif	notdef	
	get	r0,$(iounmask-real0)	# get the interrupt stack base
	st	r0,iosavep		# more re-entrant than before
#else	ROMP_RDB
 # following is not done for RDB so that one can step thru locore
 # using the debugger (otherwise the following turns of IRQ_0)
	mts scr_irb,r15			# reset romp interrupt request buffer
#endif	ROMP_RDB
	cau r2,(ROSEBASE)>>16(r0)     	# i/o base address of Rosetta
	oil r2,r2,(ROSEBASE)&0xffff     # i/o base address of Rosetta
        iow   r14,ROSE_SER(r2) 		# clear the exception register

 # Initialize the Interrupt system

 # Initially turn off all I/O BUS Interrupt mapping
         cau     r2,IOBASE(r0)           # Get IO base bus address
	 cau     r0,(SETIO)>>16(r0)      # Load SET IO INT to ROMP INT constant
	 oil     r0,r0,(SETIO)&0xffff

         st      r0,ioenable             # Save initial IOENABLE

#if	ROMP_RDB
 #  save pck new iar (only once per memory load)
 #  the interrupt vectors were set by us, and have been taken
 #  over by the debugger.
 #  we will take back the program check and save the debugger's new iar
 #  so that we can call it when we have to.
 #  interrupt level 0 and svc areas are treated similarly.
 #
 
         l     r0,pck_ps+new_iar       # pick up existing pck iar
         cal16 r1,pck0                 # pick up my pck iar
         c     r0,r1                   # ?. points to us?
         je    pck_ok                  # no need to insert our pck addr
         cal16 r2,pck_jump_to_dan      # address of br instr.
         s     r0,r2                   # offset to him
         sri   r0,1                    # divide by 2
         niuo  r0,r0,0x000f               # clear top 12 bits
         oiu   r0,r0,0x8880               # branch uncond
         sts   r0,0(r2)                # make it jump to him
#if !defined(LORDB)
         st    r1,pck_ps+new_iar       #  set up pck new iar
#endif	LORDB
pck_ok:
         l     r0,mck_ps+new_iar       # pick up existing mck iar
         cal16 r1,mck0                 # pick up my mck iar
         c     r0,r1                   # ?. points to us?
         je    mck_ok                  # no need to insert our mck addr
         cal16 r2,mck_jump_to_dan      # address of br instr.
         s     r0,r2                   # offset to him
         sri   r0,1                    # divide by 2
         niuo  r0,r0,0x000f               # clear top 12 bits
         oiu   r0,r0,0x8880               # branch uncond
         sts   r0,0(r2)                # make it jump to him
#if !defined(LORDB)
         st    r1,mck_ps+new_iar       #  set up mck new iar
#endif	LORDB
mck_ok:
 
 #  set up svc new ps:  svc0, no translation, interrupts masked, level 0
 
        cal16 r0,svc0                  # address of svc handler
        st    r0,svc_ps+new_iar        # store in new ps
	cau   r0,(NOTRANS_ICS+INTMASK_ICS)>>16(r0) #ics: no transl, ints masked
	oil   r0,r0,(NOTRANS_ICS+INTMASK_ICS) &0xffff
        sth   r0,svc_ps+new_ics        # store in new ps
 
 #  save int0 new iar (only once per memory load)
 
         l     r0,int0_ps+new_iar      # pick up existing int 0 iar
         cal16 r1,int0                 # pick up my int 0 iar
         c     r0,r1                   # ?. points to us?
         je    int0_ok                 # no need to insert our int addr
         cal16 r2,int0_jump_to_dan     # address of br instr.
         s     r0,r2                   # offset to him
         sri   r0,1                    # divide by 2
         niuo  r0,r0,0x000f               # clear top 12 bits
         oiu   r0,r0,0x8880               # branch uncond
         sts   r0,0(r2)                # make it jump to him
#if !defined(LORDB)
	 st	r1,int0_ps+new_iar	# set up int 0 new iar
#endif	LORDB
int0_ok:
#endif	ROMP_RDB
#if	ROMP_APC
/*
 * determine the processor model (either SGP or ROMPC) by setting
 * the Interrupt On Unaligned Access bit which is always 0 on the SGP
 * processor.
 */
	mfs	scr_ics,r0		# get old ics
	setsb	scr_ics,18-16		# set Interrupt On Unaligned Access
	mfs	scr_ics,r4		# get new ics
	c	r0,r4
	jeq	2f			# same - old cpu
	mts	scr_ics,r0		# restore old ics
#if	ROMP_135
/*
 * If bit 20 in register IOIM_MCC of ZIC IOIM1 == 1 then APC
 * else MOD135.
 */
	get	r4,$IOIM1		# get base of IOIM1
	ior	r4,IOIM_MCC(r4)		# get chip configuration register
	nilz	r4,r4,0x800		# if 1 then APC, if 0 then MOD135
	jne	3f			# branch if APC
	lis	r0,CPU_MOD135		# else its a MOD135
	st	r0,_cpu_model		# store cpu model number
 # if old ZIC then apply fix
	get	r6,$IOIM1		# get base of IOIM1
	ior	r4,IOIM_GSR(r6)		# get GSR to clear it
	ior	r4,IOIM_GSR(r6)		# get GSR to see if bit 20 stuck at 1
	nilz	r4,r4,0x800		# is bit 20 set?
	jeq	4f			# no, new ZIC
	ior	r4,IOIM_GCR(r6)		# yes bit 20 set, old ZIC, apply fix
	setbl	r4,6			# turn on bit 22
	iow	r4,IOIM_GCR(r6)		# write to GCR
4:	get	r0,$0x08c8		# we have 16 meg (ala APC card)
	sth	r0,_memconfig+2		# flag it in lower half of memconfig
	j	0f			# end of MOD135 specific stuff
3:
#endif ROMP_135
	lis	r0,CPU_ROMPC
	st	r0,_cpu_model		# store cpu model information
	get	r4,$IOIM1		# get base of IOIM1
	ior	r4,IOIM_MCC(r4)		# get chip configuration register
	nilz	r4,r4,0x1000		# test for -RAM
	jne	0f			# yes we have no RAM
	get	r0,$(0x08)		# we have 4meg on-card
	stc	r0,_memconfig+2		# flag it in third byte
0:	
	get	r0,$ECR_STACK
	mts	scr_ecr,r0	# reset exception stack
2:
#endif	ROMP_APC
 
	.globl _clrloop
_clrloop:


#include <ca/lohatipt.s>

	/*
	 *	Perform basic Romp initialization. Done in virtual mode, thus
	 *	it is necessary to have set up the hat/ipt by now (done by
	 *	lohatipt.s)
	 */
	
	.using	real0,r0		#set up base register (no base mode)
	l	sp,a_tmp_stk		#temporary stack for setup stuff.
	l	r15,a_after_init
	get	r0,$_romp_init		#constant table address for romp_init
	lps	0,callrompinit_ps	
	/*
	 *	Turn on virtual memory & call setup_main.
	 */
after_init:
	bali	r14,new_base
new_base:
	.using	new_base,r14
	l	r15,a_after_setup	#sp left over from last one.
	get	r0,$_setup_main		#constant table
	lps	0,callsetup_ps

	/*
	 *	Set up the initial PCB.
	 */

after_setup:
	bali	r12,another_base	#where I come from, r12 is the base...
another_base:
	.using	another_base,r12
	cas	r2,r2,r0		# This noop avoids phase errors (sigh)
	l	r14,THREAD_PCB(r2)
	st	r14,PCB_R14(r14)
	l	r15,a_load_context
	balr	r15,r15			# load_context
	.globl	_after_lc
_after_lc:
	bali	r12,yab
yab: 					#yet another base
	.using	yab,r12

        l	r15,aftermain$
	get	r0,$_main			#constant table
	lps	0,callmain_ps
	.align	2
	.fill	1024,4,0
tmp_stack:					# label comes after, because
						# stack builds down

1:	.using 	1b
 #
 #  
 #      start_init:
 #
 #	C code in main() calls this routine to setup a system state
 #	which makes it look like a system trap just occurred, and then
 #	to call load_init_program()
 #
 #	r2 == thread

eye_profil(start_init):
	/*
	 * Load active_theads[0]->kernel_stack in sp.
	 */
	bali	r6,start_init_base	# C preserves r6
start_init_base:
	.using	start_init_base,r6
	l 	r2,a_active_threads	#
	l	r2,0(r2)		# XXX fails on multiprocessors
	l	r1,THREAD_KSP(r2)	# base of Kernel Stack
	ai	r1,r1,$(KERNEL_STACK_SIZE - FAULTSAVE)
 # set u.u_ar0 = FAULT_R0(sp) : must do this since execve() uses it.
 	cal	r3,FAULT_R0(r1)		# point r3 at R0 on stack
	l	r2,UTHREAD(r2)		# get th->u_address.uthread
	st	r3,U_AR0(r2)		# u_ar0 = &R0
 #
 	get	r13,$_load_init_program	# get constant pointer
	ls	r15,0(r13)		# get entry address
	balrx	r15,r15			# load "init"
	mr	r0,r13			# copy in constant area pointer
 #	cal	sp,8(sp)		# make sp point at R1
	get	r15,aftermain$ 		# get addressability for aftermain
	br	r15
	
 #
 #  resume here after _main, in proc 0 (/etc/init);  jump to icode
 #  note: This code now munges the sp, so it is important that the
 #  interrupt mask gets turned on here.
 #
eye_catcher(aftermain):
	.using aftermain,r15		# use the return register as base
	setsb	scr_ics,INTMASK-16	# mask interrupts
	l	r0,FAULT_IAR(sp)	# get pc set up by execve
	st	r0,low_ps		# place in low_ps
	l	r0,FAULT_R1(sp)		# get user stack pointer
	st	r0,low_save1		# store for 'go' to load

	 # transl on, prob stt, lev 7
	get	r0,$(TRANS_ICS + PROBSTATE_ICS + INT_PRI7)
	sth	r0,low_ps+4		# place in low_ps
	l     r0,FAULT_R0(sp)		# load R0 (set by execve)
	lm    r2,FAULT_R2(sp)		# load R2 through R15 (R2..R6 set by
					# execve)
	mfs   scr_iar,r15		# get addressability again
1:	.using 1b,r15			# tell assembler
	l	r11,_boothowto		# put boothowto in R11 for old /etc/init
	lps	0,go_ps			# turn xlate off, bop off to go

 #
 #  go - reload registers and old ps from low core
 #      on entry:
 #          interrupts are masked <=== VERY IMPORTANT AS SP INVALIDATED
 #          translation is OFF --> Note, different from ACIS !!
 #          low_save1,low_save15, and low_ps are set
 #	   r2 ... r14 have the required final values (lm already done)
eye_catcher(go):
	.using	real0,r0
	l	r15,low_ps+old_ics_cs	# get old icscs
	mttbiu	r15,PROBSTATE-16	# problem state?
	jntb	go_now			# no...returning to system
go_user:
	l	r15,_ast		# vax ast scheduled?
	ci	r15,0
	bne	go_ast			# if so, bop thru trap
	bali	sp,flipmode		# flip into user mode (EATS R15!)
#if	CMUCS_KDB
go_now:
#endif	CMUCS_KDB
	l	r15,low_ps+old_ics_cs	# get old icscs (again, sigh)
	mttbiu	r15,INSTSTEP-16		# instruction step?
	jtb	go_step			# yes...do it
#if	CMUCS_KDB
#else	CMUCS_KDB
go_now:
#endif	CMUCS_KDB
	l	r1,low_save1
	l	r15,low_save15
        lps	0,low_ps	# reload old ps, immediate interrupts ok
go_step:
	setsb	scr_irb,IRB_IRQ_0	# request level 0 interrupt
	l	r1,low_save1		# restore old r1
	l	r15,low_save15		# restore old r15
	lps	1,low_ps	# reload old ps, no interrupts for 1 inst
go_ast:
	get	sp,saved_kernel_stk
	l	r15,low_save15	
	stm	r10,low_save10
	get	r10,$(VAST)
	x	r11,r11
	x	r14,r14			# clear exception information
	st	r11,_ast		# clear ast
	l	r12,low_ps+old_iar
	l	r13,low_ps+old_ics_cs
	lps	0,fault_ps
1:	.using	1b
#if	ROMP_APC
 #
 #  go2 - reload registers and old ps from low core
 #      on entry:
 #          interrupts are masked <=== VERY IMPORTANT AS SP INVALIDATED
 #          translation is OFF --> Note, different from ACIS !!
 #          low_save1,low_save15, and low_ps are set
 #	    r2 ... r14 have the required final values (lm already done)
eye_catcher(go2):
	.using	real0,r0
	l	r15,low_ps+old_ics_cs	# get old icscs
	mttbiu	r15,PROBSTATE-16	# problem state?
	jntb	go2_now			# no...returning to system
go2_user:
	l	r15,_ast		# vax ast scheduled?
	ci	r15,0
	bne	go2_ast			# if so, bop thru trap
	bali	sp,flipmode		# switch to user mode (EATS R15!)
#if	CMUCS_KDB
go2_now:
#endif	CMUCS_KDB
	l	r15,low_ps+old_ics_cs	# get old icscs (again, sigh)
	mttbiu	r15,INSTSTEP-16		# instruction step?
	jtb	go2_step		# yes...do it
#if	CMUCS_KDB
#else	CMUCS_KDB
go2_now:
#endif	CMUCS_KDB
         l     r1,low_save1         # restore old r1
         l     r15,low_save15       # restore old r15
         lps   2,low_ps             # reload old ps, immediate interrupts ok

go2_step:
	setsb	scr_irb,IRB_IRQ_0	# request level 0 interrupt
 # we always do a lps 2 (interrupt 0 intr. before instruction) because
 # the IAR will already have been advanced when the original exception
 # was delivered.
	l	r1,low_save1		# restore old r1
	l	r15,low_save15		# restore old r15
	lps	2,low_ps		# reload old ps, interrupt before inst
go2_ast:
	get	sp,saved_kernel_stk
	l	r15,low_save15		# restore old r15
	stm	r10,low_save10		# assure low_save1, low_save10 thru 15
	get	r10,$VAST		# mcs_pcs value for VAX AST
	x	r11,r11			# no more info needed
	x	r14,r14			# ditto
	st	r11,_ast		# clear ast
	l	r12,low_ps+old_iar	# retieve old iar
	l	r13,low_ps+old_ics_cs	# retieve old ics_cs
	lps	0,fault_ps		# short circuit int, handle fault
1:	.using	1b
#endif	ROMP_APC
 #
 #  flipmode - flip the segment registers from user/kernel to kernel/user
 #      on entry:
 #          interrupts are masked
 #          translation is off
 #          sp contains the return address
#define FLIPSEG(segreg,rosebase,sid)				     	\
	ior	sid,segreg(rosebase);  /* read segment register */ 	\
	xil	sid,sid,1;                 /* flip key bit value */ 	\
	iow	sid,segreg(r15)	/* set segment reg to value of r13 */

#define	FLIPMODE(rosebase,sid)			\
	get	rosebase,$RTA_SEGREG0;		\
	FLIPSEG(14,rosebase,sid);

eye_catcher(flipmode):	
_flipmode:
         .using real0,r0
	.globl _flipmode
	stm   r14,flipsave            # save caller's registers
	FLIPMODE(r15,r14)
	brx   sp                      # return to caller...
	lm    r14,flipsave            # with caller's registers restored
1:	.using 1b                      # tell assembler no base register

	
 #
 #  svc level 0 interrupt service routine
 #  on entry interrupts are inhibited, priority = 7, and 
 #  translate is off.
 #
	.globl  svc0
	.globl	_svc0
         .using real0,r0
_svc0:
svc0:
	st	r1,low_save1		# save r1
	stm	r12,low_save12		# save r12-r15
	bali	sp,flipmode		# switch to kernel mode
	lm	r12,svc_ps+old_iar	# get interrupt time iar, ics & code
	get	sp,saved_kernel_stk	# switch to kernel stack
	lps	0,svc_ps2		# goto svc: trans on, int off
1:       .using 1b


 #
 # come here with interrupts inhibited, level 7 (user level)
 # and translation on.
 #
 # sp = kernel stack
 # r12 = interrupt time iar
 # r13 = ics_cs at interrupt time
 # r14 = svc new iar (not used)
 # r15 = new ics (not used) and svc code
 #
 # r9 is used to save/restore the mq
 #
 # call syscall(0, svc_code, regs (&locr0) ) 
 #
	.globl	_svc
_svc:
	ai	sp,sp,-FAULTSAVE	# make room for context
svcstm:	stm	r2,FAULT_R2(sp)		# save all registers (some incorrect)
	st	r0,FAULT_R0(sp)		# save r0
	st	r12,FAULT_IAR(sp)	# save iar at time of interrupt
	lis	r2,0			# 1st parm to syscall (mcs_pcs)
	nilz	r3,r15,0xffff		# 2nd parm (info)
	cal	r4,FAULT_R0(sp)		# 3rd parm (locr0)

	mfs	scr_mq,r9		# get current multiplier/quotient
	st	r9,FAULT_MQ(sp)		# save context
	mfs	scr_iar,r6		# get addressability to low storage
1:	.using 1b,r6			# tell the assembler (C preserves R6)

	l	r15,low_save1		# value of r1 at time of interrupt
	sts	r15,FAULT_R1(sp)	# correct value on stack
#if	ROMP_APC
	lis	r15,0			# get value for FAULT_ECR
	st	r15,FAULT_CNT(sp)	# and mark no exception packets
#endif	ROMP_APC

#ifndef	LORDB
	mfs	scr_irb,r15		# get copy of irb
	mttbil	r15,IRB_IRQ_0		# get int level 0 bit
	mftbiu	r13,INSTSTEP-16		# set as instruction step bit in icscs
	clrsb	scr_irb,IRB_IRQ_0	# cancel level 0 int request if any
#endif	LORDB

	st	r13,FAULT_ICS_CS(sp)	# save icscs at time of interrupt
	lm	r12,low_save12		# values of r12-r15 at time of int
	stm	r12,FAULT_R12(sp)	# correct values on stack
	clrsb	scr_ics,INTMASK-16	# enable interrupts now
#include <mach_emulation.h>
#define	FAST_SYSCALL	0
#if	FAST_SYSCALL
#include <ca/losyscall.s>
#endif	FAST_SYSCALL
#if	MACH_EMULATION
	/*
	 * If emulation is enabled for this task, and if the
	 * syscall is a unix syscall, then change the return address
	 * in the user's registers to the emualtion entry
	 * vector and return.
	 *
	 * 	Register Usage:
	 *		r2-r5:  parameters to syscall()
	 *		r6: base register (set on entry)
	 *		r8: current_task
	 *	
	 */
	l	r10,a_active_threads	# get current_thread()->
	l	r10,0(r10)		# 
	l	r9,THREAD_TASK(r10)	# get current_task()->
	l	r8,TASK_EML_DISPATCH(r9)# get struct eml_dispatch_t *
 	ci	r8,0			# is emulation on?
	jeq	svc_call_c		# no, handle normally	 
	ci	r3,0			# test svc number
	jl	svc_call_c		# if < 0 then a mach syscall
	l	r7,DISP_COUNT(r8)	# get max syscall number
	c	r3,r7			# is r3 > r7  ?
	jhe	svc_call_c		# let syscall() worry about it.

	mr	r9,r3			# get info number
	shl	r9,2			# make it an index
	cal	r8,DISP_VECTOR(r8)	# get actual start of vector
	cas	r8,r8,r9		# get address of entry vector
	l	r8,0(r8)		# get entry vector
	cis	r8,0			# loads don't set condition codes!
	jeq	svc_call_c		# still no emulation
	/*
	 * Now we have determined that we have an emulated syscall.
	 *
	 * Set r0 == locr0[iar] (save the return address)
	 * Set locr0[iar] = emulation entry point
	 */
	l	r0,FAULT_IAR(sp)	# save the current iar for emulation
	st	r0,FAULT_R0(sp)		# pass it to emul routine
	st	r8,FAULT_IAR(sp)	# save the entry point
	j	after_svc_call_c	# go out to emulation library
	 
#endif	MACH_EMULATION
 #
 #  call syscall() to handle the svc
 #
svc_call_c:
	balix	r15,_.syscall		# call syscall
	 get	 r0,$.long(_syscall)	# load constant table for syscall
 #
 #  restore complete context and return
 #
after_svc_call_c:
	setsb	scr_ics,INTMASK-16	# disable interrupts
	lm	r14,FAULT_IAR(sp)	# get old_iar (MAY BE CHANGED) and MQ
	mts	scr_mq,r15		# restore multiplier/quotient
	get	r15,FAULT_ICS_CS(sp)	# get old_ics_cs (MAY BE CHANGED)
	stm	r14,low_ps		# save in low core
 	get	r15,FAULT_R1(sp)	# get old r1 value (UNCHANGED)
 	st	r15,low_save1		# save in low core for go
	get	r15,FAULT_R15(sp)	# get old r15 value (UNCHANGED)
	st	r15,low_save15		# save in low core for go
	get	r0,FAULT_R0(sp)		# restore 0 (UNCHANGED)
#if	ROMP_APC
	l	r11,FAULT_CNT(sp) 	# get exception count 
	cis	r11,0
	bne	ecr_restore		# re-issue exception packets
#endif	ROMP_APC
	lm	r2,FAULT_R2(sp)		# restore r2 thru r15 (UNCHANGED)
	mfs	scr_iar,r15		# get addressability again
1:	.using	1b,r15
	lps	0,go_ps			# go to go
1:	.using	1b			# tell assembler no base register



 #  fault handler, called from level 0 interrupt service routines
 #
 #  on entry:
 #     r1 = sp
 #     r10 = mcs_pcs
 #     r11 = faulting address
 #     r12 = interrupt old_iar
 #     r13 = interrupt old_ics_cs
 #     r14 = exception information (ser bits)
 #     r15 = unused
 #     low_save1,10,11,12,13,14,15 are values at time of interrupt
 #
 #  function:
 #     save complete context on the stack
 #     call trap(mcs_pcs,info,&regs)
 #     if called from user mode
 #       reschedule
 #     else
 #       restore complete context and return
 #
 #  parameters passed to trap (stack offsets):
 #

#if	ROMP_RDB
	ai	sp,sp,FRM_PROTECT	#makes rdb happy
#endif	ROMP_RDB
	.globl	_fault
_fault:
	.globl	fault
fault:
faultstm: 
	stm	r2,FAULT_R2-FAULTSAVE(sp) # save all registers (some wrong)
	st	r0,FAULT_R0-FAULTSAVE(sp) # save r0.
         ai    sp,sp,-FAULTSAVE  # make room for context
         st    r12,FAULT_IAR(sp) # save iar at time of interrupt
	 st    r13,FAULT_ICS_CS(sp) # save ICSCS
         cas   r2,r10,r0         # 1st parm to trap (mcs_pcs)
         cas   r3,r11,r0         # 2nd parm to trap (faulting address)
	 cal   r4,FAULT_R0(sp)	 # 3rd parameter to trap (locr0)
	 cas   r7,r13,r0	 # save ics_cs for later use
	 mfs   scr_iar,r6        # get addressability to low storage
1:	 .using 1b,r6            # tell the assembler (C preserves R6)
         l     r15,low_save1     # value of r1 at time of interrupt
         sts   r15,FAULT_R1(sp)  # correct value on stack
         lm    r10,low_save10    # values of r10-r15 at time of interrupt
         stm   r10,FAULT_R10(sp) # correct values on stack
 
         mfs   scr_mq,r15        # get current multiplier/quotient
         st    r15,FAULT_MQ(sp)  # save context
	 
	 cas   r13,r7,r0	# get ics
	 shr   r13,16          	# shift ics to low order bits
         nilz  r13,r13,7        # use only level bits
         mfs   scr_ics,r15      # get current ics
         nilo  r15,r15,0xfff8   # zero only level bits
         o     r15,r13          # set level at time of fault
         mts   scr_ics,r15      # change processor level

#if !defined(LORDB)
         mfs   scr_irb,r15       # get copy of irb
         mttbil r15,IRB_IRQ_0    # get int level 0 bit
         jntb  read_exceptions   # jump if no instruction step pending	 
         clrsb scr_irb,IRB_IRQ_0 # cancel level 0 interrupt request
	 cas   r13,r7,r0	 # get ics again
         oiu   r13,r13,ICSCS_INSTSTEP/UPPER  # repeat inst step after fault
	 st    r13,FAULT_ICS_CS(sp) # save ics_cs for after fault
read_exceptions:	 
#endif	LORDB
	 
#if	ROMP_APC
 # note that we set FAULT_CNT to 0 (by relying on CPU_SGP == 0 -
 # which is a bit of a kludge) when running on a SGP so that
 # the rest of the code can do one test (on FAULT_CNT) instead
 # of two.
	l	r11,_cpu_model	# see if running on ROMPC
	cis	r11,CPU_SGP
#if	ROMP_CACHE
	jeq	check_cache	# nope (NOTE: CPU_SGP == 0)
#else	ROMP_CACHE
	jeq	2f			# go forth and write FAULT_CNT
#endif	ROMP_CACHE
 # read the IOIM1 and IOIM2 General Status registers to allow use of IOIM1 & 2
 # we do this in all cases (even when the exceptions may not be in 
 # segment F because it is faster to do the IORs than to do the conditional
 # branches).
	cau	r12,IOIM1/UPPER(r0)	# get IOIM 1 base
	ior	r13,IOIM_REPLY(r12)	# get reply 
	st	r13,FAULT_REP1(sp)	# store IOIM1 reply 
	ior	r13,IOIM_GSR(r12)	# get status
	st	r13,FAULT_GSR1(sp)	# store IOIM1 GSR 
 # get IOIM2 reply and GSR
#if	ROMP_135
	l	r12,_ioim2		# test if IOIM 2 present
	cis	r12,0			# zero if not
	jeq	4f
#endif	ROMP_135
	cau	r12,IOIM2/UPPER(r0)	# get IOIM 2 base
	ior	r13,IOIM_REPLY(r12)	# get reply 
	st	r13,FAULT_REP2(sp)	# store IOIM2 reply 
	ior	r13,IOIM_GSR(r12)	# get status
	st	r13,FAULT_GSR2(sp)	# store IOIM2 GSR 
4:
 # if anything on the exception stack copy it to kernel stack
	mfs	scr_ecr,r11	# get ECR
	niuo	r10,r11,0x00ff	# get exception stack address in r10
	sri16	r11,24-16	# get exception count in r11
	cis	r11,0
	jne	get_except_info
#if	!ROMP_CACHE
	j	2f			# go forth and write FAULT_CNT
#else	ROMP_CACHE
 #
 #	on user memory faults: call lo_lookup to first check the
 # 	shared memory mapping cache.
 #
 #	r3 = exception information (info)
 #	r6 = base register
 #	r7 = ics_cs at interrupt time
 #
 #	if we have a page fault, and we're in user mode, check the
 # 	shared memory cache first.
 #
 #	call lo_lookup(mcs_pcs,info,&regs)
 #
check_cache:
	st	r11,FAULT_CNT(sp) 	# save it
	mttbil	r3,28-16		# get fault bit
	jntb	except_info_done	# exit if not page fault
	mttbiu  r7,PROBSTATE-16		# test if user mode
	jntb	except_info_done 	# don't do lookup for kernel faults
	bali	r15,lo_lookup		# call lookup
	j	except_info_done # only returns on failure
#endif	ROMP_CACHE	

get_except_info:	
 # copy first exception status
	oiu	r10,r10,SYS_ORG/UPPER	# get virtual address
	lm	r12,0(r10)	# get first exception (4 words)
	stm	r12,FAULT_EX1(sp)	# store first exception (4 words)
	cis	r11,2
#if	ROMP_CACHE
	jeq	read_second_pkt		# read the second packet
 #
 # 	if the fault generated only one exception packet,
 #	then we can try to handle it through the cache as well.
 #
 #	r12 == EX1_CTL
 #	r13 == EX1_ADDR
 #	r14 == EX1_DATA
 #	r15 == EX1_RSV
 #
 # call lo_lookup(mcs_pcs,info,regs)
 #
#define	APC_EXCEPTIONS	1 
check_except_pkt:
	st	r11,FAULT_CNT(sp)	# save fault count
	get 	r0,$ECR_STACK		# reset exception stack
	mts	scr_ecr,r0		# write exception stack
#if	APC_EXCEPTIONS
	mttbil	r3,28-16		# get fault bit
	jntb	except_info_done	# exit if not page fault
	mttbiu  r7,PROBSTATE-16		# test if user mode
	jntb	except_info_done 	# don't do lookup for kernel faults
	mr	r5,r3			# save fault addr in case lookup fails.
	nilo	r13,r13,0-0x800		# get faulting address (strip lower)
	nilz	r3,r3,0x800-1		# clear upper bits
	balix	r15,lo_lookup		# call lookup
	o	r3,r13			# finished with creating "info"
	mr 	r3,r5			# lookup failed, reset r3
#endif	APC_EXCEPTIONS
	j	except_info_done	# bye
#else	ROMP_CACHE
	jl	2f
#endif	ROMP_CACHE
read_second_pkt:
	lm	r12,4*4(r10)		# get second exception (4 words)
	stm	r12,FAULT_EX2(sp)	# store second exception (4 words)
 # reset exception stack to original position
2:
	get	r0,$ECR_STACK
	mts	scr_ecr,r0	# reset exception stack
	st	r11,FAULT_CNT(sp) 	# save it	
3:
1:
except_info_done:	


#endif	ROMP_APC

 #
 #  call trap() to handle the fault
 #
fault_call_c:
         clrsb scr_ics,INTMASK-16# enable interrupts now
1:	.using	1b
	mfs	scr_iar,r6
1:	.using	1b,r6	
 	   l    r13,__trap	 # store constant pointer
	   ls	 r15,0(r13)	 # get address of routine
         balrx r15,r15        # call trap
		 mr r0,r13
 #
 #  restore complete context and return
 #
         setsb scr_ics,INTMASK-16# disable interrupts
         l     r14,FAULT_IAR(sp) # get old_iar (MAY BE CHANGED)
         l     r15,FAULT_ICS_CS(sp)  # get old_ics_cs (MAY BE CHANGED)
         stm   r14,low_ps        # save in low core
         l     r15,FAULT_MQ(sp)  # get old multiplier/quotient (UNCHANGED)
         mts   scr_mq,r15        # restore multiplier/quotient
         ls    r15,FAULT_R1(sp)  # get old r1 value (UNCHANGED)
         st    r15,low_save1     # save in low core for go
         l     r15,FAULT_R15(sp) # get old r15 value (UNCHANGED)
         st    r15,low_save15    # save in low core for go
         l     r0,FAULT_R0(sp)   # restore 0 (UNCHANGED)
#if	ROMP_APC
	l	r11,FAULT_CNT(sp) # get exception count 
	cis	r11,0
	jeq	3f		#nothing to do
 # SVC code also comes here if exception packets are present
 # (which may happen after a sigcleanup)
ecr_restore:	
	mfs	scr_ecr,r10	# get ECR
	niuo	r10,r10,0x00ff	# get exception stack address in r10
	oiu	r10,r10,SYS_ORG/UPPER	# get kernel virtual address
	ai	r10,r10,-16	# adjust exception stack
	cis	r11,1
	jeq	2f		# just one exception
 # copy second exception status
	ai	r10,r10,-16	# adjust exception stack
	lm	r12,FAULT_EX2(sp)	# get second exception (4 words)
	stm	r12,16(r10)	# store second exception (4 words)
 # copy first exception status
2:
	lm	r12,FAULT_EX1(sp)	# get first exception (4 words)
	stm	r12,0(r10)	# store first exception (4 words)
 # reset exception stack to original position
	niuo	r10,r10,0x00ffffff/UPPER	# get 24 bit address
	sli16	r11,24-16	# get count to proper place
	o	r10,r11		# get new ecr 
	mts	scr_ecr,r10	# get new ecr value
	lm	r2,FAULT_R2(sp)	# restore 2 through 15 (UNCHANGED)
9:	.using	9b
	mfs	scr_iar,r15
9:	.using	9b,r15
	lps	0,go2_ps
9:	.using	9b
 # nothing on execption stack - proceed as before
3:
1:
#endif	ROMP_APC
         lm    r2,FAULT_R2(sp)   # restore 2 through 15 (UNCHANGED)
         mfs   scr_iar,r15       # get addressability again
1:	 .using 1b,r15           # tell assembler
         lps   0,go_ps           # jump to go with interrupts off

1:       .using 1b               # tell assembler no base register


 #  program check that is really a page fault
 #
 #  on entry:
 #     r10 = mcs_pcs
 #     r11 = faulting address (if called from lopckrt0 )
 #     r14 = exception info 
 #     interrupt old_iar
 #     interrupt old_ics_cs
 #     low_save1,10,11,12,13,14,15 are values at time of interrupt
 
         .using real0,r0
	 .globl pck_fault
eye_catcher(pck_fault):
         l     r12,pck_ps+old_iar     # get interrupt time iar
         l     r13,pck_ps+old_ics_cs  # get interrupt time ics and cs
mck_fault:	 
	ai	sp,sp,FRM_PROTECT
         mttbiu r13,PROBSTATE-16 # copy problem state bit from old ics
         jntb   goto_fault        # jump if we were in kernel state
user_fault:
         bali  sp,flipmode       # switch to kernel mode
	get	r1,saved_kernel_stk
goto_fault:
         lps   0,fault_ps        # goto fault: translation on, interrupts off
1:       .using 1b               # tell assembler no base register

#include <ca/lopckrt0.s>
#include <ca/locache.s>
#include <ca/lomapin.s>
#include <ca/lointr.s>
#include <ca/loutil.s>
#if	ROMP_NFL
/*
 * following probably should be in a machine/nfl.h but that would be
 * yet another header file to maintain.
 */
#define NFL_MASK	0xffff0000	/* mask for NFL_ADDR */
#define NFL_ADDR	0x00ff0000	/* fixed part of address */
#ifndef FOO
#define BALA		0x8a000000	/* a BALA instruction base */
#endif FOO
#define NFL_INSTN (BALA + NFL_ADDR) 	/* BALA */
#define BALI_R15	0x8cf00000	/* a BALI instruction */
#define BALI_MASK	0x000fffff	/* mask for BALI offset */
#endif	ROMP_NFL

 #
 # following is a rather kludgy way of building _fpget and _fpput 
 # from fpget and fpput.
 #
 # this is done so that the _fpget and _fpput routines are in the kernel text
 # (which is readable from user programs and hence when we get a use of the
 # fpa directly from user mode we can redirect it to the appropriate routines.
 # (what we do to be nice to users!)
 #
#define fpget _fpget		/* make it accessable from c */
#define fpput _fpput		/* both of them */
#include <ca/lofp.s>


#define fpglue _fpglue		/* make name visable */
#include <ca/fpglue.s>

	.text
	.ltorg

	.globl _endlocore
_endlocore:                             # last of locore

#if	ROMP_RDB
	.set	rdb_start,RDB_RELOC
	.org	real0+rdb_start-6		# to start of debugger area
	.align	3
	.globl	_symsize
1: .set _symsize,	RDB_SYMLEN		# size of symbol table

_start:
rdb:
        .using real0,r0          # tell the assembler to use r0 as base
	cal16	r15,start	# use 'cal16' to ignore segment number
	balr	r15,r15		# transfer control to real 'start'
 # This value must be bigger than the _end of rdb.out
	.set rdb_end, RDB_END	#compare with _end in rdb.out
	.org	real0+rdb_end		# to end of debugger area

	.org	real0+RDB_SYMTAB
	.globl	_rdb_symtab
_rdb_symtab:

 # _stext is the start of the normal C code (text)
	.globl	_stext
	.set	_stext,real0+RDB_SYMTAB+RDB_SYMLEN
	.org	real0+RDB_SYMTAB+RDB_SYMLEN
#else	ROMP_RDB
	.globl	_stext
	.set	_stext,_endlocore
#endif	ROMP_RDB

