/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 **********************************************************************
 * HISTORY
 *  8-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Corrected value of FAULTSAVE for non-APC case.
 *
 *  3-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_APC: installed acis mods for APC.
 *
 * 15-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created.
 *
 **********************************************************************
 */ 
/*
 *	Where things get saved on the stack during a trap.
 */

#include "romp_apc.h"

.set FAULT_R0 , -4
.set FAULT_R1      , 1*4 + FAULT_R0
.set FAULT_R2      , 2*4 + FAULT_R0
.set FAULT_R10     ,10*4 + FAULT_R0
.set FAULT_R11     ,11*4 + FAULT_R0
.set FAULT_R12     ,12*4 + FAULT_R0
.set FAULT_R15     ,15*4 + FAULT_R0
.set FAULT_IAR     , 1*4 + FAULT_R15
.set FAULT_MQ      , 2*4 + FAULT_R15
.set FAULT_ICS_CS , 33*4 + FAULT_R0

#if	ROMP_APC
.set FAULT_CNT     , 3*4 + FAULT_R15	/* count of exceptions */
.set FAULT_EX1     , 4*4 + FAULT_R15	/* four words for exception */
.set FAULT_EX2     , 8*4 + FAULT_R15	/* four words for exception */
.set FAULT_GSR1	   , 12*4 + FAULT_R15	/* one word for IOIM1 GSR */
.set FAULT_REP1	   , 13*4 + FAULT_R15	/* one word for IOIM1 reply */
.set FAULT_GSR2	   , 14*4 + FAULT_R15	/* one word for IOIM2 GSR */
.set FAULT_REP2	   , 15*4 + FAULT_R15	/* one word for IOIM2 reply */
#endif	ROMP_APC

#ifdef	notdef
.set FAULTSAVE     , 4 + FAULT_REP2 	# size of stack area needed 
					# for parameters to trap
#endif	notdef

.set FAULTSAVE     , 4 + FAULT_ICS_CS   # size of stack area needed
				 	# for parameters to trap


