/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 ****************************************************************
 *
 * HISTORY $Log:	lohatipt.s,v $
 * Revision 2.2  88/10/06  13:51:05  sanzi
 * 	When loading the segment registers, set unused ones to sid=SID_UNUSED.
 * 
 *  3-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_APC: Added configurations for APC cards w/on board memory.
 *
 */
 #----------------------------------------------------------------------|
 #		MEMORY/ROSETTA INITIALIZATION MODULE
 #----------------------------------------------------------------------|
 #  ASSUMES r8 - r15 ARE ZEROED
 #  ASSUMES (maybe) PAGESIZE = 2K
 #  WARNING this routine knows about the console message buffer at top
 #          of memory (just preceding the HATIPT table), in order not
 #          clear it out.
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


 # XXX FOLLOWING SHOULD PROBABLY BE SOMEWHERE ELSE
#define MEMCONFREG 0xF0008C80

	#  There are two 4-bit quantities in the m.c.r., one for
	#  each memory socket. The mapping is as follows:
	#
	#  m.c.r. value:  0-7  8   9  10  11  12  13   14    15
	#  size of card:  --- 4MB 1MB --- --- 8MB 2MB 512KB NONE

	.globl	_memcon
	b	_memcon
/* some new variables */

	.align	2

/* configuration register values for various card sizes */
#define C_NONE	15
#define C_500K	14
#define C_1MEG	9
#define C_2MEG	13
#define C_4MEG	8
#define C_8MEG	12

/* memory sizes in units of 500K for current configurations */
#define K_500	1	/* 500 K of memory */
#define K_1000	2	/* 1 Meg of memory */
#define K_1500	3	/* 1.5 Meg of memory */
#define K_2000	4	/* 2 Meg of memory */
#define K_2500	5	/* 2.5 Meg of memory */
#define K_3000	6	/* 3 Meg of memory */
#define K_3500	7	/* 3.5 Meg of memory */
#define K_4000	8	/* 4 Meg of memory */
#define	K_5000	10	/* wheee */
#define	K_6000	12	/* guess for yourself */
#define K_8000 16	/* 8 Meg of memory */
#define	K_9000	18	/* 9 Meg of memory */
#define K_10000 20	/* 10 Meg of memory */
#define	K_12000	24	/* 12 Meg of memory */
#define K_16000 32	/* 16 Meg of memory */

/* values for RAM register (add 9) for various memory sizes */
#define R_500	1
#define R_1000	2
#define R_2000	3
#define R_4000	4
#define R_8000	5
 #BJB - New value
#define R_16000 6

#if	ROMP_APC
/*
 * use CONFIG2 to specify how much memory is on the processor card
 */
#define CONFIG2(card,slot1,slot2,ram_value,phys_mem,size1,holesize) \
	.byte	card, ((slot2)<<4)+slot1, ram_value, phys_mem, size1, holesize, 0, 0
/*
 * NOTES: 
 * 1.	the memory configuration register on SGP always has high bit of each 
 *	nibble on.
 * 2.	the memory configuration register on APC has high bit of slot 2
 *	nibble (e.g. 0x80 value) on only when slow memory is present.
 * 3.	to patch _memconfig to force 4 + 4 + 4 set it to 0x808 (as 0x800
 *	will pick up value from hardware register)
 * Rules for memory cards on APC:
 * 1.	always put an 8meg card (if you have one) into slot 2.
 * 2.	otherwise put any single card into slot 1.
 * 3.	if you have two cards, put the larger into slot 1 (except if
 *	the larger is 8meg)
 * 4.	possible exception: if you have a very large kernel, and a single
 *	small memory card (e.g. 1 meg) you may have to put it into slot 2
 *	in order to boot the kernel.
 */
#endif	ROMP_APC

#define MEM_CONFIG(slot1,slot2,ram_value,phys_mem,size1,holesize) \
	.byte	0, ((slot2)<<4)+slot1, ram_value, phys_mem, size1, holesize, 0 , 0

 # following table contains the allowed memory configurations
 # all others are invalid and are rejected
 # note that since the kernel requires more than 500K it is not viable
 # to have a 500K card followed by anything other than another 500K card.
 #
#define	CONFIG	0	/* memory config table value */
#define RAM	2	/* is value for the RAM specification register */
#define	PHYS	3	/* is the size that includes all of RAM (including hole) */
#define	SIZE1	4	/* is the size of the first (or only) block of memory */
#define HOLESIZE 5	/* is the size of the hole (if any) */

#define MEMSIZE	8		/* number of bytes/entry in table */
.globl _memtable
_memtable:

	/*		slot1	slot2	RAM	PHYS	SIZE1	HOLESIZE */

#if	ROMP_APC
	/*	entries for the APC with onboard memory have 3 memory sizes */
	/*     on-card	slot1	slot2	RAM	PHYS	SIZE1	HOLESIZE */
	CONFIG2(C_4MEG,	C_NONE,	C_NONE, R_4000,	K_4000,	K_4000,	0	)
	CONFIG2(C_4MEG,	C_4MEG,	C_NONE, R_8000,	K_8000,	K_8000,	0	)
	CONFIG2(C_4MEG,	C_NONE,	C_4MEG, R_16000,K_12000,K_4000,	K_4000	)
	CONFIG2(C_4MEG,	C_4MEG,	C_4MEG, R_16000,K_12000,K_8000,	0	)
	CONFIG2(C_4MEG,	C_NONE,	C_8MEG, R_16000,K_16000,K_4000,	K_4000	)
	CONFIG2(C_4MEG,	C_4MEG,	C_8MEG, R_16000,K_16000,K_8000,	0	)
	/*	don't use the following - you lose 4meg */
	CONFIG2(C_4MEG,	C_8MEG,	C_NONE, R_8000,	K_8000,	K_8000,	0	)
	CONFIG2(C_4MEG,	C_8MEG,	C_8MEG, R_16000,K_16000,K_8000,	0	)
	/*	slow memory can't mix with fast so these aren't supported */
	CONFIG2(C_4MEG,	C_4MEG,	C_2MEG, R_16000,K_10000,K_8000,	0	)
	CONFIG2(C_4MEG,	C_4MEG,	C_1MEG, R_16000,K_9000,	K_8000,	0	)
	CONFIG2(C_4MEG,	C_2MEG,	C_NONE, R_8000,	K_6000,	K_2000,	K_2000	)
	CONFIG2(C_4MEG,	C_1MEG,	C_NONE, R_8000,	K_5000,	K_1000,	K_3000	)
	CONFIG2(C_4MEG,	C_NONE,	C_2MEG, R_16000,K_6000,	K_4000,	K_4000	)
	CONFIG2(C_4MEG,	C_NONE,	C_1MEG, R_16000,K_5000,	K_4000,	K_4000	)
	CONFIG2(C_4MEG,	C_2MEG,	C_2MEG, R_16000,K_8000,	K_2000,	K_4000	)
#endif	ROMP_APC
	/* standard (supported) configurations */
	MEM_CONFIG(	C_8MEG, C_8MEG, R_16000,K_16000,K_16000,0	)
	MEM_CONFIG(	C_8MEG,	C_4MEG,	R_16000,K_12000,K_12000,0	)
	MEM_CONFIG(	C_8MEG, C_2MEG, R_16000,K_10000,K_10000,0	)
	MEM_CONFIG(	C_8MEG, C_1MEG, R_16000,K_9000, K_9000, 0	)
	MEM_CONFIG(	C_8MEG, C_NONE, R_8000, K_8000, K_8000, 0	)
	MEM_CONFIG(	C_4MEG,	C_4MEG,	R_16000,K_12000,K_4000,	K_4000	)
	MEM_CONFIG(	C_4MEG,	C_2MEG,	R_16000,K_10000,K_4000,	K_4000	)
	MEM_CONFIG(	C_4MEG,	C_1MEG,	R_16000,K_9000,	K_4000,	K_4000	)
	MEM_CONFIG(	C_4MEG,	C_NONE,	R_4000,	K_4000,	K_4000,	0	)
	MEM_CONFIG(	C_2MEG,	C_2MEG, R_4000,	K_4000,	K_2000,	0	)
	MEM_CONFIG(	C_2MEG,	C_500K, R_4000,	K_2500,	K_2000,	0	)
	/* non-standard configurations */
	MEM_CONFIG(	C_2MEG,	C_NONE, R_2000,	K_2000,	K_2000,	0	)
	MEM_CONFIG(	C_NONE,	C_2MEG, R_2000,	K_2000,	K_2000,	0	)
	MEM_CONFIG(	C_2MEG,	C_1MEG, R_4000,	K_3000,	K_2000,	0	)
	/*  end of configurations */
	MEM_CONFIG(	0, 0,	0,	0,	0,	0	)

 #	.align 1
 #  Determine installed memory size from Memory Configuration Register.
 #  do this by looking up the value from the configuration register 
 #  (or the software override of it) in the above table.
 #  a configuration that isn't found will (for now) result in a hard
 #  loop. (To be done: set a error value into the LED's)
 #
_memcon:

	l	r2,_memconfig		# get software memory config
	nilz	r0,r2,0xff		# test and
	jne	1f			# if non-zero use it
	get	r1,$MEMCONFREG
	lcs	r0,0(r1)		# check it out
	mc33	r2,r0			# move into proper place.
	st	r2,_memconfig		# save for later reference
	oi	r2,r2,0x88		# standardize the memory sizes
1:

	#  Convert the codes to 0=0 1=512K 2=1M 3=2M 4=4M 5=8M
	#  by table lookup (sorry about that Mike)
	# r2 is the value we are looking up
	# r5 is the pointer in the above table
	# r0 is the test value
	cal	r5,_memtable
1:	geth	r0,CONFIG(r5)		# get the test value
	cis	r0,0			# test to see if done
	jeq	0f			# unsupported memory configuration
	c	r0,r2			# test if this one
	jeq	1f			# yes
	bx	1b
		inc	r5,MEMSIZE	
 #
 # to be nice we will try again ignoring the memory card in the second
 # slot - this allows some combinations to still boot up
 # though all of the memory isn't used.
0:	
	oi	r2,r2,0xf0			# kill off second slot
	cal	r5,_memtable
2:	geth	r0,CONFIG(r5)		# get the test value
	cis	r0,0			# test to see if done
	jeq	0f			# unsupported memory configuration
	c	r0,r2			# test if this one
	jeq	1f			# yes
	bx	2b
		inc	r5,MEMSIZE	
0:	
	get	r2,$LED_MEM_CONFIG	# display for invalid configuration
	bali	r5,display		# and show it
	j	0b			# loop if bad
/* we now have the proper table entry pointed to by r5 */
1:
/* Load the software page size and determine if it is a multiple of
 * 4K.  If it is, set the hardware page size to 4K, else use 2K pages.
 */
	.using	real0,r0
	get	r2,$(_page_size)
	niuo	r2,r2,$(0xfff)		#mask off segment number (real mode)
	l	r2,0(r2)		#r2 is software page size
	nilz	r2,r2,0x0fff		#mask off bits for 4K and up
#if	0
	bz	0f			#if 0 then we're using a mult of 4K
#endif	0
	get	r4,$(0x800)		#use 2K page size
	st	r4,_rose_page_size
	lis	r4,0xb			#shift of 11 bits
	st	r4,_rose_page_shift
	b	1f
0:
	get	r4,$(0x1000)		#use 4K page size
	st	r4,_rose_page_size
	lis	r4,0xc			#shift of 12 bits
	st	r4,_rose_page_shift
1:

 # calculate the number of bytes and the number of pages
 # of actual memory 
 # r0 will contain the number of bytes of memory present
	lcs	r0,PHYS(r5)
	sli	r0,19-0xb		# compute number of 2K pages
	cli	r4,0xc			# 4K pages?
	bne	0f
	sri	r0,1			# if so, only half as many
0:
	st	r0,_physmem		# save for posterity


 #  Compute number of entries in the HAT/IPT table
 #  this is the RAM size / page size
 #  or (# of pages in 256k) << log (# of 256k segments)
 #  the 256k is because we start at 1 instead of 0

	lcs	r2,RAM(r5)		# get RAM size
	get	r3,$(256*1024/0x800)	#256 KB in 2K pages
	cli	r4,0xc			#are we using 4K pages?
	bne	0f
	sri	r3,1			#half as many IPT entries for 4K
0:
	sl	r3,r2			# r3 = number of HAT/IPT entries

 #  Compute hash mask for HAT chain head offset calculation

	ai	r0,r3,-1		# compute HAT hashing mask
	st	r0,_RTA_HASHMASK	# save for future use

 # see if we are running with more than 8Mbytes of physical memory, and if so
 # turn off the ROM which would otherwise overlap RAM.  The rom spec reg
 # will be reset by hardware on a reboot.  Until then ROM is effectively gone.

	get	r7,$(ROSEBASE)
	cis	r2,R_16000		
	bne	1f			# if not using top half, skip
	lis	r4,0			# r4 = new ROM spec reg
	iow	r4,ROSE_ROM(r7)		# turn off ROM 

 #  Load up the ROSETTA RAM Specification Register 
 #  Note: this is NOT the size of installed memory, it's
 #  the size of memory rounded up to (512K * 2**N).

1:	inc	r2,9			# encode size for Rosetta
					# (10=512K, 11=1M, 12=2M, ...)
	iow	r2,ROSE_RAM(r7)		# set Rosetta ram spec register
					# (set ram start address to 0)

 #  Compute HATIPT address and tell ROSETTA where it is.

	sli	r3,LOG2HATIPTSIZE	# r3 = size of hatipt table needed
	lcs	r1,PHYS(r5)		# r1 = # of 2K pages in mem + hole
	sli16	r1,19-16		# r1 = hi phys address
	sf	r3,r1			# r3 = address of hatipt table
	inc	r2,1
	l	r0,_rose_page_shift
	cli	r0,0xc			# using 4K pages?
	be	0f
	inc	r2,1			# then multiplier is twice the size
0:

	srp 	r3,r2			# r2 = rosetta hatipt address code
	cli	r0,0xc			# 4K pages?
	bne	0f
	oil	r2,r2,TCR_S		# set the 4K page size bit
0:
	iow	r2,ROSE_TCR(r7)		# set Rosetta translation control reg
	nilo	r2,r2,~TCR_S		# clear 4K bit for saving address
	st	r3,hatipt		# remember it
	oiu	r2,r3,SYS_ORG/UPPER	# add system segment for translate mode
	st	r2,_RTA_HATIPT		# remember translated hatipt addr

 #  Record the usable memory size.
	
	srpi	r3,0xb 			# r2 = # of 2K pages (sans hatipt)
	cli	r0,0xc			# 4K pages?
	bne	0f
	sri	r2,1			# half as many pages
0:
	st	r2,_maxmem		# max available memory
	st	r2,_freemem		# initialize free memory size

 #  Clear memory from end of kernel data to up near top of memory.
 #  Do not clear the msgbuf which is the MSGBUFPAGES pages before the
 #  HATIPT table, which we also don't clear here.
	
	l	r1,_edata$		# end of kernel initialized data
	niuo	r1,r1,0xfff		# mask off segment number
	l	r2,hatipt		# don't clear HATIPT at top of mem
	ai	r2,r2,-MSGBUFPAGES*0x800 - 32 # or msgbuf (may have valid data)
	lcs	r3,SIZE1(r5)
	sli16	r3,19-16		# r3 is beginning of hole
	st	r3,_holestart		# save for romp_init
	lcs	r4,HOLESIZE(r5)
	sli16	r4,19-16
	a	r4,r3			# r4 is end of hole
	st	r4,_holeEnd		# save for romp_init

	#  Clear to next higher 32 byte boundary.

clrloopA:
	nilz	r0,r1,0x1f		# 32 byte boundary?
	jz	endclrloopA		# yes-->go to next phase
	sts	r8,0(r1)		# zero another word
	inc	r1,4			# point to next word
	j	clrloopA		# -->try again
endclrloopA:
		
	#  Clear from kernel data to the upper bound computed above
	#  r1 points to current 32byte block being cleared
	#  r2 points to the end of the region to clear

clrloopB:     				# do while more to clear:
	c	r1,r3			# at beginning of hole?
	blx	0f			# if not continue and
	stm	r8,0(r1)		# 	zero 8 words
	cas	r1,r4,r0		# else skip hole...
	ai	r1,r1,-8*4		#  hack around end-of-loop incr.
	cal	r3,0xff(r2)		# and hack hole start so we ignore it
0:	c	r1,r2			# Done yet?
	blx	clrloopB		# no-->keep looping...
	ai	r1,r1,8*4		#   while bumping the pointer


 #  Initialize some more ROSETTA stuff.

	s	r0,r0			# zippo
	iow	r0,ROSE_SER(r7)		# clear exception bits
	iow	r0,ROSE_TLBS(r7)	# blast the entire tlb
	iow	r0,ROSE_TIDR(r7)	# set tid reg = 0 (user)
	
 #  Loop through HATIPT mapping system page i to real page i.

	get	r0,$(0x01ffffff)	# Protection bits:
			# spare(7),write(1)=1,tid(8)=ff,lockbits(16)=ffff	
	get	r1,$(SYS_ADDRTAG)	# part of addrtag for seg id
	lis	r9,0			# page number
	l	r11,_rose_page_shift	# which page size are we using?
	l	r3,hatipt		# point to HATIPT at end of memory
	l	r4,_RTA_HASHMASK	# hashing significant bits
	ai	r2,r4,1			# r2 = number of HATIPT entries
	nilz	r4,r4,RTA_SID_SYSTEM	# partial result for hash calculations
	cal16	r5,RTA_UNDEF_PTR(r0)	# Invalid IPTPTR value for debug
	l	r7,_physmem		# pointer to end of valid memory
	get	r8,$-1			# invalid HATPTR

hatiptloop:
	mr	r10,r9			# copy of page number
	cis	r11,0xc			# 4K pages?
	jne	0f
	sli	r10,1			# double page # for addrtag
0:
	o	r10,r1			# add in segid part
	oiu	r10,r10,0x4000		# use key 01->user read, kernel write
	sts	r10,IPTADDRTAG(r3)	# set ADDRTAG field to sys seg addr
	sths	r8,IPTHATPTR(r3)	# in case the hatptr is invalid here
	mr	r6,r9			# copy page number for mungeing
	x	r6,r4			# "unhash" to get page pointer
	c	r6,r7			# beyond end of installed memory?
	jnl	hatinvalid		# yes, leave hat ptr invalid

	sths	r6,IPTHATPTR(r3)	# set HATPTR field to this page
hatinvalid:
	sths	r5,IPTIPTPTR(r3)	# invalid IPTPTR
	sts	r0,IPTLOCK(r3)		# set lock bits and flags
	inc	r9,1			# next page
	sis	r2,1			# decrement counter
	bnzx	hatiptloop		# loop if not zero
	    ai	    r3,r3,HATIPTSIZE	# ...while pointing to next entry

 #  Set up segment registers (for system mode)

	#  Segments 0 through E - initialize to unused segid

	get	r1,$RTA_SEGREG0		#IO address of seg reg 0
	get	r0,$(RTA_SID_UNUSED*4+RTA_SEG_PRESENT)	#ununsed & present
	lis	r2,0xe			#number of segments to clear

segregloop:
	iow	r0,0(r1)		# set to unused sid
	sis	r2,1			# decrement counter
	cal	r1,RTA_SEGREGSTEP(r1)	# point to next seg reg
	jnz	segregloop		# loop back

	#  Segment SYS_SEG = system

	get	r0,$(RTA_SID_SYSTEM*4+RTA_SEG_PRESENT)	#system sid & present
	get	r1,$RTA_SEGREG0 + SYS_SEG
	iow	r0,0(r1)		# set seg reg SYS_SEG = system

	#  Set segment F not present; it belongs to the IO controller.

	#  Set segment F not present; it belongs to the IO controller.
	#  we set the sid=SID_UNUSED because MMU translation function
	#  does not check the present bit and we don't want it to appear
	#  valid.

	get	r0,$(0x201*4)		# sid unused, present = 0
	iow	r0,RTA_SEGREGSTEP(r1) 	#	 Seg f not present.

 #  Determine the first page past unix - set _firstaddr

	l	r2,_end$		# point to end of unix
	niuo	r2,r2,0x0fffffff/UPPER	# mask off high 4 bits (seg #)
	ai	r2,r2,0x1000-1  	# past next 4K page boundary
	sri	r2,0xc			# now just (4K) page number past unix
	slpi	r2,0xc			# r3 now a byte address
	st	r3,_firstaddr		# save for later


 # CAREFUL!! r2 assumed to contain page num of first uarea page and
 #           r8 assumed to contain -1 by following code

 #--------------------END OF HATIPT TABLE INITIALIZATION---------------|
