/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ****************************************************************
 * HISTORY
 * $Log:	lointr.s,v $
 * Revision 2.3  88/10/01  21:48:09  rpd
 * 	Changed includes to the new style.
 * 	Changed CS_KDB conditionals to CMUCS_KDB.
 * 	[88/10/01  21:12:23  rpd]
 * 
 * 26-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added code from ACIS which counts interrupts (of dubious value).
 *
 * 16-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Add code to avoid '88' on machine check.
 *
 * 21-Mar-87  Rich Sanzi (sanzi) at Carnegie-Mellon University
 *	Purged all uses of KERNSTACK under MACH.
 *
 * 27-Feb-87  Rich Sanzi (sanzi) at Carnegie-Mellon University
 *	Removed conditional include of lokprof.s as that code is not
 *	longer needed for kernel profilinig. 
 ****************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <cmucs_kdb.h>

 # Data moved to locore.c for addressability.
#include <ca/loslih.h>
	.align 2	# *tjm
	.globl int0
	.globl int1
	.globl int2
	.globl int3
	.globl int4
	.globl int5
	.globl int6
 #****************************************************************
 #* 	Level 0 Interrupt Handler				 *
 #****************************************************************
 #
 # Level 0 interrupts result from:
 # 1. IRQ_0 	level 0 request bit (used for single instruction stepping)
 # 2. soft-reset	keyboard "panic" request (MODEL only)
 #

eye_catcher(int0):
	.text
	.using	real0,r0
	st	r1,low_save1
	stm	r10,low_save10

	mfs	scr_irb,r15		# get copy of irb
	mttbil	r15,IRB_IRQ_0		# get int level 0 bit
	jntb	int0_ext		# no irb bit, must be external i/o interrupt
	clrsb	scr_irb,IRB_IRQ_0	# reset interrupt request bit

	l	r15,LV0+old_ics_cs	# get old icscs
	mttbiu	r15,PROBSTATE-16	# problem state?
	jtb	int0_step		# yes, user instruction step

	# single step interrupt in kernel mode, jump to debugger

#if	CMUCS_KDB
	l	r10,_kdbintr		# check for a KDB interrupt
	cis	r10,0
	jeq	int0_lm			# no -> goto RDB
	# enter KDB through fault
	cau   r10,(STEP)>>16(r0) # mcs_pcs value for inst step "check"
	oil   r10,r10,(STEP)&0xffff
        lis   r11,0             # no additional information required
        l     r12,int0_ps+old_iar     # get interrupt time iar
        l     r13,int0_ps+old_ics_cs  # get interrupt time ics and cs
	ai    sp,sp,FRM_PROTECT
        lps   0,fault_ps        # goto fault: translation on, interrupts off
#endif	CMUCS_KDB

	.align	2	# needed so that int0_jump_to_dan can be patched
int0_lm:
	lm	r10,low_save10		# get the registers back
int0_jump_to_dan: b real0		# go there (branch patched during start)

         # single step interrupt in user mode, handle via fault
int0_step:
	 cau   r10,(STEP)>>16(r0) # mcs_pcs value for inst step "check"
	 oil   r10,r10,(STEP)&0xffff
         lis   r11,0             # no additional information required
         l     r12,int0_ps+old_iar     # get interrupt time iar
         l     r13,int0_ps+old_ics_cs  # get interrupt time ics and cs
         bali  sp,flipmode       # switch to kernel mode
#if	MACH
	get	sp,saved_kernel_stk
#else	MACH
	 cau   sp,(KERNSTACK)>>16(r0) # switch to kernel stack
	 oil   sp,sp,(KERNSTACK)&0xffff
#endif	MACH	 
         lps   0,fault_ps        # goto fault: translation on, interrupts off
 #
 # other level 0 interrupt
 # if debugger is present pass it control, otherwise go to interrupt common
 # routine
 #
int0_ext:
#if	ROMP_RDB
	j	int0_lm		# to the debugger
#else
	lm	r10,low_save10		# get the registers back
	st	r6,iosave6		# save r6
	l	r6,iosavep		# get interrupt stack pointer
	cal	r6,-IOSAVEL(r6)		# adjust for frame size
	ti	4,r6,iosavea-real0	# test to see if overflowed
	st	r6,iosavep		# save new value
	stm	r0,XIHR0(r6)		# save all registers on interrupt stack

	# Get the old IAR and ICS/CS
	l	r10,LV0
	l	r11,LV0+old_ics_cs

	get	r7,$(slih_0-real0)
	b	int_comm
#endif	ROMP_RDB

 #****************************************************************
 #* 	Level 1 Interrupt Handler Should be Hard IO Timer	 *
 #****************************************************************

eye_catcher(int1):
	.using	real0,r0
	clrsb	scr_irb,IRB_IRQ_1	# reset interrupt request bit
	clrsb	scr_ts,26-16		# Reset Timer interrupt status bit
	st	r6,iosave6		# save r6
	l	r6,iosavep		# get insterrrupt stack pointer
	cal	r6,-IOSAVEL(r6)		# adjust for frame size
	ti	4,r6,iosavea-real0	# test to see if overflowed
	st	r6,iosavep		# save new value
	stm	r0,XIHR0(r6)		# save all registers on interrupt stack

	l	r10,_intrcnt		# count clock interrupts
	inc	r10,1
	st	r10,_intrcnt

	# Get the old IAR and ICS/CS
	l	r10,LV1
	l	r11,LV1+old_ics_cs

 #/*BJB*/ Put interrupt level in r8
	get	r8,$1

	# Check if in Supervisor state and set Kernel stack

	get	r7,$(slih_1-real0)
	b	int_comm

 #****************************************************************
 #* 	Level 2 Interrupt Handler				 *
 #****************************************************************
 # Level 2 interrupts generated by:
 #
 # 1. IOCC
 # 2. Rosetta program check
 # 3. FPA
 #

eye_catcher(int2):
	.using	real0,r0
	clrsb	scr_irb,IRB_IRQ_2	# reset interrupt request bit
	st	r6,iosave6		# save r6
	l	r6,iosavep		# get insterrrupt stack pointer
	cal	r6,-IOSAVEL(r6)		# adjust for frame size
	ti	4,r6,iosavea-real0	# test to see if overflowed
	st	r6,iosavep		# save new value
	stm	r0,XIHR0(r6)		# save all registers on interrupt stack


	# Get the old IAR and ICS/CS
	l	r10,LV2
	l	r11,LV2+old_ics_cs

 #/*BJB*/ Put interrupt level in r8
	get	r8,$2

	# Check if in Supervisor state and set Kernel stack

	get	r7,$(slih_2-real0)
	b	int_comm

 #****************************************************************
 #* 	Level 3 Interrupt Handler				 *
 #****************************************************************
 #
 # Level 3 interrupts generated by I/O Bus levels and Planar:
 #
 # 8259 level	I/O Level	I/O adapter
 #	0	0 (Planar)	8237 Terminal count
 #	1	10 		I/O BUS IRQ 10
 #	2	9		I/O BUS IRQ 9
 #	3	3		I/O BUS IRQ 3
 #	4	4		I/O BUS IRQ 4
 #	5	1 (planar)	Keyboard controller
 #	6	2 (planar)	8530 serial port
 #	7	7		I/O BUS IRQ 7
 #

eye_catcher(int3):

	.using	real0,r0
	st	r6,iosave6
	l	r6,iosavep
	cal	r6,-IOSAVEL(r6)
	ti	4,r6,iosavea-real0
	st	r6,iosavep
	stm	r0,XIHR0(r6)

	# Get the old IAR and ICS/CS
	l	r10,LV3
	l	r11,LV3+old_ics_cs

 #/*BJB*/ Put interrupt level in r8
	get	r8,$3

	get	r7,$(slih_3-real0)
	b	int_comm

 #****************************************************************
 #* 	Level 4 Interrupt Handler				 *
 #****************************************************************
 #
 # Level 4 interrupts generated by:
 #
 # I/O interrupts thru second 8259A interrupt controller
 #

eye_catcher(int4):

	.using	real0,r0
	st	r6,iosave6
	l	r6,iosavep
	cal	r6,-IOSAVEL(r6)
	ti	4,r6,iosavea-real0
	st	r6,iosavep
	stm	r0,XIHR0(r6)

	# Get the old IAR and ICS/CS
	l	r10,LV4
	l	r11,LV4+old_ics_cs

 #/*BJB*/ Put interrupt level in r8
	get	r8,$4

	get	r7,$(slih_4-real0)
	b	int_comm

 #****************************************************************
 #* 	Level 5 Interrupt Handler				 *
 #****************************************************************

eye_catcher(int5):

	.using	real0,r0
	st	r6,iosave6
	l	r6,iosavep
	cal	r6,-IOSAVEL(r6)
	ti	4,r6,iosavea-real0
	st	r6,iosavep
	stm	r0,XIHR0(r6)

	# Get the old IAR and ICS/CS
	l	r10,LV5
	l	r11,LV5+old_ics_cs


 #/*BJB*/ Put interrupt level in r8
	get	r8,$5

	get	r7,$(slih_5-real0)
	b	int_comm

 #****************************************************************
 #* 	Level 6 Interrupt Handler Soft Timer			 *
 #****************************************************************

eye_catcher(int6):
	.using	real0,r0
	st	r6,iosave6
	l	r6,iosavep
	cal	r6,-IOSAVEL(r6)
	ti	4,r6,iosavea-real0
	st	r6,iosavep
	stm	r0,XIHR0(r6)

	l	r10,_intrcnt+4		# count soft interrupts
	inc	r10,1
	st	r10,_intrcnt+4

	# Get the old IAR and ICS/CS
	l	r10,LV6
	l	r11,LV6+old_ics_cs

 #/*BJB*/ Put interrupt level in r8
	get	r8,$6

	mfs	scr_irb,r15	  # get copy of irb
	mttbil	r15,IRB_IRQ_6	  # get int level 6 bit
	jntb	int6_ext	  # no irb bit, must be external i/o interrupt

 # interrupt was requested via the IRB

	clrsb	scr_irb,IRB_IRQ_6 # clear interrupt request bit
	get	r7,$(slih_6soft-real0)
	b	int_comm

int6_ext:
	get	r7,$(slih_6-real0)
	b	int_comm

 #****************************************************************
 #* 	Machine Check Interrupt Handler				 *
 #****************************************************************
eye_catcher(mck0):
#if	ROMP_APC
	cas	r0,r0,r0		# nop
	st	r15,low_save15		# these instructions prevent "death-by-88"
 #	bala	0f - real0		# on both SGP and ROMPC
	.long	BALA + 0f - real0	# can't use bala - sigh
0:	l	r15,low_save15
#else	ROMP_APC
	b	0f	# this instruction is necessary for certain page-faults
			# that will result in a "death-by-88" without it.
0:
#endif	ROMP_APC

        st    r1,low_save1      # copy interrupt time r1 into low_save var
        stm   r10,low_save10    # copy interrupt time rx into low_save var

        mfs   scr_mcspcs,r10    # r10 = program check status
	oi	r10,r10,MCS_CHECK # fake the machine check status

 #
 #  machine check
 #  if debugger present and in kernel mode pass to the debugger
 #  otherwise pass to 'trap'.
 #
mck_notstg:
#if	ROMP_RDB
	l	r11,mck_ps+old_ics_cs # get the ics into r11
	mttbiu	r11,PROBSTATE-16	#copy problem state bit from old ics
	jntb	mck_debug	#transfer control to debugger if not user mode
#endif
 #
 #  real macine checks - call fault to handle
 #
mck_real:
	lis r11,0             # no additional information required
	b	pck_fault	# handle as a fault
 #
 # pass control to debugger if it is present
 #
mck_debug:
         lm    r10,low_save10    # restore regs
mck_jump_to_dan: b real0         # jump to original owner of program check


 #****************************************************************
 #* 	Common Interrupt Handler				*
 #*	On entry:						*
 #*		r6 = INT STACK					*
 #*		r7 = slih table entry pointer			*
 #*/*BJB*/	r8 = interrupt level
 #*		r10 = iar at interrupt time			*
 #*		r11 = icscs at interrupt time			*
 #*	The registers are saved at 0(r6)...60(r6)		*
 #*		except for r6 which is in iosave6		*
 #*	During:							*
 #*		r1 = KERN STACK (sp)				*
 #*		r9 = Save MQ at interrupt time			*
 #*								*
 #****************************************************************

booboo:  get	r2,$0x96	# value for 'booboo' in lights
	bali	r5,display
	j	booboo		# and loop (sigh)
#ifdef IODEBUG
	.align	2		# *tjm
$_iotrap:
	.globl _iotrap
	.int _iotrap
#endif IODEBUG


iosave3: .long		/*BJB*/
	.globl	int_comm
eye_catcher(int_comm):

	.using	real0,r0
/*BJB - Set up the BJBEYE and BJBIAR silly fields in the int stack for 
	debugging */
	st	r3,iosave3		#BJB
	cau	r3,0xbbbb(r0)		#BJB
	o	r3,r8			#BJB mask on interrupt level.
	st	r3,XBJBEYE(r6)		#Put eye-catcher on int stack BJB
	l	r3,iosave3		#BJB
	st	r10,XBJBIAR(r6)		#Put iar on int stack BJB

/*BJB - end debugging code */

	mttbiu	r11,PROBSTATE-16	# get probstate bit
 	bntbx	goto_int_comm_1		# not probstate, sp was sys sp, ie. ok
 	 ai	sp,sp,FRM_PROTECT 
	bali	sp,flipmode		# switch to kernel mode
#if	MACH
	get	sp,saved_kernel_stk
#else	MACH	
	cau     sp,(KERNSTACK)>>16(r0)	# switch to kernel stack
	oil     sp,sp,(KERNSTACK)&0xffff
#endif	MACH
goto_int_comm_1:



	l	r0,iosave6		# Get The real value of R6 at IRPT
	sts	r0,XIHR6(r6)		# Save it on INT Stack
	mfs	scr_mq,r9		# r9 = get mq at IRPT

	#
	# Get ready to call SLIH
	#
	cas	r8,r6,r0		# Save Int Stack pointer
	# Save the ICS and set the SLIH's
	lh	r5,IOSLICS(r7)		# Set ICS for SLIH Execution
	sth	r5,go_callslih+4	# Set the SLIH ICS
	lps	0,go_callslih

 #
 # interrupts can (and will) happen between here and 'afterslih'
 # note that translation is now ON.
 #
callslih:

#if	ROMP_RDB
 #
 # following is to fake up a C entry sequence for the debugger
 # traceback routine
 #
	cas	r15,r10,r0		# fake "return" value
	j	0f
	ai	sp,sp,FRM_PROTECT	# for RDB's benifit
0:
	.globl	_callslih
_callslih:
	stm	r15,-4(sp)		# save return address
	ai	sp,sp,-4		# room for 1 register
#endif	ROMP_RDB
	oiu	r7,r7,SYS_ORG/UPPER	# Prepare to enter translate mode
 # Set up stack for SLIH arguments

	ls	r5,DEVSLIH(r7)		# Entry Point to SLIH code
	l	r2,DEVDEP(r7)		# Pass Device Dependant information

	cas	r3,r11,r0		# Pass the SLIH the icscs (arg2)
	cas	r4,r10,r0		#  and the IAR at interrupt (arg3)
	l	r15,0(r5)
	balrx	r15,r15
	 mr	r0,r5
	# Restore state for return from Interrupt Processing
1:	.using	1b
	mfs	scr_iar,r15
	.text
1:	.using 1b,r15
	lps	0,go_afterslih
 # we are now back at FLIH priority with translate off.
afterslih:

	.using	real0,r0
	cas	r6,r8,r0		# Restore the INT stack pointer
	mts	scr_mq,r9		# Restore MQ
	st	r10,low_ps+old_iar	# Store old program status for
	st	r11,low_ps+old_ics_cs	#   end Interrupt processing

	# Enable IL's According to mask value of level being resumed
	ti	1,r6,iounmask-1-real0	# Check for IO Stack underflow

	# Restore Registers and resume interrupted proram

	cal	r6,IOSAVEL(r6)		# Pop Register save area stack
	# This is safe before restoring regs. because All Int's are masked
	st	r6,iosavep		# Save new stack pointer


	mttbiu	r11,PROBSTATE-16	# get probstate bit
	jtb	5f			# probstate - normal return
 # since we're not interrupted from user state, just go back without
 # worrying about scheduling.  Thus, during autoconf there is no need for
 # a u-area (which is good, since there isn't a u-area).
	l	r1,XIHR1-IOSAVEL(r6)	# get old r1
	l	r0,XIHR0-IOSAVEL(r6)	# get old r0
	lm	r2,XIHR2-IOSAVEL(r6)	# restore other registers
	lps	0,low_ps
5:

	# Save This stuff for go
	l	r0,XIHR1-IOSAVEL(r6)	# get old r1
	st	r0,low_save1		# stash away for go
	l	r0,XIHR15-IOSAVEL(r6)	# get old r15
	st	r0,low_save15		# stash away for go
	l	r0,XIHR0-IOSAVEL(r6)	# get old r0
	lm	r2,XIHR2-IOSAVEL(r6)	# restore other registers


	# Resume interrupted program
	lps	0,go_ps			# jump to "go" with interrupts off
1:	.using	1b			# no longer have addressability
