/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 * HISTORY:$Log:	lomapin.s,v $
 * Revision 2.2  88/10/06  13:54:12  sanzi
 * 	Use new reverse pointers maintained in hash_table.
 * 	
 * 
 *
 * 	These are assembly language versions of the routines
 *	mapin() and mapout() contained in pmap.c
 */ 
/*
 * The following are offsets in the hatipt entries
 */
#define	HAT_FIELD	0x4	
#define	IPT_FIELD	0x6
#define	REV_FIELD	0xe
#define	IPT_LASTBIT	16
#define	LOG_IPTSIZE	4

#define	r_hatipt 	r15	/* register containing the hatipt pointer */
#define	rev_ptr		r14	/* reverse link pointer */
#define	prev_ipte	r13	/* previous ipte */
#define	ipt_ptr		r12	/* value of this_ipte->ipt_ptr */
#define	bitmask		r12	/* reused for is_in computation */
#define	this_ipte	r11	/* current working entry */
#define	next_ipte	r10	/* next entry in the chain */
#define	r_is_in		r9 	/* register containing is_in table address */
#define	basereg		r8	/* for looking up globals */
#define	tmp2		r7	/* used for temporary computations */
#define	index		r6	/* used for temporary computations */
#define	vpage		r5	/* used as a temporary */
#define	tmp3		r4	/* used for bitmask groveling (in mapout) */
#define	count		r3	/* second parameter */
#define	ppage		r2	/* first parameter */

	.align	2
	.globl	_.lo_mapout
	.globl	_lo_mapout
	
_lo_mapout:	.long _.lo_mapout
eye_catcher(lo_mapout):
_.lo_mapout:	
	stm	r6,-76(sp)	# space for 10 registers
	ai	sp,sp,-76	# adjust stack
 # setup base register
 	.using 	lo_mapout_base,basereg
	bali	basereg,lo_mapout_base
lo_mapout_base:
	l	r_hatipt,_RTA_HATIPT	# get hat pointer
	l 	r_is_in,_is_in		# get is_in table address
start_loop:	
 # check is_in table 
#define	word	tmp2
#define	bm_addr	tmp3 		/* bitmask address */
 	mr	index,ppage		# get index
	srpi	index,3			# word = ppage / 8 (paired shift)
	cas	bm_addr,r_is_in,word	# address of bit vector
	lcs	word,0(bm_addr)		# get word
	nilz	index,index,0x0007	# mask all but lower 3 bits
	lis	bitmask,1		# compute bitmask
	sl	bitmask,index		# now have desired bit
	mr	index,word		# save the word from the bit vector
 	n	index,bitmask		# is bit set?
#if	ROMP_CACHE	
	je	mapout_return		# bit is clear, we are done
#else	ROMP_CACHE
	be	mapout_pageout_panic
#endif	ROMP_CACHE		
 # clear the bit in the table 
	onec	bitmask,bitmask		# complement the bitmask
	n	word,bitmask		# clear the bit for this ppage
	stcs	word,0(bm_addr)		# write new bit vector entry back
#undef	word	
#undef	bm_addr
 # get ipte entry
 	mr	index,ppage			# use index as temp
 	sli	index,LOG_IPTSIZE		# make it an index into HATIPT
	cas	this_ipte,index,r_hatipt # this_ipte = &RTA_HATIPT[ppage]
	lh	ipt_ptr,IPT_FIELD(this_ipte) 	# get this_ipte->ipt_ptr
	lh	rev_ptr,REV_FIELD(this_ipte) 	# get this_ipte->rev_ptr
	mttbil	ipt_ptr,IPT_LASTBIT-16		# last bit set?
	btb	ipt_endchain
	mr	index,ipt_ptr			# save value of ipt_ptr
	sli	index,LOG_IPTSIZE		# make ipt an offset in HATIPT
	cas	next_ipte,index,r_hatipt   	# get pointer to next_ipte
	sth	rev_ptr,REV_FIELD(next_ipte) 	# unlink reverse chain
ipt_endchain:		
	mttbil	rev_ptr,IPT_LASTBIT-16		# check last bit of rev link
	bntb	rev_iptchain
 #
 # The reverse link points to a hat entry
 #
 	clrbl	rev_ptr,IPT_LASTBIT-16		# clear the last bit
	mr	index,rev_ptr			# save value of rev_ptr
	sli	index,LOG_IPTSIZE		# make it an index in hatipt
	cas	prev_ipte,index,r_hatipt	# get prev_ipte
	sth	ipt_ptr,HAT_FIELD(prev_ipte)	# unlink forward chain (HAT)
	b	mapout_done
rev_iptchain:	
 # 
 # The reverse link points to a normal ipte entry
 #
 	mr	index,rev_ptr			# save value of rev_ptr
	sli	index,LOG_IPTSIZE		# make it an index in hatipt
	cas	prev_ipte,index,r_hatipt	# get prev_ipte	
	sth	ipt_ptr,IPT_FIELD(prev_ipte)	# unlink forward chain (HAT)
mapout_done:	
	get	index,$(RTA_UNDEF_PTR)		# for debuggging
	sth	index,IPT_FIELD(this_ipte)	# 
	sth	index,REV_FIELD(this_ipte)	# 
	dec	count,1			# subtract one from count
	cis	count,0			# is count zero
	bnex	start_loop		# mapout next page
	inc	ppage,1			# 
mapout_return:	
	ai	sp,sp,76		# reset stack
	lm	r6,-76(sp)		# get registers back
	br 	r15			# exit	
	.align	2
mapout_pageout_panic:
	l	r2,$.long panic_str4	# get argument
	get	r14,$(_panic)		# get panic dap
	l	r15,0(r14)		# get panic entry
	balrx	r15,r15			# bye
	mr	r0,r14
	j	mapout_return
							
panic_str4:	.asciz	"mapout: page already out"	
	.align	2

#undef	r_hatipt 	/* r15	*/
#undef	rev_ptr		/* r14	*/
#undef	prev_ipte	/* r13	*/
#undef	ipt_ptr		/* r12	*/
#undef	bitmask		/* r12	*/
#undef	this_ipte	/* r11	*/
#undef	next_ipte	/* r10	*/
#undef	r_is_in		/* r9 	*/
#undef	basereg		/* r8	*/
#undef	tmp2		/* r7	*/
#undef	index		/* r6	*/
#undef	vpage		/* r5	*/
#undef	tmp3		/* r4	*/
#undef	count		/* r3	*/
#undef	ppage		/* r2	*/

#define	r_hatipt 	r15	/* register containing the hatipt pointer */
#define	hash_value	r14	/* temporary for hash computation */
#define	addrtag		r14	/*  */
#define	sid		r13	/* temporary computations */
#define	bitmask		r12	/* for is_in computation */
#define	this_ipte	r12	/* current ipte entry */
#define	prev_ipte	r11	/* current working hat entry */
#define	next_ipte	r10	/* next entry in the chain */
#define	r_is_in		r9 	/* register containing is_in table address */
#define	basereg		r8	/* for looking up globals */
#define	tmp2		r7	/* used for temporary computations */
#define	index		r6	/* used for temporary computations */
#define	count		r5	/* fourth parameter */
#define	prot		r4	/* third parameter */
#define	vpage		r3	/* second parameter */
#define	ppage		r2	/* first parameter */
#define	r_hashmask	r0	/* for computing hash values */

	.align	2
	.globl	_.lo_mapin
	.globl	_lo_mapin
	
_lo_mapin:	.long _.lo_mapin

/*
 *	lo_mapin(ppage,vpage,prot,count,sid)
 *	
 *	purpose: add the given <sid,vpage,prot> --> ppage mapping
 *	into the HATIPT.  repeat for count pages starting at vpage, ppage
 *	and incrementing by one for each iteration of count.
 */

eye_catcher(lo_mapin):
_.lo_mapin:
	stm	r6,-76(sp)		# space for 10 registers
	ls	sid,0(sp)		# get sid now
	ai	sp,sp,-76		# adjust stack
 # setup base register
 	.using 	lo_mapin_base,basereg
	bali	basereg,lo_mapin_base
lo_mapin_base:
	l	r_hatipt,_RTA_HATIPT	# get hat pointer
	l	r_hashmask,_RTA_HASHMASK # get hash mask
in_start_loop:
 # check is_in table 
#define	word	tmp2 
	l 	r_is_in,_is_in		# get is_in table address
 	mr	index,ppage		# get index
	srpi	index,3			# word = ppage / 8 (paired shift)
	cas	r_is_in,r_is_in,word	# address of bit vector
	lcs	word,0(r_is_in)		# get word
	nilz	index,index,0x0007	# mask all but lower 3 bits
	lis	bitmask,1		# compute bitmask
	sl	bitmask,index		# now have desired bit
	mr	index,word		# save the word from the bit vector
	n	index,bitmask		# is bit set?
	jne	mapin_panic1		# panic! page is already in.
 # set the bit in the table 
	o	word,bitmask		# set the bit for this ppage
	stcs	word,0(r_is_in)		# write new bit vector entry back
#undef	word	
 # get ipte for this page
 	mr	index,ppage		# don't corrupt ppage
	sli	index,LOG_IPTSIZE	# make it an index into HATIPT
	cas	this_ipte,r_hatipt,index	# get address of ipte
 # do prefetch of rose_page_size	
	l	index,_rose_page_size	# get page size 
 # generate addrtag
 	mr	addrtag,prot		# addrtag = prot
	sli16	addrtag,RTA_KEY_SHIFT-16 # shift it over
	mr	tmp2,sid		# get sid
	sli16	tmp2,RTA_VPAGE_BITS-16	# shift it over
	o	addrtag,tmp2		# or in the sid bits to the addrtag
	mr	tmp2,vpage		# don't corrupt vpage 
	ci	index,0x1000		# using 4K pages?
	jne	mapin_vpage_ok
	sli	tmp2,1			# vpage =<< 1
mapin_vpage_ok:	
	o	addrtag,tmp2		# addrtag is now valid
	st	addrtag,0(this_ipte)		# write it to HATIPT
	get	tmp2,$(0x0100ffff)	# the proper values for HATIPT word 3
	st	tmp2,IPTLOCK(this_ipte)	# write it to HATIPT
mapin_do_hash:
	mr	hash_value,vpage		# don't corrupt vpage
 	x	hash_value,sid			# hash function
	n	hash_value,r_hashmask		# mask to desired size
	mr	index,hash_value		# save hash_value for later
	sli	index,LOG_IPTSIZE		# make it an index into HATIPT
	cas	prev_ipte,r_hatipt,index 	# get addr of hat for this page
	lh	tmp2,HAT_FIELD(prev_ipte) 	# get prev_ipte->hat_ptr
	mttbil	tmp2,IPT_LASTBIT-16		# check last bit of hat chain
	btb	hat_endchain	
	mr	index,tmp2			# dont clobber hat_ptr value
	sli	index,LOG_IPTSIZE		# get next_ipte entry
	cas	next_ipte,index,r_hatipt	# 
	sth	ppage,REV_FIELD(next_ipte) 	# link in to reverse chain
hat_endchain:	
	sth	tmp2,IPT_FIELD(this_ipte)	# store at this_ipte->ipte_ptr
	sth	ppage,HAT_FIELD(prev_ipte)	# write new ppage for prev_ipte
	setbl	hash_value,IPT_LASTBIT-16	# set the IPT_HATLINK bit
	sth	hash_value,REV_FIELD(this_ipte)	# link in to reverse chain

mapin_done:	
	inc	vpage,1			# bump vpage
	dec	count,1			# decrement count
	cis	count,0			# equal zero yet?
	bnex	in_start_loop		# do next physical page
	inc	ppage,1			# bump ppage
	
mapin_return:
	ai	sp,sp,76	# reset stack
	lm	r6,-76(sp)	# get registers back
	br 	r15		# exit

mapin_panic1:
	get	r14,$(_panic)		# get panic dap
	l	r15,0(r14)		# get panic entry
	l	r2,$.long panic_str3	# get argument
	balrx	r15,r15			# toodles
	mr	r0,r14
	j	mapin_return		# this isn't necessary

panic_str3:
	.asciz	"mapin: page already in!"
	

#undef	addrtag		
#undef	bitmask		
#undef	this_ipte	
#undef	next_ipte	
#undef	prev_ipte
#undef	r_is_in		
#undef	basereg		
#undef	tmp2		
#undef	index		
#undef	count		
#undef	prot		
#undef	vpage		
#undef	ppage		
#undef	r_hashmask	
#undef	r_hatipt
#undef	hash_value
#undef	sid
 /*
  * lo_remap(addrtag,ppage,prot)
  *
  * Don't even think about calling this from C code.
  * This is an attempt at fast remapping of a page for use exclusively by
  * the cache code.
  */

#define	r_hatipt 	r15	/* register containing the hatipt pointer */
#define	hash_value	r14	/* temporary for hash computation */
#define	addrtag		r14	/*  address tag used when adding ipte entry */
#define	rev_ptr		r14	/* used when linking in to chains */
#define	count		r13	/* page counter */
#define	bitmask		r12	/* for is_in computation */
#define	prev_ipte	r12	/* current working hat entry */
#define	this_ipte	r11	/* current ipte entry */
#define	next_ipte	r10	/* next entry in the chain */
#define	r_is_in		r9 	/* register containing is_in table address */
#define	ipt_ptr		r9	/* reused r9 */
#define	basereg		r8	/* for looking up globals */
#define	tmp2		r7	/* used for temporary computations */
#define	index		r6	/* used for temporary computations */
#define	prot		r5	/* fourth parameter */
#define	ppage		r4	/* third parameter */
#define	vpage		r3	/* second parameter */
#define	sid		r2	/* first parameter */
#define	r_hashmask	r0	/* for computing hash values */

1:	.using	1b
	.align	2
	.globl	_.lo_remap
	.globl	_lo_remap
	
_lo_remap:	.long _.lo_remap
_.lo_remap:
#if	USE_ASSEMBLY
	st	r15,-4(sp)		# save return address 
	ai	sp,sp,-4
#else	USE_ASSEMBLY
	stm	r6,-76(sp)	# space for 10 registers
	ai	sp,sp,-76	# adjust stack
#endif	USE_ASSEMBLY
 # setup base register
 	.using 	lo_remap_base,basereg
	bali	basereg,lo_remap_base
lo_remap_base:
	l	count,_ppages_per_vmpage
	l	r_hatipt,_RTA_HATIPT		# get hat pointer
	l	r_hashmask,_RTA_HASHMASK 	# get hash mask
remap_start_loop:
 # get ipte entry
 	mr	index,ppage			# use index as temp
 	sli	index,LOG_IPTSIZE		# make it an index into HATIPT
	cas	this_ipte,index,r_hatipt # this_ipte = &RTA_HATIPT[ppage]
 # check is_in table 
#define	word	tmp2 
	l 	r_is_in,_is_in		# get is_in table address
 	mr	index,ppage		# get index
	srpi	index,3			# word = ppage / 8 (paired shift)
	cas	r_is_in,r_is_in,word	# address of bit vector
	lcs	word,0(r_is_in)		# get word
	nilz	index,index,0x0007	# mask all but lower 3 bits
	lis	bitmask,1		# compute bitmask
	sl	bitmask,index		# now have desired bit
	mr	index,word		# save the word from the bit vector
	n	index,bitmask		# is bit set?
	jne	remap_mapout		# map out the page
 # set the bit in the table 
	o	word,bitmask		# set the bit for this ppage
	bx	remap_mapout_done	# skip mapping out the page
	stcs	word,0(r_is_in)		# write new bit vector entry back
#undef	word	
remap_mapout:
	lh	ipt_ptr,IPT_FIELD(this_ipte) 	# get this_ipte->ipt_ptr
	lh	rev_ptr,REV_FIELD(this_ipte) 	# get this_ipte->rev_ptr
	mttbil	ipt_ptr,IPT_LASTBIT-16		# last bit set?
	btb	remap_endchain
	mr	index,ipt_ptr			# save value of ipt_ptr
	sli	index,LOG_IPTSIZE		# make ipt an offset in HATIPT
	cas	next_ipte,index,r_hatipt   	# get pointer to next_ipte
	sth	rev_ptr,REV_FIELD(next_ipte) 	# unlink reverse chain
remap_endchain:		
	mttbil	rev_ptr,IPT_LASTBIT-16		# check last bit of rev link
	bntb	remap_iptchain
 #
 # The reverse link points to a hat entry
 #
 	clrbl	rev_ptr,IPT_LASTBIT-16		# clear the last bit
	mr	index,rev_ptr			# save value of rev_ptr
	sli	index,LOG_IPTSIZE		# make it an index in hatipt
	cas	prev_ipte,index,r_hatipt	# get prev_ipte
	sth	ipt_ptr,HAT_FIELD(prev_ipte)	# unlink forward chain (HAT)
	b	remap_mapout_done
remap_iptchain:	
 # 
 # The reverse link points to a normal ipte entry
 #
 	mr	index,rev_ptr			# save value of rev_ptr
	sli	index,LOG_IPTSIZE		# make it an index in hatipt
	cas	prev_ipte,index,r_hatipt	# get prev_ipte	
	sth	ipt_ptr,IPT_FIELD(prev_ipte)	# unlink forward chain (HAT)
 # map the page in
remap_mapout_done:
 # do prefetch of rose_page_size	
	l	index,_rose_page_size		# get page size 
 # generate addrtag
 	mr	addrtag,prot			# addrtag = prot
	sli16	addrtag,RTA_KEY_SHIFT-16 	# shift it over
	mr	tmp2,sid			# get sid
	sli16	tmp2,RTA_VPAGE_BITS-16		# shift it over
	o	addrtag,tmp2		# or in the sid bits to the addrtag
	mr	tmp2,vpage			# don't corrupt vpage 
	ci	index,0x1000			# using 4K pages?
	jne	remap_vpage_ok
	sli	tmp2,1				# vpage =<< 1
remap_vpage_ok:	
	o	addrtag,tmp2			# addrtag is now valid
	st	addrtag,0(this_ipte)		# write it to HATIPT
	get	tmp2,$(0x0100ffff)	# the proper values for HATIPT word 3
	st	tmp2,IPTLOCK(this_ipte)		# write it to HATIPT
remap_do_hash:
	mr	hash_value,vpage		# don't corrupt vpage
 	x	hash_value,sid			# hash function
	n	hash_value,r_hashmask		# mask to desired size
	mr	index,hash_value		# save hash_value for later
	sli	index,LOG_IPTSIZE		# make it an index into HATIPT
	cas	prev_ipte,r_hatipt,index 	# get addr of hat for this page
	lh	tmp2,HAT_FIELD(prev_ipte) 	# get prev_ipte->hat_ptr
	mttbil	tmp2,IPT_LASTBIT-16		# check last bit of hat chain
	btb	remap_hat_endchain	
	mr	index,tmp2			# dont clobber hat_ptr value
	sli	index,LOG_IPTSIZE		# get next_ipte entry
	cas	next_ipte,index,r_hatipt	# 
	sth	ppage,REV_FIELD(next_ipte) 	# link in to reverse chain
remap_hat_endchain:	
	sth	tmp2,IPT_FIELD(this_ipte)	# store at this_ipte->ipte_ptr
	sth	ppage,HAT_FIELD(prev_ipte)	# write new ppage for prev_ipte
	setbl	hash_value,IPT_LASTBIT-16	# set the IPT_HATLINK bit
	sth	hash_value,REV_FIELD(this_ipte)	# link in to reverse chain
remap_done:
	inc	vpage,1			# bump vpage
	dec	count,1			# decrement count
	cis	count,0			# equal zero yet?
	bnex	remap_start_loop		# do next physical page
	inc	ppage,1			# bump ppage
remap_return:
#if	USE_ASSEMBLY
	ai	sp,sp,4			# return
	l	r15,-4(sp)
	br	r15
#else	USE_ASSEMBLY
	ai	sp,sp,76	# reset stack
	lm	r6,-76(sp)	# get registers back
	br 	r15		# exit	
#endif	USE_ASSEMBLY
