/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	lopckrt0.s,v $
 * Revision 2.2  88/10/01  21:48:39  rpd
 * 	Changed CS_KDB conditionals to CMUCS_KDB.
 * 	[88/10/01  21:13:28  rpd]
 * 
 *  8-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added code ala ACIS to correctly call rdb from program check
 *	level.
 *
 */ 
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <cmucs_kdb.h>

	.text

 #
 #  program check level 0 interrupt service routine
 #
 #
 #  assumptions:  All the interesting (ones passed to trap.c) bits in the
 #       storage exception register are included in the lower order 11 (the
 #       number of bits required for hardware page offsets).
 #
 # r10 = mcs_pcs	value with (possibly) simulated bit values for certain
 #		conditions.
 # r11 = exception information
 #
	.align	2
pck_vec1:
	.long	pck1 -real0		# New IAR
	.short	NOTRANS_ICS+INTMASK_ICS+INT_PRI0,0	# New ICS
        .using real0,r0
eye_catcher(pck0):
#if	ROMP_APC
	cas	r0,r0,r0		# nop
	st	r15,low_save15		# these instructions prevent "death-by-88"
 #	bala	0f - real0		# on both SGP and ROMPC
	.long BALA + 0f - real0		# can't have above instn - sigh
0:	l	r15,low_save15
#else
	b	0f	# this instruction is necessary for certain page-faults
			# that will result in a "death-by-88" without it.
0:
#endif
        stm   r10,low_save10    # copy interrupt time rx into low_save var
        mfs   scr_mcspcs,r10    # r10 = program check status
	lps   1,pck_vec1	# get off program check level ASAP
pck1:
        st    r1,low_save1      # copy interrupt time r1 into low_save var

#if	ROMP_APC
        nilz  r11,r10,PCS_TRAP+PCS_PRIV_I+PCS_BAD_I+PCS_RESERVED
#else	ROMP_APC
        nilz  r11,r10,PCS_UNKNOWN+PCS_TRAP+PCS_PRIV_I+PCS_BAD_I+PCS_RESERVED
#endif	ROMP_APC
        bnz   pck_notstg        # branch if any of those bad guys

	cau   r15,(ROSEBASE)>>16(r0) # i/o base address of Rosetta
	oil   r15,r15,(ROSEBASE)&0xffff
        ior   r14,ROSE_SER(r15) # r14 = storage exception register
#if	ROMP_DEBUG
	st	r14,_ser	# save ser
#endif	ROMP_DEBUG
        niuo  r13,r14,RTA_EX_OHOH_UPPER  # unexpected upper bits
        nilo  r13,r13,RTA_EX_OHOH_LOWER  # unexpected lower bits
        bnz   pck_debug          # branch if any unexpected bits are on

/*
 *	Code to set the RTA_EX_HACK bit in r14 if the RTA_EX_FAULT bit is
 *	set.  This is because the fault bit is overwritten by the page number
 *	and never makes it to the trap routine where it is needed.  This
 *	should be done in some better way...
 */
	mttbil r14,19-16	#get RTA_EX_LOAD bit
	mftbil r14,29-16	#copy it into RTA_EX_HACK

	nilo   r14,r14,~RTA_EX_CECC # forget about correctable ecc errors

    # Following added by mjb to deal with lm and stm data faults.
    # Maybe I even got it right this time.
	nilz  r13,r14,RTA_EX_MULTX  # Multiple exceptions indicated?
	jz    pck05		# Nope.
        mttbil r10,30-16        # d-fetch vs i-fetch bit
        bntb  pck_debug          # jump if i-fetch -- this is not normal
	nilo  r14,r14,0xFFFF-RTA_EX_MULTX # Let's not get confused
pck05:
    # End of lines added by mjb to deal with lm and stm exceptions.

        ior   r12,ROSE_SEAR(r15)# r12 = storage exception address register
#if	ROMP_DEBUG
	st	r12,_sear	# save for debugging
#endif 	ROMP_DEBUG
        mttbil r10,30-16        # d-fetch vs i-fetch bit
        jtb   pck10             # jump if d-fetch (SEAR correct)
        l     r12,pck_ps+old_iar# r12 = iar at time of fault
        nilz  r13,r12,0x800-1   # r13 = 2K page offset
        ci    r13,0x800-6       # if inst (or subject of bx) w/in page
        jl    pck10             # then jump (iar in faulting page)

        iow   r12,ROSE_CRA(r15) # compute real addr of lower page
        ior   r13,ROSE_TRAR(r15)# r13 = translated real addr register
        cis   r13,0             # if high bit is on, translation failed
        jl    pck10             # then jump (lower page faulted)
        ais   r12,6             # else put iar into higher page
pck10:
        nilo  r12,r12,0-0x800	# zero page offset bits in exception address
        nilz  r11,r14,0x800-1	# zero all but pg offset bits in exception reg
        o     r11,r12           # fold interesting exception bits into pg off.
	s	r14,r14		# zippo
	iow   r14,ROSE_SER(r15) # Clear the exception register
        b     pck_fault         # go handle page fault
 #
 #  program check, but not a storage fault
 #  if debugger present and in kernel mode pass to the debugger
 #  otherwise pass to 'trap'.
 #
pck_notstg:
#if	ROMP_RDB
	l	r11,pck_ps+old_ics_cs # get the ics into r11
	mttbiu	r11,PROBSTATE-16	#copy problem state bit from old ics
	jntb	pck_debug	#transfer control to debugger if not user mode
#endif	ROMP_RDB
         mttbil r10,26-16        # if not a trap inst (bit 26 from PCS)
         jntb  pck_real          # then jump
	 cau   r10,(BKPT)>>16(r0)  # mcs_pcs value for breakpoint inst "check"
	 oil   r10,r10,(BKPT)&0xffff
 #
 #  real program checks - call fault to handle
 #
pck_real:
	lis r11,0             # no additional information required
	b	pck_fault	# handle as a fault
 #
 # pass control to debugger if it is present
 #
pck_debug:
#if	CMUCS_KDB
        mttbil	r10,26-16        # if not a trap inst (bit 26 from PCS)
        jntb	pck_rdb          # then jump
	cau	r10,(BKPT)>>16(r0)# mcs_pcs value for breakpoint inst "check"
	oil	r10,r10,(BKPT)&0xffff
	l	r13,pck_ps	# r13 = iar after trap
	l	r12,pck_ps+old_ics_cs	# trap in translate mode ?
	mttbiu	r12,TRANS-16
	jntb	pck_kdb_notrans
	lps	0,pck_kdb_ps1

pck_kdb_trans:
	bali	r15,pck_kdb_base# establish addressibility
pck_kdb_base:
	.using	pck_kdb_base,r15
	lh	r12,0(r13)	# get the instruction that caused the trap
	lps	0,pck_kdb_ps2	# go back to physical

	.using	real0,r0
pck_kdb_notrans:
	lh	r12,0(r13)	# get the instruction that caused the trap
pck_kdb_check:
	cal16	r13,RDB_BKPT(r0)
	c	r12,r13
	je	pck_rdb
	j	pck_real

	.align	2
pck_kdb_ps1:
	.long	pck_kdb_trans				# new iar
	.short	TRANS_ICS+INTMASK_ICS+INT_PRI0,0	#new ics
pck_kdb_ps2:
	.long	pck_kdb_check - real0			# new iar
	.short	NOTRANS_ICS+INTMASK_ICS+INT_PRI0,0	# new ics

	.align	2		# make sure pck_jump_to_dan can be patched
pck_rdb:
#endif	CMUCS_KDB
#if	!ROMP_RDB
	j	pck_real
#endif	!ROMP_RDB
	 mts	scr_mcspcs,r10	 # r10 = program check status
	 bx	pck_jump_to_dan
         lm    r10,low_save10    # restore regs
	 .align	2
pck_jump_to_dan: b real0         # jump to original owner of program check
