	ci	r3,0
	jhe	fast_syscall_end
	/*
	 * look up the number of args in the trap table.
	 *
	 * this code assumes that if there are > 0 parameters,
	 * then we have a valid syscall.
	 */
	twoc	r7,r3			# make info positive
	get	r10,$mach_trap_count	# get count
	c	r7,r10			# is it >= count?
	jhe	fast_syscall_end	# let C code worry about it.
	get	r10,$mach_trap_table	# get table pointer	 

	sli	r7,3			# make it a byte offset into the array
	cas	r10,r10,r7		# get pointer to entry
	lh	r8,0(r10)		# get "mach_trap_length"
	sis	r8,4			# there's alot of history behind this..
	ci	r8,4*4			# number of args passed in regs
	jh	move_args
call_mach_syscall:
	lis	r11,0
	l	r14,4(r10)		# get data area pointer
	cis	r14,0			# does one exist?
	je	fast_syscall_end	# no, punt
	l	r2,FAULT_R2(sp)		# get the parameters
	l	r3,FAULT_R3(sp)
	l	r4,FAULT_R4(sp)
	l	r5,FAULT_R5(sp)		
	l	r15,0(r14)		# get entry point
	balrx	r15,r15			# call it.
	mr	r0,r14

	cas	sp,sp,r11		# pop off parameters
	l	r3,FAULT_ICSCS(sp)	# get icscs
	clrbl	r3,31-16		# clear test bit
	st	r3,FAULT_ICSCS(sp)	# store icscs
	cis	r2,0			# successful return?
	je	syscall_check_signals
	setbl	r3,31-16		# set test bit
	st	r3,FAULT_ICSCS(sp)	# store icscs	
	j	syscall_check_signals	# done!

move_args:
	/*
	 * we're going to touch the user's address space here,
	 * so we must set thread->recover in case we fault.
	 *
	 * r6 == base register
	 * r8 == total number of bytes for syscall()
	 * r10 == pointer to mach_trap_table entry for this syscall
	 *
	 * register usage:
	 *	r13: pointer to fault frame on stack
	 *	r12: temporarily used to compute bytes to copy
	 *		then used to store current_thread
	 *	r11: na
	 *	r10: see above
	 *	 r9: set to destination area on our stack for copy
	 *	 r8: used to keep track of the number of args left to copy
	 *	
	 * stack usage:
	 * -->	on entry, the sp points at the fault frame, ie., @ R1
	 * --> 	we adjust the stack pointer down to avoid clobbering it
	 * -->	then we allocate a label_t on the stack (of size SYS_SAVESIZE)
	 * -->  
	 */
#define	SYS_SAVESIZE	64
	mr	r13,sp			# save frame pointer
	ais	sp,-4			# FAULT_R0 == -4
	get	r12,$16			# number of bytes in regs
	s	r8,r12			# bytes remaining on stk.
	s	sp,r8			# adjust stack for args
	mr	r9,sp			# and save a pointer
	ai	r1,r1,-SYS_SAVESIZE	# allocate space
	get	r15,$syscall_recover	# load recover address
	stm	r1,0(r1)		# store registers
	mfs	scr_ics,r0		# get the ics
	sts	r0,4*15(r1)		# save the ics
	l	r12,a_active_threads	# get thread
	l	r12,0(r12)		#
	st	r1,THREAD_RECOVER(r12)	# save the context pointer
	/*
	 *  register usage in the copy loop: 
	 *	r6 == base register (still)
	 *	r8 == number of bytes to move (word aligned)
	 *  	r9 == address on our stack to move them to
	 *	r10 == pointer to mach_trap_table entry
	 *	r12 == pointer to curent_thread()
	 *	r13 == pointer to FAULT frame
	 */
	l	r7,FAULT_R1(r13)	# get the user's sp
	mr	r8,r11
move_loop:
	l	r5,0(r7)		# get parameter
	sts	r5,0(r9)		# store parameter
	ai	r7,4			# bump usp
	ai	r9,4			# bump ksp
	sis	r8,4			# decrement count
	jh	move_loop		# anything left to copy?
 # call the trap routine
	lis	r2,0
	sts	r2,THREAD_RECOVER(r12)	# clear recover field
	ai	sp,sp,SYS_SAVESIZE	# pop saved area
	l	r2,FAULT_R2(r13)	# save the parameters
	l	r3,FAULT_R3(r13)	
	l	r4,FAULT_R4(r13)
	l	r5,FAULT_R5(r13)
	l	r14,4(r10)		# get entry point
	l	r15,0(r14)		# call mach trap routine
	balrx	r15,r15
	mr	r0,r14

	cas	sp,sp,r11		# pop off parameters
	ai	sp,sp,4			# adjust sp to point at R1
	l	r3,FAULT_ICSCS(sp)	# get icscs
	clrbl	r3,31-16		# clear test bit
	st	r3,FAULT_ICSCS(sp)	# store icscs
	cis	r2,0			# successful return?
	je	after_svc_call_c
	setbl	r3,31-16		# set test bit
	st	r3,FAULT_ICSCS(sp)	# store icscs	
	j	after_svc_call_c	# done!
	/*
	 * we come here whenever the above code faults
	 * illegally trying to read the user's parameters (for instance,
	 * if the user's stack were invalid).
	 *
	 * on entry: sp points at the fault frame
	 *
	 * prepare to return (KERN_INVALID_ARGUMENT)
	 * and then check for signals
	 */
syscall_recover:
	mr	r1,r13			# restore stack pointer
	lis	r0,0			# clear recover field
	sts	r0,THREAD_RECOVER(r12)
	get	r2,$(KERN_INVALID_ARGUMENT)
	st	r2,FAULT_R2(sp)		# store it.

	/*
	 * on entry: sp points at the fault frame
	 *
	 * unfortunately, we also must check for pending
	 * signals before exiting.  if we find that there are
	 * signals pending, then we schedule an ast (blech, but
	 * it's what the vax does, and if it's good enough for
	 * them...
	 */
syscall_check_signals:
	l	r12,a_active_threads	# get thread (again!)
	l	r12,0(r12)		#
	l	r11,THREAD_EXIT_CODE(r12) # abnormal exit ?
	get	r10,$THREAD_EXIT	# check against exit code
	c	r10,r11
	jeq	syscall_call_ast
	l	r11,THREAD_UTASK(r12)	# get utask->
	l	r10,U_PROCP(r11)	# get u_procp->
	l	r9,P_CURSIG(r11)	# get cursig
	l	r8,P_SIG(r11)		# get sig
	o	r8,r9			# signals pending?
	jeq	after_svc_call_c	# no, skip it
syscall_call_ast:
	get	r7,$_ast
	lis	r6,1
	st	r6,0(r7)		# schedule an ast
	j	after_svc_call_c	# and bounce
fast_syscall_end:	
