/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 ****************************************************************
 * HISTORY
 * $Log:	loutil.s,v $
 * Revision 2.5  89/01/04  13:34:01  rpd
 * 	Fixed load_context to restore the AFPA DMA length register.
 * 	[89/01/04  13:21:36  rpd]
 * 	
 * 	Fixed entry points for save_context and load_context
 * 	to follow normal _/_. conventions.  Added variables
 * 	a_save_context and a_longjmp.
 * 	[89/01/03  16:45:23  rpd]
 * 
 * Revision 2.4  88/11/23  17:20:42  rpd
 * 	Added thread_exit_code check to thread_bootstrap.
 * 	[88/11/14  16:34:32  rpd]
 * 	
 * 	More Acis merge.
 * 	[88/11/13  22:22:01  rpd]
 * 
 * Revision 2.3  88/10/10  15:43:13  sanzi
 * 	Fixed several misuses of the .using statement.  I don't know why
 * 	these bugs haven't caused the system to puke and die hard.  Perhaps 
 * 	we are just lucky.
 * 
 * 25-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Modified save_context and load_context to always save the AFPA
 *	length register.
 *
 * 26-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Modified load_context and save_context to save and restore the 
 *	icscs.
 *
 * 17-Dec-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	In load_context():  don't compare value of old fpa_curreg, since
 *	we are switching contexts and it will soon be meaningless.  
 *
 * 15-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	In load_context(): issue FPA_TSKSWU command even if this thread
 *	was the last user of the FPA.
 *
 *  9-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	MACH_TT: fixed thread_bootstrap routine to not adjust the ksp.
 *	The ksp must now point at r1 on the kernel stack upon calling
 *	the routine.
 *
 * 26-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added code from 4.3 ACIS to remap ROS into kernel text (when
 *	display() is called on a machine with > 8 Mbytes of memory),
 *	however, I don't trust it so I turned it off.
 *
 *  6-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added upcmul() routine, which is used by the profiling code
 *	to generate the upper 32 bits of a 32x32 bit product.  See
 *	the routine addupc() in trap.c for its usage.
 *
 * 29-Jul-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	In save_context():  lock the fpa, even if it is already locked.
 *	If the fpa is currently in program check mode, but we haven't
 *	handled the problem yet (which might be because we got a
 *	simultaneous page fault combined with an fpa fault), then
 *	locking the fpa will cause it to program check again, and then
 *	we can handle it correctly.  This requires that trap allow
 *	the kernel to take data faults when in kernel mode.  (See trap for
 *	the relevant changes.)
 *
 * 28-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Fixed bug in trans_virt_addr which prevented it from correctly
 *	indicating failure.
 *
 *  5-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Eliminated ROMP_FPA and check of PCB_SSWAP.
 *
 * 16-Apr-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added MACH_TT support.  thread_tramp() should probably be
 *	flushed in favor of starting kernel threads the way user 
 *	threads are started.  Flushed all uses of KERNSTACK.
 *	The thread's kernel stack is computed in load_context, saved
 *	in saved_kernel_stk, and restored when interrupts are taken
 *	in user mode. 
 *
 * 30-Mar-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Picked up various routines from acis which replace asm's (such
 *	as wait and tgte).
 *
 * 27-Feb-87  Rich Sanzi (sanzi) at Carnegie-Mellon University
 *	Converted some "eye_catcher()" macros to "eye_profil" to support
 *	kernel profiling of these assembly routines.
 *
 * 14-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_FPA: Modified load_context to correctly set the FPA
 *	register set number.
 *
 * 10-May-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Merged in definition of xadunload from new revision ibm sources.
 *
 *  8-Apr-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Modified save_context and load_context to work with 
 *	thread pointers instead of process pointers.
 *
 * 28-Feb-86  David Golub (dbg) at Carnegie-Mellon University
 *	Added save_context and load_context.
 *****************************************************************
 */

 #  Note that these are NOT the 'spln' routines called by C, these
 #  are the routines that the 'spln' macros invoke (e.g. they have
 #  the UNIX spl numbers mapped into the romp CPU numbers.
 #	  e.g. 'spl0()' --> _spl7()		(WEW)
 #
 #  set interrupt level 0 (highest priority) through level 7 (lowest)
 #    also set interrupt level according to argument
 #    always return previous level
 #
 # when the debugger is present INT_PRI0 is actually 1 (instead of 0)
 # so that the debugger can use level zero interrupt requests to
 # single step the kernel.
 #
        .globl	_.spl0
	.globl	_.spl1
	.globl	_.spl2
	.globl	_.spl3
	.globl	_.spl4
	.globl	_.spl5
	.globl	_.spl6
	.globl	_.spl7
	.globl	_.splx
	.globl	_.splimp
	.globl	_.splnet
	.globl	_.splclock
 	.globl	_.splsoftclock
	.globl	_.splsched
	.globl	_.splbio
	.globl	_.spltty
	.globl	_.splhigh
	.globl	_.splvm
	.globl	_spl0
	.globl	_spl1
	.globl	_spl2
	.globl	_spl3
	.globl	_spl4
	.globl	_spl5
	.globl	_spl6
	.globl	_spl7
	.globl	_splx
	.globl	_splimp
	.globl	_splnet
	.globl	_splclock
	.globl	_splsoftclock
	.globl	_splsched
	.globl	_splbio
	.globl	_spltty
	.globl	_splhigh
	.globl	_splvm

eye_catcher(_spl0): _.spl0:   bx spljoin;   lis r3,7
eye_catcher(_spl1): _.spl1:   bx spljoin;   lis r3,6
eye_catcher(_spl2): _.spl2:   bx spljoin;   lis r3,5
eye_catcher(_splimp):_.splimp:  bx spljoin;   lis r3,2
eye_catcher(_spl3): _.spl3:   bx spljoin;   lis r3,4
eye_catcher(_spl4): _.spl4:   bx spljoin;   lis r3,3
eye_catcher(_spl5): _.spl5:   bx spljoin;   lis r3,2
eye_catcher(_spl6): _.spl6:   bx spljoin;   lis r3,1
eye_catcher(_splnet):_.splnet:  bx spljoin;   lis r3,6
eye_catcher(_spl7): _.spl7:   bx spljoin;   lis r3,INT_PRI0
eye_catcher(_splclock): _.splclock:	bx spljoin;	lis r3,1
eye_catcher(_splhigh): _.splhigh:	bx spljoin;	lis r3,1
eye_catcher(_splsched): _.splsched:	bx spljoin;	lis r3,1
eye_catcher(_spltty): _.spltty:	bx spljoin;	lis r3,2
eye_catcher(_splbio): _.splbio:	bx spljoin;	lis r3,2
eye_catcher(_splsoftclock): _.splsoftclock:	bx spljoin;	lis r3,6
eye_catcher(_splvm): _.splvm:	bx spljoin;	lis r3,2
eye_catcher(_splx):  _.splx:       nilz  r3,r2,7 # get only low 3 bits
 #
 #  common spl routine;  on entry, r3 = new level
 #
spljoin:
          mfs   scr_ics,r2       # get the current status
          ni    r4,r2,-8         # get all but priority in r4
          o     r3,r4            # overlay priority bits
          ni    r2,r2,7          # get only old priority bits
          brx   r15              # return and...
            mts   scr_ics,r3       # set new status

 #
 #  I/O routines:  ior(port);  iow(port,value);
 #
         .globl _ior
	 .globl _iow
	.globl _.ior
	.globl _.iow
eye_profil(ior):
         brx   r15
         ior   r2,0(r2)          # read data from port (NCS->r2 = return)

eye_profil(iow):
         brx   r15
         iow   r3,0(r2)          # write data to port
 #
 #  system reqister access routines
 #
         .globl _mtsr
	.globl _.mtsr
eye_profil(mtsr):
         sli   r2,2              # r2 = parm 1 * 4
         mfs   scr_iar,r5        # set r5 to address of next inst
1:       ais   r5,mts_vector - 1b# set r5 to address of mts_vector
         a     r5,r2             # set r5 to address of mts_vector entry
         balr  r0,r5             # case statement (set r0 for debug)
mts_vector:                      # each entry must be 4 bytes
         brx   r15;   mts r0,r3  # set scr 00 to 2nd parm |***
         brx   r15;   mts r1,r3  # set scr 01 to 2nd parm |***
         brx   r15;   mts r2,r3  # set scr 02 to 2nd parm |***
         brx   r15;   mts r3,r3  # set scr 03 to 2nd parm |***
         brx   r15;   mts r4,r3  # set scr 04 to 2nd parm |***
         brx   r15;   mts r5,r3  # set scr 05 to 2nd parm |***
         brx   r15;   mts r6,r3  # set scr 06 to 2nd parm |***
         brx   r15;   mts r7,r3  # set scr 07 to 2nd parm |***
         brx   r15;   mts r8,r3  # set scr 08 to 2nd parm |***
         brx   r15;   mts r9,r3  # set scr 09 to 2nd parm |***
         brx   r15;   mts r10,r3  # set scr 10 to 2nd parm |***
         brx   r15;   mts r11,r3  # set scr 11 to 2nd parm |***
         brx   r15;   mts r12,r3  # set scr 12 to 2nd parm |***
         brx   r15;   mts r13,r3  # set scr 13 to 2nd parm |***
         brx   r15;   mts r14,r3  # set scr 14 to 2nd parm |***
         brx   r15;   mts r15,r3  # set scr 15 to 2nd parm |***
         .globl _mfsr
         .globl _.mfsr
eye_profil(mfsr):
         sli   r2,2              # r2 = parm 1 * 4
         mfs   scr_iar,r5        # set r5 to address of next inst
1:       ais   r5,mfs_vector - 1b# set r5 to address of mfs_vector
         a     r5,r2             # set r5 to address of mfs_vector entry
         balr  r0,r5             # case statement (set r0 for debug)
mfs_vector:                      # each entry must be 4 bytes
         brx   r15;   mfs r0,r2  # return scr 00 |***
         brx   r15;   mfs r1,r2  # return scr 01 |***
         brx   r15;   mfs r2,r2  # return scr 02 |***
         brx   r15;   mfs r3,r2  # return scr 03 |***
         brx   r15;   mfs r4,r2  # return scr 04 |***
         brx   r15;   mfs r5,r2  # return scr 05 |***
         brx   r15;   mfs r6,r2  # return scr 06 |***
         brx   r15;   mfs r7,r2  # return scr 07 |***
         brx   r15;   mfs r8,r2  # return scr 08 |***
         brx   r15;   mfs r9,r2  # return scr 09 |***
         brx   r15;   mfs r10,r2  # return scr 10 |***
         brx   r15;   mfs r11,r2  # return scr 11 |***
         brx   r15;   mfs r12,r2  # return scr 12 |***
         brx   r15;   mfs r13,r2  # return scr 13 |***
         brx   r15;   mfs r14,r2  # return scr 14 |***
         brx   r15;   mfs r15,r2  # return scr 15 |***

 #  prepare for a core dump by saving the registers (including stack
 #  pointer) and also the important MM registers
 #  as a favour to the user we will cause the TRAR to point to the
 #  real address of the u area

	.globl _dumpregs
	.set _dumpregs,real0 + 0x400
	.globl _dumpmmregs
	.set _dumpmmregs,real0 + 0x400 + 64
	.globl _scb
	.set _scb,_dumpregs+8	# just so adb user can find our stack
	.globl _dumpsave	
eye_profil(dumpsave):

         mfs   scr_iar,r5       # use r5 as base register
1: 	 .using 1b,r5           # tell assembler
	stm	r0,_dumpregs	# save the registers
	get	r2,$0x19	# count of MM segment registers SEG0...RAS MODE
	get	r3,$RTA_SEGREG0	# point to seg reg 0
 #	cau	r3,(RTA_SEGREG0)>>16(r0) # point to seg reg 0
 #	oil	r3,r3,(RTA_SEGREG0)&0xffff
#if	MACH
	/*
	 *	Fetch address of utask
	 *
	 *	active_threads[0]->task->u_address 
	 */
	l 	r4,a_active_threads	#
	l	r4,0(r4)		# XXX fails on multiprocessors
	l	r4,THREAD_TASK(r4)	# get thread->task
	l	r4,UTASK(r4)		# get task->utask
#else	MACH 
	get	r4,$USTRUCT	# get address of U area
#endif	MACH	
	iow	r4,ROSE_CRA(r3) # do the translate
	cal	r4,_dumpmmregs
 # loop thru storing the important MMU registers into lowcore
1:
	ior	r0,0(r3)	# get the registers
	put	r0,0(r4)	# store it
	ais	r4,4		# step pointer
	sis	r2,1
	ais	r3,1
	cis	r2,0
	jne	1b
	br	r15		# just return 


 #
 # int	save_context()
 #
 #	Saves the current process context, masks interrupts off,
 #	and returns 0.  Sets up the saved context so that resuming
 #	the process returns 1.
 #
 #	Use is:
 #
 # swtch()
 # {
 #	if (save_context()) return;
 #	...
 #	load_context(newproc);
 # }

	.globl	_.save_context
	.globl	_save_context

_save_context:
	.long	_.save_context

	.globl	_a_save_context
_a_save_context:
	.long	_.save_context

eye_catcher(_.save_context):

	 bali  r4,save_ctx_base
save_ctx_base:
	 .using save_ctx_base,r4
         setsb scr_ics,INTMASK-16      # no interrupts, please
 # get the current pcb into r5	 
	 l     r5,a_active_threads
	 l     r5,0(r5)			# XXX - Fails on multiprocessors
	 l     r5,THREAD_PCB(r5)
 #  save current state in the current pcb

#define	AFPA_LENGTH_UPPER	0xfe1e7c03
#define	AFPA_LENGTH_LOWER	0x7c03
 
/*
 * Note: FPA processing is done before any important status is saved
 * in PCB in case we cause an FPA interrupt here.
 *
 *	Here, we check to see if we have any FPA hardware.
 *	If we do, we lock it here in the old context.  This may cause
 *	a fault, if the FPA is in a program check state.  If so,
 *	fpa_pci() will handle it appropriately.  
 */

	l	r3,_float_hardware	# get float hardware value
	ni	r0,r3,FLOAT_AFPA_DMA	# is it an AFPA with DMA?
	jeq	no_afpa_dma
	cau	r2,AFPA_LENGTH_UPPER/UPPER(r0)	# get top 16 bits of address
	l	r0,AFPA_LENGTH_LOWER(r2)	# read the length register
	st	r0,PCB_AFPALEN(r5)	# store it
	get	r2,$FPA_LOCKFP		# get lock command
	sts	r2,0(r2)		# try to lock fpa (could cause fault)
	j	fpaAbsent		# skip FPA checks
no_afpa_dma:	
	ni	r0,r3,FLOAT_AFPA 	# do we have any afpa hardware ?
	jz	no_afpa			# try for fpa hardware
	j	fpaLocked		# just lock afpa (don't store status)
no_afpa:
	ni	r0,r3,FLOAT_FPA 	# do we have any float hardware ?
	jz	fpaAbsent		# no hardware, so skip it.
	l	r3,_fpa_curreg		# get current register set
	ni	r0,r3,FPA_LOCK		# was locked?	
	jnz	fpaLocked		# yes, don't store status to RAM
	get	r2,$FPA_RDSTR		# otherwise read status 
	.globl	_resume_rdstr
_resume_rdstr:				# location of read status command 
	get	r2,0(r2)		# into r2
#if	ROMP_APC
	c	r2,r2			# force sync here
#endif	ROMP_APC
	j	fpaAbsent		# skip the following lock
fpaLocked:
	get	r2,$FPA_LOCKFP		# get lock command
	sts	r2,0(r2)		# try to lock fpa (could cause fault)
fpaAbsent:
         sts   sp,PCB_USP(r5)          # save sp
         stm   r6,PCB_R6(r5)           # save registers
 #save CCR in PCB
	 get   r2,$CCR			# point to CCR in IO space
	 l     r2,0(r2)			# get its value
	 st	r2,PCB_CCR(r5)		# save CCR in pcb 
 # save ICSCS in PCB
 	 mfs	scr_ics,r2		# get ics_cs into R2
	 sth	r2,PCB_ICSCS(r5)	# stuff it into pcb.
 # return 0
	 brx	r15
	  lis	  r2,0

1:	.using	1b		# no base register anymore

 #	NOTE: longjmp and setjmp are jammed between save_context and
 #	      load_context to that they are reachable by (small-displacement)
 #	      jump instructions form those routines.
 #
 #  longjmp(buf) - restore saved context and return (to caller of setjmp)
 #      label_t buf;
 #
	.globl	_.longjmp
	.globl	_longjmp

	.globl	_a_longjmp
_a_longjmp:
	.long	_.longjmp

eye_profil(longjmp):

         lm    r1,0(r2)                # restore registers
	 ls    r0,4*15(r2)	       # restore ics
	 mts   scr_ics,r0
         brx   r15                     # return, after...
         lis   r2,1                    # return value 1
 #
 #  setjmp(buf) - save context for later
 #
	.globl	_savectx
         .globl _setjmp
eye_profil(setjmp):
_savectx:
	.globl _.savectx
	.globl _.setjmp
_.savectx:
         stm   r1,0(r2)                # save registers
	 mfs   scr_ics,r0	       # save ics
	 sts   r0,4*15(r2)
         brx   r15                     # return, after...
         lis   r2,0                    # return value == 0



 #
 #	load_context(p)
 #	struct thread *p;
 #
 #	Loads context for a new process.  Assumes that the process
 #	saved its state with save_context, and makes that save_context
 #	call return 1.   Sets the correct FPA register set or locks the
 #	current one if none is assigned to the new process.
 #

	.globl	_.load_context
	.globl	_load_context

_load_context:
	.long	_.load_context

eye_catcher(_.load_context):

 # find the address of the sidtab of the pmap for this thread
	 l     r3,THREAD_TASK(r2)	# r3 = th->task (pointer to task)
	 l     r3,TASK_MAP(r3)		# r3 = th->task->map (pointer to map)
	 l     r3,MAP_PMAP(r3)		# r3 = th->task->map->pmap
	 ais   r3,PMAP_SIDTAB		# r3 = &(th->task->map->pmap->sidtab)
 # now (properly) restore the segment registers from this pmap.
	 s     r4,r4
	 get   r13,$(RTA_SEGREG0)
load_segregs:
	 lh    r5,0(r3)			# r5 = sid from sidtab for ser(r4)
	 sli   r5,2			# shift 2 bits for seg reg format
	 oiu   r5,r5,(RTA_SEG_PRESENT)>>16
	 cas   r14,r4,r13		# r14 = &(ser(r4))
	 iow   r5,0(r14)		# write it
	 ais   r4,1
	 ais   r3,2			# assumption: sid's are of length 2
	 cli   r4,NUSR_SEGS
	 bl   load_segregs
	 iow   r5,(RTA_INV_TLB - RTA_SEGREG0)(r13) #invalidate entire TLB
 # we have now switched completely to the new process' memory (and stack)
 #  now running as new process - restore registers
 #  restore other registers
#if	MACH
	mfs	scr_iar,r14
1:	.using	1b,r14			# need a base for below
	l	r5,THREAD_KSP(r2)	# get base of kernel stack
	ai	r5,r5,$(KERNEL_STACK_SIZE) # move pointer to top
	st	r5,saved_kernel_stk	# save for locore to load on ints
1:	.using	1b			# no base
#endif 	MACH
	 l     r5,THREAD_PCB(r2)
         ls    sp,PCB_USP(r5)          # restore sp

#if	ROMP_APC
 #
 #   If the current thread owns the 68881, then
 #   allow accesses to the hardware; otherwise, disable
 #   accesses to the hardware.
 #
 #   We use
 #	r0, r13, r14
 #
 #   We assume
 #	r2 - is the new thread
 #
 #   We preserve the value of
 #	r2, r3
 #
	mfs	scr_iar,r14
1:	.using	1b,r14
	l	r0,_mc881_thread
	/* On an SGP board, 68881 doesn't exist */
	ci	r0,-1			# does it exist?
	be	1f			# no, skip code
	.using	1b			# no base
	get	r14,$(IOIM2)	# get IOIM2 base address
	get	r13,$(IOIM2_PROB_DISABLE)	# assume "lock"
	c	r0,r2			# is this the owner?
	jne	0f			# yes, go open it up
	get	r13,$(IOIM2_PROB_ENABLE)	# enable problem state access
0:
	iow	r13,IOIM_SUB_PROB(r14)	# do the lock or unlock
	# done with 68881 processing
1:
#endif	ROMP_APC

TestFloat:
	mfs	scr_iar,r14
1:	.using	1b,r14
	l	r13,_float_hardware	# get float hardware value
	ni	r0,r13,FLOAT_FPA+FLOAT_AFPA # do we have any float hardware ?
	jz	fpaAbsent2		# no hardware, so skip it.
	.using	1b
	
 # either switch to fpa register set or lock the fpa
 # r2 points to our thread structure on entry
 #
 # Always issue TSKSWU command, even if this thread last used
 # the FPA.
 #
	l	r14,THREAD_PCB(r2)	# r14 = address of pcb
	l	r12,PCB_FPAREGS(r14)	# get floating point reg set.
	get	r2,$_fpa_curreg
	st	r12,0(r2)		# store new reg @ 0(r2) (_fpa_curreg)
	ni	r0,r12,FPA_LOCK		# should lock it?
	jnz	1f			# yes, lock fpa
	get	r2,$FPA_TSKSWU		# otherwise get task switch command
	sts	r12,0(r2)		# do fpa task switch
	ni	r0,r13,FLOAT_AFPA_DMA	# is it an AFPA with DMA?
	jeq	0f
	l	r11,PCB_AFPALEN(r14)	# get length register
	store	r11,AFPA_LENGTH_UPPER,r12 # and set it (clobbers r12)
	j	0f
 # issue fpa lock command
1:
	get	r2,$FPA_LOCKFP
	sts	r2,0(r2)		# and lock it
0:
fpaAbsent2:
 # set CCR from pcb
	l	r7,PCB_CCR(r5)		# pick up ccr value
	get	r6,$CCR			# point to CCR
	stcs	r7,0(r6)		# put into CCR
 # set CCR end
 # note that save_context saved the icscs with the interrupt mask ON.
 	lh	r2,PCB_ICSCS(r5)	# get saved ics (just ics!) 
	mfs	scr_ics,r3		# get current ics
	nilz	r2,r2,0x7		# get level bits for new ipl
	nilo	r3,r3,0xfff8		# get all but level bits in old ics
	o	r2,r3			# mash pieces together
	mts	scr_ics,r2		# set new icscs with old ipl
 # restore the registers	 
	lm    r6,PCB_R6(r5)	  # restore registers
 # get ICSCS from pcb
	clrsb scr_ics,INTMASK-16      # now interrupts are safe ???
	brx	r15		  # return 
	lis   r2,1		      # return 1 -- normal return

	.align	2
	.globl _xadunload
 xadunload_ps:
	.long	xadunload-real0
	.short NOTRANS_ICS+INT_PRI1,0	# new ics: xlate off, PRIO 1

 xadunload_ps2:
	.long	xadunload2
	.short	0-0,0		# will be replaced by actual ics upon call


eye_profil(xadunload):
|-----------------| xadunload |-------------------|
	stm	%.LOWREG103,(.LOWREGVAR103-16)*4(sp)	# save registers 
	ai	sp,sp,(.LOWREGVAR103-16)*4		# room for r14...r15
 cas r0,r4,r0 | bfcode
 # go to non-translated mode
	mfs scr_iar,r15
1:	.using	1b,r15
	mfs	scr_ics,r14		# get current ics_cs
	lps	0,xadunload_ps		# turn off translate

	.using	real0,r0
xadunload:
 # following only works because translate & storage protect is off
	sth	r14,xadunload_ps2+old_ics_cs	# for later

	cis r5,0 | 85
	be L105 | EQ	(write)

	cis r2,0 | 85
	be L107 | NE	(no buffer)

 # read: transfer adapter to buffer
 # this code was written by Frank Bartucca, IBM Milford
	cis	r0,0		# compare hdcnt to 0
	ble	L118		# already done
	sis	r0,4
	bx	1f		# branch to read routine
2:	ls	r4,0(r3)	# pick up value 
	sis	r0,4		# decrement hdcnt by 4
	inc	r2,8		# increment buffaddr by 8
	st	r5,-4(r2)	# store r5 at buffaddr-4
1:	ble	3f		# if hdnct < 0 clean up 
	ls	r5,0(r3) 	# start next adapter read
	sis	r0,4		# decrement hdcnt by 4
	ble	0f		# if hdcnt <= 0 clean up 
	bx	2b		# else keep going
0:	sts	r4,0(r2)	# store r4 at buffaddr
	bx	L118		#branch to return code
	sts	r5,4(r2)	# store r5 at buffaddr
3:	bx	L118		# else keep going
	sts	r4,0(r2)	# store r4 at buffaddr

 # read: just reference the buffer to unload it and throw away the results
L107:
0:	si r0,r0,4 | 190
	bl L118 | LT
	bx 0b | branch
	ls r2,0(r3) | 94

 # come here to fill out a record with zero's
L117:
	get r15,$0 | 92
0:
	si r0,r0,4 | 190
	bl L118 | LT
	bx 0b | branch
	sts r15,0(r3) | 80

 # come here to fill adapter buffer for write
L105:
	cis r2,0 | 85
	be L117 | NE
#ifndef notdef
	cis	r0,0		# compare hdcnt to 0 
	jle	L118		# jump to return code if hdcnt <= 0 
	sis	r0,4		# decrement hdcnt by 4 
	blex	0f		# clean up if hdcnt <= 0 
	ls	r4,0(r2)	# load r4 from buffaddr 
2:	ls	r5,4(r2)	# load r5 from buffaddr 
	sts	r4,0(r3)	# write r4 to adapter 
	sis	r0,4		# decrement hdcnt by 4 
	jle	1f		# clean up if hdcnt <= 0 
	inc	r2,8		# increment buffaddr by 8 
	ls	r4,0(r2)	# load r4 from buffaddr 
	sts	r5,0(r3)	# write r5 to adapter 
	sis	r0,4		# decrement hdcnt by 4 
	jh	2b		# if hdcnt > 0 keep going 
0:	bx	L118		# jump to return code 
	sts	r4,0(r3)	# write r4 to adapter 
1:	bx	L118		# branch to return code 
	sts	r5,0(r3)	# write r5 to adapter 
#else	/* old write code */
 # write case
	sis	r0,4	# compare hdcnt to 4
	ble	1f	# either 0 or 4 to do
0:	ls	r4,0(r2)	# get from buffer
	ls	r5,4(r2)	# start another read
	inc	r2,8		# increment pointer
	sis	r0,8		# decrement count
	sts	r4,0(r3)	# store into adapter
	bhx	0b		# branch and complete 
	sts	r5,0(r3)	# storing of second word
 # we have less than 8 to go
1:	bl	L118	# all done
	ls	r4,0(r2)	# can only be 1 word left to do
	bx	L118
	sts	r4,0(r3)	# complete last store
#endif

L118:
 lps	0,xadunload_ps2
xadunload2:
	lm	%.LOWREG103,0(sp)
	brx	r15
	ai	sp,sp,(16-.LOWREGVAR103)*4
.set .LOWREGVAR103, 14 | not optimized
.set .LOWREG103, r14
.set L103, (12 - .LOWREGVAR103) * 4
.set .R103, .LOWREG103
.set .V103, 0 | eobl2


 #
 #	display(nn) displays two hex digits in the front panel display
 #
	.globl	_display
eye_profil(display):
	mfs	scr_ics,r0
	mfs	scr_iar,r3
1: 	.using	1b,r3
	lps	0,display_ps
 # now running non-translated
	.using	real0,r0		# locore addressing
display_go:
	sth	r0,display_ps2+old_ics_cs
	bali	r5,display		# call routine
	lps	0,display_ps2
display_go2:
	br	r15			# and return to caller
 # display routine available to kernel in non-translate mode
 # r2 contains the value to display
display:
	cau	r3,ROS_ADDR/UPPER(r0)
	ls	r3,4(r3)		# get the ROS EP table
 # we could call ROS but since we've referenced it that is enough
	cau     r3,(LED_ADDR)>>16(r0)	# get the address base for LED's
	oil     r3,r3,(LED_ADDR)&0xffff
	mc33	r3,r2			# get the complete address
	ior	r0,0(r3)		# read from it
	iow	r0,0(r3)		# write it (lock it)
	br	r5			# and return to caller
#ifdef	notdef
 # ROS is not in address space:
 # Since we must map ROS out again anyway, we map ROS not at
 # 8 Meg, but just below us were we're safe from dma (We're in
 # big trouble if someone is trying to dma to kernel text!!).
 # NOTE: This method is making some very sweepping assumptions
 # about the nature of the kernel:
 #	1) we're in locore, so at least 128K of kernel text
 # follow us (we are almost certainly in the first 64K of memory,
 # but it's easy to find the first 64K chunk after us, so we do).
 #	2) we cannot be interrupted! (we don't want to find
 # ourselves in random ROS as oppose to trap or loslih, especially
 # since half the ROS is 286 code!).
 #	3) we will not program check/machine check here!! (see above).
 #
0:
#define ROS_PAGE	(((1f-real0)/UPPER)+1)
#define ROS_SPEC_2	(((ROS_PAGE) << 4) + 0x0001)
#define ROS_ADDR_2	(ROS_PAGE)
	get	r0,$(ROS_SPEC_2) # get first 64K junk after us an validate it.
	iow	r0,MMU_ROS(r3)		# and store it
	cau	r3,ROS_ADDR_2(r0)
	ls	r3,4(r3)		# get the ROS EP table
	get	r3,$(MMUBASE)		# get base address of MMU
	lis	r0,0
	iow	r0,MMU_ROS(r3)		# Map out ros so we can use kernel text again
	j	1b
      TTNOFRM
#endif	notdef
1:	.using	1b

eye_profil(trans_virt_addr):
	get	r3,$(ROSEBASE)	# r3 = rosetta io base (io addr space)
	iow	r2,0x83(r3)	# write va into rosetta LRA reg
	ior	r2,0x13(r3)	# read rosetta TRAR
	mttbiu	r2,31-31	# high bit set ==> no mapping
	jntb	0f		# branch if there is a mapping
	get	r2,$-1
0:	br	r15		# return--r2 is return value


 # set bit 22 in scr 12 (ie set the bit in the IRB
eye_profil(setsoftint):
	brx	r15
	setsb	r12, 22-16

eye_profil(asmwait):
	wait
	br	r15

eye_profil(asmtgte):
	tgte	r1, r1
	br	r15

eye_profil(setint0):
	brx	r15
	setsb 	r12, 16-16

#if	MACH
 #
 #	thread_bootstrap
 #	
 #	trampoline code for launching threads:
 #
 #	Must move PCB_IAR for the current thread into r15,
 #	and must move PCB_R0 into r0, then balr r15 to the entry
 #	point for the kernel process.
 #
 #
	.data
panic_str:
 	.ascii "kernel thread exited! \0"
	.text
	
	.globl	_thread_tramp 
eye_catcher(_thread_tramp):
	bali	r5,thread_tramp_base
thread_tramp_base:
	.using thread_tramp_base,r5
	
	l	r2,a_active_threads	#Get the thread 
	l	r2,0(r2)		
	l	r2,THREAD_PCB(r2)	#Get thread->pcb
	l	r0,PCB_R0(r2)		# Get Data area pointer
	l	r15,PCB_IAR(r2)		# Get entry point for routine
	balr	r15,r15			# jump to the kernel thread.

 /*
  *	Since kernel threads are not supposed to exit...
  */
  	get	r2,$panic_str		
	get	r0,$_panic
	bali	r15,_.panic
	
/*
 *	Rather than just jump into the middle of fault, 	
 *	this code does exactly the same thing.
 */
 	.align	2
#define	TT_DEBUG 	1
#if	TT_DEBUG 
 	.globl	_boots_cnt
_boots_cnt:	
boots_cnt:	.long	0
#endif	TT_DEBUG
	
eye_profil(thread_bootstrap):
	mfs	scr_iar,r6
1:	.using	1b,r6	
#if	TT_DEBUG
	l	r14,boots_cnt	# get count
	ai	r14,r14,1	# increment it
	st	r14,boots_cnt	# store count
#endif	TT_DEBUG	
	l	r11,a_active_threads	# get thread
	l	r11,0(r11)		#
	l	r11,THREAD_EXIT_CODE(r11) # abnormal exit ?
	get	r10,$THREAD_EXIT	# check against exit code
	c	r10,r11
	jeq	2f
	get	r10,$_ast
	lis	r11,1
	st	r11,0(r10)		# schedule an ast
2:      setsb scr_ics,INTMASK-16# disable interrupts
        l     r14,FAULT_IAR(sp) # get old_iar (MAY BE CHANGED)
        l     r15,FAULT_ICS_CS(sp)  # get old_ics_cs (MAY BE CHANGED)
        stm   r14,low_ps        # save in low core
        l     r15,FAULT_MQ(sp)  # get old multiplier/quotient (UNCHANGED)
        mts   scr_mq,r15        # restore multiplier/quotient
        ls    r15,FAULT_R1(sp)  # get old r1 value (UNCHANGED)
        st    r15,low_save1     # save in low core for go
        l     r15,FAULT_R15(sp) # get old r15 value (UNCHANGED)
        st    r15,low_save15    # save in low core for go
        l     r0,FAULT_R0(sp)   # restore 0 (UNCHANGED)
#if	ROMP_APC
	/* no need to check for exception packets */
#endif	ROMP_APC
        lm    r2,FAULT_R2(sp)   # restore 2 through 15 (UNCHANGED)
        mfs   scr_iar,r15       # get addressability again
1:	.using 1b,r15           # tell assembler
        lps   0,go_ps           # jump to go with interrupts off
1:       .using 1b               # tell assembler no base register
#endif	MACH

 #
 # upcmul(n,scale)
 # multiply n * scale and drop bottom 16 bits
 #
 # on entry r2 = n, r3 = scale
 #
 # normally 0x8000 <= r3 <= 0
 # and  MAXTEXT <= r2 < 0.
 # where MAXTEXT is <= 24,000,000 on most systems
 #
eye_profil(upcmul):

 
        mts     scr_mq,r3                  #copy x into multiplier quotient
 
        #multiply the mq by r2 and put the answer in r0
 
        s       r0,r0                   #zero answer and set carry on
 
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply
        m       r0,r2                   #incremental multiply

	jc0	0f		
	a	r0,r2			#add r2 in again if r3 >= 2^31	
0:
 
	mfs	scr_mq,r3		# low order result
	sri16	r3,16-16		# get top 16 bits of low order
	sli16	r0,16-16		# get bottom 16 bits of high order

	brx	r15			# return
	 cas	r2,r0,r3		# get result

