/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 **********************************************************************
 * HISTORY
 * $Log:	machdep.c,v $
 * Revision 2.10  88/12/20  13:39:57  rpd
 * 	Added ROMP_SC_RTFL hack from Acis.  Pick up a few other
 * 	mysterious changes to sendsig/sigcleanup from Acis.
 * 	[88/12/07  17:10:06  rpd]
 * 
 * Revision 2.9  88/12/19  02:37:00  mwyoung
 * 	Remove lint.
 * 	[88/12/17            mwyoung]
 * 	
 * 	Move memory hole handling to <machine/pmap.c>.
 * 	[88/12/12            mwyoung]
 * 
 * Revision 2.8  88/11/23  16:24:21  rpd
 * 	Added missing 135 support to sigcleanup.
 * 	[88/11/23  10:27:52  rpd]
 * 	
 * 	Changed includes to the new style.
 * 	Picked up 135 support, delay_preadjust(), and
 * 	delay_adjust() from Acis.
 * 	[88/11/04  17:11:52  rpd]
 * 
 * Revision 2.7  88/09/27  17:30:08  rvb
 * 	Fixed Log
 * 
 * Revision 2.6  88/09/27  16:06:20  rvb
 * 	valloc arptab
 * 	[88/09/27  15:44:16  rvb]
 * 
 * Revision 2.5  88/08/24  01:41:49  mwyoung
 * 	Corrected include file references.
 * 	[88/08/22            mwyoung]
 * 
 * Revision 2.4  88/07/20  16:16:56  rpd
 * Fixed calls to pmap_pr_phys.
 * 
 * 25-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Changed sendsig() to write out all registers in the user's saved
 *	state.  
 *
 * 13-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Removed use of freemem.
 *
 * 26-Dec-87  David Golub (dbg) at Carnegie-Mellon University
 *	Changed MACH_NOFLOAT conditional to MACH.
 *
 * 21-Oct-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Applied CMUCS changes from the vax to correct rollover bug
 *	in microtime().
 *
 * 31-Aug-87  David Golub (dbg) at Carnegie-Mellon University
 *	Changed include file conventions.
 *	Removed: arg_zone swapmap swbuf set_cpu_number bbssi bbcci
 *		user_pt_map MACH_TIME
 *	Removed code in setregs() to close files and reset signals
 *	(in execve() for BSD 4.3).
 *
 * 26-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	In boot(), don't call update() if updlock is not clear.
 *
 * 30-Jul-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Corrected parameter to float_exit() in setregs -- was called with
 *	u.u_procp, and now is called with current_thread().
 *
 * 25-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added get_post routine from ACIS.
 *
 * 24-Jul-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added calls to pmap_pr_phys() to protect Xbuffer and
 *	AED bitmap such that the user can write them.
 *
 *  4-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_APC: APC support from ACIS.
 *
 * 26-Jun-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Made QUOTA a #if-type option.
 *
 * 24-Jun-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed calls to useracc to have a correct "protection"
 *	parameter (B_WRITE instead of "1").
 *
 * 21-May-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	MACH_TT : moved sigcode to the bottom of the USRSTACK.
 *
 * 23-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	hc: turned off optimization.
 *
 *  6-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Reorganized set_consdev/set_ccr to handle MACH_TT more
 *	gracefully.
 *
 * 07-Apr-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	MACH_TT changes to uses of u.u_pcb.
 *
 * 30-Mar-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Dropped in new "Debugger" routine from acis, changed asm's to
 *	calls to locore, made "light-blanker" in reboot use a constant.
 *
 * 25-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	NOFLOAT support for showing load in DDS.
 *
 * 23-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Flushed MACH_ACC.
 *
 * 23-Feb-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Removed cpu_number, since it's now a macro.  Fixed show_load to
 *	only display the load average every 5 seconds, since that's how
 *	often it is computed.
 *
 * 22-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Support for MACH_NOFLOAT.
 *
 *  2-Feb-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added support for KDB.
 *
 * 19-Jan-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Added include of new "confdep.h" file.
 *	[ V5.1(F1) ]
 *
 * 28-Jan-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Reduce the size of the buffer cache to 5% of physical memory.
 *
 * 13-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Fixed support for holey memory to decrement vm_page_free_count
 *	appropriately (VERY important for pageout to function) and also
 *	made IObuf allocation, setting of physmem and freemem and the
 *	memory size printf take the hole into account.
 *
 * 23-Dec-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added code to map in AED bitmap and X magic buffer.  Moved
 *	INIT_INTR() to romp_init.c.
 *
 * 16-Aug-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added microtimer routine.
 *
 * 11-Jun-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Wrote halt_cpu() routine.
 *
 * 27-Mar-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	MACH_VM: Merged in VM changes.
 *
 * 28-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added definitions of bb{ss,cc}i.
 *
 * 25-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Renamed mdsetregs to be setregs and added process entry point as
 *	a paramerer, since u_exdata.ux_entloc is no more.  This
 *	corresponds to 4.3.
 *
 * 25-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed sigmask in sendsig to me sigmsk to avoid collision with
 *	CMU macro.
 *
 **********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <confdep.h>

#include <cmucs.h>
#include <cmucs_kdb.h>
#include <cmucs_rfs.h>
#include <quota.h>
#include <romp_135.h>
#include <romp_apc.h>
#include <romp_debug.h>
#include <romp_dualcall.h>
#include <romp_nfl.h>
#include <romp_show_load.h>
#include <romp_rdb.h>
#include <romp_sc_rtfl.h>
#include <mach.h>
 
#include <cpus.h>

#ifdef	hc
pragma	off (optimize);
#endif	hc

/*     machdep.c       6.2     83/10/02        */

#if	ROMP_APC
#include <ca/cpu.h>
#include <ca/sigframe.h>
#endif	ROMP_APC
#include <ca/reg.h>
#include <ca/rosetta.h>
#include <ca/scr.h>
#include <ca/debug.h>
#include <ca/led.h>
/*
 * Support for X console emulator Event Q pseudo-device
 */
#include <cacons/xio.h>
/*
 * Support for AED simulated bitmap hack
 */
#include <aed.h>
#include <cacons/apaaed.h>
#if	ROMP_DUALCALL
#include <ca/frame.h>
#endif	ROMP_DUALCALL
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/kernel.h>
#include <sys/map.h>
#include <sys/vm.h>
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/reboot.h>
#include <sys/conf.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/clist.h>
#include <sys/callout.h>
#include <sys/mbuf.h>
#include <sys/msgbuf.h>
#include <sys/quota.h>
#include <ca/rpb.h>
#include <ca/io.h>
#include <sys/acct.h>
#if	CMUCS_RFS
#include <sys/rfs.h>
#endif	CMUCS_RFS

#include <sys/lock.h>
#include <sys/thread.h>	/* for the definition of current_thread() */

#include <vm/vm_kern.h>
#include <vm/vm_page.h>
#include <vm/vm_param.h>
#include <sys/zalloc.h>
#include <ca/post.h>
#if	ROMP_NFL
#include <ca/fp.h>
#endif	ROMP_NFL
struct zone	*arg_zone;
extern char	*shutl, *eshutl;

#if	CMUCS
#include <netinet/in.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#endif	CMUCS
#if	ROMP_NFL
#include <ca/fp.h>
#endif	ROMP_NFL

/*
 * Declare these as initialized data so we can patch them.
 */
int    nbuf = 0;

int    bufpages = 0;
char	ccr_default = { CCR_DEFAULT };		/* see ca/scr.h for bit definitions */

vm_map_t	buffer_map;

/*
 * Machine-dependent startup code
 * an important thing to remember is that 'physmem' is the count of the actual
 * physical memory; 'endmem' is the size that includes all of memory and
 * 'holelength' is the size of the hole in memory (if there is one).
 * maxmem is the page address of the actual effective end of memory.
 */
startup(firstaddr)
	caddr_t	firstaddr;
{
	register unsigned i;
	register caddr_t v;
	int base, residual;
	int vpage;
	extern char start, etext, edata, end;
	extern bufbase, buflimit;
	vm_size_t	size;
	kern_return_t	ret;
	vm_offset_t	trash_offset;

	delay_preadjust();		/* preadjust the delay counts */

	/* XXX - need to handle message buffer */

	/*
	 * Initialize the console port
	 */

#define	mem_wo_hole	(mem_size - (holeEnd - holestart))
	/*
	 *	The following constants are set to keep a bunch
	 *	of Unix code happy, all uses of these should eventually
	 *	be fixed.
	 */
	physmem = atop(mem_wo_hole);			/* XXX */
#if	MACH
#else	MACH
	freemem = atop(mem_wo_hole);			/* XXX */
#endif	MACH

	/*
	 * Allocate space for the event pseudo-device.  We just grab some
	 * pages from the free list and don't bother to do locking since we
	 * haven't started any slaves yet.
	 */
	vpage = MagicXBuffAddr;
	size = round_page(XBASIZE);
	vm_map_find(kernel_map,vm_object_allocate(size),0,&vpage,size,FALSE);
	vm_map_pageable(kernel_map,vpage,vpage+size,FALSE);
	/*
	 *	Protect the buffer so its world writeable, uggh.
	 *	see rosetta.h
	 */
	pmap_pr_phys(kernel_pmap, vpage, vpage+size,
		     RTA_KEY_UW << RTA_KEY_SHIFT);/*XXX*/
#if	NAED > 0
	/*
	 * Allocate space for the bitmap for the simulated
	 * bitmapped AED display.  The +2048 is due to the fact that
	 * the aed handling code puts the control registers after the
	 * bitmap (and doesn't define a proper size constant).
	 */
	vpage = AED_BM_ADDR;	/* Again, an address, NOT a page! */
	size = round_page(AED_BM_SIZE + 2048);
	vm_map_find(kernel_map,vm_object_allocate(size),0,
			&vpage,size,FALSE);
	vm_map_pageable(kernel_map,vpage,vpage+size,FALSE);
	/*
	 * 	Also protect this AED buffer.
	 *	see rosetta.h
	 */
	pmap_pr_phys(kernel_pmap, vpage, vpage+size,
		     RTA_KEY_UW << RTA_KEY_SHIFT);/*XXX*/
#endif	NAED > 0

	/*
	 * Good {morning,afternoon,evening,night}.
	 */
	printf("%s", version);

#define MEG	(1024*1024)
	printf("physical memory = %d.%d%d megabytes.\n", mem_wo_hole/MEG,
		((mem_wo_hole%MEG)*10)/MEG,
		((mem_wo_hole%(MEG/10))*100)/MEG);
	/*
	 *	It is possible that someone has allocated some stuff
	 *	before here, (like vcons_init allocates the unibus map),
	 *	so, we look for enough space to put the dynamic data
	 *	structures, then free it with the assumption that we
	 *	can just get it back later (at the same address).
	 */
	firstaddr = (caddr_t) round_page(firstaddr);
	/*
	 *	Between the following find, and the next one below
	 *	we can't cause any other memory to be allocated.  Since
	 *	below is the first place we really need an object, it
	 *	will cause the object zone to be expanded, and will
	 *	use our memory!  Therefore we allocate a dummy object
	 *	here.  This is all a hack of course.
	 */
	ret = vm_map_find(kernel_map, vm_object_allocate(0), (vm_offset_t) 0,
				&firstaddr,8*1024*1024, TRUE);
					/* size big enough for worst case */
	if (ret != KERN_SUCCESS) {
		printf("startup: no space for dynamic structures.\n");
		panic("startup");
	}
	vm_map_remove(kernel_map, firstaddr, firstaddr + 8*1024*1024);
	v = firstaddr;
#define	valloc(name, type, num) \
	(name) = (type *)(v); (v) = (caddr_t)((name)+(num));\
	if (show_space) \
		printf("name = %d(0x%x) bytes @%x, %d cells @ %d bytes\n",\
		 num*sizeof(type), num*sizeof(type), name, num, sizeof (type))
#define	valloclim(name, type, num, lim) \
	(name) = (type *)(v); (v) = (caddr_t)((lim) = ((name)+(num)));\
	if (show_space) \
		printf("name = %d(0x%x) bytes @%x, %d cells @ %d bytes\n",\
		 num*sizeof(type), num*sizeof(type), name, num, sizeof (type))
#define vround() (v = (caddr_t) ( ( ((int) v) + (NBPG-1)) & ~(NBPG-1)))
#define vquadround() (v = (caddr_t) ( ( ((int) v) + (8-1)) & ~(8-1)))

#if	CMUCS_RFS
	valloc(rfsProcessTable, struct rfsProcessEntry, nproc);
#endif	CMUCS_RFS

	valloclim(inode, struct inode, ninode, inodeNINODE);
	valloclim(file, struct file, nfile, fileNFILE);
	valloclim(proc, struct proc, nproc, procNPROC);
	valloc(cfree, struct cblock, nclist);
	valloc(callout, struct callout, ncallout);
	valloc(namecache, struct namecache, nchsize);
#if	QUOTA
	valloclim(quota, struct quota, nquota, quotaNQUOTA);
	valloclim(dquot, struct dquot, ndquot, dquotNDQUOT);
#endif	QUOTA
#if	CMUCS
	{
	extern struct arptab *arptab;
	extern int arptab_size, arptab_bsiz, arptab_nb;
		arptab_size = arptab_bsiz * arptab_nb;
		valloc(arptab, struct arptab, arptab_size);
	}
#endif	CMUCS

	/*
	 * Determine how many buffers to allocate.
	 * Use 5% of memory.
	 * Insure a minimum of 16 buffers.
	 */
	if (bufpages == 0)
			bufpages = atop(mem_wo_hole / 20);
	if (nbuf == 0) {
		/*
		 *	Put ~2K in each buffer.
		 */
		nbuf = (bufpages * page_size) / 2048;
		if (nbuf < 16)
			nbuf = 16;
	}

	/*
	 * Now the amount of virtual memory remaining for buffers
	 * can be calculated, estimating needs for the cmap.
	 */
#define MAXBUFFERPAGES 512 /* Should be in sys/buf.h */
	if (bufpages == 0) 
		panic("bufpages == 0");
	if (nbuf == 0) 
		panic("nbuf == 0");

	/*
	 * Don't bite off more real pages than we can map!
	 */
	if (bufpages > nbuf * (MAXBSIZE / page_size))
		bufpages = nbuf * (MAXBSIZE / page_size);

	valloc(buf, struct buf, nbuf);

	/*
	 * Clear space allocated thus far, and make r/w entries
	 * for the space in the kernel map.
	 */
	v = (caddr_t) round_page(v);
	size = (vm_size_t) (v - firstaddr);
	ret = vm_map_find(kernel_map, vm_object_allocate(size), 
				(vm_offset_t) 0,&firstaddr, size, FALSE);
	if (ret != KERN_SUCCESS) {
		panic("startup: unable to allocate kernel data structures");
	}
	vm_map_pageable(kernel_map, firstaddr, v, FALSE);
	/* set firstaddr to the next address to be allocated */
	firstaddr = v;

	/*
	 * Now allocate buffers proper.  They are different than the above
	 * in that they usually occupy more virtual memory than physical.
	 */
	valloc(buffers, char, MAXBSIZE * nbuf);
	base = bufpages / nbuf;
	residual = bufpages % nbuf;
	if (show_space) { 
		printf("bufpages = %d, nbuf = %d, base = %d, residual = %d\n",
				bufpages, nbuf, base, residual);
	} 
	/*
	 *	Allocate virtual memory for buffer pool.
	 */
	v = (caddr_t) round_page(v);
	size = (vm_size_t) (v - firstaddr);
	buffer_map = kmem_suballoc(kernel_map, &firstaddr, &trash_offset /* max */, size,TRUE);
	ret = vm_map_find(buffer_map, vm_object_allocate(size), 
				(vm_offset_t) 0, &firstaddr, size, FALSE);
	if (ret != KERN_SUCCESS) {
		panic("startup: unable to allocate buffer pool");
	}

	for (i = 0; i < nbuf; i++) {
		vm_size_t	thisbsize;
		vm_offset_t	curbuf;

		/*
		 * First <residual> buffers get (base+1) physical pages
		 * allocated for them.  The rest get (base) physical pages.
		 *
		 * The rest of each buffer occupies virtual space,
		 * but has no physical memory allocated for it.
		 */

		thisbsize = page_size*(i < residual ? base+1 : base);
		curbuf = (vm_offset_t)buffers + i * MAXBSIZE;
		vm_map_pageable(buffer_map, curbuf, curbuf+thisbsize, FALSE);
	}


	/*
	 * Initialize callouts
	 */
	callfree = callout;
	for (i = 1; i < ncallout; i++)
		callout[i-1].c_next = &callout[i];

	{
		register int	nbytes;

		nbytes = ptoa(vm_page_free_count);
		printf("available memory = %d.%d%d megabytes.\n", nbytes/MEG,
			((nbytes%MEG)*10)/MEG,
			((nbytes%(MEG/10))*100)/MEG);
		nbytes = ptoa(bufpages);
		printf("using %d buffers containing %d.%d%d megabytes of memory\n",
			nbuf,
			nbytes/MEG,
			((nbytes%MEG)*10)/MEG,
			((nbytes%(MEG/10))*100)/MEG);
	}
	mb_map = kmem_suballoc(kernel_map, &mbutl, &embutl, 
			ptoa((nmbclusters)),FALSE);
	/*
	 * Configure the system.
	 */
	configure();

#if	CMUCS_KDB
	/*
	 * Initialize KDB.
	 */
	kdb_init();
#endif	CMUCS_KDB

       /* enable interrupts */
       spl0();
}

#ifdef PGINPROF
/*
 * Return the difference (in microseconds)
 * between the  current time and a previous
 * time as represented  by the arguments.
 * If there is a pending clock interrupt
 * which has not been serviced due to high
 * ipl, return error code.
 */
vmtime(otime, olbolt, oicr)
register int otime, olbolt, oicr;
{
	printf("vmtime called!\n");
}
#endif

#define RTFL_MASK	0xffffff00	/* mask off data byte of BALA */
#define RTFL_MAGIC	0x60f08a00	/* cas r0,r15,r0 ; bala fpglue */

/*
 * Send an interrupt to process.
 *
 * Stack is set up to allow sigcode stored
 * in u. to call routine, followed by chmk
 * to sigcleanup routine below.  After sigcleanup
 * resets the signal mask and the stack, it
 * returns to user who then unwinds with the
 * rei at the bottom of sigcode.
 */

sendsig(p, sig, mask)
int (*p)(), sig, mask;
{
	register int *regs,*rp1,*rp2;
	register struct sigframe *fp;
	register struct sigcontext *scp;
	int oonstack;

	DEBUGF(sydebug&SHOW_SIGNAL,
		printf("sendsig, p=%x,sig=%x,mask=%x\n",p,sig,mask));
	regs = u.u_ar0;
	oonstack = u.u_onstack;

	/*
	 * Push a stack frame for this signal
	 */
	if (!oonstack && (u.u_sigonstack & sigmask(sig))) {
		/* wasn't on onstack, and wants to be */
		fp = (struct sigframe *)u.u_sigsp - 1;
		u.u_onstack = 1;
	}
	else
		/* was on onstack, or doesn't want to be */
#if	ROMP_DUALCALL
		fp = (struct sigframe *)
			(regs[SP] + (u.u_calltype?FRM_PROTECT:0)) - 1;
#else
		fp = (struct sigframe *)
			(regs[SP] + FRM_PROTECT) - 1;
#endif	ROMP_DUALCALL

	scp = &fp->sf_sc;

	/*
	 * Make sure we can access the new signal frame
	 */
	if (!useracc((caddr_t)fp,sizeof(struct sigframe),B_WRITE)) {
		/* can't get there! */
		/* process has trashed its stack; give it an illegal */
		/* instruction to halt it in its tracks */
		u.u_signal[SIGILL] = SIG_DFL;
		sig = sigmask(SIGILL);
		u.u_procp->p_sigignore &= ~sig;
		u.u_procp->p_sigcatch &= ~sig;
		u.u_procp->p_sigmask &= ~sig;
		psignal(u.u_procp, SIGILL);
		return;
	}

	/*
	 * Set up the sigcontext to be passed to p()
	 */
	scp->sc_onstack = oonstack;
	scp->sc_mask = mask;
	scp->sc_sp = regs[SP];
	scp->sc_iar = regs[IAR];
	scp->sc_icscs = regs[ICSCS];
	scp->sc_floatsave = 0;

	/*
	 * Save the current registers
	 */
	rp1 = &regs[INFO];
	rp2 = &(scp->sc_regs[INFO]);
	while (rp1 >= regs)
		*rp2-- = *rp1--;

	/*
	 * Set up registers to call p()
	 */
	regs[R2] = fp->sf_signum = sig; /* 1st parameter: sf_signum */

#if	ROMP_NFL
	if (sig == SIGFPE) {
	    if (float_sendsig(fp)) {	/* Call floating point code to send */
		scp->sc_flags |= SC_FLOATSAVE;
		fp->sf_sc.sc_floatsave = (char *) &(fp->sf_floatsave);
	    }
	}
#endif	ROMP_NFL
#if	ROMP_SC_RTFL
	/*
	 * The RTFL has one case that we have to check for here.
	 * RTFL entry code is (aligned on a fullword boundary):
	 *	cas	r0,r15,r0
	 *	bala	fpglue
	 * if we take a signal after the case, but before the bala, and if
	 * the signal handler then reexecutes the generated code, then when
	 * we return from the handler the IAR will be partway thru the generated
	 * code and we are in trouble.
	 * This code checks to see if this might be happening, and sets a flag
	 * that sigcleanup will check to see if the RTFL magic sequence has been
	 * changed. If it has then we back up the IAR to point to the start of
	 * the code and continue execution. For efficiency we only look into
	 * the user address space if the IAR is non-aligned and if R0 == R15
	 * (after all we should have just executed a cas r0,r15,r0).
	 */
	if ((regs[IAR]&2) && regs[R0] == regs[R15] &&
			(fuword(regs[IAR]-2)&RTFL_MASK) == RTFL_MAGIC) {
		scp->sc_saveiar = regs[IAR];	/* save the IAR */
		scp->sc_flags |= SC_RTFL;	/* possible RTFL case */
		DEBUGF(sydebug&SHOW_SIGNAL, printf("sendsig: IAR=%x possible RTFL!\n",regs[IAR]));
	}
#endif	ROMP_SC_RTFL
#if	ROMP_APC
	/*
	 * copy exception information into sigframe so that packets
	 * can be reissued after the signal is complete 
	 * note that the exception information is taken from our 
	 * stack - signals sent from another process won't save
	 * exception information as there won't be any on our 
	 * stack.
	 */
#if	ROMP_135
	if (cpu_model == CPU_ROMPC || cpu_model == CPU_MOD135)
#else	ROMP_135
	if (cpu_model == CPU_ROMPC)
#endif	ROMP_135
	if (scp->sc_regs[ECR_COUNT] = regs[ECR_COUNT]) {
		bcopy((caddr_t)&regs[EX1_CTL],
			(caddr_t) &scp->sc_regs[EX1_CTL],
			regs[ECR_COUNT] * sizeof (struct ex_packet));
		regs[ECR_COUNT] = 0;	/* forget about exception for now */
		scp->sc_flags |= SC_EXCEPTION;
	}
#endif	ROMP_APC
	if (sig == SIGILL || sig == SIGFPE) {
		regs[R3] = fp->sf_code = u.u_code; /* 2nd parameter: sf_code */
		u.u_code = 0;
	}
	else
		regs[R3] = fp->sf_code = 0; /* 2nd parameter: sf_code */
	regs[R4] = (int)(fp->sf_scp = &(fp->sf_sc));/* 3rd parameter: sf_scp */
#if	MACH
	regs[R15] = (int) SIGCODE_ADDRESS;
#else 	MACH
	regs[R15] = (int)u.u_pcb.pcb_sigc;  /* return addr:  svc 139 */
#endif	MACH
#if	ROMP_DUALCALL
	if (u.u_calltype) {
	    regs[R0] = (int)p;
	    regs[IAR] = fuword((caddr_t)p);
	} else
	    regs[IAR] = (int)p;                 /* addr of signal handler */
#else
	regs[IAR] = (int)p;                 /* addr of signal handler */
#endif	ROMP_DUALCALL
	regs[SP] = (int)fp;                 /* push signal context */

	/*
	 * "Return" to the handler
	 */
	return;
}

/*
 * Routine to cleanup state after a signal
 * has been taken.  Reset signal mask and
 * stack state from context left by sendsig (above).
 * Then restore saved registers and simulate return from interrupt
 * (lps).
 */
sigcleanup()
{
	struct sigframe *fp;
	int *regs, *rp1, *rp2;
	struct sigcontext *scp;

	regs = u.u_ar0;
	DEBUGF(sydebug&SHOW_SIGNAL, printf("sigcleanup regs=%x scp=%x\n",regs,scp));

	fp = (struct sigframe *)regs[SP];
	if (!useracc((caddr_t)fp,sizeof(struct sigframe),B_WRITE))
		return;

	scp = &fp->sf_sc;

#if	ROMP_SC_RTFL
	/*
	 * check to see if we have a RTFL case and if we need to do 
	 * RTFL fixup.
	 */
	if ((scp->sc_flags&SC_RTFL) && scp->sc_iar == scp->sc_saveiar &&
			(fuword(scp->sc_saveiar-2) & RTFL_MASK) != RTFL_MAGIC) {
		printf("RTFL JACKPOT!!!\n");	/* was this worthwhile? */
		scp->sc_iar -= 2;		/* adjust the IAR back to 
						   the beginning of the RTFL
						   block.  */
	}
#endif	ROMP_SC_RTFL

	/*
	 * Restore registers
	 */
	rp1 = &regs[MQ];
	rp2 = &(scp->sc_regs[MQ]);
	while (rp1 >= regs)
		*rp1-- = *rp2--;

#if	ROMP_APC
	/*
	 * copy exception information from sigframe so that packets
	 * will be reissued upon return from syscall and sigcleanup.
	 */
#if	ROMP_135
	if (cpu_model == CPU_ROMPC || cpu_model == CPU_MOD135)
#else
	if (cpu_model == CPU_ROMPC)
#endif	ROMP_135
	if ((scp->sc_flags&SC_EXCEPTION) && (regs[ECR_COUNT] = scp->sc_regs[ECR_COUNT])) {
		if ((unsigned) regs[ECR_COUNT] > MAX_EXCEPTIONS)
			regs[ECR_COUNT] = MAX_EXCEPTIONS;	/* paranoia */
		DEBUGF(sydebug&SHOW_SIGNAL, printf("sigcleanup: %d exceptions\n",regs[ECR_COUNT]));
		bcopy((caddr_t) &scp->sc_regs[EX1_CTL],
			(caddr_t) &regs[EX1_CTL],
			regs[ECR_COUNT] * sizeof (struct ex_packet));
	}
#endif	ROMP_APC

	/*
	 * Alter registers available to signal handler
	 */
	regs[IAR] = scp->sc_iar;
	regs[SP]  = scp->sc_sp;
	regs[ICSCS] = scp->sc_icscs | ICSCS_USERSET & ~ICSCS_USERCLR;

	DEBUGF(sydebug&SHOW_SIGNAL, printf("sigcleanup IAR=%x SP=%x ICS_CS=%x\n",
		regs[IAR], regs[SP], regs[ICSCS]));	/* */
	DEBUGF(sydebug&SHOW_SIGREGS, prstate("sigcleanup", 0, 0, regs[IAR], regs[ICSCS],regs));	/* */

	/*
	 * Alter floating point registers 
	 */
	if (scp->sc_flags&SC_FLOATSAVE)
		float_sigcleanup(scp);

	/*
	 * Restore signal values
	 */
	u.u_onstack = scp->sc_onstack & SC_ONSTACK;
	u.u_procp->p_sigmask = scp->sc_mask & ~(sigmask(SIGKILL) |
	    sigmask(SIGCONT) | sigmask(SIGSTOP));
}

#ifdef notdef
dorti()
{
       struct frame frame;
       register int sp;
       register int reg, mask;
       extern int ipcreg[];

       (void) copyin((caddr_t)u.u_ar0[FP], (caddr_t)&frame, sizeof (frame));
       sp = u.u_ar0[FP] + sizeof (frame);
       u.u_ar0[PC] = frame.fr_savpc;
       u.u_ar0[FP] = frame.fr_savfp;
       u.u_ar0[AP] = frame.fr_savap;
       mask = frame.fr_mask;
       for (reg = 0; reg <= 11; reg++) {
	       if (mask&1) {
		       u.u_ar0[ipcreg[reg]] = fuword((caddr_t)sp);
		       sp += 4;
	       }
	       mask >>= 1;
       }
       sp += frame.fr_spa;
       u.u_ar0[PS] = (u.u_ar0[PS] & 0xffff0000) | frame.fr_psw;
       if (frame.fr_s)
	       sp += 4 + 4 * (fuword((caddr_t)sp) & 0xff);
       /* phew, now the rei */
       u.u_ar0[PC] = fuword((caddr_t)sp);
       sp += 4;
       u.u_ar0[PS] = fuword((caddr_t)sp);
       sp += 4;
       u.u_ar0[PS] |= PSL_USERSET;
       u.u_ar0[PS] &= ~PSL_USERCLR;
       u.u_ar0[SP] = (int)sp;
}
#endif

/*
 * Reboot the system, with various options
 */
int    waittime = -1;

boot(paniced, arghowto)
int paniced, arghowto;
{
       register int howto;             /* r11 == how to boot */
       register int devtype;           /* r10 == major of root dev */
       register int x;

       DEBUGF(svdebug, printf("paniced=%x,arghowto=%x\n", paniced, arghowto));
       x = * (int *) CSR;		/* clear csr lock */
       * (int *) CSR = 0;		/* and reset it */
       (void) spl1();                  /* allow level 5 disk intr DOB/STB */
       howto = arghowto;
       if (howto&RB_SUSPEND) {
		u.u_error = EINVAL;
		(void) spl0();
		return;
	}
       if ((howto&RB_NOSYNC)==0 && waittime < 0 && bfreelist[0].b_forw) {
	       extern int updlock;
	       waittime = 0;
	       if (updlock == 0) update();
	       printf("syncing disks... ");
	       { register struct buf *bp;
		 int iter, nbusy = 0, lbusy = 0;

		 for (iter = 0; iter < 20; iter++) {
		       nbusy = 0;
		       for (bp = &buf[nbuf]; --bp >= buf; )
			       if ((bp->b_flags & (B_BUSY|B_INVAL)) == B_BUSY)
				       nbusy++;
		       if (nbusy < lbusy)
			       iter = 0;
		       if ((lbusy = nbusy) == 0)
			       break;
		       printf("%d ", nbusy);
		       for (nbusy=100000; nbusy; --nbusy)
		       		;	/* a bit of a delay */
		 }
	       }
	       printf("done\n");
       }
       (void) spl7();                         /* extreme priority */
       devtype = major(rootdev);
       if (howto&RB_HALT) {
	       printf("halting (via wait);\n");
	       DISPLAY(LED_BLANK);		/* turn out the light */
	       for (;;)
			asmwait();
       } else {
	       if (paniced == RB_PANIC) {
		       dumpsys();              /* dump to swap area */
	       }
	       for (;;)
			_reboot(howto,devtype);
	}
}


int    dumpmag = 0x8fca0101;   /* magic number for savecore */
int    dumpsize = 0;           /* also for savecore */
/*
 * Doadump comes here after turning off memory management and
 * getting on the dump stack, when called by the system attention code
 * or more directly from above during 'boot' when called from 'panic'. 
 */
dumpsys()
{

       dumpsave();		/* save important MM stuff */
       dumpsize = physmem;	/* dump includes the hole */
       printf("\ndumping to dev %x, offset %d\n", dumpdev, dumplo);
       printf("dump ");
       switch ((*bdevsw[major(dumpdev)].d_dump)(dumpdev)) {

	case ENODEV:
		printf("driver can't dump yet\n");
		break;

       case ENXIO:
               printf("device bad\n");
               break;

       case EFAULT:
               printf("device not ready\n");
               break;

       case EINVAL:
               printf("area improper\n");
               break;

       case EIO:
               printf("i/o error");
               break;

       default:
               printf("succeeded");
               break;
       }
}

/*
 * I'm not sure what is machine dependent about this one XXX
 */
physstrat(bp, strat, prio)
struct buf *bp;
int (*strat)(), prio;
{
       int s;

       (*strat)(bp);
       /* pageout daemon doesn't wait for pushed pages */
       if (bp->b_flags & B_DIRTY)
	       return;
       s = spl6();
       while ((bp->b_flags & B_DONE) == 0)
	       sleep((caddr_t)bp, prio);
       splx(s);
}



/*
 * This is where the "soft network" interrupt comes to. The
 * hardware interrupt routine has pulled the packet off the
 * interface and now wants us to run (at lower priority) the
 * protocol family specific routine to munch the packet.
 */
softnet()
{
#ifdef INET
#define LOCORE /* *sigh* */
#include <net/netisr.h>
#undef LOCORE /* unsigh */
	extern int netisr;
	if (netisr & (1<<NETISR_RAW)) {
		netisr &= ~(1<<NETISR_RAW);
		rawintr();
		return(0);
	}
	if (netisr & (1<<NETISR_IP)) {
		netisr &= ~(1<<NETISR_IP);
		ipintr();
		return(0);
	}
	netisr = 0;
#endif INET
	return (1);
}

/*
 * Debugger -- go enter the debugger, if we have one
 * We return when done debugging (or if there is no debugger)
 */
/*
 * debug_flag determines what action we take upon a call to debugger
 * if debug_flag > 0 then we invoke the debugger if there has been
 * console input within that many seconds. 
 * if debug_flag == 0 then we always invoke the debugger
 * if debug_flag < 0 then we print a message, wait for a while
 * and then return.
 */
int debug_flag = 0;
Debugger(s)
char *s;
{
	/*      extern char etext, end; /* */
	register int n = debug_flag;
	extern unsigned long cons_sec;

	/*
	 * Check validity of s before we try to use it
	 */
	printf("Debugger called from %s.\n",
		( ((u_int) s > (u_int) &etext) &&
		  ((u_int) s < (u_int) &end) && *s)? s : "someplace");
#if	ROMP_RDB
	if (n == 0 || cons_sec+n >= time.tv_sec) {
		printf("Type \"go iar+2\" to continue execution.\n");
		asmtgte();	/* asm(" tgte r1,r1 ");  */
	}
	else {
		if (n < 0) 
			n = -n;
		printf("Press CTRL-ALT-SPACE to enter debugger\n");
		delay(n << 10);
	}
#else	ROMP_RDB
	printf("(But we weren't compiled with RDB!  Sorry.)\n");
#endif	ROMP_RDB
}

/*
 * Clear registers on exec
 */
int
setregs(entry)
	u_long entry;	
{
	register int i, j;
	register struct proc *p = u.u_procp;

	i = u.u_ar0[IAR] = entry;
#if	ROMP_DUALCALL
	/* Old calling sequence crt0 begins with

		start:	j   next
			.short	0
			.ascii "<start>"
	   and expects kframe (struct argument) to be on the stack.

	   New calling sequence crt0 begins with

		start:  j   .start
			.short 1	# version number, eventually
			.long  magicno  # magic number -- to be determined
			.long  _start   # to let execve load data ptr in r0
			.globl __fpfpr
			.long  __fpfpr  # location of software fp status
			.ascii "<start>"
			.start:
	   and expects the first four words of kframe to be in r2-r5,
	   which it will store on the stack. 
	*/
	j = fuiword((caddr_t) i) & 0xffff;	/* .short 1  or .short 0 */
	if (j == 1) { 	/* Must be NCS */
	    u.u_calltype = j;
	    u.u_r.r_val2 = fuiword((caddr_t) i+NBPW*2);/* val2->R0 in trap.c */
	    u.u_ar0[R0] = u.u_r.r_val2;
		/* Copy first 4 words of kframe struct into user's r2-r5, 
		   and bump sp past them.
		 */
	    for (i=R2; i<R6; i++, u.u_ar0[SP] += NBPW)
		u.u_ar0[i] = fuword((caddr_t) u.u_ar0[SP]); 
	    u.u_r.r_val1 = u.u_ar0[R2];		/* val1 -> R2 in trap.c */
	}
	else {
	    	
		u.u_calltype = 0;			/* OCS */
	}
#endif ROMP_DUALCALL
	/*
	 * restore ccr to default state 
	 * by clearing all bits not on in 
	 * default case.
	 */
	set_ccr(0x80000000 | (int) ccr_default);
	/* 
	 * restore consdev by clearings bits for
	 * all possible console devices
	 */
	set_consdev(0x80000000 | (int) 0);
	/*
	 * upon exec release the current register set (as is done
	 * upon exit).
	 */
	float_exit(current_thread());
}

/*
 * set/clear bits in the consdev (console device flags) for this process
 * if top bit in value is on then we clear the given
 * bits otherwise set them.
 */
set_consdev(value) register int value;
{
	register char	*ptr;

#if	MACH
	ptr = &current_thread()->pcb->pcb_consdev;
#else	MACH
	ptr = &u.u_pcb.pcb_consdev;
#endif	MACH
	if (value < 0)
		*ptr &= value;
	else
		*ptr |= value;
}

/* 
 * return the value in the console device flags for this process.
 */
get_consdev()
{
#if	MACH
	return(current_thread()->pcb->pcb_consdev);
#else	MACH
	return(u.u_pcb.pcb_consdev);
#endif	MACH	
	
}


#ifdef UPANIC
/*
 * panic initiated from user code (root only)
 * for testing dump taking.
 */
upanic()
{
	register struct a {
		char *	opt;
	};

	if (suser())
		panic(((struct a *)u.u_ap)->opt);
}
#endif

/*
 * set/clear bits in the ccr for this process
 * if top bit in value is on then we clear the given
 * bits otherwise set them.
 */
set_ccr(value) register int value;
{
	register int	*ptr;

#if	MACH
	ptr = &current_thread()->pcb->pcb_ccr;
#else	MACH
	ptr = &u.u_pcb.pcb_ccr;
#endif	MACH
	if (value < 0)
		*ptr &= value;
	else
		*ptr |= value;
	* (char *) CCR = *ptr;
}

#define DELAY_COUNT 1000

int delay_count = DELAY_COUNT;

/* 
 * give 'n' milliseconds of real-time delay.
 */
delay(n)
	register int n;
{
	register int i;

	while (--n >= 0)
		for (i = delay_count; --i >= 0;)
			* (char *) DELAY_ADDR = 0xFF;
}

sigreturn()
{
 panic("sigreturn not implemented");
}


halt_cpu()
{
 splhigh();
 printf("Halting CPU via wait (it's OK to reboot or power down now).");
 while (1) {
  wait();
  printf (".");
 }
}


/*
 * Return the best possible estimate of the time in the timeval
 * to which tvp points.  We do this by reading the interval count
 * register to determine the time remaining to the next clock tick.
 * We must compensate for wraparound which is not yet reflected in the time
 * (which happens when the ICR hits 0 and wraps after the splhigh(),
 * but before the mfpr(ICR)).  Also check that this time is no less than
 * any previously-reported time, which could happen around the time
 * of a clock adjustment.  Just for fun, we guarantee that the time
 * will be greater than the value obtained by a previous call.
 */
microtime(tvp)
	register struct timeval *tvp;
{
	int s = splhigh();
	static struct timeval lasttime;
	register long t;

	*tvp = time;
	t =  mfsr(SCR_TIMER);
/* Due to the compiler sucking, I am doing the following calculation 
 * using bit shifts and adds.  Note that what I am really computing is
 * t * (1 * 10^6) / ROMPHZ (knowing that romphz = 1024), or t * 976,
 * that is t * 1111010000 (binary).  ie...
 */
	tvp->tv_usec += (t << 4) + (t << 6) + (t << 7) + (t << 8) +
			(t << 9);
#if	CMUCS
	if (tvp->tv_usec >= 1000000) {
#else	CMUCS
	if (tvp->tv_usec > 1000000) {
#endif	CMUCS	    
		tvp->tv_sec++;
		tvp->tv_usec -= 1000000;
	}
	if (tvp->tv_sec == lasttime.tv_sec &&
	    tvp->tv_usec <= lasttime.tv_usec &&
#if	CMUCS
	    (tvp->tv_usec = lasttime.tv_usec + 1) >= 1000000) {
#else	CMUCS	    
	    (tvp->tv_usec = lasttime.tv_usec + 1) > 1000000) {
#endif	CMUCS	    		
		tvp->tv_sec++;
		tvp->tv_usec -= 1000000;
	}
	lasttime = *tvp;
	splx(s);
}


/*
 * adjust the value of the delay_count variable so that it gives
 * as close to 1 millisecond delay as we can expect.
 * we do this by doing a nominal 1second delay and adjusting
 * the delay count by the resulting change in the time variable.
 */
#define ADJUST_TIME	1000	/* number of millseconds to delay */
delay_adjust()
{
	struct timeval tv = time;	/* start time */
	long eltime;			/* difference in usec */
	long new_count;

	delay(ADJUST_TIME);		/* nominal 1 second delay */
	eltime = (time.tv_sec-tv.tv_sec) * 1000 + (time.tv_usec-tv.tv_usec)/1000;	/* actual time taken by delay(ADJUST_TIME) */
	if (eltime <= 0)
		printf("oops, clock not running (%d)\n",eltime);
	else {
		new_count = (delay_count * ADJUST_TIME) / eltime;
		DEBUGF(1, printf("adjust delay_count from %d to %d\n",delay_count,new_count));
		delay_count = new_count;
	}
}

/* 
 * adjust the delays according to the CPU type
 * a finer adjustment will be made later but we need a close 
 * approximation for the probe routines.
 */
delay_preadjust()
{
#if	ROMP_APC
	if (cpu_model == CPU_ROMPC)
		delay_count = 600;
	else
#endif	ROMP_APC
#if	ROMP_135
	if (cpu_model == CPU_MOD135)
		delay_count = 800;
	else
#endif	ROMP_135
		delay_count = 400;
}



osigcleanup()

{
 uprintf("osigcleanup syscall is not supported on RTs\n");
}



#if	ROMP_SHOW_LOAD
show_load()
{
	int	a;

#if	MACH
	a = (avenrun[0] * 10) / LSCALE;
#else	MACH
	a = avenrun[0] * 10;
#endif	MACH

	display(((a/10) << 4) + (a % 10)); 	/* display in lights */
	timeout(show_load,NULL,5 * hz);	/* reactivate myself in 5 seconds */
}
#endif	ROMP_SHOW_LOAD


struct post *
get_post(io_addr)	/* should be moved to machdep.c */
	register caddr_t io_addr;
{
	register struct post *pp;
	
	for (pp = &POST_CB.posts[0]; pp < &POST_CB.posts[NPOSTS]; pp++) {
		if (pp->primary == (u_short)io_addr)
			return (pp);
	}
	return (NULL);
}

baddev()
{
    	panic("baddev");
}
