#ifdef CMU
/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ***********************************************************************
 * HISTORY
 * $Log:	machparam.h,v $
 * Revision 2.2  88/11/23  16:24:49  rpd
 * 	Added volatile from Acis.
 * 	[88/11/04  17:12:50  rpd]
 * 
 * 10-Sep-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Moved declaration of rorootdev inside KERNEL-only clause.
 *
 *  2-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Fixed to allow standalone code to use the definition of DELAY().
 *
 * 12-Sep-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed page size to 4K.
 *
 * 11-Jun-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added macro for splsched.
 *
 * 28-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	added macros for splsoftclock, splhigh and spltty.
 *
 ***********************************************************************
 */
#endif CMU


/*
 * Machine dependent constants for Romp.
 */
#if	0
#define        NBPG    4096            /* bytes/page */
#define        PGOFSET (NBPG-1)        /* byte offset into page */
#define        PGSHIFT 12              /* LOG2(NBPG) */
#define        LOG2NBPG 12             /* LOG2(NBPG) */
#else	0
#define        NBPG    2048            /* bytes/page */
#define        PGOFSET (NBPG-1)        /* byte offset into page */
#define        PGSHIFT 11              /* LOG2(NBPG) */
#define        LOG2NBPG 11             /* LOG2(NBPG) */
#endif	0

#define        CLSIZE          1
#define        CLSIZELOG2      0

#define        SSIZE   CLSIZE          /* initial stack size/NBPG */
#define        SINCR   1               /* increment of stack/NBPG */

#define        UPAGES  4               /* pages of u-area */

#define SEGMENT_OFFSET 0x0FFFFFFF      /* Romp hardware segment offset */
#define DATABASE       0x10000000      /* virtual address of data origin */




/*
 * Some macros for units conversion
 */
/* Core clicks (4K bytes) to segments and vice versa */
#define        ctos(x) (x)
#define        stoc(x) (x)

#define        dtob(x) ((x)<<9)

/* clicks to bytes */
#define        ctob(x) ((x)<<11)

/* bytes to clicks */
#define        btoc(x) ((((unsigned)(x)+2047)>>11))

/*
 * Macros to decode interrupt control status.
 */
#define        USERMODE(icscs)   ((icscs) & ICSCS_PROBSTATE)
#define        BASEPRI(icscs)    (((icscs) & ICSCS_PRIORITY) == ICSCS_PRIORITY)

#if	defined(KERNEL) || defined(STANDALONE)
#define DELAY_ADDR	0xf00080E0		/* IOCC delay location */
#define DELAY(n)	{ register int N = (n); while (--N >= 0) \
				* (char volatile *) DELAY_ADDR = 0xff;	}

#ifndef ASSEMBLER
short rorootdev;		/* for read-only root device */
#endif	ASSEMBLER

#endif	defined(KERNEL) || defined(STANDALONE)
