/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/***************************************************************
 * HISTORY
 * $Log:	mem.c,v $
 * Revision 2.4  88/11/23  16:25:41  rpd
 * 	Changed includes to the new style.
 * 	Picked up volatile use from Acis.
 * 	[88/11/04  17:17:38  rpd]
 * 
 * Revision 2.3  88/08/22  21:27:14  mja
 * 	Add "mach.h".
 * 	[88/08/04  13:12:55  mja]
 * 
 * 25-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added AFPA support (kmem character device  3 12 ).
 *
 * 23-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	hc: turned off optimization.
 *
 * 26-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Removed dead variable.
 *
 ****************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <mach.h>

/* $ Header: mem.c,v 4.2 85/08/25 19:28:22 chessin Exp $ */
/* $ Source: /ibm/acis/usr/sys_ca/ca/RCS/mem.c,v $ */

/*     mem.c   6.1     83/07/29        */

#ifdef	hc
pragma	off (optimize);
#endif	hc

/*
 * Memory special file
 */

#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/systm.h>
#include <sys/vm.h>
#include <sys/uio.h>
#include <ca/rosetta.h>
#include <ca/float.h>
#include <ca/fpa.h>
#include <vm/vm_kern.h>

mmread(dev, uio)
	dev_t dev;
	struct uio *uio;
{

	return (mmrw(dev, uio, UIO_READ));
}


mmwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{

	return (mmrw(dev, uio, UIO_WRITE));
}


mmrw(dev, uio, rw)
	dev_t dev;
	struct uio *uio;
	enum uio_rw rw;
{
	register u_int c, v;
	register struct iovec *iov;
	int error = 0;
	struct buf *bp;

	while (uio->uio_resid > 0 && error == 0) {
		iov = uio->uio_iov;
		if (iov->iov_len == 0) {
			uio->uio_iov++;
			uio->uio_iovcnt--;
			if (uio->uio_iovcnt < 0)
				panic("mmrw");
			continue;
		}
		switch (minor(dev)) {

/* minor device 0 is physical memory */
/* Strategy:
 * 1. verify the address is within physical memory.
 * 2. verity that the end address does not exceed memory
 *     if write, uimove user's data to kernel buffer
 * 3. go to V=R mode (target address cannot be in segment 0 as this is
 *	read-only text (note: should check to make sure that this gets
 *	picked up properly if it is in segment 0)
 * 4. do the copy via uiomove
 * 5. restore previous (presumably non V=R).
 *     if read, uiomove the kernel buffer to the user's area
 */
		case 0:
			v = btop(uio->uio_offset);
			if (v >= physmem)
				goto fault; /* start address too big */
			v = btop(uio->uio_offset + iov->iov_len + -1);
			if (v >= physmem)
				goto fault; /* end address too big */
			c = MIN((u_int)iov->iov_len, MAXBSIZE);
			bp = geteblk(c);
			if (rw == UIO_READ) {
				register int s, x;
				s = spl5(); /* 5??? */
				GET_VR0(x);
				bcopy((caddr_t)uio->uio_offset,
					bp->b_un.b_addr,
					c);
				SET_VR(x); /* restore virtual */
				splx(s);  /* restore prio */
				error = uiomove(bp->b_un.b_addr,
					(int)c, rw, uio);
			} else {
				register int s, x;
				error = uiomove(bp->b_un.b_addr,
					(int)c, rw, uio);
				s = spl5(); /* 5??? */
				GET_VR0(x);
				bcopy(bp->b_un.b_addr,
					(caddr_t)uio->uio_offset, c);
				SET_VR(x); /* restore virtual */
				splx(s);  /* restore prio */
			}
			brelse(bp);
			continue;

/* minor device 1 is kernel memory */
		case 1:
			c = iov->iov_len;
			if (!kernacc((caddr_t)uio->uio_offset,
				c, rw == UIO_READ ? B_READ : B_WRITE))
				goto fault;
			error = uiomove((caddr_t)uio->uio_offset, (int)c, rw, uio);
			continue;

/* minor device 2 is EOF/RATHOLE */
		case 2:
			if (rw == UIO_READ)
				return (0);
			c = iov->iov_len;
			break;

/* minor device 3 is kernel memory, addressed as bytes */
/* minor device 4 is kernel memory, addressed as shorts */
/* minor device 5 is kernel memory, addressed as longs */
		case 3:
		case 4:
		case 5:
			c = iov->iov_len;
			if (!kernacc((caddr_t)uio->uio_offset,
				c, rw == UIO_READ ? B_READ : B_WRITE))
				goto fault;
			if (!useracc(iov->iov_base,
				c, rw == UIO_READ ? B_READ : B_WRITE))
				goto fault;
			error = IOcpy((caddr_t)uio->uio_offset, iov->iov_base,
				(int)c, rw, minor(dev) - 3);
				
			break;
/* minor device 12 is the path to access the afpa control store */
		case 12: {
#define AFPA_VALID(x) \
    ((unsigned)(x) <= \
		((unsigned) AFPA_UCODE_HIGHEST)-((unsigned) AFPA_UCODE_LOWEST))

			unsigned long to, from;
			unsigned int to_first_inc, to_last_inc;
			unsigned int from_first_inc, from_last_inc;
			int s;
			int count;
			vm_offset_t memory;
			vm_size_t  size;

			size = c = iov->iov_len;
			/*
			 * Make sure length and user base aligned properly.
			 *
			 * The idea is we are accessing double words into the
			 * control store.  So, the count and the control
			 * store addresses need to be double word aligned.
			 *
			 * In addition, we are accessing the user storage
			 * via a "long" pointer, so user storage must be
			 * word aligned.
			 */
			if ((c&7) ||
			   (((int) uio->uio_offset)&7) ||
			   (((int) iov->iov_base)&3)) {
				return EINVAL;
			}
			/*
			 * Check that the limits are correct.
			 *
			 * Note that we run through the loop 'c/8'
			 * times; that each time through we are
			 * incrementing the control store offset
			 * by 4.  So, at the end of the
			 * loop, the control store offset is
			 * set to ((c/8)*4).  So, at the start of
			 * the last iteration, the offset is
			 * (((c/8)*4)-4, and the LAST offset
			 * we access is, therefore, (((c/8)*4)-4+1
			 * == (c/2)-3.
			 */
			if (!(AFPA_VALID(uio->uio_offset)
			      && AFPA_VALID(((unsigned)uio->uio_offset)
						+((c/2)-(sizeof (long)-1))))) {
				goto fault;
			}
			/* Make sure things are legal */
			if ((float_hardware&FLOAT_AFPA_CONTROL_STORE_ENABLE)
									== 0) {
				return EACCES;
			}
			memory = kmem_alloc(kernel_map,round_page(c));
#if	!MACH			
			if (!useracc(iov->iov_base,
				c, rw == UIO_READ ? B_WRITE : B_READ)) {
				goto fault;
			}
#endif	!MACH			
			if (rw == UIO_READ) {
				to = (unsigned long) memory;
				to_first_inc = to_last_inc = sizeof (long);
				from = (unsigned) AFPA_UCODE_LOWEST +
						(unsigned long) uio->uio_offset;
				from_first_inc = 1;
				from_last_inc = sizeof (long) -1;
			} else {
				to = (unsigned) AFPA_UCODE_LOWEST +
						(unsigned long) uio->uio_offset;
				to_first_inc = 1;
				to_last_inc = sizeof (long) -1;
				from = (unsigned long) memory;
				from_first_inc = from_last_inc = sizeof (long);
				if (copyin(iov->iov_base,memory,c) != 0) {
				    kmem_free(kernel_map,memory,size);
				    goto fault;
				}
			}
			s = splhigh();
			count = c >> 3;		/* Writing double words */
			/*
			 * We go to some trouble to make sure
			 * that our "pointer" arithmetic is unsigned.
			 * we have to use volatile on both from and to 
			 * pointers since either one can be the afpa control
			 * store.
			 */
			while (count--) {
			    * (long volatile *) to = * (long volatile *) from;
			    to += to_first_inc;
			    from += from_first_inc;
			    * (long volatile *) to = * (long volatile *) from;
			    to += to_last_inc;
			    from += from_last_inc;
			}
			splx(s);
			if (rw == UIO_READ) {
			    if (copyout(memory,iov->iov_base,c) != 0) {
			    	kmem_free(kernel_map,memory,size);
			    	goto fault;
			    }
			}
		    	kmem_free(kernel_map,memory,size);
			break;
		}

		default:
			goto fault;
		}
		if (error)
			break;
		iov->iov_base += c;
		iov->iov_len -= c;
		uio->uio_offset += c;
		uio->uio_resid -= c;
	}
	return (error);
	
fault:
	return (EFAULT);
}

/*
 * Aligned Kernel Address Space <--> User Space transfer
 */
IOcpy(ioadd, usradd, n, rw, log2length)
	caddr_t ioadd, usradd;
	register int n;
	enum uio_rw rw;
	int log2length;
{
	register caddr_t from, to;
	register int length;
	register int mask;

	/*
	 * Check for length and alignment commensurate
	 * with the request
	 */
	mask = 3 >> (2 - log2length);
	if (n & mask || (int) ioadd & mask || (int) usradd & mask)
		return (EINVAL);

	if (rw == UIO_READ) {
		from = ioadd;
		to = usradd;
	} else {
		from = usradd;
		to = ioadd;
	}

	n >>= log2length;
	length = 1 << log2length;

	switch(log2length) {

	case 0:
		for (; n > 0; n--) {
			*(char *)to = *(char *)from;
			to += length;
			from += length;
		}
		break;

	case 1:
		for (; n > 0; n--) {
			*(short *)to = *(short *)from;
			to += length;
			from += length;
		}
		break;

	case 2:
		for (; n > 0; n--) {
			*(long *)to = *(long *)from;
			to += length;
			from += length;
		}
		break;

	default:
		panic("IOcpy");
	}
	return (0);
}
