/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 ****************************************************************
 * HISTORY
 * 25-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added pcb_afpalen length field for AFPA support.
 *
 * 28-Nov-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Added missing #ifdef KERNEL bracketing around `ast' variable.
 *	[ V5.1(XF21) ]
 *
 *  4-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	romp: Changed for new romp floating point hardware.  Also
 *	eliminated some crud and fixed size of filler field.
 *
 *  2-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Fixed includes for non-KERNEL builds.
 *
 * 19-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Inserted fparegs variable to indicate what hardware fpa register
 *	set (if any) is allocated to this thread.  Inserted fpasave area
 *	to save floating point registers it is necessary to deallocate
 *	the physical registers.  Also changed indentation to use tabs
 *	instead of spaces.
 *
 * 22-Mar-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Fixed for recursive includes.
 *
 ***********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#ifdef	KERNEL
#include "../ca/float.h"
#else	KERNEL
#include <ca/float.h>
#endif	KERNEL

#ifndef	_PCB_
#define	_PCB_

/*
 * RT process control block
 */

#ifndef	ASSEMBLER
struct pcb
{
	int	pcb_ksp;        /* kernel stack pointer */
	int	pcb_esp;	/* exec stack pointer */
	int	pcb_ssp;	/* supervisor stack pointer */
#define pcb_usp pcb_r1			/* user stack pointer */
	int	pcb_r0;
	int	pcb_r1;
	int	pcb_r2;
	int	pcb_r3;
	int	pcb_r4;
	int	pcb_r5;
	int	pcb_r6;
	int	pcb_r7;
	int	pcb_r8;
	int	pcb_r9;
	int	pcb_r10;
	int	pcb_r11;
	int	pcb_r12;
	int	pcb_r13;
	int	pcb_r14;
	int	pcb_r15;
	int	pcb_iar;        /* instruction address */
	int	pcb_icscs;      /* program status longword */
/*
 * Software pcb (extension)
 */
	int	pcb_sigc[2];	/* really just filler */
	int	pcb_afpalen;	/* length register for ROMPC with AFPA */
	int	pcb_fpastatus;	/* fpa status value when owned an exception */
	int	pcb_ccr;	/* value for CCR for this process */
	char	pcb_consdev;	/* which console devices are open for HW access */
	char	pcb_floatinfo;	/* exception information for the fpa */
	char	pcb_fill[2];	/* Alignment filler. */
	struct floatsave fpasave;
	int	fparegs;	/* current register set # */
	long	floatmask;	/* Floating point hardware in use */
					/* (see ../machine/float.h) */
};

#ifdef	KERNEL
extern	int ast;

#define aston() ast = 1;

#define astoff() ast = 0;
#endif	KERNEL
#endif	ASSEMBLER
#endif	_PCB_
