/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	ca/pmap.h
 *
 *	RT Version:
 *	Copyright (c) 1986, 1987, William J. Bolosky
 *
 *	Romp/Rosetta machine-dependent structures for the pmap module.
 *
 * HISTORY
 * $Log:	pmap.h,v $
 * Revision 2.5  89/01/15  21:33:27  rpd
 * 	Use decl_simple_lock_data.
 * 	[89/01/15  14:51:07  rpd]
 * 
 * Revision 2.4  88/10/27  10:41:02  rpd
 * 	Removed include of romp_shared_seg.h.
 * 
 * Revision 2.3.1.1  88/10/26  14:25:56  rpd
 * 	Removed include of romp_shared_seg.h.
 * 
 * Revision 2.3  88/10/10  22:23:35  sanzi
 * 	Move declaration of pmap_resident_count() to within the 
 * 	#ifndef ASSEMBLER condition. 
 * 
 * Revision 2.2  88/10/06  13:57:15  sanzi
 * 	Fix stupid automatic generated log message in previous revision.
 * 	Make pmap_resident_count() a function declaration instead of 
 * 	a macro.
 * 	Fix include file references.
 * 	Delete ROMP_SHARED_SEG conditionals.
 * 
 * Revision 2.1.1.5  88/10/04  09:43:58  sanzi
 * 	Fix stupid automatic generated log message in previous revision.
 * 
 * Revision 2.1.1.4  88/10/04  09:41:41  sanzi
 * 	Make pmap_resident_count() a function declaration instead of
 *	a macro.
 *
 * Revision 2.1.1.3  88/10/04  09:38:56  sanzi
 * 	Fix include file references.
 * 
 * 14-Dec-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added pmap_phys_address() declaration.
 *
 * 15-Jul-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added pmap_resident_count() macro.
 *
 * 22-Jun-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_SHARED_SEG: Added ss table and vmmap.
 *
 * 19-Mar-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Export kernel_pmap as all good pmap modules should.
 *
 *  8-Apr-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Created.
 *
 */

#ifndef	_PMAP_MACHINE_
#define	_PMAP_MACHINE_	1

/* If you change this then you must also change the line in mkmakefile.c
 * in the source for config which gives the load address to the loader and
 * the sed script in make.ws which converts kernel virtual addresses into
 * real addresses while building the debugger symbol table.  You must also
 * chnage the .set for SYS_ORG in locore.h.  And change 
 * VM_MIN/MAX_{KERNEL,}ADDRESS in vm_param.h (sigh).
 */
#define	SYS_SEG	0xe
#define SYSBASE_ADDR	0xe0000000	  /* virt addr of system origin */
#define SYSBASE  ((u_long)SYSBASE_ADDR)
#define	NUSR_SEGS	SYS_SEG	/* Hacky, but correct */
/*BJB#define IOSAVEL		19 * 4 */
#define	IOSAVEL		21 * 4  /* BJB-for debugging interrupts */

#ifndef	ASSEMBLER
#include <sys/zalloc.h>
#include <sys/lock.h>
#include <vm/vm_param.h>
#include <machine/vmparam.h>
#include <vm/vm_statistics.h>

/*
 * WARNING: load_context in ca/loutil.s relies on the fact that sidtab is
 * 	    an array of shorts.  If you change this, you must also change
 *	    load_context or all hell will break loose.  It also relies on 
 *	    sidtab being the first thing in this structure.
 */
struct pmap {
	short			sidtab[NUSR_SEGS];	/* seg id's */
	int			ref_count;	/* reference count */
	decl_simple_lock_data(,	lock)		/* lock on map */
	struct pmap_statistics	stats;		/* map statistics */
	queue_head_t		ppage_list;	/* list of physical pages */
	int			ppage_count;	/* count of known ppages */
	queue_head_t		cache_entries;	/* shm cache entries */
	int			cache_count;	/* count of cache entries */
};

typedef struct pmap_list_entry {
    	queue_chain_t	pmap_pages;		/* chain entry for the list */
	struct pmap	*pmap;			/* pmap that owns this page */
	boolean_t	in_use;			/* debugging */
    	vm_offset_t	vaddr;			/* virtual address */
	vm_offset_t	paddr;			/* physical page */
} *pmap_list_entry_t;

typedef struct pmap	*pmap_t;

#define	PMAP_NULL	((pmap_t) 0)
extern	loadpt;
extern	pmap_t	kernel_pmap;
extern	int pmap_resident_count(/* pmap_t pmap */);

#define KERNSTACK       (ENDOFP1-sizeof(struct user)) /* top of kernel stack */
#define uareabase(u)    ((caddr_t)(u)+sizeof(struct user)-UPAGES*NBPG)

vm_offset_t	pmap_phys_address();

#endif	ASSEMBLER

#define	PMAP_ACTIVATE(pmap, th, cpu) \
{\
	extern pmap_t active_pmap; \
	active_pmap = pmap; \
}

#define PMAP_DEACTIVATE(pmap,th,cpu) \
{\
	extern pmap_t active_pmap; \
	active_pmap = PMAP_NULL; \
}


#endif	_PMAP_MACHINE_
