/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $ACIS:rdb.h 7.4$ */
/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 ***********************************************************************
 * HISTORY
 * $Log:	rdb.h,v $
 * Revision 2.6  88/12/20  13:41:15  rpd
 * 	Fixed includes.
 * 	[88/12/07  17:10:55  rpd]
 * 
 * Revision 2.5  88/08/25  18:40:26  mwyoung
 * 	Put RDB_END, etc, back to original value now that rdb.ws is small again.
 * 	[88/08/15  23:15:55  rpd]
 * 
 * Revision 2.4  88/08/24  01:42:44  mwyoung
 * 	Corrected include file references.
 * 	[88/08/22            mwyoung]
 * 
 * Revision 2.3  88/08/06  18:05:41  rpd
 * Moved symbol table up to 0x23000, to leave more room for rdb.
 * 
 * Revision 2.2  88/07/20  16:18:36  rpd
 * Merged in changes for a bigger, relocated symbol table.  Needed
 * for longer names in the symbol table.
 * 
 **********************************************************************
 */

/*
 * this file is included in machine/locore.c and standca/rdb.c
 * normally, and is processed by an awk script in ../conf/make.ws
 * so that the values can be used in that shell script
 * the 'values' MUST be of the form 0xvalue for this to work!
 * rules:
 * RDB_STACK	is the top of the debugger stack (used to be 0x800)
 * RDB_RELOC	is the base of the debugger
 * RDB_END	is the end of the debugger (see output from make rdb.out
 *		in standca)
 * RDB_SYMTAB	is the base of the symbol table (=RDB_END)
 * RDB_SYMLEN	is the length of the symbol table
 */

#ifdef	KERNEL
#include <cmucs_kdb.h>
#include <romp_rdb.h>
#else	KERNEL
#include <sys/features.h>
#endif	KERNEL

#ifndef	_RDB_
#define _RDB_
#define RDB_STACK	0x800		/* DEBUGGER stack top */
#define RDB_RELOC	0x6000
#define RDB_END		0x29000
#define RDB_SYMTAB	0x29000		/* start of debugger symtab */

#if	CMUCS_KDB
#if	ROMP_RDB
#define	KDB_SYMTAB	0xe0023000
#else	ROMP_RDB
#define	KDB_SYMTAB	0xe0023000
#endif	ROMP_RDB
#endif	CMUCS_KDB

#define RDB_SYMLEN	0x18000

/*
 * Parameters for POST 
 */ 
#define POST_START	0x800		
#define POST_SIZE	0x800		

/*
 * define for start of kernel 
 */
#define KERNEL_START	0x1000		
#endif _RDB_
