/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/* 
 * HISTORY
 * 15-Feb-88  David Black (dlb) at Carnegie-Mellon University
 *	Move MCHECK to bad access, and change code.
 *
 *  4-Feb-88  David Golub (dbg) at Carnegie-Mellon University
 *	Don't panic on unrecognized error codes.
 *
 * 29-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Created.
 *
 */

#include "sys/boolean.h"
#include "sys/exception.h"
#include "sys/kern_return.h"
#include "sys/signal.h"

#include "ca/scr.h"

/*
 *	machine_exception translates a mach exception to a unix exception
 *	and code.  This handles all the hardware-specific exceptions for
 *	the vax.  unix_exception() handles the machine-independent ones.
 */

boolean_t machine_exception(exception, code, subcode, unix_signal, unix_code)
int	exception, code, subcode;
int	*unix_signal, *unix_code;
{
    	*unix_code = 0;
	
	switch(exception) {
	    case EXC_BAD_ACCESS:
	        switch(code) {
		    case EXC_ROMP_MCHECK:
		        *unix_signal = SIGBUS;
			break;
		    default:
	    	        return(FALSE);
		}
		break;

	    case EXC_BAD_INSTRUCTION:
	        *unix_signal = SIGILL;
		if (code == EXC_ROMP_PRIV_INST)
		    *unix_code = PCS_KNOWN | PCS_PRIV_I;
		else
		    *unix_code = PCS_KNOWN | PCS_BAD_I;
		break;

	    case EXC_ARITHMETIC:
	    	switch(code) {
		    case EXC_ROMP_68881:
			*unix_signal = SIGFPE;
			break;
		    case EXC_ROMP_68881_TIMEOUT:
			*unix_signal = SIGBUS;
			break;
		    case EXC_ROMP_FLOAT_SPEC:
		        *unix_signal = SIGBUS;
			break;
   		    case EXC_ROMP_FPA_EMUL:
			*unix_signal = SIGFPE;
			*unix_code = subcode;
			break;
		    default:
			return(FALSE);
		}
		break;

	    case EXC_BREAKPOINT:
	    	*unix_signal = SIGTRAP;
		break;
	
	    default:
	    	return(FALSE);

	}
	return(TRUE);
}


