/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ***********************************************************************
 * HISTORY
 * 12-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added ACIS definition of setsoftTTY() for use by the asy and psp
 *	drivers.
 *
 * 23-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	hc: turned off optimization.
 *
 * 31-Mar-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed asm's in setsoft{clock,net} to calls to setsoftint.
 *
 * 19-Mar-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Deleted all queue code.
 *
 * 26-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Declared the type of parameters in several routines to make
 *	hc/lint happy.
 *
 *  5-Aug-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Fixed _dequeue to do the right thing.
 *
 * 28-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added enqueue_tail and dequeue_head.
 *
 ***********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#ifdef	hc
pragma off(optimize);
#endif	hc

#include "../ca/softint.h"

/* routines done by SED	*/

blkclr(dest, len)
	register char *dest;
	register int len;
{
	mfill(dest, len, 0);
}


setsoftclock()
{

	softlevel |= SOFT_CLOCK;
	setsoftint();
}

setsoftTTY()
{
	softlevel |= SOFT_TTY;
	setsoftint();
}

#ifdef INET
setsoftnet()
{

	softlevel |= SOFT_NET;
	setsoftint();
}
#endif INET

