/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: sigframe.h,v 2.1 87/09/30 13:41:57 mrt Exp $ */
/* $ACIS:sigframe.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/ca/sigframe.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsigframe = "$Header: sigframe.h,v 2.1 87/09/30 13:41:57 mrt Exp $";
#endif

#ifdef	KERNEL
#include "ca/float.h"
#include "sys/signal.h"
#else	KERNEL
#include <machine/float.h>
#include <sys/signal.h>
#endif	KERNEL

struct sigframe {  /* the following is pushed on the stack during a signal */
	int sf_signum;               /* space for first parameter */
	int sf_code;                 /* space for second parameter */
	struct sigcontext *sf_scp;   /* space for third parameter */
	struct sigcontext sf_sc;     /* actual sigcontext */
	struct floatsave sf_floatsave;  /* floating-point virtual machine */
#define MAX_EXCEPTIONS 2	     /* max number of exceptions */
};

struct ex_packet {
	int	ex_ctl;			/* exception control */
	int	ex_addr;		/* exception address */
	int	ex_data;		/* exception data */
	int	ex_rsv;			/* reserved */
};
