/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*	softint.h	*/

/*
 * CPU level 6 is used for software interrupts.
 *
 * The softlevel word contains one bit representing which software
 * interrupt routine is requested.
 *
 * SOFT_ALL is the OR of all the valid bits and
 * is used for defensive programming.
 */

/*
 * Bit positions for softlevel
 */

#define SOFT_CLOCK	1
#define SOFT_NET	2
#define SOFT_TTY	0x4
#define SOFT_ALL	(SOFT_CLOCK | SOFT_NET)

#if defined(KERNEL) && !defined(LOCORE)

int	softlevel;

#endif
