/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * Copyright (c) 1986 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 ***********************************************************************
 * HISTORY
 *  6-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Generic kernels are only bootable from hd, or fd when these
 *	devices are configured.
 *
 * 31-Mar-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed asm("wait") to asmwait();
 *
 * 28-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Added missing NSTC conditional around reference to driver
 *	structure.
 *	[ V5.1(F8) ]
 *
 * 17-Dec-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Installed latest version of getchar() from acis.
 *
 * 16-Jul-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Zapped swapdev and argdev and associated code.
 *
 *  7-Jul-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Removed unnecessary include of pte.h
 *
 ***********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include "fd.h"
#include "hd.h"
#include "st.h"
/*	swapgeneric.c	6.1	83/08/05	*/


#include "../h/param.h"
#include "../h/conf.h"
#include "../h/buf.h"
#include "../h/vm.h"
#include "../h/systm.h"
#include "../h/reboot.h"
#include "../caio/ioccvar.h"

/*
 * Generic configuration;  all in one
 */
int dmmin, dmmax, dmtext;


#if	NHDC > 0
extern struct iocc_driver hdcdriver;
#endif	NHDC
#if	NFDC > 0
extern struct iocc_driver fdcdriver;
#endif	NFDC
#if	NSTC > 0
extern struct iocc_driver stcdriver;
#endif	NSTC

struct genericconf {
	caddr_t gc_driver;
	char *gc_name;
	dev_t gc_root;
} genericconf[] = {
#if	NHDC > 0
	{ (caddr_t) & hdcdriver, "hd", makedev(1, 0), },
#endif	NHDC
#if	NFDC > 0
	{ (caddr_t) & fdcdriver, "fd", makedev(3, 0), },
#endif	NFDC
#if	NSTC > 0
	{ (caddr_t) & stcdriver, "st", makedev(5, 0), },
#endif	NSTC > 0
	{ 0 },
};

setconf()
{
	register struct iocc_device *mi;
	register struct genericconf *gc;
	int unit, swaponroot = 0;

	if (boothowto & RB_ASKNAME) {
		char name[128];		
retry:
		printf("root device? "); 
		gets(name);

		for (gc = genericconf; gc->gc_driver; gc++)
			if (gc->gc_name[0] == name[0] &&
			    gc->gc_name[1] == name[1])
				goto gotit;
		goto bad;
gotit:
		if (name[3] == '*') {
			name[3] = name[4];
			swaponroot++;
		}
		if (name[2] >= '0' && name[2] <= '7' && name[3] == 0) {
			unit = name[2] - '0';
			goto found;
		}
		printf("bad/missing unit number\n");
bad:
		printf("use hd%%d, fd%%d, ud%%d, or st%%d\n");
		goto retry;
	}
	unit = 0;
	for (gc = genericconf; gc->gc_driver; gc++) {
		for (mi = ioccdinit; mi->iod_driver; mi++) {
			if (mi->iod_alive == 0)
				continue;
			if (mi->iod_unit == 0 && mi->iod_driver ==
			    (struct iocc_driver *)gc->gc_driver) {
				printf("root on %s0\n",

				    mi->iod_driver->idr_dname);
				goto found;
			}
		}
	}
	printf("no suitable root\n");
	while (1) asmwait();
found:
	gc->gc_root = makedev(major(gc->gc_root), unit * 8);
	rootdev = gc->gc_root;
}


gets(cp)
	char *cp;
{
	register char *lp;
	register c;

	lp = cp;
	for (;;) {
		c = getchar() & 0177;
		switch (c) {
		case '\n':
		case '\r':
			*lp++ = '\0';
			return;
		case '\b':
		case '#':
			lp--;
			if (lp < cp)
				lp = cp;
			continue;
		case '@':
		case 'u' & 037:
			lp = cp;
			cnputc('\n');
			continue;
		default:
			*lp++ = c;
		}
	}
}


#define KBD_DATA	0x01		  /* value for data present */
#define NONE_FLAG	0x80		  /* flag for no code defined */

#include "../cacons/screen_conf.h"
getchar()
{
	register int c, ch;
	int iid;
	extern int _init_kbd;
	extern SCREEN_INFO cons[];
	extern int cons_if;

	for (;;) {
		ch = kls_raw_read(&iid);
		if (iid != KBD_DATA)
			continue;
		if (((c = kbde_key_scan(&cons[cons_if], ch)) & NONE_FLAG) == 0)
			break;
	}
	if (c == '\r')
		c = '\n';
	cnputc(c);
	return (c);
}

