/*
 ****************************************************************
 * Mach Operating System
 * Copyright (c) 1986 Carnegie-Mellon University
 *  
 * This software was developed by the Mach operating system
 * project at Carnegie-Mellon University's Department of Computer
 * Science. Software contributors as of May 1986 include Mike Accetta, 
 * Robert Baron, William Bolosky, Jonathan Chew, David Golub, 
 * Glenn Marcy, Richard Rashid, Avie Tevanian and Michael Young. 
 * 
 * Some software in these files are derived from sources other
 * than CMU.  Previous copyright and other source notices are
 * preserved below and permission to use such software is
 * dependent on licenses from those institutions.
 * 
 * Permission to use the CMU portion of this software for 
 * any non-commercial research and development purpose is
 * granted with the understanding that appropriate credit
 * will be given to CMU, the Mach project and its authors.
 * The Mach project would appreciate being notified of any
 * modifications and of redistribution of this software so that
 * bug fixes and enhancements may be distributed to users.
 *
 * All other rights are reserved to Carnegie-Mellon University.
 ****************************************************************
 * HISTORY
 * $Log:	syscall_sw.h,v $
 * Revision 2.2  88/10/11  10:07:49  rpd
 * 	Major modifications to kernel_trap:
 * 	  The _trap_name symbol is defined correctly now,
 * 	  so pointers to system calls should work.
 * 	
 * 	  Now traps pass 6 arguments in registers.
 * 	
 * 	  errno processing is no longer done.
 * 	[88/10/06  12:14:43  rpd]
 * 
 *  1-Apr-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Fixed to always pass in 5 parameters (in r2-r6).
 *	If you need to send in more than 5, then you must fix
 *	kernel_trap and also fix ../ca/trap.c.
 *
 *  1-Sep-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created from mach_syscalls.h in the user library sources.
 ****************************************************************
 */

#ifndef	_MACHINE_SYSCALL_SW_
#define	_MACHINE_SYSCALL_SW_	1

#define kernel_trap(trap_name, trap_number, number_args)	\
	.set	.oVpcc, 0					\
	.set	.oVncs, 0					\
	.globl	_/**/trap_name;					\
	.globl	_./**/trap_name;				\
								\
	.data;							\
_/**/trap_name:							\
	.long _./**/trap_name;					\
								\
	.text;							\
_./**/trap_name:						\
	ai	r1,r1,-8;					\
	st	r6,0(r1);					\
	st	r7,4(r1);					\
	l	r6,8(r1);					\
	l	r7,12(r1);					\
	svc	trap_number(r0);				\
	l	r6,0(r1);					\
	l	r7,4(r1);					\
	brx	r15;						\
	ai	r1,r1,8;					\
								\
	.ltorg;							\
	.align	2

#endif	_MACHINE_SYSCALL_SW_
