/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ***********************************************************************
 * HISTORY
 * $Log:	trap.c,v $
 * Revision 2.11  88/12/19  02:38:29  mwyoung
 * 	Remove lint.
 * 	[88/12/18            mwyoung]
 * 	
 * 	Remove old MACH conditionals.
 * 	[88/12/14            mwyoung]
 * 
 * Revision 2.10  88/11/23  17:12:03  rpd
 * 	Picked up changes (mostly machine check handling) from Acis.
 * 	[88/11/04  17:22:07  rpd]
 * 
 * Revision 2.9  88/10/18  03:17:01  mwyoung
 * 	Condense stale history... summary left below.
 * 	[88/10/10            mwyoung]
 * 	
 * 	Check for thread halt after user page fault.
 * 	[88/09/16            mwyoung]
 * 
 * Revision 2.8  88/10/11  11:33:36  rpd
 * 	Mach traps can have up to 6 arguments now.
 * 	[88/10/06  12:15:39  rpd]
 * 
 * Revision 2.7  88/08/24  01:43:44  mwyoung
 * 	Corrected include file references.
 * 	[88/08/22            mwyoung]
 * 
 * Revision 2.6  88/08/22  21:39:47  mja
 * 	Don't clear resource pause notify flag on entry into system
 * 	call; add EDQUOT case to the fspause() check temporarily until
 * 	the two cases are better distinguished; collapse conditionals.
 * 	[88/08/08  15:53:57  mja]
 * 
 * Revision 2.5  88/07/18  16:53:55  mwyoung
 * Recover from truncation anomaly... cause unkown.
 * 
 * Revision 2.4  88/07/17  17:51:11  mwyoung
 * Distinguish users of kernel VM in a new way.
 * 
 * MACH_XP: For kernel_only tasks, try fault on the current task's
 * map first.
 * 
 *
 * 20-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added a call to klswait() after each call to kbdreset().  This
 *	conforms with new kls driver changes from acis.  
 *
 * 28-Mar-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Set the locr0[INFO] field with the exception information to
 *	allow the user to get at it with thread_get_state().
 *
 * *********
 *
 *	Summary of significant history:
 *		Support for floating point units (sanzi).
 *		Handle thread termination and exceptions (dbg, dlb, sanzi).
 *		Add profiling hooks (sanzi).
 *		Incorporate APC double fault handling and other ACIS
 *		updates (bolosky).
 *		KDB support (dpj).
 *		Initial conversion from ACIS version to MACH and CMUCS
 *		standards. (bolosky)
 *
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <mach.h>
#include <cmucs.h>
#include <cmucs_kdb.h>
#include <cmucs_rfs.h>
#include <romp_apc.h>
#include <romp_debug.h>
#include <vice.h>
#include <psp.h>

#ifdef	hc
pragma off(optimize);
#endif	hc

#include <ca/debug.h>
#include <ca/frame.h>
#include <ca/scr.h>
#include <ca/rosetta.h>
#include <ca/reg.h>
#include <ca/cpu.h>
#include <ca/io.h>
#if	ROMP_APC
#include <ca/ioim.h>
#endif	ROMP_APC

#include <sys/param.h>
#include <sys/vmparam.h>
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/acct.h>
#include <sys/kernel.h>
#include <sys/vmmeter.h>

#if	MACH
#include <kern/parallel.h>
#include <sys/kern_return.h>
#include <sys/task.h>
#include <sys/thread.h>
#include <vm/vm_map.h>
#include <vm/vm_kern.h>
#include <vm/pmap.h>
#include <vm/vm_param.h>
#include <kern/syscall_sw.h>
#include <sys/exception.h>
#include <sys/ux_exception.h>
#endif	MACH

#define SYSCALLTRACE
#ifdef SYSCALLTRACE || CMUCS_RFS
#include <bsd/syscalls.c>
#endif SYSCALLTRACE || CMUCS_RFS


#define IPAGE_FAULT	(PCS_KNOWN+PCS_IADDR)
#define DPAGE_FAULT 	(PCS_KNOWN+PCS_DADDR)
#define ILL_OP		(PCS_KNOWN+PCS_BAD_I)
#define PRIV_OP		(PCS_KNOWN+PCS_PRIV_I)
#if	ROMP_APC
#define DPAGE_FAULT2 	(PCS_UNKNOWN+PCS_DADDR)
#endif	ROMP_APC

#if	CMUCS
extern 	struct	sysent	cmusysent[];
extern 	int 	ncmusysent;
extern 	int 	nallsysent;
#endif	CMUCS

extern 	long 	master_idle;
struct 	sysent 	sysent[];
int 	nsysent;
char 	*mcpcfmt = MCPCFMT;
char 	*icsfmt = ICSFMT;
int 	_csr;				  /* the csr contents after trap */
					  /* just ICS without CS */
int addupc_r15 = 1;			  /* if we should use r15 if iar isn't good */

#if	ROMP_DEBUG					  
#if	ROMP_APC
#define SHOW_MUX	0x80000000	/* trdebug: show apc_mux calls */
#define SHOW_MUX2	0x40000000	/* trdebug: show apc_mux results */
#endif	ROMP_APC
#define TR_SHOW_REGS	0x20000000	/* trdebug: show registers */
#endif	ROMP_DEBUG

#if	MACH
#define	rosetta_fault_type(ser)	(ser&RTA_EX_HACK ? 			\
		VM_PROT_READ:VM_PROT_WRITE|VM_PROT_READ)
#define	rosetta_page_fault(ser) (ser&RTA_EX_FAULT)
#define	rosetta_prot_fault(ser)	(ser&RTA_EX_KEYS)
#define	rosetta_fault(ser)	(ser&(RTA_EX_FAULT|RTA_EX_KEYS))
#define	IOSPACE_SEG		0xf

/*
 * Called from the trap handler when a processor trap occurs.
 *   mcs_pcs   = machine check status and program check status
 *   info = specific to type of check (eg rosetta exception register)
 *
 * Note that some high order bits of the mcs_pcs are used to simulate the
 *   breakpoint and AST conditions of the VAX.
 */
/*ARGSUSED*/
trap(mcs_pcs, info, locr0)
	register mcs_pcs, info;
	register int *locr0;
{
#define ics_cs locr0[ICSCS]
	struct 	proc 	*p;
	vm_map_t	map;
	kern_return_t	result;	
	label_t 	*recover;
	vm_prot_t	fault_type;
	char 		*epitaph;
	struct 	timeval	syst;

	int	exc_type, exc_code, exc_subcode;

	int 	save_error;

	DEBUGF(trdebug,
	    prstate("trap", mcs_pcs, info, locr0[IAR], ics_cs, locr0));

	if (!USERMODE(ics_cs)) {
	    /*
	     *	Trap in system mode.  We allow page faults
	     *	in certain circumstances, as well as fpa related
	     *	exceptions.
	     */
		switch(mcs_pcs) {
		    case DPAGE_FAULT2:
		        switch (locr0[ECR_COUNT]) {
			    case 2:
			    	apc_mux(locr0);
				/* fall through */
			    case 1:
			    	info = (locr0[EX1_ADDR] & (-NBPG)) |
					(info&(NBPG-1));
				break;
			    default:
			    	epitaph = "unrecognized exception count";
			    	goto grave;
			}
			/* fall through */
		    case DPAGE_FAULT: {
		    	if (current_thread() != THREAD_NULL) {
			    save_error = u.u_error;
			    u.u_error = 0;
			}
			/*
			 *	Certain types of FPA exceptions
			 *	do not set FAULT/PROTECTION bits
			 *	of the Segment Exception Register,
			 *	and hence are not Page Faults.
			 *
			 *	However, the mc881 can fault doing
			 *	Hardware Assisted DMA to memory, either
			 *	because the memory is write protected, or
			 *	because the page it is DMA-ing to is
			 *	invalid.
			 */
			if ((!rosetta_fault(info))
			      || (rosetta_fault(info)
			          && (GETSEG(info) == IOSPACE_SEG))) {
				      
			    if (float_pci(mcs_pcs,info,locr0)) return;
			    
			    recover = (label_t *) current_thread()->recover;
			    
			    if (recover != NULL) {
				longjmp(recover);
			    }
			    epitaph = "unhandled segment 0xf exception!";
			    goto grave;
			}
		    
			if ((GETSEG(info) == SYS_SEG) && !current_task()->kernel_vm_space)
				map = kernel_map;
			else
				map = current_thread()->task->map;

			fault_type = rosetta_fault_type(info);
		    
			result = vm_fault(map,
					trunc_page((vm_offset_t) info),
					fault_type,
					FALSE);

			if ((result != KERN_SUCCESS) && current_task()->kernel_vm_space)
				result = vm_fault(kernel_map,
					trunc_page((vm_offset_t) info),
					fault_type,
					FALSE);

			while (thread_should_halt())
				thread_halt_self();

			if (current_thread() != THREAD_NULL) {
			    u.u_error = save_error;
			}
		    
			if (result == KERN_SUCCESS) {
			    return;
			}
#if	CMUCS_KDB
			{
				/*
				 * The kernel debugger has its own 
				 * recovery hook.
				 */
				extern int kdbtrapok;
				if (kdbtrapok) {
					kdb_trap(mcs_pcs,locr0);
					return;
				}
			}
#endif	CMUCS_KDB
			recover = (label_t *) current_thread()->recover;
			    
			if (recover != NULL) {
			    longjmp(recover);
			}

			epitaph = "unhandled kernel page fault!";
			goto grave;
		    } /* end case DPAGE_FAULT */
		    
		    case IPAGE_FAULT: {
			epitaph = "Instruction Page Fault in Kernel Mode";
			goto grave;
		    }

		    case MCS_CHECK: {
		    	epitaph = "machine check";
			goto grave;
		    }

		    default: {
#if	CMUCS_KDB
			if (kdb_trap(mcs_pcs,locr0))
				return;
			/* fall through */
#endif	CMUCS_KDB			
			printf("unknown trap type: mcs_pcs = 0x%x\n",mcs_pcs);
			epitaph = "trap";
			goto grave;
		    }
		}
	} /* end if (!USERMODE(icscs)) */

	mcs_pcs |= USER;
	p = u.u_procp;
	if (p) {
	    syst = u.u_ru.ru_stime;
	    u.u_ar0 = locr0;
	}
	exc_code = 0;
	exc_subcode = 0;

	switch(mcs_pcs) {
	    case MCS_CHECK + MCS_PMUC_TO + MCS_DATA_TO + USER:
	    case MCS_CHECK + MCS_PMUC_TO + USER:
	    case MCS_CHECK + MCS_DATA_TO + USER:
	    case MCS_CHECK + MCS_INS_TO + USER:
	    case MCS_CHECK + USER: {
		printf("machine check in user mode ... ");
		klsreset();		  /* reinitialize keyboard */
		klswait();		  /* and wait until done */
		printf("keyboard init done\n");
#if	NPSP > 0
		pspreset();
		printf("psp init done.\n");
#endif	NPSP
		exc_type = EXC_BAD_ACCESS;
		exc_code = EXC_ROMP_MCHECK;
		exc_subcode = info;
		locr0[MCSPCS] = mcs_pcs;
		locr0[INFO] = info;
		break;			/* call thread_doexception() */
	    }
	    
	    case DPAGE_FAULT2 | USER:
	        switch (locr0[ECR_COUNT]) {
		    case 2:
		    	apc_mux(locr0);
			/* fall through */
		    case 1:
		    	info = (locr0[EX1_ADDR] & (-NBPG)) |
				(info&(NBPG-1));
			break;
		    default:
		    	epitaph = "unrecognized exception count";
		    	goto grave;
		}
		/* fall through */
	    case DPAGE_FAULT | USER: 
	    case IPAGE_FAULT | USER: {
		save_error = u.u_error;
		u.u_error = 0;
		/*
		 *	Certain types of FPA exceptions
		 *	do not set FAULT/PROTECTION bits
		 *	of the Segment Exception Register,
		 *	and hence are not Page Faults.
		 *
		 *	However, the mc881 can fault doing
		 *	Hardware Assisted DMA to memory, either
		 *	because the memory is write protected, or
		 *	because the page it is DMA-ing to is
		 *	invalid.
		 */
		if ((!rosetta_fault(info))
		      || (rosetta_fault(info)
		          && ((GETSEG(info) == IOSPACE_SEG)))) {
			      
		    if (float_pci(mcs_pcs,info,locr0)) return;

		    exc_type = EXC_BAD_ACCESS;
		    exc_code = KERN_INVALID_ADDRESS;
		    exc_subcode = info;
		    locr0[MCSPCS] = mcs_pcs;
		    locr0[INFO] = info;
		    break; 	/* call thread_doexception() */
		}
		map = current_thread()->task->map;

		fault_type = rosetta_fault_type(info);
		    
		result = vm_fault(map,
				trunc_page((vm_offset_t) info),
				fault_type,
				FALSE);

		while (thread_should_halt())
			thread_halt_self();

		u.u_error = save_error;
			
		if (result == KERN_SUCCESS) {
		    return;
		}
		exc_type = EXC_BAD_ACCESS;
		exc_code = result;
		exc_subcode = info;
		locr0[INFO] = info;
		break;
	    }
	    
	    case VAST | USER: {
		astoff();
		if (p) {
		    if ((p->p_flag & SOWEUPC) && u.u_prof.pr_scale) {
			addupc(locr0[IAR],&u.u_prof,1);
			p->p_flag &= ~SOWEUPC;
		    }
		}
		goto out;
	    }

	    case BKPT | USER:  {	/* breakpoint only in USER mode */
	        ics_cs &= ~ICSCS_INSTSTEP;
		exc_type = EXC_BREAKPOINT;
		exc_code = EXC_ROMP_TRAP_INST;
		break;
	    }
	    
	    case STEP | USER:  {	/* inst step  only in USER mode */
	        ics_cs &= ~ICSCS_INSTSTEP;
		exc_type = EXC_BREAKPOINT;
		exc_code = EXC_ROMP_INST_STEP;
		break;
	    }
	    case ILL_OP | USER: {
	    	exc_type = EXC_BAD_INSTRUCTION;
		exc_code = EXC_ROMP_ILLEGAL_INST;
		break;
	    }
	    case PRIV_OP | USER: {
	    	exc_type = EXC_BAD_INSTRUCTION;
		exc_code = EXC_ROMP_PRIV_INST;
		break;
	    }
	    default:  {
	    	printf("Unknown user Trap type 0x%x info 0x%x\n",mcs_pcs,info);
#if	ROMP_RDB
		Debugger("Unknown user trap");
#else	ROMP_RDB
#if	CMUCS_KDB
		kdb_trap(mcs_pcs,locr0);
#endif	CMUCS_KDB
#endif	ROMP_RDB
		return;
	    }
	    	
	}	/* end switch(mcs_pcs) for USER */
	thread_doexception(current_thread(),exc_type,exc_code,exc_subcode);

out:
	if (p) {
	    if (CHECK_SIGNALS(p,current_thread()->u_address.uthread)) {
		unix_master();
		if (p->p_cursig || issig())
		    psig();
		unix_release();
	    }
	}

	while (thread_should_halt()) thread_halt_self();

	if (runrun[cpu_number()] && csw_check()) {
	    (void) splhigh();
	    runrun[cpu_number()] = 0;
	    u.u_ru.ru_nivcsw++;
	    thread_block();
	}

	if (u.u_prof.pr_scale) {
	    int ticks;
	    struct timeval *tv = &u.u_ru.ru_stime;

	    ticks = (tv->tv_sec - syst.tv_sec) * hz +
			(tv->tv_usec - syst.tv_usec) / tick;
	    if (ticks)
			addupc(locr0[IAR], &u.u_prof, ticks);
	}
	return;
	
grave:
	splhigh();
	prstate("trap", mcs_pcs, info, ics_cs, locr0);
	panic(epitaph);
}
#undef	ics_cs
#else	MACH
/*
 * Called from the trap handler when a processor trap occurs.
 *   mcs_pcs   = machine check status and program check status
 *   info = specific to type of check (eg rosetta exception register)
 *
 * Note that some high order bits of the mcs_pcs are used to simulate the
 *   breakpoint and AST conditions of the VAX.
 */
/*ARGSUSED*/
	b_mcs_pcs, b_info, b_ics_cs, b_error, b_iar, b_regaddr, b_ft;
trap(mcs_pcs, info, locr0)
	register mcs_pcs, info;
	register int *locr0;
{
#define ics_cs locr0[ICSCS]
	register int i;
	struct proc *p;
	char *epitaph;
	vm_map_t	map;
	label_t 	*recover;
	vm_prot_t	fault_type;

	struct timeval syst;

	DEBUGF(trdebug,
	    prstate("trap", mcs_pcs, info, locr0[IAR], ics_cs, locr0));

	syst = u.u_ru.ru_stime;
#if	MACH
#else	MACH
	cnt.v_trap++;		/* count traps */
#endif	MACH

	if (ICSCS_PROBSTATE & ics_cs) {
		mcs_pcs |= USER;
		u.u_ar0 = locr0;
	}
		b_info = info; b_mcs_pcs = mcs_pcs; b_ics_cs = ics_cs;
		b_iar = locr0[IAR]; b_regaddr = (int)locr0; 
	switch (mcs_pcs) {
	default:
#if	CMUCS_KDB
		if (kdb_trap(mcs_pcs,locr0))
			return;
		/* fall through */
#endif	CMUCS_KDB
		if (mcs_pcs & MCS_CHECK) {	/* machine check */
			if (mcs_pcs & USER) {	/* machine check in user mode */
				printf("machine check in user mode ...\n");
				prstate("machine check", mcs_pcs, info, locr0[IAR], ics_cs, locr0);
				klsreset();	/* reinitialize keyboard */
				klswait();	/* and wait until done */
				printf("keyboard init done.\n");
#if NPSP > 0
				pspreset();
				printf("psp init done.\n");
#endif NPSP
				i = SIGBUS;
				break;
			} else {	/* machine check in kernel mode */
				epitaph = "machine check";
				klsreset();	/* reinitialize keyboard */
				spl0();		/* allow interrupts */
				klswait();	/* and wait until done */
			}
		} else if (mcs_pcs & USER) {
			printf("trap: unknown trap (0x%b) in user mode\n",
				mcs_pcs, mcpcfmt);
			i = SIGSEGV;
			break;
		} else {	/* else unknown trap in kernel mode */
			epitaph = "trap";
		}
		goto grave;

#if	ROMP_APC
	case DPAGE_FAULT2:
	case DPAGE_FAULT2 + USER:
		if (locr0[ECR_COUNT] == 0) {
			epitaph = "nothing on exception stack";
			goto grave;
		}
		if (locr0[ECR_COUNT] > 1)
			apc_mux(locr0);	/* handle multiple exceptions */
		info = (info&(NBPG-1)) | (locr0[EX1_ADDR] & (-NBPG));
/* Debug */	b_info = info;
		/* fall thru for now */
#endif	ROMP_APC
	case DPAGE_FAULT + USER:	  /* data page fault */
	case IPAGE_FAULT + USER:	  /* inst page fault */
	case DPAGE_FAULT:
		if ((current_thread() != THREAD_NULL)
		   && (ICSCS_PROBSTATE & ics_cs)) {
			i = u.u_error;
			u.u_error = 0;
		}
		/*
		 *	Determine which map to "fault" on.
		 *	If the faulting address is a kernel
		 *	address, make sure we were executing
		 *	in kernel mode.
		 *
		 *	XXX - The following check for system
		 *	segment should be in a macro somewhere
		 *	just in case we change it someday - Avie
		 *	We can't change this--it's built into the
		 *	Rosetta hardware.  But it should be a macro
		 *	anyway. - Bill
		 */
		if ((((((vm_offset_t)info) & 0xf0000000) >> 28) == SYS_SEG) &&
			!(ICSCS_PROBSTATE & ics_cs)) {

			map = kernel_map;
		} else
			map = current_task()->map;
		if (info & RTA_EX_HACK)
			fault_type =  VM_PROT_READ;
		else
			fault_type = VM_PROT_READ|VM_PROT_WRITE;


		b_ft = fault_type;
		/*
		 *	Make sure that either it was a page fault
		 *	(or a protection problem) in
		 *	segment 0xf (which could be an fpa problem) or
		 *	that rosetta set neither the fault nor the protection
		 *	bits.  If the former is true, then we have an FPA
		 *	exception.  If the latter is true, then either
		 *	the  user referenced a bad address in the io
		 *	segment or it is an FPA exception.   Since it's
		 *	not so easy to determine the bad address which
		 * 	was referenced, we'll just call the fpa procedure,
		 *	which will (probably) allocate an fpa register set.
		 *	If the problem wasn't related to the fpa, the
		 *	process will just fault again, and the FPA code
		 *	won't claim the problem, so we'll bus error them
		 *	on the second pass...
		 *
		 * 	Note that the mc881 performs DMA accesses to memory
		 *	on behalf of the user, and therefore exceptions
		 *	from the 881 might be both rosetta address faults
		 *	as well as rosetta protection faults.
		 */
		if (((info & (RTA_EX_FAULT|RTA_EX_KEYS))
			&& GETSEG(info) == 0xf)
			|| (((info & (RTA_EX_FAULT|RTA_EX_KEYS)) == 0))) {
			if ((mcs_pcs == DPAGE_FAULT) ||
			    (mcs_pcs == DPAGE_FAULT2)) {
			    /*
			     * just return when fpa faults in kernel mode.
			     */
			    if (float_pci(mcs_pcs,info,locr0)) return;
			    else {
				/*
				 * The kernel (in copyin()/ copyout())
				 * may have referenced a bad address
				 * on behalf of the user.
				 */
				if (current_thread() != THREAD_NULL)
				    recover = (label_t *) 
					current_thread()->recover;
				if (recover != NULL) {
					longjmp(recover);
				}

				while (thread_should_halt())
					thread_halt_self();

				/*
				 * The user must be doing something highly
				 * bogus, send tactical nuke signal.
				 */
				psignal(u.u_procp,SIGSEGV);
				return;	
			    }
			}
			else {
			    if (float_pci(mcs_pcs,info,locr0)) goto out;
			    else goto lost;
			}
		}

		if (b_error = (vm_fault(map,
			trunc_page((vm_offset_t) info), fault_type,FALSE)
					!= KERN_SUCCESS)) {
			/*
			 *	If we're in the copyin/copyout routines,
			 *	we want to return control to the failure
			 *	return address that has been saved in
			 *	the thread table.
			 */
lost:
			if ((current_thread() != THREAD_NULL)
			   && (ICSCS_PROBSTATE & ics_cs)) 
				u.u_error = i;
#if	CMUCS_KDB
			{
				/*
				 * The kernel debugger has its own 
				 * recovery hook.
				 */
				extern int kdbtrapok;
				if (kdbtrapok) {
					kdb_trap(mcs_pcs,locr0);
					return;
				}
			}
#endif	CMUCS_KDB
			recover = (label_t *)current_thread()->recover;
			if (recover != NULL) {
				longjmp(recover);
			}
			i = SIGSEGV;
			break;
		}

		while (thread_should_halt())
			thread_halt_self();

		if ((current_thread() != THREAD_NULL)
		   && (ICSCS_PROBSTATE & ics_cs)) 
			u.u_error = i;
		return;
		
	case IPAGE_FAULT:
			epitaph = "instruction page fault in kernel mode";
			goto grave;
	case USER:	panic("wrongo!");

	case BKPT + USER:		  /* allow breakspoint inst only in user mode */
	case STEP + USER:		  /* allow inst step only in user mode */
		ics_cs &= ~ICSCS_INSTSTEP; /* probably off already */
		i = SIGTRAP;
		break;

	case VAST + USER:		  /* allow VAX AST only in user mode */
		astoff();		  /* once is enough */
		/*
		 * we attempt to first profile the IAR, if that doesn't
		 * work we try r15. This is primarily so that the generated
		 * floating point code gets attributed to the calling C
		 * code rather than lost.
		 */
		if ((u.u_procp->p_flag & SOWEUPC) && u.u_prof.pr_scale) {
			if (!addupc(locr0[IAR], &u.u_prof, 1) && addupc_r15)
				addupc(locr0[R15], &u.u_prof, 1);
			u.u_procp->p_flag &= ~SOWEUPC;
		}
		goto out;

	case ILL_OP + USER:		  /* illegal instruction */
	case PRIV_OP + USER:		  /* privileged instruction */
		u.u_code = mcs_pcs - USER;
		i = SIGILL;
		break;

	}
	/* end of switch mcs_pcs */
	thread_psignal(current_thread(), i);
out:
	p = u.u_procp;
	if (CHECK_SIGNALS(p, current_thread()->u_address.uthread)) {
		if (p->p_cursig || issig())
			psig();
	}

	p->p_pri = p->p_usrpri;

	if (ICSCS_PROBSTATE & ics_cs) {
		/*
		 *	If trapped from user mode, handle possible
		 *	rescheduling or termination.
		 */
		while (thread_should_halt())
			thread_halt_self();

		if (runrun[cpu_number()] && csw_check()) {
			(void) spl6();
			runrun[cpu_number()] = 0;
			u.u_ru.ru_nivcsw++;
			thread_block();
		}
	}
	if (u.u_prof.pr_scale) {
		register int    ticks;
		register struct timeval *tv = &u.u_ru.ru_stime;

		ticks = (tv->tv_sec - syst.tv_sec) * hz +
			(tv->tv_usec - syst.tv_usec) / tick;
		if (ticks)
			addupc(locr0[IAR], &u.u_prof, ticks);
	}
	return;

    grave:
	spl7();
	prstate("trap", mcs_pcs, info, ics_cs, locr0);
	panic(epitaph);
}
#undef	ics_cs
#endif	MACH

/*
 * the register address map such that regs[regmap[0]] gets r0.
 */

char regmap[] = {
	R0, R1, R2, R3, R4, R5, R6, R7, R8, R9, R10, R11, R12, R13, R14, R15 };
/*
 * print the machine state
 * iar, mcs_pcs, ics_cs, general registers
 */
prstate(name, mcs_pcs, info, iar, ics_cs, regs)
	register char *name;
	register int mcs_pcs, info, ics_cs;
	register int *regs;
	short *iar;
{
	register int i;
	printf("%s: mcs_pcs=0x%b, info=0x%b, iar=0x%x, ics_cs=0x%b\n",
	    name, mcs_pcs, mcpcfmt,
	    info,"\20\1DATA\2PROTECTION\3TLB-SPECIFICATION\4PAGE-FAULT\5MULTIPLE\6EXTERNAL-DEVICE\7IPT-SPECIFICATION\10ROS-WRITE\12TLB-RELOAD\13CORRECTABLE-ECC",
	    iar, ics_cs, icsfmt);
	csr_print();
	if (regs) {
		for (i=0; i<16; ) {
			if ((i & 0x03) == 0)
				printf("R%x ... R%x ",i,i+3);
			prhex((char *) (regs + regmap[i]), sizeof (int));
			if ((++i & 0x03) == 0)
				printf("\n");
		}
	}
#if	ROMP_APC
		if (cpu_model == CPU_ROMPC && regs[ECR_COUNT])
			{
			print_ecr(regs[ECR_COUNT], (int) &regs[EX1_CTL]);
#define PRINT(value) if (regs[EX_/**/value]) printf("value=%x ",regs[EX_/**/value])
			PRINT(GSR1);
			PRINT(REP1);
			PRINT(GSR2);
			PRINT(REP2);
			}
#endif	ROMP_APC
	printser();
}

prhex(ptr,n)
	register char * ptr;
	register int n;
{
/*
 * print "n" bytes pointed to by "ptr" in hex
 * we do this because the kernel printf isn't smart
 * enought to print out a specified number of digits.
 */
	while (--n >= 0) {
		putnibble(*ptr >> 4);
		putnibble(*ptr);
		++ptr;
	}
	printf(" ");
}

static
putnibble(n)
	register int n;
{
	printf("%c","0123456789abcdef"[n&0x0f]);
}

/*
 * nonexistent system call-- signal process (may want to handle it)
 * flag error if process won't see signal immediately
 * Q: should we do that all the time ??
 */
nosys()
{
	if (u.u_signal[SIGSYS] == SIG_IGN || u.u_signal[SIGSYS] == SIG_HOLD)
		u.u_error = EINVAL;
#if	MACH
	thread_doexception(current_thread(), EXC_SOFTWARE,
		EXC_UNIX_BAD_SYSCALL, 0);
#else	MACH
	psignal(u.u_procp, SIGSYS);
#endif	MACH
}


static
csr_print()
{
	register int csr = *(int volatile *)CSR;
	printf("CSR=%b\n", csr,
			"\20\11PIO-PENDING\12PLANAR-BUSY\13CH-RESET-CAPTURED\14DMA-EXECPTION\15I/O-CHECK\16INV-OPERATION\17PROT-VIOLATION\20PIO-DMA\21DMA-ERR-CH8\22DMA-ERR-CH7\23DMA-ERR-CH6\24DMA-ERR-CH5\25DMA-ERR-CH3\26DMA-ERR-CH2\27DMA-ERR-CH1\30DMA-ERR-CH0\31PIO-ERR\33SYSTEM-ATTN\34SOFT-RESET\35POWER\37INTR-PENDING\40EXCEPTION");	_csr = csr;		/* save it for later */
	}


#include <machine/fp.h>
#include <machine/softint.h>

void
saveFP(savearea)
	FP_MACH * savearea;
{
	*savearea = machine;
}


void
restoreFP(savearea)
	FP_MACH * savearea;
{
	machine = *savearea;
}


void
slih6(dev, icscs, iar)
	register dev_t dev;
	register int icscs;
	register int iar;
{
	FP_MACH fpregs;

#ifdef	lint
	dev++;
#endif	lint

	saveFP(&fpregs);

	while (softlevel) {

		if (softlevel & SOFT_CLOCK) {
			softlevel &= ~SOFT_CLOCK;
			softclock(iar,icscs);
		}
		if (softlevel & SOFT_NET) {
			softlevel &= ~SOFT_NET;
#ifdef INET
			softnet();
#endif
		}
		if (softlevel & SOFT_TTY) {
		    softlevel &= ~SOFT_TTY;
		    softTTY();
		}
		if (softlevel & ~SOFT_ALL) {
			printf("slih6: undefined bit(s) set in softlevel: %x\n",
			    softlevel);
			softlevel &= SOFT_ALL;
		}
	}
	restoreFP(&fpregs);
}


#define ON(x) (x) ? "1" : "0"


static
printser
()
{
/* cannot use ROSE_IOBASE because it doesn't return a value (DUMB!) */
	register int rosebase = ROSEBASE; /* get base address */
#if	ROMP_DEBUG
	extern int ser;
#else	ROMP_DEBUG
	register int ser = ior(rosebase + ROSE_SER);
#endif	ROMP_DEBUG
	register int reg;

	printf("SER=%b ", ser,
	    "\20\1DATA\2PROTECTION\3TLB-SPECIFICATION\4PAGE-FAULT\5MULTIPLE\6EXTERNAL-DEVICE\7IPT-SPECIFICATION\10ROS-WRITE\12TLB-RELOAD\13CORRECTABLE-ECC\14STORAGE\15LOAD\16I/O-ADDRESS\17STORAGE-ADDRESS\20RSC-NAKDN\21RSC-NAKDA\22SEGMENT-VIOLATION");
	printf("SEAR=%x ", ior(rosebase + ROSE_SEAR));
	printf("TRAR=%x ", ior(rosebase + ROSE_TRAR));
	reg = ior(rosebase + ROSE_TCR);
	printf("TCR=%b HAT/IPT=%x\n", reg,
		"\20\114K-PAGE\12RESERVED\13INTR-TLB-RELOAD\14INTR-CECC\15TLIPT\16RAS-DIAG\17ISPER\20V=R", reg & 0xff);
}

syscall(mcs_pcs, info, locr0)
	register int info;
	int mcs_pcs;
	register int *locr0;
{
#define	ics_cs	locr0[ICSCS]
	int i;
	caddr_t params;
	struct sysent *callp;
	int opc;
	register int pno;
	struct timeval syst;
	struct proc *p = u.u_procp;
	register struct uthread *uthread=current_thread()->u_address.uthread;
	register struct utask *utask = current_thread()->u_address.utask;

#ifdef	lint
	mcs_pcs++;
#endif	lint

	syst = u.u_ru.ru_stime;
#if	MACH
#else	MACH
	cnt.v_syscall++;		/* count sys calls */
#endif	MACH	
	if (info == 139) { 	/* This undefined syscall is used by */
		sigcleanup();	/* the signal trampoline code, to do */
		goto out;	/* the return from the user signal   */
	}

#ifdef KPROF
	if (info == 199) { /* kernel profiling added by JEC */
		kernprof(locr0[R2], locr0[R3]);
		goto out;
	}
#endif KPROF

	opc = locr0[IAR] - 4;		/* address of svc inst */

	uthread->uu_error = 0;			/* optimistic */
/* This strange left-shift/right shift sign extends i(nfo) into an int */
	if ((i = ((info<<16)>>16))) {
		uthread->uu_arg[0] = locr0[R2];
		uthread->uu_arg[1] = locr0[R3];
		uthread->uu_arg[2] = locr0[R4];

		if (utask->uu_calltype) {
			uthread->uu_arg[3] = locr0[R5];
			pno = 4;
		} else
			pno = 3;
	} else {	  /* indirection */
		i = locr0[R2];
		uthread->uu_arg[0] = locr0[R3];
		uthread->uu_arg[1] = locr0[R4];

		if (utask->uu_calltype) {
			uthread->uu_arg[2] = locr0[R5];
			pno = 3;
		} else
			pno = 2;
	}
	if ((i < -ncmusysent) && !(i < (-ncmusysent - mach_trap_count))) {
		if (utask->uu_calltype)
		   locr0[R2] = do_mp_syscall(info,locr0[R2],
			locr0[R3],locr0[R4],locr0[R5],locr0[R6],locr0[R7]);
		else
		   locr0[R0] = do_mp_syscall(info,locr0[R2],
			locr0[R3],locr0[R4],locr0[R5],locr0[R6]);
		ics_cs &= ~ICSCS_TESTBIT;			
		goto out;
	}
	callp = ((u_short)(i + ncmusysent) > nallsysent)
	 	? &sysent[63] : &sysent[i];
	if (utask->uu_calltype)
		params = (caddr_t)locr0[SP] + ARG5_OFFSET;
	else
		params = (caddr_t)locr0[SP] + 3 * sizeof(int);
	for (; pno < callp->sy_narg; ++pno) {
		uthread->uu_arg[pno] = fuword(params);
		params += sizeof(int);
	}
	uthread->uu_ap = uthread->uu_arg;
	if (utask->uu_calltype) {
		uthread->uu_r.r_val1 = 0;
		uthread->uu_r.r_val2 = locr0[R0];
	} else {
		uthread->uu_r.r_val1 = 0;
		uthread->uu_r.r_val2 = locr0[R2];
	}
	if (setjmp(&uthread->uu_qsave)) {
		if (uthread->uu_error == 0 && uthread->uu_eosys == JUSTRETURN)
			uthread->uu_error = EINTR;
	} else {
		uthread->uu_eosys = JUSTRETURN;
#ifdef SYSCALLTRACE
		if (svdebug && (!svpid || (svpid == p->p_pid))) {
			register int arg_i;
			char *cp;
			if (info >= nsysent) printf("0x%x", info);
			else
				printf("%s", syscallnames[info]);
			cp = "(";
			for (arg_i = 0; arg_i < callp->sy_narg; arg_i++) {
				printf("%s%x", cp, uthread->uu_arg[arg_i]);
				cp = ", ";
			}
			if (arg_i)	putchar(')', 0);
			printf(" pid=%d\n", p->p_pid);
		}
#else	SYSCALLTRACE
	if (svdebug &&
	    (!svpid || (svpid == p->p_pid)))
		printf("Syscall %d routed for pid %d\n", info, 
			p->p_pid);
#endif	SYSCALLTRACE
#if	CMUCS_RFS
	/*
	 *  Remember the system call we are executing so that it
	 *  can be handled remotely if need be.
	 */
	uthread->uu_rfsncnt = 0;
	uthread->uu_rfscode = info;
#endif CMUCS_RFS
#if	VICE
	uthread->uu_rmt_ncnt = 0;
	uthread->uu_rmt_code = i;
#endif	VICE
#if	CMUCS
	/*
	 *  Show no resource pause conditions (except for a possible polled
	 *  pause in the process of being retried).
	 */
	uthread->uu_rpswhich &= URPW_NOTIFY;
	uthread->uu_rpsfs = 0;
#endif	CMUCS
	(*(callp->sy_call))(); 		/* off we go! */
 
	if (svdebug && (svdebug > 1 || uthread->uu_error) &&
		 (!svpid || (svpid == p->p_pid)))
		printf("%s completed for pid %d error %d returns 0x%x 0x%x\n",
		    syscallnames[info], p->p_pid, uthread->uu_error,
		    uthread->uu_r.r_val1,
		    uthread->uu_r.r_val2);
	}
#if	CMUCS_RFS
 /*
  *  The special error number EREMOTE is used by the remote system call
  *  facility to short-circuit standard system call processing when the
  *  equivalent has already been done remotely.  It serves simply to
  *  unwind the call stack back to this point when the call has actually
  *  been completed successfully.  It is not an error and should not be
  *  relected back to the user process.
  *
  *  Also, clear the system call code value to indicate that we are no
  *  longer in a system call.  I don't think this is actually necessary
  *  since any calls on namei() will probably have to have come through
  *  a system call and remote processing must have been specifically
  *  enabled by the caller of namei().  Nevertheless, namei() will still
  *  check this value before actually making a remote call and it nevers
  *  hurts to be safe.
  */
	if (uthread->uu_error == EREMOTE)
		uthread->uu_error = 0;	
	uthread->uu_rfscode = 0;
#endif	CMUCS_RFS
#if	VICE
	if (uthread->uu_error == EVICEOP)
		uthread->uu_error = 0;
	uthread->uu_rmt_code = 0;
#endif	VICE
#if	CMUCS
	switch (uthread->uu_error) {
		case EDQUOT:	/* temp == ENOSPC */
		case ENOSPC:
		{
	/*
	 *  The error number ENOSPC indicates disk block or inode
	 *  exhaustion on a file system.  When this occurs during a
	 *  system call, the fsfull() routine will record the file
	 *  system pointer and type of failure (1=disk block, 2=inode)
	 *  in the U area.  If we return from a system call with this
	 *  error set, invoke the fspause() routine to determine
	 *  whether or not to enter a resource pause.  It will check
	 *  that the resource pause fields have been set in the U area
	 *  (then clearing them) and that the process has enabled such
	 *  waits before clearing the error number and pausing.  If a
	 *  signal occurs during the sleep, we will return with a false
	 *  value and the error number set back to ENOSPC.  If the wait
	 *  completes successfully, we return here with a true value.
	 *  In this case, we simply restart the current system call to
	 *  retry the operation.
	 *
	 *  Note:  Certain system calls can not be restarted this
	 *  easily since they may partially complete before running
	 *  into a resource problem.  At the moment, the read() and
	 *  write() calls and their variants have this characteristic
	 *  when performing multiple block operations.  Thus, the
	 *  resource exhaustion processing for these calls must be
	 *  handled directly within the system calls themselves.  When
	 *  they return to this point (even with ENOSPC set), the
	 *  resource pause fields in the U area will have been cleared
	 *  by their previous calls on fspause() and no action will be
	 *  taken here.
	 */
		if (fspause(0))
		    uthread->uu_eosys = RESTARTSYS;
		break;
		}
	    /*
	     *  TODO:  Handle these error numbers, also.
	     */
		case EAGAIN:
		case ENOMEM:
		case ENFILE: /* need a statement here */ ;
	}
#endif	CMUCS
	ics_cs &= ~ICSCS_TESTBIT;
	if (uthread->uu_eosys == RESTARTSYS)
		locr0[IAR] = opc; /* backup IAR to re-execute svc */
	else if (uthread->uu_error) {
		if (utask->uu_calltype) 
			locr0[R2] = uthread->uu_error;
		else
			locr0[R0] = uthread->uu_error;
		ics_cs |= ICSCS_TESTBIT;
	} else {
		if (utask->uu_calltype) {
			locr0[R2] = uthread->uu_r.r_val1;
			locr0[R0] = uthread->uu_r.r_val2;
		} else {
			locr0[R0] = uthread->uu_r.r_val1;
				locr0[R2] = uthread->uu_r.r_val2;
		}
	}
out: {
	if (CHECK_SIGNALS(p, uthread)) {
		if (p->p_cursig || issig())
			psig();
	}				

	p->p_pri = p->p_usrpri;

	while (thread_should_halt())
		thread_halt_self();

	if (runrun[cpu_number()] && csw_check()) {
		(void) spl6();
		runrun[cpu_number()] = 0;
		utask->uu_ru.ru_nivcsw++;
		thread_block();
	}

	if (utask->uu_prof.pr_scale) {
		register int    ticks;
		register struct timeval *tv = &u.u_ru.ru_stime;

		ticks = (tv->tv_sec - syst.tv_sec) * hz +
			(tv->tv_usec - syst.tv_usec) / tick;
		if (ticks)
			addupc(locr0[IAR], &utask->uu_prof, ticks);
	}
return;
    }
}
#undef	ics_cs

/*
 *	This handles a mach syscall (one whose number is less than the cmu
 *	extra syscalls in this implementation).
 */

int do_mp_syscall(info, arg0, arg1, arg2, arg3, arg4)
	register int info;
{
	int		syscall_no = -(info<<16)>>16;
					/* Turn signed 16-bit integer into
					 * a sign-extended 32-bit integer
					 */

#if	ROMP_DEBUG
	if (svdebug && (!svpid || (svpid == u.u_procp->p_pid))) 
		printf("Mach syscall #%d.\n",info);
#endif	ROMP_DEBUG
	if (mach_trap_table[syscall_no].mach_trap_function)
		return(u.u_r.r_val1 =
			(*(mach_trap_table[syscall_no].mach_trap_function))
				(arg0,arg1,arg2,arg3,arg4)); 
	return(0);
}



#if	ROMP_APC

static char *ec_length[] = { "c", "h", "", "ts" };
static char *ec_ops[] = { "l", "lm", "ior", "la", "st", "stm", "iow", "?" };
static char *ec_cancel[] = { "", "-" };

static
print_ecr(ecr_count,ecr_addr)
{
	if ((unsigned) ecr_count <= 2) {
		printf("exception stack(%d):",ecr_count);
		for (; ecr_count-- > 0; ecr_addr += 16) {
			int reg = * (unsigned short *)(ecr_addr+2);
			
			printf("\t%s%s%s r%d,%x ",
				ec_cancel[reg&1],	/* cancelled? */
				ec_ops[(reg>>3)&0x07],	/* storage operation */
				ec_length[(reg>>6)&0x03],	/* operation length */
				(reg>>8)&0x0f,		/* register number */
				* (int *)(ecr_addr+4)	/* address */
				);
			if (reg&(0x04<<3))
				printf("[%x] ", * (int *)(ecr_addr+8));	/* data value */
		}
		printf("\n");
	}
}

static char ioim[] = {
	1, 0, 0, 0, 		/* 0 1 2 3 */
	1, 0, 0, 0, 		/* 4 5 6 7 */
	0, 0, 0, 0, 		/* 8 9 A B */
	2, 2, 1, 1		/* C D E F */
};

#define ISLOCKED_68881() (ior(IOIM2+IOIM_SUB_PROB) & SEG_C) == 0 /* if 68881 locked */

/*
 * handle sticky cases where the second of certain multiple exceptions must be
 * either simulated or eliminated as the operation will have actually taken
 * place.
 */

static
apc_mux(locr0)
register int *locr0;
{
 int addr2 = locr0[EX2_ADDR];
 int ctl2 = locr0[EX2_CTL];

 DEBUGF(trdebug & SHOW_MUX,
	prstate("apc_mux", locr0[MCSPCS], locr0[INFO], (short *) locr0[IAR], 
			locr0[ICSCS],locr0));
 if (GETSEG(addr2) == 0xf && ! IS_IOR_IOW(ctl2) &&
		(IS_IOCC(addr2) || IS_68881(addr2)) ) {
	/*
	 * If here, the newest exception (2nd one) is from the IOCC (IOIM1),
	 * or the MC68881 (IOIM2). 
	 * Check to see if the oldest exception was from the same channel
	 * as the newest. If it was, and it was not an IOR/IOW, then the 
	 * newest exception was rejected at the IOIM, and it was totally
	 * restartable.
	 * Note that if the first exception was an IOR, then this does not
	 * serialize the channel, so the 2nd exception would have gone thru.
	 */
	int addr1 = locr0[EX1_ADDR];
	int ctl1 = locr0[EX1_CTL];
	if (!IS_IOR_IOW(ctl1) &&
			ioim[GETSUBSEG(addr1)] == ioim[GETSUBSEG(addr2)]){
		/*
		 * both exceptions from same channel - serialized 
		 */
		DEBUGF(trdebug & SHOW_MUX2,printf("apc_mux: both ioim%d\n",
			ioim[GETSUBSEG(addr1)]));
		return;
	}
	if (IS_68881(addr2)) {
		/*
		 * we control access to the 68881 by "locking" it. This
		 * is done by turning off problem state access it its
		 * subsegments when we want to detect access to it.
		 * any "lock" exception to the 68881 is just an PMUC 
		 * exception and, as the 2nd exception, is totally
		 * restartable.
		 */
		if ((cpu_model == CPU_ROMPC) && !ISLOCKED_68881()) {
		/*
		 * check for Store/Load. Unconditionally discard Loads
		 * as the second exception in the stack for the 68881.
		 * Note that the test for a load as the 2nd exception 
		 * is only against the high order bit of the storage
		 * operation field in the exception control word.
		 * We have already verified that the second exception
		 * is not an IORead, and a LM is a serializing 
		 * instruction, so we should never see it as a second
		 * exception in the stack following a store. This leaves
		 * only Load and LHA which do serialize after a Store.
		 */
			if (IS_STORE(ctl1) && !IS_STORE(ctl2))
				discard_load(locr0);
			else
				/*
				 * 68881 is 2nd exception, 
				 * not Store/Load
				 * abort the 68881 unless the 68881
				 * is reporting a take exception
				 */
				mc881_abort(locr0);
		}
	} else {
	/*
	 * the IOCC was the 2nd exception in the stack, and the first
	 * exception was from a different channel or was an IOR
	 */
		if ((_csr = *(int *)CSR) & 0x80000000) {
		/*
		 * bit 0 of the CSR is set indicating the IOCC reported
		 * the program check.
		 */
			* (int *) CSR = 0;	/* reset CSR */
			DEBUGF(trdebug & SHOW_MUX2,{
				printf("apc_mux: IOCC ");
				csr_print();
				});
		} else if (IS_STORE(ctl1) && !IS_STORE(ctl2) &&
				(locr0[EX_GSR1] & IOIM_PARITY_REC) == 0){
			discard_load(locr0);	/* throw away the load */
		}

	}
 }

}

static
discard_load(locr0)
register int *locr0;
{
 int ctl2 = locr0[EX2_CTL];
 int addr2 = locr0[EX2_ADDR];
 int reply = 
    locr0[ioim[GETSUBSEG(addr2)] == 1 ? EX_REP1 : EX_REP2];   /* get reply */
 
 DEBUGF(trdebug & SHOW_MUX2,
	prstate("discard_load",locr0[MCSPCS],locr0[INFO],(short *) locr0[IAR], 
		locr0[ICSCS], locr0));
 
 if (IS_CANCELLED(ctl2)) {
	DEBUGF(trdebug & SHOW_MUX2,
		printf("apc_mux: discard_load - cancelled\n"));
	return;		/* already cancelled */
 }
	
 /*
  * normalize the PMUC Reply Register:
  * for byte and halfword loads, the reply data is not kept right
  * justified in the register, but rather its location is a
  * function of the low 2 or 1 bit(2) of the address packets
  * (respectively).
  */

 switch(EX_GETLEN(ctl2)) {
	case EX_BYTE:
		reply = (reply >> ((~addr2) & 03) * 8) & 0xff;
		break;
	case EX_HALF:
		reply = (reply >> ((~addr2) & 01) * 16) & 0xffff;
		if (EX_GETOP(ctl2) == EX_LHA)
			reply = (reply<<16) >> 16;	/* extend sign */
		break;
	case EX_WORD:
		break;		/* already in correct place */
	case EX_TS:
		return;		/* no action for TSH */
	}
 DEBUGF(trdebug & SHOW_MUX2,
	printf("apc_mux: discard_load: reply=%x len=%s reg=%d\n",reply,
		ec_length[EX_GETLEN(ctl2)],EX_GETREG(ctl2)));
 /*
  * Now, the reply data is normalized, and the Test and Set Halves
  * have been screened.
  * Cancel the Load, and update the context save area. 
  */
 locr0[R0 + EX_GETREG(ctl2)] = reply;	/* update proper register */
 --locr0[ECR_COUNT];	/* get rid of this exception */
}
#endif	ROMP_APC

/*
 * addupc takes an 'iar' in the user text and finds the appropriate
 * cell in the profiling array and increments it. 
 * it replaces a version written in assembler on the vax.
 * it special cases the common values for pr_scale (1, 1/2, 1/4 etc)
 * which are done by shifts. the more general case is done via
 * upcmul which does a 32x32 bit product and drops the bottom 16 bits.
 */
static
addupc(iar, prof, ticks)
	register int iar;
	register struct uuprof *prof;
	register int ticks;
{
	register int x = (iar - prof->pr_off) >> 1;
	register short *buf;
	label_t jmpbuf;
	int s;
	
	if (x < 0)
		goto out;
	switch(prof->pr_scale)
		{
	case 0x10000:
		break;
	case 0x8000:
		x >>= 1;
		break;
	case 0x4000:
		x >>= 2;
		break;
	case 0x2000:
		x >>= 3;
		break;
	case 0x1000:
		x >>= 4;
		break;
	case 0x800:
		x >>= 5;
		break;
	default:
		x = upcmul((unsigned) x, prof->pr_scale);
		break;
		}
	if (((unsigned)x<<1) >= prof->pr_size)
		goto out;
	buf = prof->pr_base + x;
	/*
	 *	make sure we can write to the destination address
	 */
	s = splvm();
	if (setjmp(&jmpbuf)) {
	    /*
	     *	We faulted trying to either write or read the user's
	     *	profiling buffer.  Hence we shut of profiling.
	     */
	    current_thread()->recover = NULL;
	    splx(s);
	    prof->pr_scale = 0;
	    return;
	}
	current_thread()->recover = (vm_offset_t)&jmpbuf;
	buf[0] += ticks;
	current_thread()->recover = NULL;
	splx(s);
out:
	return;
}
