/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ***********************************************************************
 * HISTORY
 * $Log:	vmparam.h,v $
 * Revision 2.4  88/11/23  16:28:08  rpd
 * 	More Acis merge and cleanup.
 * 	[88/11/13  22:22:47  rpd]
 * 
 * Revision 2.3  88/10/18  00:28:44  mwyoung
 * 	Added define of USRTEXT
 * 	[88/10/17            mrt]
 * 
 * 10-Dec-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Corrected definition of USER_FPM.
 *
 *  7-Dec-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Modified include conditionals around "ca/fp.h".
 *
 * 18-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Eliminated declaration of sigcode -- we do not want to export it
 *	to the user. 
 *
 * 21-May-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	MACH_TT : Redefined ENDOFP1 to be VM_MAX_ADDRESS, and added new
 *	definition -- SIGCODE_ADDRESS.
 *
 * 13-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Conditionalized MAXDSIZ, among others.
 *
 * 12-Sep-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Castrated.
 *
 ***********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */



#ifdef	KERNEL
#include <mach.h>
#else	KERNEL
#include <sys/features.h>
#endif	KERNEL

/*
 * Machine dependent constants for ROMP
 */
/*
 * USRTEXT is the start of the user text/data space, while USRSTACK
 * is the top (end) of the user stack.  LOWPAGES and HIGHPAGES are
 * the number of pages from the beginning of the P0 region to the
 * beginning of the text and from the beginning of the P1 region to the
 * beginning of the stack respectively.
 */
#define USRTEXT		0

#if	!defined(LOCORE) && !defined(ASSEMBLER)
#include <ca/fp.h>
#endif	!defined(LOCORE) && !defined(ASSEMBLER)

#if	MACH
#define ENDOFP1         0xe0000000  /* first address past P1 */

/*
 * should be  extern int sigcode[3] but we do not want to export
 * the sigcode variable to the user.
 *
 *	The name "SIGCODE_SIZE" is not quite accurate.
 */
 
#define	SIGCODE_SIZE (sizeof(int) * 3 + sizeof (struct fp_mach) )

/*
 * The user's floating point emulator status goes between the sigcode
 * and the start of the user stack.
 */

#define USER_FPM 	(ENDOFP1-sizeof(struct fp_mach))

#define	USRSTACK	(ENDOFP1-SIGCODE_SIZE)

#define	SIGCODE_ADDRESS	(USRSTACK)
#else	MACH

#define ENDOFP1         0xd0000000  /* first address past P1 */
#define	USRSTACK        0xc0000000  /* stack builds down from top of seg c.*/
#define UAREA           (ENDOFP1-UPAGES*NBPG) /* start of u area */
#define uareabase(u)    ((caddr_t)(u)+sizeof(struct user)-UPAGES*NBPG)

#define USER_FPM         (USRSTACK-sizeof(struct fp_mach))

#endif	MACH

/*
 * Virtual memory related constants ??? JEC ???
 */

#ifndef	SLOP
#define SLOP    32
#endif	SLOP

#ifndef	MAXTSIZ
#define MAXTSIZ         ((6*2048-SLOP) * 1024)  /* max text size */
#endif	MAXTSIZ

#ifndef	DFLDSIZ
#define	DFLDSIZ		(6*1024*1024)		/* initial data size limit */
#endif	DFLDSIZ

#ifndef	MAXDSIZ
#define MAXDSIZ         ((12*1024-32-SLOP) * 1024)  /* max data size */
#endif	MAXDSIZ

#ifndef	DFLSSIZ
#define	DFLSSIZ		(512*1024)		/* initial stack size limit */
#endif	DFLSSIZ

#ifndef	MAXSSIZ
#define MAXSSIZ         ((12*1024-32-SLOP) * 1024) /* max stack size */
#endif	MAXSSIZ

