/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	aedtty.h,v $
 * Revision 2.3  88/10/06  17:02:36  sanzi
 * 	Added include of "device_base.h".
 * 
 */ 
#include <cacons/device_base.h>

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: aedtty.h,v 2.3 88/10/06 17:02:36 sanzi Exp $ */
/* $ACIS:aedtty.h 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/aedtty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidaed_tty = "$Header: aedtty.h,v 2.3 88/10/06 17:02:36 sanzi Exp $";
#endif

#define AED_MMAP	0xf40a0000
#define AED_DELAY	DELAY(2)

#define aedrd(X,Y,Z) bcopy(AED_MMAP+Z, X, Y+Y)
#define aedwr(X,Y,Z) bcopy(X, (AED_MMAP+Z), Y+Y)


#define term_mode	0x0200
#define setup_mode	0x0300
#define data_port	0x4000
#define status_port	0x4002

char *aedbase = (char *)AED_MMAP;

short *aed_data;
short *aed_status;
extern int delay_count;

#define AEDTMO (delay_count*256)
static	aed_to = 0;

#define vinit() aed_data = (short *)(aedbase + data_port);

#define vwait()	{register int tmo = aed_to ? 1 : AEDTMO;\
			while (*aed_data) {\
				if(tmo-- < 0) {\
					if(aed_screen_init()) {\
						aed_to = 1;\
						break;\
					}\
					tmo = AEDTMO;\
					aed_to = 0; \
				}\
				AED_DELAY; \
			} }
#define vterm(c)	{ \
			vwait(); \
			AED_DELAY;\
			*aed_data = (term_mode | c); \
			AED_DELAY;}

#define vsetup(c)	{ vwait();\
			AED_DELAY;\
			*aed_data = (setup_mode | c); \
			AED_DELAY; }
