/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	apa8tty.h,v $
 * Revision 2.2  88/10/06  17:23:57  sanzi
 * 	Added include of "device_base.h".
 * 
 */ 
#include <cacons/device_base.h>

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: apa8tty.h,v 2.2 88/10/06 17:23:57 sanzi Exp $ */
/* $ACIS:apa8tty.h 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/apa8tty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidapaEtty = "$Header: apa8tty.h,v 2.2 88/10/06 17:23:57 sanzi Exp $";
#endif

#include <cacons/apa_structs.h>

#define FALSE 0
#define TRUE  1

/*
 * Control register (short)
 */
#define FC 0xF0000160
/*
 * Data mask registers (2 each 8 bits)
 */
#define DM 0xF0000162

/*
 * Display memory for the APA-8
 */
#define FB 0xF4D00000
#define APA8BASE 0xF4D00000


/* bits 0-2  rotate count */
#define DCR_ROTMASK 0x0007

/* bits 3-5  logic unit function control */
#define DCR_FCMASK	0x0038
#define DCR_FCOR	0x0028
#define DCR_FCNOR	0x0038
#define DCR_FCPA	0x0010
#define DCR_FCPB	0x0000
#define DCR_FCPNA	0x0030
#define DCR_FCPNB	0x0020

#define DEFAULT_FUNC	DCR_FCPNB
#define HIDDEN_FUNC     DCR_FCPA
#define RDWR_FUNC	DCR_FCPA

/* 6-7 reserved */

/* 8-9 memory mode */
#define DCR_MEMMODE	0x0300
#define DCR_SWR		0x0000
#define DCR_ISWR	0x0100
#define DCR_ADWR	0x0200
#define DCR_AURW	0x0300

/* 10 inc/dec of the address counter */
#define DCR_DEC		0x0400
#define DCR_INC		~0x0400

/* 11 x/y stepping */
#define DCR_X		0x0800
#define DCR_Y		~0x0800

/* 12  1 means block transfer */
#define DCR_BT		0x1000

/* 13  1 means interrupt enable */
#define DCR_IEN		0x2000

/* 14  1 means Sync enable */
#define DCR_SEN		0x4000

/* 15  1 means Video enable */
#define DCR_VEN		0x8000

/* Data Mask Register masks (typically are the inverse of each other) */
#define DM_A		0xff00
#define DM_B		0x00ff

#define CLEAR_DM	0x0000
#define DEFAULT_DM	DM_B
#define HIDDEN_DM       DM_A
#define RDWR_DM		DM_A
#define ALL_DM		0xffff

/*
 * values for the writemask.
 */
#define NOMASK 0x0000
#define MASKBYTE2 0x00ff
#define MASKBYTE1 0xff00

/*
 * NOTE: A SCREEN is the visible area of the display.
 *	 A BITMAP is the whole display.
 *	 A HIDDEN is the hidden area of the display.
 */

/* Screen dimensions in pixels */

/*
 * screen width.
 */
#define SCREEN_WD	720
#define HIDDEN_WD	304
#define BITMAP_WD	(HIDDEN_WD + SCREEN_WD)

/*
 * screen height.
 */
#define SCREEN_HT	512


/*
 * Screen dimensions in bytes. Return BITMAP offsets.
 *
 * BITMAP_BYTE_WD is BITMAP_WD divided by 8 to get the number of bytes in 
 * a scan line.
 */

/*
 * screen width in bytes.
 */
#define SCREEN_BYTE_WD	90
#define HIDDEN_BYTE_WD	38
#define BITMAP_BYTE_WD	(HIDDEN_BYTE_WD + SCREEN_BYTE_WD)

/*
 * screen width in words
 */
#define SCREEN_WORD_WD DIV_BPW(SCREEN_WD)
#define HIDDEN_WORD_WD DIV_BPW(HIDDEN_WD)
#define BITMAP_WORD_WD DIV_BPW(BITMAP_WD)

#define TOP_SCANLINE 0

/*
 * The increment to the next scanline directly below the current scanline.
 */
#define NEXT_SL		(BITMAP_BYTE_WD)

/*
 * Bitmap to BUS address offsets.  All address offsets in the bitmap area
 * must be multiplied by 2 before being used as BUS offsets.
 */
#define BM_TO_BUS(n)	((n) << 1)

/*
 * Converts a bus address (0xf4d00000 - 0xf4d1ff00) to the scan line
 * number. (0 - 511)
 */
#define BUS_TO_SL(bus) (((int)bus & 0x1ff00) >> 8)
#define SL_TO_BUS(sl)  ((sl) << 8)

/*
 * Convert a logical line number to physical scan lines in the bitmap.
 */
#define LINE_TO_SL(line)	(((line) * col_ht) + TOP_SCANLINE)

/*
 * Convert a physical scan line to a logical line number.
 */
#define SL_TO_LINE(sl)	((sl - TOP_SCANLINE)/col_ht)

/*
 * The next macro takes a line number (1 - 32) and returns the BUS 
 * address for that line. It used to. des 4/11/86
 */
#define LINE_TO_BUS(line) (line_addr[line])

/*
 * Now set up logical columns...
 */
#define FIRSTCOL 0
#define FIRSTLINE 0

/*
 * Convert logical columns to actual bytes in a scanline.
 */
#define COL_TO_BM(col) (DIV_BPB((col)*col_wd))

/*
 * Converts columns to BUS bytes without the BASE.
 */
#define COL_TO_BUS(col) (col_addr[col])

/*
 * Converts column to the rotate amount.
 */
#define COL_TO_ROTATE(col) ((8 - ((col)*col_wd)) & DCR_ROTMASK)

/*
 * The physical bitmap addresses on the apa8 adaptor card
 * go from 0000 to 0xffff. (the size of a short or word, 16 bits addresses
 * these spots.
 */
#define MAXOFFSET 0xffff

/*
 * This is defined to be the last scan line in the hidden area.
 * It is needed because the side affect of setting the writemask registers
 * is the mask is also written to the bitmap.
 */
#define WRMASK_APA8BASE (*(unsigned short *)(APA8BASE + BM_TO_BUS(MAXOFFSET-1)))

#define SET_FC(control_info)	{					\
	*(unsigned short *) FC = (unsigned short)(control_info);	\
}

#define SET_WRITEMASK(mask) {						\
	SET_FC(DCR_SEN | DCR_VEN | DCR_ISWR | DCR_X | DCR_FCOR);	\
	WRMASK_APA8BASE = (unsigned short) mask;			\
}

#define SET_DATAMASK(mask) {						\
	*(unsigned short *)DM = (unsigned short)mask;			\
}

/*
 * Macros to indicate the type of function being performed.
 */
#define IS_OR(func)	(func & 0x0008)
#define IS_A(func)	((func & 0x0010) && !(IS_OR(func))) 
#define IS_B(func)	(!(func & 0x0010) && !(IS_OR(func)))

/*
 * create a macro that does a "not" on the function control call.  By "not"
 * I mean turn a pass through A or B into a not pass through A or B
 * and turn an A or B into a not (A or B)
 */
#define NOTFC(N)  (IS_OR(N) ? ((N) ^ 0x0010) : ((N) ^ 0x0020))

#define IS_NOT_FUNC(N) ((N & 0x0020) && ((N & DCR_FCMASK) != DCR_FCOR))


