/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/*
 * HISTORY
 * $Log:	buf_emul.c,v $
 * Revision 2.3  88/10/06  17:32:04  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Purge log.
 * 
 */
#include <cacons/device_base.h>
 
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: buf_emul.c,v 2.3 88/10/06 17:32:04 sanzi Exp $ */
/* $ACIS:buf_emul.c 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/buf_emul.c,v $ */

#ifndef lint
static char *rcsid = "$Header: buf_emul.c,v 2.3 88/10/06 17:32:04 sanzi Exp $";
#endif

/* Routines for a buffering output emulator.
 */
#include <sys/param.h>
#include <sys/conf.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/errno.h>

#include <cacons/screen_conf.h>
#include <cacons/consdefs.h>
#include <cacons/consvars.h>
#include <cacons/buf_emul.h>
#ifdef ATR
/*
 * defines to supprot the IOCTL
 */
#include <sys/dir.h>
#include <sys/user.h>
#include <ca/io.h>
#include <ca_atr/pcif.h>
#include "vga.h"
#include "ibmvbarmmmdxiv.h"
#if	NVGA > 0
extern int vga_nmodes;
extern unsigned vga_mode;
extern int  vga_screen_type;
extern int  vga_open;
#endif VGA
#if	NIBMVBARMMMDXIV > 0
extern int ibm8514_exists;
extern int ibm8514_open;
#endif 8514
#define NEGA	0
#else !ATR
#define NEGA 0
#if NEGA > 0
extern int ega_screen_type;
#endif
#define NIBMVBARMMMDXIV 0
#define NVGA 0
#endif !ATR

static int buf_maxchar = (BUF_CMAX/CBSIZE) * CBSIZE;	/* limit on number of characters */ 

struct clist buf_cq[NUMBER_CONS];
char buf_flag[NUMBER_CONS];


buf_open(dev, tp, si)
int dev;
register struct tty *tp;
register SCREEN_INFO *si;
{
	register struct clist *b = &buf_cq[WS];

	if ((buf_flag[WS] & BUF_ISOPEN) == 0) {
		buf_flag[WS] = BUF_ISOPEN;
		b->c_cc = 0;
		b->c_cf = b->c_cl = 0;
	}
	return (0);
}

buf_write(tp, uio, si)
register struct tty *tp;
struct uio *uio;
register SCREEN_INFO *si;
{
	return ((*linesw[tp->t_line].l_write)(tp, uio));
}

/*
 * output a character to the buffer.
 *	If a kernel panic is detected, restore console functions,
 *	flush buffer, and allow panic processing to proceed.
 */

extern char *panicstr;

buf_putc(c, si)
register int c;
register SCREEN_INFO *si;
{
	register struct clist *b = &buf_cq[WS];

	if ((b->c_cc > buf_maxchar) || (putc(c, b)))
		ndflush(b, CBSIZE);
	
	if (panicstr) /* do this after putting char in buffer */
		panic_restore(WS);
	return(0);	
}

/* 
 *	pass back a character from buffer
 */

buf_getc(which)
register int which;
{
	register struct clist *b = &buf_cq[which];

	return(getc(b));	/* which will be -1 if empty */
}

buf_ioctl(tp, cmd, data, si)
	struct tty *tp;
	int    cmd;
	unsigned	*data;
	SCREEN_INFO si;
{
	switch (cmd) {

	case BUFSETWIND :
#if NVGA > 0
		/*
		 * restrict the setting of the window to display
		 * memory.
		 */
		if ((*data < VGA_SCREEN_MIN) || (*data > VGA_SCREEN_MAX)) {
			return(EINVAL); /* - Invalid argument */
		}
		*data = set_128_window(*data);
		u.u_pcb.pcb_win = (char) current_128_w;
		return(0);
#else VGA
		return(EINVAL);	/* only the VGA need access to pc memory */
#endif VGA
/*		break;	*/

	case BUFINITVGA:
#if NVGA > 0
	{
		/*
		 * initialize the VGA to a predetermined mode
		 */
		unsigned tmp = *(unsigned *)data;

		if (tmp  >= vga_nmodes) {
			return(EINVAL);
		}
		tmp = vga_mode;
		/* fool vga_screen_init() to do this for us! */
		vga_mode = *(unsigned *)data;
		vga_screen_init();
		/*
		 * tell set_type that the vga is no longer available
		 */
		vga_open = 1;
		/* 
		 * now make sure the next time vga_screen_init() is called
		 * (which is when this display device is closed and the vga
		 * returns to glass tty mode), that the display returns to
		 * it's previouse mode.
		 */
		vga_mode = tmp;
		return(0);
	}
#else VGA
		return(ENXIO);
#endif VGA
/*		break;	*/
	case BUFINIT8514:
#if NIBMVBARMMMDXIV > 0
		/*
		 * this variable is set in ibm8514 if the display adapter
		 * exists
	 	 */
		if (ibm8514_exists) {
			lo_init_8514();
			vga_set_type(vga_screen_type);
			ibm8514_open = 1;
			return(0);
		} else {
			return(ENXIO);
		}
#else 8514
		return(ENXIO);
#endif 8514
/*		break;	*/
	case BUF8514CTRL:
#if NIBMVBARMMMDXIV > 0
	{
		unsigned tmp;

		/*
		 * disable the 8514
		 */
		tmp = inw(PCIF_POS_REG);
		if (*data) {
			tmp |= 1;
		} else {
			tmp &= ~1;
		}
		outw(PCIF_POS_REG,tmp);
		return(0);
	}
#else 8514
		return(ENXIO);
#endif 8514
/*		break;	*/
	/*
	 * Return display info data
 	 */
	case BUFDISPINFO:
		*(unsigned *)data =
#ifdef ATR
		(BUF_CPU_ATR) |
#endif ATR
#ifdef IBMRTPC
		(BUF_CPU_RTPC) |
#endif IBMRTPC
#if NIBMVBARMMMDXIV > 0
		(BUF_PUT_8514(ibm8514_get_type())) |
#endif 8514
#if NVGA > 0
		(BUF_PUT_VGA(vga_get_type())) |
#endif VGA
#if NEGA > 0
		(BUF_PUT_EGA(ega_screen_type)) |
#endif EGA
				0;
		return(0);
/*		break;	*/
	default:
		return(-1);
	}
}

/*
 *	On closing a display device, if it was the current console, then
 *	reopen it, flushing any messages which were queued.
 */
buf_dump_console(which)
register int which;
{
	register SCREEN_INFO *si = &cons_info[which];
	register int c;

	/* now dump buffer */
	while ((c = buf_getc(which)) != EOBUF) {
		if (c == '\n')
			(*emulsw[si->oute.emulator].e_putc)('\r',si,0);
		(*emulsw[si->oute.emulator].e_putc)(c,si,0);
	}



	buf_flag[which] = 0;
}
/* process a kernel panic -- whichever was the active console, close its
 *	device, restore the console function, dump the message buffer.
 *	Then the panic printf is free to proceed
 */
panic_restore(which)
register int which;
{
	register SCREEN_INFO *si = &cons_info[which];
	register struct tty *tp = &cons[which];

	/* Close the Emulator just in case it isn't the default glass tty */
	(*emulsw[si->oute.emulator].e_close)(tp, si);

	/* Reinit the screen */
	sichars (which, CE_DEFAULT, si);
	(*screen_sw[WS].init)();
	screen_sw[WS].flags |= CONSDEV_INIT;

	/* Open the default emulator */
	(*emulsw[si->oute.emulator].e_open)(which, tp, si);

	buf_dump_console (which);
}

