/* 
 * Mach Operating System 
 * Copyright (c) 1988 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	buf_emul.h,v $
 * Revision 2.4  88/10/10  22:26:13  sanzi
 * 	Remove include of vgaio.h.
 * 
 * Revision 2.3  88/10/06  17:34:24  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 
 */ 
#include <cacons/device_base.h>
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: buf_emul.h,v 2.4 88/10/10 22:26:13 sanzi Exp $ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/buf_emul.h,v $ */

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char *rcsidbuf_emul = "$Header: buf_emul.h,v 2.4 88/10/10 22:26:13 sanzi Exp $";
#endif

#define BUF_CMAX	2048	/* Size of circular buffer */
#define BUF_ISOPEN	1	/* flag that buf_emul is open */

#define BUFSETWIND	_IOWR(b,0,unsigned)	/* 6152 only */
#define BUFINITVGA	_IOW(b,1,int)		/* 6152 only */
#define BUFINIT8514	_IO(b,2)		/* 6152 only */
#define BUF8514CTRL	_IOW(b,3,unsigned)	/* 6152 only */
#define BUFDISPINFO	_IOR(b,4,unsigned)	/* RT & 6152 */
/*
 * valid fields for BUFDISPINFO
 *
 * bit 31 is the CPU type (1=6152 (ATR), 0=RTPC)
 * bits 3-0 on the RT is the EGA switch settings
 * bits 3,2 on the 6152 are the 8512 display type
 * bits 1,0 on the 6152 are the vga display type
 * All other fields are reserved
 */
#define	BUF_CPU		0x80000000	/* CPU field */
#define	 BUF_CPU_ATR	0x80000000	/* CPU is ATR */
#define	 BUF_CPU_RTPC	0x00000000	/* CPU is RTPC */
#define	 BUF_IS_ATR(x)	(((x) & BUF_CPU) == BUF_CPU_ATR)
#define	 BUF_IS_RTPC(x)	(((x) & BUF_CPU) == BUF_CPU_RTPC)
#define	BUF_8514_TYPE	0x0000000c	/* type of 8514 display */
#define  BUF_GET_8514(x) (((x) & BUF_8514_TYPE) >> 2)
#define BUF_VGA_TYPE	0x00000003	/* type of VGA display */
#define  BUF_GET_VGA(x)	 ((x) & BUF_VGA_TYPE)
#define BUF_EGA_TYPE	0x0000000f	/* ega switch settings */
#define  BUF_GET_EGA(x)	 ((x) & BUF_EGA_TYPE)
#ifdef KERNEL
#define	BUF_PUT_8514(x)	 (((x) & 0x3) << 2)
#define BUF_PUT_VGA(x)	 ((x) & BUF_VGA_TYPE)
#define BUF_PUT_EGA(x)	 ((x) & BUF_EGA_TYPE)
#endif

#define BUFSETWIND	_IOWR(b,0,unsigned)	/* 6152 only */
#define BUFINITVGA	_IOW(b,1,int)		/* 6152 only */
#define BUFINIT8514	_IO(b,2)		/* 6152 only */
#define BUF8514CTRL	_IOW(b,3,unsigned)	/* 6152 only */
#define BUFDISPINFO	_IOR(b,4,unsigned)	/* RT & 6152 */
/*
 * valid fields for BUFDISPINFO
 *
 * bit 31 is the CPU type (1=6152 (ATR), 0=RTPC)
 * bits 3-0 on the RT is the EGA switch settings
 * bits 3,2 on the 6152 are the 8512 display type
 * bits 1,0 on the 6152 are the vga display type
 * All other fields are reserved
 */
#define	BUF_CPU		0x80000000	/* CPU field */
#define	 BUF_CPU_ATR	0x80000000	/* CPU is ATR */
#define	 BUF_CPU_RTPC	0x00000000	/* CPU is RTPC */
#define	 BUF_IS_ATR(x)	(((x) & BUF_CPU) == BUF_CPU_ATR)
#define	 BUF_IS_RTPC(x)	(((x) & BUF_CPU) == BUF_CPU_RTPC)
#define	BUF_8514_TYPE	0x0000000c	/* type of 8514 display */
#define  BUF_GET_8514(x) (((x) & BUF_8514_TYPE) >> 2)
#define BUF_VGA_TYPE	0x00000003	/* type of VGA display */
#define  BUF_GET_VGA(x)	 ((x) & BUF_VGA_TYPE)
#define BUF_EGA_TYPE	0x0000000f	/* ega switch settings */
#define  BUF_GET_EGA(x)	 ((x) & BUF_EGA_TYPE)
#ifdef KERNEL
#define	BUF_PUT_8514(x)	 (((x) & 0x3) << 2)
#define BUF_PUT_VGA(x)	 ((x) & BUF_VGA_TYPE)
#define BUF_PUT_EGA(x)	 ((x) & BUF_EGA_TYPE)
#endif
