/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	bus.c,v $
 * Revision 2.2  88/10/06  17:36:01  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Fix includes.
 * 
 */ 
#include <cacons/device_base.h>

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: bus.c,v 2.2 88/10/06 17:36:01 sanzi Exp $ */
/* $ACIS:bus.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/bus.c,v $ */

#ifndef lint
static char *rcsid = "$Header: bus.c,v 2.2 88/10/06 17:36:01 sanzi Exp $";
#endif

#include <sys/param.h>
#include <ca/scr.h>	/* for CCR bits */

busopen(dev,flag)
register dev_t dev;
register int flag;
{

	/* grant permission to access segment F (IOBUS),
	 * allows access to storage and I/O map
	 */
	set_ccr(CCR_SMP|CCR_IMP);

	return(0);
}


busclose(dev)
register dev_t dev;
{

	/* don't allow access to storage map */
	set_ccr(~(CCR_SMP | CCR_IMP));

	return(0);
}
