/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY
 * $Log:	consio.h,v $
 * Revision 2.4  88/10/06  17:43:02  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Fix includes.
 *  
 */ 
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: consio.h,v 2.4 88/10/06 17:43:02 sanzi Exp $ */
/* $ACIS:consio.h 9.9$ */

/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/consio.h,v $ */

#include <cacons/device_base.h>

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char *rcsidconsio = "$Header: consio.h,v 2.4 88/10/06 17:43:02 sanzi Exp $";
#endif
#define CONS_GEN	0	/* Generic console that indicates goto cons_if*/
#define CONS_AED	1
#define CONS_APA16	2
#define CONS_APA8C	3
#define CONS_APA8	4
#define CONS_EGA	5
#define CONS_MONO	6
#define CONS_MPEL	7
#define CONS_VGA	1
#define CONS_IBM8514	2
#ifndef ATR
#define CONS_DUMMY	8	/* a dummy console */
#else ATR
#define CONS_DUMMY	3	/* a dummy console */
#endif
#define CONS_EMGD	CONS_APA16
#define CONS_AMGD	CONS_APA8
#define CONS_AMGDC	CONS_APA8C

#ifdef IBMRTPC
#define NUMBER_CONS	8	/* How many possible real consoles on RT */
#else
#ifdef ATR
#define NUMBER_CONS	3	/* How many possible real consoles on ATR */
#else
#define NUMBER_CONS	10	/* How many possible real consoles the user needs to deal with */
#endif
#endif

#define CONSDEV_PRESENT 0x01	/* screen is present */
#define CONSDEV_KERNEL	0x02	/* screen is available to the kernel */
#define CONSDEV_USER	0x04	/* screen is available to the user */
#define CONSDEV_INIT	0x08	/* screen has been inited for console output */
#define CONSDEV_TTY	0x10	/* display hardware has been opened */
#define CONSDEV_GRA	0x20	/* display hardware has been opened */
#define CONSDEV_LOG	0x40	/* display is logging printfs */

#define CONSDEV_ALIVE	(CONSDEV_PRESENT | CONSDEV_KERNEL)
#define CONSDEV_USEIT	(CONSDEV_PRESENT | CONSDEV_USER)
#define CONSDEV_BOTH	(CONSDEV_KERNEL | CONSDEV_USER)
#define CONSDEV_NONE	0		/* only the two bits will be used */

#ifndef KERNEL
struct consoles_tab	{ /* to support the setscreen utility */
	char	*name;	/* which screen device */
	int	consnum;
};

#define INIT_CONSOLES_TAB	\
struct consoles_tab consoles_tab[] = {	\
	/*  NAME	CONSNUM */	\
	{"aed",		CONS_AED},	\
	{"apa16",	CONS_APA16},	\
	{"apa8c",	CONS_APA8C},	\
	{"apa8",	CONS_APA8},	\
	{"ega",		CONS_EGA},	\
	{"mono",	CONS_MONO},	\
	{"mpel",	CONS_MPEL},	\
	{"vga",		CONS_VGA},	\
	{"ibm8514",	CONS_IBM8514},	\
	{"DUMMY",	CONS_DUMMY},	\
}	/* end of INIT_CONSOLES_TAB define */
#endif ~KERNEL

struct screen_control	{
	int device;		/* which screen device to control */
	int	switches;
};

/* ioctl numbers must fit into sequence in screen_conf.h */
#define SCRIOCGETF		_IOWR(c,9,struct screen_control)/* get screen flags */
#define SCRIOCSETC		_IOWR(c,10,struct screen_control)/* set screen config */

#define EOBUF	-1

