/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/*
 * the following defines specify the escape sequences used by the 
 * ibm3101 emulator (used for ibmconsole, ibmapa8, ibmapa16 devices)
 * The cryptic codes are (generally) the termcap names for the particular
 * function.
 */

#define ESC_FOUND 0x100		       /* flag for escape found */
#define ESC_(x) ESC_FOUND+'x'		/* ESC + x */

#define UP_CHAR ESC_(A)			/* ESC A cursor up */
#define CL_CHAR	ESC_(K)			/* ESC K clear screen */
#define ND_CHAR ESC_(C)			/* ESC C non-destructive space */
#define CD_CHAR ESC_(J)			/* ESC J clear to end of screen */
#define CE_CHAR ESC_(I)			/* ESC I clear to end of line */
#define HO_CHAR ESC_(H)			/* ESC H home cursor */
#define CM_CHAR2 ESC_(Y)		/* ESC Y x y */
#define SO_CHAR	ESC_(p)			/* ESC p stand out */
#define SE_CHAR	ESC_(q)			/* ESC q stand out end */
#define HI_CHAR ESC_(Z)			/* ESC Z hi intensity */
#define LO_CHAR ESC_(z)			/* ESC z lo intensity */
#define US_CHAR ESC_(W)			/* ESC W start underline */
#define UE_CHAR ESC_(w)			/* ESC w stop underline */
#define SH_CHAR ESC_(s)			/* ESC s status line on/off */
#define SAVE_CM ESC_(j)			/* ESC j save cursor position */
#define RESTORE_CM ESC_(k)		/* ESC k restore cursor position */
#define AL_CHAR ESC_(L)			/* ESC L insert line */
#define DL_CHAR ESC_(M)			/* ESC M delete line */
#define IGN_CHAR	ESC_([)		/* ESC [ ==> ESC */
#define CURSOR_OFFSET	' '	       /* blank is normal offset value */

#ifndef lint
static char term_type[] = "ibm3101";
#endif
