/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	monotty.h,v $
 * Revision 2.2  88/10/06  18:18:42  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Fix includes.
 * 
 */ 
#include <cacons/device_base.h>

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: monotty.h,v 2.2 88/10/06 18:18:42 sanzi Exp $ */
/* $ACIS:monotty.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/monotty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidmonodefs = "$Header: monotty.h,v 2.2 88/10/06 18:18:42 sanzi Exp $";
#endif

/* Monocrome Console attribute byte definitions */
#define MONO_NORMAL_VIDEO	0x07	/* Normal Video */
#define MONO_REVERSE_VIDEO	0x70	/* Reverse Video */
#define MONO_UNDERLINE_VIDEO	0x01	/* under line */
#define MONO_HI_INTENSITY	0x08	/* High Intensity */
#define MONO_BLINK		0x80	/* blink bit */

/* Screen memory defintions */

#ifdef ATR
/*
 * For the ATR version of the system the screen buffer is really an
 * offset into the 128K byte window. We comptute this offset in
 * the probe routine, then place it into the static variable
 * mono_screen_buffer.
 */
static char *mono_screen_buffer;
#define SCREEN_BUFFER mono_screen_buffer
#endif ATR

#ifdef IBMRTPC
#define SCREEN_BUFFER	(char *) 0xf40b0000
#endif IBMRTPC

#define SCREEN_END	(SCREEN_BUFFER + SCREEN_SIZE)
#define MONO_SCREEN_LENGTH	25
#define MONO_SCREEN_WIDTH	80

/* sets Pointer where we are */
#define set_ptr(x, y) screen_ptr = lines[y] + (x<<1)
