/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	qevent.h,v $
 * Revision 2.2  88/10/06  18:25:24  sanzi
 * Added include of device_base.h.  Fixed includes.
 * 
 */ 
#include <cacons/device_base.h>

/* $Header: qevent.h,v 2.2 88/10/06 18:25:24 sanzi Exp $ */
/* $ACIS:qevent.h 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/qevent.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidqevent = "$Header: qevent.h,v 2.2 88/10/06 18:25:24 sanzi Exp $";
#endif

/*
 * Event queue entries
 */

# ifndef _XQEVENT_
# define _XQEVENT_

#ifndef CONS_AED
#	include <cacons/screen_conf.h>
#endif CONS_AED

typedef struct  _X_event {
        u_short xe_x;          /* x position */
        u_short xe_y;          /* y position */
        u_short xe_time;       /* 10 millisecond units (button only) */
        u_char xe_type;       /* button or motion? */
        u_char xe_key;        /* the key (button only) */
        u_char xe_direction;  /* which direction (button only) */
        u_char xe_device;     /* which device (button only) */
} XEvent;

/* xe_type field */
#define XE_BUTTON      0               /* button moved */
#define XE_MMOTION     1               /* mouse moved */
#define XE_TMOTION     2               /* tablet moved */

/* xe_direction field */
#define XE_KBTUP	0               /* up */
#define XE_KBTDOWN	1               /* down */
#define XE_KBTRAW	2		/* undetermined */

/* xe_device field */
#define XE_MOUSE       1               /* mouse */
#define XE_DKB         2               /* main keyboard */
#define XE_TABLET      3               /* graphics tablet */
#define XE_AUX         4               /* auxiliary */
#define XE_CONSOLE     5               /* console */

/* The event queue */

typedef struct _X_eventqueue {
	XEvent *events;		/* input event buffer */
	int size;		/* size of event buffer */
	int head;		/* index into events */
	int tail;		/* index into events */
} XEventQueue;

/* mouse cursor position */

typedef struct _X_cursor {
        short x;
        short y;
} XCursor;

/* mouse motion rectangle */

typedef struct _X_box {
        short bottom;
        short right;
        short left;
        short top;
} XBox;

struct x_screen_size {
	int	x_x_min;	/* minimum x for mouse */
	int	x_y_min;	/* minimum y for mouse */
	int	x_x_max;	/* maximum x for mouse */
	int	x_y_max;	/* maximum y for mouse */
};

struct x_softc {
	struct	x_screen_size	x_size;	/* screen size for mouse tracking */
	short	x_cursor;	/* is the kernel cursor on or off */
	short	x_notrack;	/* can the kernel cursor be turned on */
};

/* Ioctl's for event queue emulators */
#define QIOCSMSTATE	_IOW(q,0,XCursor)
#define QIOCADDR	_IOR(q,1,char *)
#define QIOCLDCUR	_IOW(q,2,QIOLocator)
#define QIOOLDCUR	_IOW(q,2,QIOOldLoc)	/* compatibility ioctl */
#define QIOCSHOWCUR	_IO(q,3)
#define QIOCHIDECUR	_IOW(q,4,XBox)

#define QIOCBELL	_IOW(q,5,int)
#define QIOCCLICK	_IOW(q,6,int)
#define QIOCAUTOREP	_IOW(q,7,int)
#define QIOCSETCAPSL	_IO(q,8)
#define QIOCSETNUML	_IO(q,9)
#define QIOCSETSCROLLL	_IO(q,10)
#define QIOCCLRCAPSL	_IO(q,11)
#define QIOCCLRNUML	_IO(q,12)
#define QIOCCLRSCROLLL	_IO(q,13)
#define	QIOCSETSIZE	_IOW(q,14,struct x_screen_size)
#define	QIOCGETSIZE	_IOR(q,15,struct x_screen_size)

# endif _XQEVENT_
