/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	screen_conf.h,v $
 * Revision 2.3  88/10/06  18:29:53  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Fix includes.
 * 
 */ 
#include <cacons/device_base.h>

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: screen_conf.h,v 2.3 88/10/06 18:29:53 sanzi Exp $ */
/* $ACIS:screen_conf.h 9.5$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/screen_conf.h,v $ */

#ifndef lint
static char *rcsidscreen_conf = "$Header: screen_conf.h,v 2.3 88/10/06 18:29:53 sanzi Exp $";
#endif

#ifdef KERNEL
#ifdef ATR
#define PCIF_PASS1	/* Change this to PCIF_PASS1 for the old cards */
#endif ATR

#ifndef makedev
#	include <sys/types.h>
#endif makedev
#ifndef IOWR
#	include <sys/ioctl.h>
#endif IOWR

#ifndef TTIPRI
#	include <sys/tty.h>
#endif TTIPRI

#else

#ifndef makedev
#	include <sys/types.h>
#endif makedev
#ifndef IOWR
#	include <sys/ioctl.h>
#endif IOWR

#endif

#include <cacons/consio.h>

#define C (char *)

#define SCREEN_SWITCH		-1	/* switch to next routine */
#define SCREEN_SWITCH_RELOAD	-2	/* switch screen and reload */
#define SINGLE_HEAD		-3	/* switching not possible */
#define SAME_CONS		-4	/* switching not necessary */
#define SCREEN_SEARCH		-5	/* check for next w/o initiation */

#ifdef ROUND
#undef ROUND
#endif ROUND
#define ROUND(v,m)	m += ((v % m) ? (m - (v % m)) : 0)

#define E_SLOT(u,v)	for (u = 0; (v & (1<<u)); u++)
#define SET_SLOT(u,v)	(v |= (1<<u))
#define CLEAR_SLOT(u,v) (v &= ~(1<<u))

struct screen_sw {
	char	*name;
	int	(*probe)();		/* Probe for Screen */
	int	(*init)();		/* Initialize Screen */
	int	(*s_putc)();		/* Put character on Screen */
	int	(*pos_cur)();		/* Position Cursor on Screen */
	int	(*blank)();		/* Blank A section of Screen */
	int	(*move)();		/* Move Some lines on Screen */
	int	(*printscreen)();	/* routine to print screen */
	char	*rwaddr;		/* Read & writeable addr on screen */
	short	lines;			/* Number of lines on screen */
	short	width;			/* Width of screen in characters */
	short	vbits;			/* Vertical number of screen bits */
	short	hbits;			/* Horizontal number of screen bits */
	int	flags;			/* some flags about the screen */
	int	def_oute;		/* Default output emulator */
	int	(*pos_loc)();		/* Position Locator on Screen */
	int	(*load_loc)();		/* Load Locator description */
	int	(*show_loc)();		/* Show Locator on Screen*/
	int	(*hide_loc)();		/* Hide Locator on Screen */
	int	(*apa_init)();		/* All Points Addressable screen init */
	char	acix_char;		/* Char for displaying logo */
	int	(*color_table)();	/* change color table */
	int	color_entries;		/* number entries in color table */
	int	(*put_status)();	/* put status (smart devs only) */
	char	*addr;			/* screen base address */
};

/* General Defines for emulators to use with the screen_sw structure */
#define WS		si->which_screen
#define SCREEN_LENGTH	(screen_sw[WS].lines)
#define SCREEN_WIDTH	(screen_sw[WS].width)

#ifdef SCREEN_SIZE
#undef SCREEN_SIZE
#endif SCREEN_SIZE
#define SCREEN_SIZE	(SCREEN_LENGTH * SCREEN_WIDTH)

#define STATUS_LINE	(SCREEN_LENGTH - 1)

/* Character Attributes */
#define NORMAL_VIDEO	0x00
#define BLINK		0x01
#define REVERSE_VIDEO	0x02
#define UNDERLINE_VIDEO 0x04
#define HI_INTENSITY	0x08
#define LITERAL_VIDEO	0xff

/* color table values */
#define FOREGROUND_COLOR	0x01
#define BACKGROUND_COLOR	0x00
#define SCREEN_RED		0x04

/* Color Set Flags */
/* color table flags */
#define COLOR_SET		0x00	/* set the color table entry to color */
#define COLOR_FG_INC		0x01	/* increment the fg color table entry */
#define COLOR_FG_DEC		0x02	/* decrement the fg color table entry */
#define COLOR_BG_INC		0x03	/* increment the bg color table entry */
#define COLOR_BG_DEC		0x04	/* decrement the bg color table entry */
#define REVERSE_COLOR		0x05	/* reverse the fg and bg color entries*/
#define CHANGE_DISPLAY_MODE	0x06	/* change display mode		      */
#define ENABLE_BLINK		0x07	/* enable possibility of blink	      */
#define ENABLE_BG_INTENSITY	0x08	/* enable possibility of bg hi intense*/
#define ENABLE_FG_INTENSITY	0x09	/* enable possibility of fg hi intense*/

/* MonoChrome displays are only interested in the high bit of a color */
#define SCREEN_HIGH_BIT 0x80000000

/* Tell the emulator the printf is from the kernel */
#define SCREEN_KERNEL	0x2

/* Define the different display types */
#define	SCREEN_TYPE_NONE	0
#define	SCREEN_TYPE_COLOR	1
#define	SCREEN_TYPE_MONO	2

/* Defines for calling console screen dependant switched routines */

/* Put character 'c' with attribute 'screen_attr' on console */
#ifdef ATR
/* For the ATR version: save the current PC window
 *			set the window for the screen
 *			call the screen specific putc routine
 *			restore previous window
 */
#define screen_putc(c, screen_attr, fg, bg)				\
		{							\
		char *bndary;						\
									\
		bndary = (char *)get_128_window();			\
		set_128_window(screen_addr(WS));			\
		(*screen_sw[WS].s_putc)(c, screen_attr, fg, bg);	\
		set_128_window(bndary); 				\
		}
#endif ATR

#ifdef IBMRTPC
#define screen_putc(c, screen_attr, fg, bg)  \
	(*screen_sw[WS].s_putc) (c, screen_attr, fg, bg)
#endif IBMRTPC

/* put the status out (smart devices only. e.i. aed) */
#define screen_put_status(pos,str) (*screen_sw[WS].put_status)(pos,str)

/* color table select */
#define screen_color_table(entry,red,green,blue,flags) \
	(*screen_sw[WS].color_table)(entry,red,green,blue,flags)

/* Move cursor to x,y position */
#define pos_cursor(x, y) (*screen_sw[WS].pos_cur) (x, y)

/* blank with screen_attribute from start coordinates to end coordinates */
#define screen_blank(s_a, sy, sx, ey, ex, fg, bg) \
		(*screen_sw[WS].blank) (s_a, sy, sx, ey, ex, fg, bg)

/* Macro for blanking a line */
#define blank_line(s_a, line, fg, bg) \
		screen_blank(s_a, line, 0, line, SCREEN_WIDTH-1, fg, bg)

/* move line1 ... line2 to dest */
#define screen_move(l1, l2, dest) (*screen_sw[WS].move) (l1, l2, dest)

/* Position screen locator on screen at x,y position with msbox restriction */
#define pos_locator(x, y, msbox) (*screen_sw[WS].pos_loc) (x, y, msbox)

/* Load a new screen locator discription with msbox restriction */
#define load_locator(c, msbox) (*screen_sw[WS].load_loc) (c, msbox, si)

/* Show screen locator with msbox restriction */
#define show_locator(msbox) (*screen_sw[WS].show_loc) (msbox)

/* Hide screen locator */
#define hide_locator(bounds) (*screen_sw[WS].hide_loc) (bounds)

/* APA Screen init */
#define apa_initialize() (*screen_sw[WS].apa_init) ()

/* Real hardware addresses for the displays */
#define screen_addr(n) screen_sw[n].addr

#define lp_pos_cursor(col,line,dev)	(((line)*screen_sw[(dev)].width)+(col))

#define NO_ENTRY	-1
struct emul_info {
	int emulator;		/* Which Emulator is currently in use */
	int unit;		/* Emulator info unit */
	struct proc *rsel;	/* Process waiting for select */
	short flag;		/* Emulator Flags */
	short intr_reason;	/* Reason for interrupt to emulator */
};
typedef struct emul_info EMUL_INFO;


struct screen_info {
	int which_screen;	/* Which screen is currently in use */
	struct emul_info ine;	/* Input Emulator */
	struct emul_info oute;	/* Output Emulator */
};
typedef struct screen_info SCREEN_INFO;

#define CON_SELECT_SCREEN	_IOWR(c,0,int)
#define CON_GET_SCREEN		_IOR(c,1,int)
#define EIGETD			_IOR(c,2,int)
#define EOGETD			_IOR(c,3,int)
#define EISETD			_IOWR(c,5,int)
#define EOSETD			_IOWR(c,6,int)
#define CON_INIT_SCREEN 	_IOW(c,8,int)
#define CON_GET_FOCUS_CODE	_IOR(c,9,int)
#define CON_SET_FOCUS_CODE	_IOWR(c,10,int)

#if defined(KERNEL) || defined(STANDALONE)
struct screen_sw screen_sw[];
#endif

/* Emulator structures and Definitions */
/*
 * Emulator line control switch.
 */
struct emulsw
{
	int	(*e_open)();
	int	(*e_close)();
	int	(*e_read)();
	int	(*e_write)();
	int	(*e_ioctl)();
	int	(*e_rint)();
	int	(*e_putc)();
	int	(*e_select)();
	int	(*e_putstatus)();	/* to put up status information */
	int	(*e_color_table)();
};

typedef struct
{
	short	data[16];
	short	mask[16];
	struct {
		short v, h;
	} hotSpot;
	unsigned fg;
	unsigned bg;
} QIOLocator;

#ifndef NO_OLD_CURSOR
typedef struct
{
	short	data[16];
	short	mask[16];
	struct {
		short v, h;
	} hotSpot;
} QIOOldLoc;
#endif

typedef struct {
	short	bottom;
	short	top;
	short	left;
	short	right;
	int	flags;
} MSBox;

#ifdef KERNEL
	struct emulsw emulsw[];
	struct tty *cons_tp;
	typedef QIOLocator Locator;
#endif

/* Defines for EMUL_INFO structure intr_reason flag */
#define E_INT_KBD	1		/* Keyboard data */
#define E_INT_MOUSE	2		/* Mouse data */

/* Defines for Emulator indexes */
#define E_STDINPUT	0
#define E_KBDINPUT	0
#define E_STDOUTPUT	1
#define E_IBMOUTPUT	2
#define E_ANSIOUTPUT	3
#define E_XINPUT	4
#define E_BUFOUTPUT	5
#define E_AED		6

#define E_XOUTPUT	E_BUFOUTPUT
#define E_ANDREWOUTPUT	E_BUFOUTPUT

/* Defines for pulling out the screen and emul pack from minor device */
#define MINOR_SCREEN(d) 	(minor(d) & 0x07)
#define MINOR_EMUL(d)		((minor(d) >> 4) & 0x0f)
#define MINOR_BUS(d)		(minor(d) & 0x08)

/* Defines for symbolic minor devices on consoles for emulator(s) selection */
#define CE_DEFAULT	0	/* Must be 0 for standard configuration */
#define CE_X		1	/* X window manager emulators */
