/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	std_emul.c,v $
 * Revision 2.3  88/10/06  18:32:55  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Fix includes.
 * 
 */ 
#include <cacons/device_base.h>

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: std_emul.c,v 2.3 88/10/06 18:32:55 sanzi Exp $ */
/* $ACIS:std_emul.c 9.3$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/std_emul.c,v $ */

#ifndef lint
static char *rcsid = "$Header: std_emul.c,v 2.3 88/10/06 18:32:55 sanzi Exp $";
#endif

#include <sys/param.h>
#include <sys/conf.h>
#include <sys/ioctl.h>
#include <sys/tty.h>

#include <cacons/screen_conf.h>
#include <cacons/consdefs.h>
#include <cacons/std_emul.h>

#include <cacons/kls.h>

#ifdef ATR
#include <ca/io.h>
#endif ATR

int lp_put();

stdoe_open(dev, tp, si)
dev_t dev;
register struct tty *tp;
register SCREEN_INFO *si;
{
	return (0);
}

stde_close(tp, si)
register struct tty *tp;
register SCREEN_INFO *si;
{
	register EMUL_INFO *ei = &si->ine;

	ei->flag = 0;
	ei->unit = 0;
	return (0);
}


stde_ioctl(tp, cmd, addr, si)
register struct tty *tp;
int cmd;
caddr_t addr;
register SCREEN_INFO *si;
{
	return (-1);

}

stde_select(dev, rw, si)
dev_t dev;
int rw;
register SCREEN_INFO *si;
{
	return (ttselect (dev, rw));
}


stde_write(tp, uio, si)
register struct tty *tp;
struct uio *uio;
register SCREEN_INFO *si;
{
	return ((*linesw[tp->t_line].l_write)(tp, uio));
}


/*
 * output a character to the RAW screen
 * we look at the characters passing thru to see if 
 * they are something interesting before passing them through
 */
stde_putc(c, si, kern_flag)
register int c;
register SCREEN_INFO *si;
register kern_flag;
{
	/* Output Emulator Information */

	if (c == 07)
		beep();		/* ring the bell */
	else
		screen_putc (c, LITERAL_VIDEO, 
			FOREGROUND_COLOR, BACKGROUND_COLOR);
	/* log to printer */
	if ((screen_sw[WS].flags & CONSDEV_LOG) && lp_put(si, (c == '\t'?' ':c)))
		screen_sw[WS].flags &= ~CONSDEV_LOG; /* error - stop logging */
}

stde_put_status(si, pos, str)
register SCREEN_INFO *si;
register int pos;
register char *str;
{

/* this is called stde_put_status. The intent is to pass status to whichever
 * of the "smart" devices is the present screen. Presently, aed is the only one.
 * All aed emulation is within the microcode. For now, no switch table is used.
 * Modify by using an emulator switch table. (See the macro definition of
 * screen_putc in screen_conf.h)
 */

	screen_put_status(pos,str);
}

stde_color_table(entry,red,green,blue,flags,si)
unsigned entry,red,green,blue;
int flags;
SCREEN_INFO *si;
{
	screen_color_table(entry,red,green,blue,flags);
}

