/* 
 * Mach Operating System 
 * Copyright (c) 1987 Carnegie-Mellon University 
 * All rights reserved.  The CMU software License Agreement specifies 
 * the terms and conditions for use and redistribution. 
 */ 
/* 
 * HISTORY $Log:	std_emul.h,v $
 * Revision 2.2  88/10/06  18:35:25  sanzi
 * 	Added include of "device_base.h".  Merge with ACIS to minimize differences.
 * 	Fix includes.
 * 
 */ 
#include <cacons/device_base.h>

/* $Header: std_emul.h,v 2.2 88/10/06 18:35:25 sanzi Exp $ */
/* $ACIS:std_emul.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/cacons/std_emul.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidstd_emul = "$Header: std_emul.h,v 2.2 88/10/06 18:35:25 sanzi Exp $";
#endif

#define CTL(x) ('x'&037)	NONE,/* get a control character */

#define NONE	0377			  /* code for no code defined */
#define END	NONE, NONE		  /* no code for end */
#define E ESC_FLAG +

#define ESC_MARK 0x100
#define ALT_MARK 0x80

int debug_key;

static int state, make_break;

#define SHIFT1	0x12
#define SHIFT2	0x59
#define ALT1	0x19
#define ALT2	0x39
#define BREAK	0xf0
#ifdef PC_KEYBOARD
#define CAPS_LOCK 0x11		/* used to be control */
#define CNTRL	0x14		/* used to be shift lock */
#else
#define CAPS_LOCK 0x14		/* key labeled caps lock */
#define CNTRL	0x11		/* key labeled control */
#endif
#define DEBUG_CHAR 0x62
#define PRINT_CHAR 0x57		/* print the screen */
#define ESC_FLAG	0x80	/* generate ESC + character */
#define ALT_FLAG	0x100	/* generate ALT + character */
#define NUM_LOCK 0x76		/* numeric lock */
#define SWITCH_CHAR 0x5f	/* scroll lock */
#define CLICK_CHAR 0x76		/* use num lock as it is useless */
#ifdef ESC2_CHAR
#define ESC1_CHAR	(033 + ESC_MARK)
#else
#define ESC1_CHAR	033
#endif
#define MAX_CODES  133
char codes[(MAX_CODES+1) * 4 ]  = {
/* PLAIN     SHIFTED   CAPSLCK   ALT 	      code	 */
    NONE,     NONE,     NONE,	NONE,	/*   0 0x00	 */
    NONE,     NONE,     NONE,	NONE,	/*   1 0x01	 */
    NONE,     NONE,     NONE,	NONE,	/*   2 0x02	 */
    NONE,     NONE,     NONE,	NONE,	/*   3 0x03	 */
    NONE,     NONE,     NONE,	NONE,	/*   4 0x04	 */
    NONE,     NONE,     NONE,	NONE,	/*   5 0x05	 */
    NONE,     NONE,     NONE,	NONE,	/*   6 0x06	 */
   E 'S',    E 'I',    E 'S',	NONE,	/*   7 0x07	 f1 */
   '\33',    '\33',    '\33',	NONE,	/*   8 0x08	 */
    NONE,     NONE,     NONE,	NONE,	/*   9 0x09	 */
    NONE,     NONE,     NONE,	NONE,	/*  10 0x0a	 */
    NONE,     NONE,     NONE,	NONE,	/*  11 0x0b	 */
    NONE,     NONE,     NONE,	NONE,	/*  12 0x0c	 */
    '\t',     '\b',     '\t',	NONE,	/*  13 0x0d	 */
     '`',      '~',      '`',	NONE,	/*  14 0x0e	 */
   E 'T',    E 'J',    E 'T',	NONE,	/*  15 0x0f	 f2 */
    NONE,     NONE,     NONE,	NONE,	/*  16 0x10	 */
    NONE,     NONE,     NONE,	NONE,	/*  17 0x11	 */
    NONE,     NONE,     NONE,	NONE,	/*  18 0x12	 */
     '<',      '>',      '<',	NONE,	/*  19 0x13	 */
    NONE,     NONE,     NONE,	NONE,	/*  20 0x14	 */
     'q',      'Q',      'Q',	NONE,	/*  21 0x15	 */
     '1',      '!',      '1',	NONE,	/*  22 0x16	 */
   E 'U',    E 'K',    E 'U',	NONE,	/*  23 0x17	 f3 */
    NONE,     NONE,     NONE,	NONE,	/*  24 0x18	 */
    NONE,     NONE,     NONE,	NONE,	/*  25 0x19	 */
     'z',      'Z',      'Z',	NONE,	/*  26 0x1a	 */
     's',      'S',      'S',	NONE,	/*  27 0x1b	 */
     'a',      'A',      'A',	NONE,	/*  28 0x1c	 */
     'w',      'W',      'W',	NONE,	/*  29 0x1d	 */
     '2',      '@',      '2',	NONE,	/*  30 0x1e	 */
   E 'V',    E 'L',    E 'L',	NONE,	/*  31 0x1f	 f4 */
    NONE,     NONE,     NONE,	NONE,	/*  32 0x20	 */
     'c',      'C',      'C',	NONE,	/*  33 0x21	 */
     'x',      'X',      'X',	NONE,	/*  34 0x22	 */
     'd',      'D',      'D',	NONE,	/*  35 0x23	 */
     'e',      'E',      'E',	NONE,	/*  36 0x24	 */
     '4',      '$',      '4',	NONE,	/*  37 0x25	 */
     '3',      '#',      '3',	NONE,	/*  38 0x26	 */
   E 'W',    E 'M',    E 'W',	NONE,	/*  39 0x27	 f5 */
    NONE,     NONE,     NONE,	NONE,	/*  40 0x28	 */
   '\40',    '\40',    '\40',	NONE,	/*  41 0x29	 */
     'v',      'V',      'V',	NONE,	/*  42 0x2a	 */
     'f',      'F',      'F',	NONE,	/*  43 0x2b	 */
     't',      'T',      'T',	NONE,	/*  44 0x2c	 */
     'r',      'R',      'R',	NONE,	/*  45 0x2d	 */
     '5',      '%',      '5',	NONE,	/*  46 0x2e	 */
   E 'P',    E 'N',    E 'P',	NONE,	/*  47 0x2f	 f6 */
    NONE,     NONE,     NONE,	NONE,	/*  48 0x30	 */
     'n',      'N',      'N',	NONE,	/*  49 0x31	 */
     'b',      'B',      'B',	NONE,	/*  50 0x32	 */
     'h',      'H',      'H',	NONE,	/*  51 0x33	 */
     'g',      'G',      'G',	NONE,	/*  52 0x34	 */
     'y',      'Y',      'Y',	NONE,	/*  53 0x35	 */
     '6',      '^',      '6',	NONE,	/*  54 0x36	 */
   E 'Q',    E 'O',    E 'Q',	NONE,	/*  55 0x37	 f7 */
    NONE,     NONE,     NONE,	NONE,	/*  56 0x38	 */
    NONE,     NONE,     NONE,	NONE,	/*  57 0x39	 */
     'm',      'M',      'M',	NONE,	/*  58 0x3a	 */
     'j',      'J',      'J',	NONE,	/*  59 0x3b	 */
     'u',      'U',      'U',	NONE,	/*  60 0x3c	 */
     '7',      '&',      '7',	NONE,	/*  61 0x3d	 */
     '8',      '*',      '8',	NONE,	/*  62 0x3e	 */
   E 'R',    E 'X',    E 'X',	NONE,	/*  63 0x3f	 f8 */
    NONE,     NONE,     NONE,	NONE,	/*  64 0x40	 */
     ',',      '<',      ',',	NONE,	/*  65 0x41	 */
     'k',      'K',      'K',	NONE,	/*  66 0x42	 */
     'i',      'I',      'I',	NONE,	/*  67 0x43	 */
     'o',      'O',      'O',	NONE,	/*  68 0x44	 */
     '0',      ')',      '0',	NONE,	/*  69 0x45	 */
     '9',      '(',      '9',	NONE,	/*  70 0x46	 */
   E 'Y',    E '-',    E 'Y',	NONE,	/*  71 0x47	 f9 */
    NONE,     NONE,     NONE,	NONE,	/*  72 0x48	 */
     '.',      '>',      '.',	NONE,	/*  73 0x49	 */
     '/',      '?',      '/',	NONE,	/*  74 0x4a	 */
     'l',      'L',      'L',	NONE,	/*  75 0x4b	 */
     ';',      ':',      ';',	NONE,	/*  76 0x4c	 */
     'p',      'P',      'P',	NONE,	/*  77 0x4d	 */
     '-',      '_',      '-',	NONE,	/*  78 0x4e	 */
   E '<',    E '>',    E '<',	NONE,	/*  79 0x4f	 f10 */
    NONE,     NONE,     NONE,	NONE,	/*  80 0x50	 */
    NONE,     NONE,     NONE,	NONE,	/*  81 0x51	 */
    '\'',      '"',      '\'',	NONE,	/*  82 0x52	 */
    NONE,     NONE,     NONE,	NONE,	/*  83 0x53	 */
     '[',      '{',      '[',	NONE,	/*  84 0x54	 */
     '=',      '+',      '=',	NONE,	/*  85 0x55	 */
   E '[',    E ']',    E '[',	NONE,	/*  86 0x56	 f11 */
    NONE,     NONE,     NONE,	NONE,	/*  87 0x57	 */
    NONE,     NONE,     NONE,	NONE,	/*  88 0x58	 */
    NONE,     NONE,     NONE,	NONE,	/*  89 0x59	 */
    '\r',     '\r',     '\r',	NONE,	/*  90 0x5a	 */
     ']',      '}',      ']',	NONE,	/*  91 0x5b	 */
    '\\',      '|',      '\\',	NONE,	/*  92 0x5c	 */
    NONE,     NONE,     NONE,	NONE,	/*  93 0x5d	 */
   E ',',    E '.',    E ',',	NONE,	/*  94 0x5e	 f12 */
    NONE,     NONE,     NONE,	NONE,	/*  95 0x5f	 */
   E 'B',    E 'B',    E 'B',	NONE,	/*  96 0x60	 down arrow */
   E 'D',    E 'D',    E 'D',	NONE,	/*  97 0x61	 left arrow */
    NONE,     NONE,     NONE,	NONE,	/*  98 0x62	 */
   E 'A',    E 'A',    E 'A',	NONE,	/*  99 0x63	 up arrow */
  '\177',   '\177',   '\177',	NONE,	/* 100 0x64	 */
   E 'F',    E 'f',    E 'F',	NONE,	/* 101 0x65	 end */
    '\b',     '\b',     '\b',	NONE,	/* 102 0x66	 */
    '\0',   E '\0',   E '\0',	NONE,	/* 103 0x67	 ins */
    NONE,     NONE,     NONE,	NONE,	/* 104 0x68	 */
     '1',      '1',      '1',	NONE,	/* 105 0x69	 */
   E 'C',    E 'C',    E 'C',	NONE,	/* 106 0x6a	 right arrow */
     '4',      '4',      '4',	NONE,	/* 107 0x6b	 */
     '7',      '7',      '7',	NONE,	/* 108 0x6c	 */
   E 'E',    E 'e',    E 'E',	NONE,	/* 109 0x6d	 page down */
   E 'H',    E 'H',    E 'H',	NONE,	/* 110 0x6e	 home */
   E 'G',    E 'g',    E 'G',	NONE,	/* 111 0x6f	 page up */
     '0',      '0',      '0',	NONE,	/* 112 0x70	 */
     '.',      '.',      '.',	NONE,	/* 113 0x71	 */
     '2',      '2',      '2',	NONE,	/* 114 0x72	 */
     '5',      '5',      '5',	NONE,	/* 115 0x73	 */
     '6',      '6',      '6',	NONE,	/* 116 0x74	 */
     '8',      '8',      '8',	NONE,	/* 117 0x75	 */
    NONE,     NONE,     NONE,	NONE,	/* 118 0x76	 */
     '/',      '/',      '/',	NONE,	/* 119 0x77	 */
    NONE,     NONE,     NONE,	NONE,	/* 120 0x78	 */
    '\r',     '\r',     '\r',	NONE,	/* 121 0x79	 enter key */
     '3',      '3',      '3',	NONE,	/* 122 0x7a	 */
    NONE,     NONE,     NONE,	NONE,	/* 123 0x7b	 */
     '+',      '+',      '+',	NONE,	/* 124 0x7c	 */
     '9',      '9',      '9',	NONE,	/* 125 0x7d	 */
     '*',      '*',      '*',	NONE,	/* 126 0x7e	 */
    NONE,     NONE,     NONE,	NONE,	/* 127 0x7f	 */
    NONE,     NONE,     NONE,	NONE,	/* 128 0x80	 */
    NONE,     NONE,     NONE,	NONE,	/* 129 0x81	 */
    NONE,     NONE,     NONE,	NONE,	/* 130 0x82	 */
    NONE,     NONE,     NONE,	NONE,	/* 131 0x83	 */
     '-',      '-',      '-',	NONE,	/* 132 0x84	 */
    NONE,     NONE,	NONE,	NONE,		/* LAST ENTRY	 */
};
