/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/* 18-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added routine softTTY() from ACIS for asy and psp driver support.
 */

#include "sys/param.h"
#include "sys/systm.h"
#include "sys/dir.h"
#include "sys/user.h"
#include "sys/ioctl.h"
#include "sys/tty.h"
#include "sys/proc.h"
#include "sys/inode.h"
#include "sys/file.h"
#include "sys/conf.h"
#include "sys/buf.h"
#include "sys/dk.h"
#include "sys/uio.h"
#include "sys/kernel.h"
#include "caio/cbuf.h"

softTTY()
{
	struct tty * tp; 
	char c;
	int err, s = spl_tty();
	struct cbuf *cbuf;

	TTY_DEQUEUE(&ttyintrq, tp );
	(void) splx(s);
	if ( tp ) {
	    	cbuf = (struct cbuf *) tp->t_addr;
		while ( cbuf->cc > 0 ) {
			s = spl_tty();
			CGET( cbuf, c, err ); 	  /* get character */
			(void) splx(s);
			if ( err ) cbuf->cc = 0;
			(*linesw[tp->t_line].l_rint)(c, tp); /* process it */
		}
	}			

}

