/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * 23-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Created from 4.3 ACIS tty.h.
 */
/*
 * 5799-CGZ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */

#define spl_tty()	spl4()
#define CBUFMAX	1023
struct cbuf {
	int 	cc, first, next;
	char	buf[CBUFMAX];
	struct tty *t_next;		/* next tty in cbuf chain */
	caddr_t	t_addr;			/* driver specific */
};

#define CGET(cbufp, c, e) { \
	if ( (cbufp)->cc > 0 ) { \
		c = (cbufp)->buf[(cbufp)->first++]; \
		if ( (cbufp)->first > CBUFMAX ) (cbufp)->first = 0; \
		(cbufp)->cc--; \
		e = 0; \
	} else e = 1; \
}

#define CPUT(cbufp, c, e) { \
	if ( (cbufp)->cc <= CBUFMAX ) { \
		(cbufp)->buf[(cbufp)->next++] = c; \
		if ( (cbufp)->next > CBUFMAX ) (cbufp)->next = 0; \
		(cbufp)->cc++; \
		e = 0; \
	} else e = 1; \
}

/* ttyqueue is a structure pointing to the head and tail of a queue of
 * tty structures.  These structures have characters in their 
 * circular buffers and are waiting to have them processed.
 */
struct ttyqueue {
	struct tty *head;
	struct tty *tail;
};

struct ttyqueue ttyintrq;  

/* macros to manipulate ttyintrq */

#define TTY_DEQUEUE(ttyq, tq) { \
	(tq) = (ttyq)->head; \
	if ( (tq) ) { \
		(ttyq)->head = ((struct cbuf *)(tq)->t_addr)->t_next; \
		if ( (ttyq)->head  == 0 ) (ttyq)->tail = 0; \
		((struct cbuf *)(tq)->t_addr)->t_next = 0; \
	} \
} 

#define TTY_ENQUEUE(ttyq, tq) { \
	struct cbuf *cbuf = (struct cbuf *) (tq)->t_addr; \
	if ( (cbuf->t_next == 0) && ( (ttyq)->tail != (tq) ) ) { \
		if ( (ttyq)->tail == 0 ) \
		        (ttyq)->head = (tq); \
	        else \
			((struct cbuf *)(ttyq)->tail->t_addr)->t_next = (tq); \
		(ttyq)->tail = (tq); \
	} \
}

