/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	dmareg.h,v $
 * Revision 2.2  88/12/19  02:39:05  mwyoung
 * 	Added TCW_ADDRESS, to describe the address field of a translation
 * 	control word.
 * 	[88/11/29            mwyoung]
 * 
 * 27-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	chnaged dma_spl from _spl3 to spl4.
 *
 */
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $ACIS:dmareg.h 9.0$ */

#include <cmucs.h>

/* Translation Control Word Definitions */
/*
 * TCW's control the translate of the addresses generated by the various
 * adapters to real addresses in memory. For a more complete description
 * see the IBM RT PC Technical Reference Volume I, 74x9961.
 */

#if	CMUCS
/*
 *	Fields within the TCW:
 *		address (bits 0-12):
 *			The real or virtual memory address to which I/O
 *		reserved (bit 13)
 *		IOC (bit 14):
 *			Indicates whether transfer is to real memory or I/O space
 *		real/virtual (bit 15):
 *			Indicates whether the address is real or a virtual
 *			address.  Not all combinations of page/region and
 *			real/virtual are allowed, depending on the controller.
 */
#define	TCW_ADDRESS	((1 << 13) - 1)		/* Address for I/O (mask) */

#define TCW_REAL_ACC	0			/* Real access */
#define TCW_VIRTUAL_ACC	(1 << 15)		/* Virtual access */

#define TCW_RSC_ACC	0			/* RSC access */
#define TCW_IOB_ACC	(1 << 14)		/* IO BUS access */
#else

#define TCW_REAL_ACC              0             /* Real access */
#define TCW_VIRTUAL_ACC      0x8000             /* Virtual access */

#define TCW_RSC_ACC               0             /* RSC access */
#define TCW_IOB_ACC          0x4000             /* IO BUS access */
#endif	CMUCS

#if	CMUCS
/*
 *	How the TCWs are used
 */
#endif	CMUCS

#define TCW_BASE        0xf0010000	      /* TCWs base address */
#define TCW_PAGESIZE	2048		      /* bytes/TCW page mode */
#define TCW_PAGEMASK	(TCW_PAGESIZE-1)      /* page displacement mask */
#define TCW_PAGESHIFT	11		      /* page mode prefix */
#define TCW_REGIONSIZE	(32*1024)	      /* bytes/TCW region mode */
#define TCW_REGIONMASK	(TCW_REGIONSIZE-1)    /* region displacement mask */
#define TCW_REGIONSHIFT	15		      /* region mode prefix */
#define TCW_16BIT	64		      /* number of 16 bit tcw's /channel */
#define TCW_8BIT	(TCW_16BIT/2)	      /* number 8 bit tcw's / channel*/
#define TCW_REGION	(TCW_16BIT*8)	      /* number of region mode tcw's */
#define	TCW_GROUP_SIZE	DMA_MASK_SIZE	      /* group size = number of bits in an unsigned */
#define TCW_GROUPS	(TCW_REGION/TCW_GROUP_SIZE ) /* number of tcw groups (must be <= 32) */
#define TCW(chan,page)	(*(short *)(TCW_BASE + \
		(sizeof(short)*((chan)*TCW_16BIT+(page)))) )
#ifdef REGION
#define TCW_REGION_CHAN	8		      /* tcw region mode tcw "channel" */
#endif

/*
 * Note: not all combinations of ic_flags make sense for all types of
 * dma (page mode vs region mode, system dma vs alternate master dma).
 */

/* 8237 dma controller chip registers
 * DMA controller register
 */

#define DM_CTL1_BASE       0xf0008840        /* Controller 1 base register */

struct dma_8bit_device {
	struct {
		char dm_base;
		char dm_count;
		} dm_chan[4];		/* base /count registers */
	char  dm_cmd;			/* command status */
	char  dm_req;			/* request  register */
	char  dm_smask;			/* single mask */
	char  dm_mode;			/* mode register */
	char  dm_ff;			/* internal flip-flop */
	char  dm_temp_mclr;		/* R:temp reg , W: Master clear */
	char  dm_clr_mask;		/* W:clear mask */
	char  dm_all_mask;		/* W:write all mask reg */
	};


/*
 * Controller_2  registers  (channel 5-7) 16 bit
 *
 */

#define DM_CTL2_BASE       0xf0008860        /*    Controller 2 base register */

struct dma_16bit_device {
	struct {
		char dm_base;		/* 16 bit device registers */
		char dm_fill1;
		char dm_count;	
		char dm_fill2;
		} dm_chan[4];		/* base /count registers */
	char  dm_cmd;			/* command status */
	char  dm_fill3;
	char  dm_req;			/* request  register */
	char  dm_fill4;
	char  dm_smask;			/* single mask */
	char  dm_fill5;
	char  dm_mode;			/* mode register */
	char  dm_fill6;
	char  dm_ff;			/* internal flip-flop */
	char  dm_fill7;
	char  dm_temp_mclr;		/* R:temp reg , W: Master clear */
	char  dm_fill8;
	char  dm_clr_mask;		/* W:clear mask */
	char  dm_fill9;
	char  dm_all_mask;		/* W:write all mask reg */
	char  dm_fill10;
};

/* CRRB bits to enable dma controllers */
#define DM_CTL1_ENABLE          0x28        /*  8 bit controller */
#define DM_CTL2_ENABLE          0x30        /* 16 bit controller */

/* dma_cmd registers */
#define DM_CTLR_ENABLE		0x00
#define DM_CTLR_DISABLE		0x04

#define DM_PRIO_FIXED		0x00
#define DM_PRIO_ROTATE		0x10

#define DM_WR_LATE		0x00
#define DM_WR_EXTEND		0x20

#define DM_CMD_DEFAULT		(DM_CTLR_ENABLE | DM_PRIO_FIXED | DM_WR_EXTEND)

/* dm_mode  */
#define DM_READ		0x4
#define DM_WRITE	0x8
#define DM_MODE_FLAGS	0x00f0	/* modes passed as flags by the user in ic_flags */
#define DM_XFER		0x00c0	/* transfer type bits CASCADE,DEMAND,BLOCK,SINGLE */

/* dm_smask */
#define DM_CHAN_ENABLE  0x0
#define DM_CHAN_DISABLE 0x4

/* channel 8 control */
#define DM_CHAN8_REG	0xf0008c00
#define DM_CHAN8_ENABLE 0x80
#define DM_CHAN8_DISABLE 0x00
#define DM_CHAN8_MASK	(DM_XFER | DMA_REGION)  /* Fixed flags for channel 8 */
#define DM_CHAN8_NEED	(DMA_CASCADE | DMA_REGION) /* What those fixed flags should be */

/* 
 * macros to select controller from channel 
 *
 * NOTE, the test for DMA_CTLR_2 is only valid after the test for
 * DMA_CTLR_1 has failed
 */
#define DMA_CTLR_1(channel)	((channel) < DMA_CHAN4)
#define DMA_CTLR_2(channel)	((channel) != DMA_CHAN8)

/* dma translation mode register setup */
#define DM_MR         0xf00088e0        /* DMA translation mode reg  */
					/* PAGE/REGION */
#define DMA_SET_PAGE_MODE(chan)		(*(char *)DM_MR &= ~(0x80 >> (chan)))
#ifdef REGION
#define DMA_SET_REGION_MODE(chan)	(*(char *)DM_MR |= 0x80 >> (chan))
#endif

/* phys xfer size */
#define DM_MAXPHYS8 	 (TCW_8BIT * TCW_PAGESIZE)
#define DM_MAXPHYS16 	 (TCW_16BIT * TCW_PAGESIZE)
#define DM_MAXPHYSPAGE 	 (TCW_16BIT * TCW_PAGESIZE)
#ifdef REGION
#define DM_MAXPHYSREGION (TCW_REGION * TCW_REGIONSIZE)
#endif

/* dma high bits for page mode alternate controller transfers */
#define DM_HI_BITS	0x00fe0000

#define	spl_dma()	spl4()		/* must inhibit ALL devices */

