/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	fdreg.h,v $
 * Revision 2.2  88/11/23  16:29:40  rpd
 * 	Merged with Acis.
 * 	[88/11/04  17:45:43  rpd]
 * 
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: fdreg.h,v 2.2 88/11/23 16:29:40 rpd Exp $ */
/* $ACIS:fdreg.h 11.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/caio/fdreg.h,v $ */

#ifndef lint
static char *rcsidfdreg = "$Header: fdreg.h,v 2.2 88/11/23 16:29:40 rpd Exp $";
#endif

struct 	fddevice {	
	volatile unsigned char fd_digout; /* 0:   digital output register */
	volatile unsigned char fd_empty;  /* 1:   no register at 0xf00003f3 */
	volatile unsigned char fd_status; /* 2:   status register */
#define	FDSTAT "\20\10RQM\7DIO\6NDM\5CB\4DBD\3DBC\2DBB\1DAB"
#define	FDSTATDAB		0x01	/* device 0 seeking */
#define	FDSTATDBB		0x02	/* device 1 seeking */
#define	FDSTATDIO		0x40	/* data direction */
#define	FDSTATRQM		0x80	/* Request data register */
	volatile unsigned char fd_data;	/* 3:   data register */
	volatile unsigned char fd_fixd;	/* 4:   fixed disk register */
	volatile unsigned char fd_digin; /* 5:   digital input register */
#define	FDNOTREADY		0x80	/* ready bit on fd_digin */
};

/* fd adapter command defines */
#define	FDREAD			0xe6
#define	FDWRITE			0xc5
#define	FDFORMAT 		0x4d
#define	FDSPEC			0x03	/* specify command */
#define	FDREADSTAT 		0x04	/* read status register */
#define	FDSENI			0x08	/* sense interrupt command */
#define	FDREST			0x07	/* reset drive to cylinder 0 */
#define	FDSEEK			0x0f	/* seek to given cyl */

/* fd control register defines */
#define	FDRST			0xfb	/*reset adapter card */
#define	FDMOTORON(slave)	((slave?0x20:0x10)+0x04)
#define	FDMOTOROFF(slave)	(slave?0xdf:0xef)
#define	FDINTENABLE		0x08

/* other hardwar magic numbers */
#define	FDBIT2			2	/* shift to put head # in bit 2 */
#define	FDPATTERN 		0xf6	/* formatting pattern byte */
#define	FDTRACK39		0x2be	/* block # for 39th track of 360K */
#define	FDLOAD			0x02	/* head load time and bit 0=dma data
					 * mode 50ms HLT */
#define FD_MID_POINT		2100	/* midpoint to determin which type
					 * of drive is connected (see fdslave
					 * in fd.c).
					 */
#define	FDMOTORSTART		1000000	/* motor start time in usec (this
					 * number is very pessimistic. It is 
					 * used only at auto config time) 
					 */
#define	FDRECAL			3000000	/* worst case  time to do a recalibrate (from last cylinder) */
