/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* mouse software structures and defines */
struct mouseq {
	struct mouseq	*qp_next;	/* pointer to the next mouse cmd */
	struct klsq	cmd1,cmd2;	/* kls commands */
	int		ms_count;
};

struct ms_softc {
	struct mouseq	*ms_head;	/* head of mouse cmd queue */
	struct mouseq	*ms_tail;	/* tail of mouse cmd queue */
	int		ms_sem;		/* semaphore protects some critical */
					/* sections of mouse code. */
	int		ms_flags;	/* mouse status flags */
	int		msenabled;	/* set if mouse is enabled for input */
	long		ms_rate;	/* last rate mouse set to (used for asyc */
	int		ms_cnt;		/* count of opened mouse streams */
					/* resets) */
	long		ms_resl;		/* last resolution mouse set to (used for */
	int		ms_sunit;
					/* async resets) */
};
#define MS_QUERY	0x2		/* query routine waiting for mouse data */
#define MS_BUSY	0x1		/* query routine using mouse data */
#define MS_NOSTREAM 0x4		/* use remote not streaming mode */
#define MS_EXP	0x8		/* use exponential mode */

#define MSPOOLSZ	10
#define MSPRI		(PZERO+5)

/* following taken from hd.c */
#define	SHOW_CHARS	0x01
#define SHOW_RDWR	0x02
#define SHOW_INTR	0x04
#define SHOW_INIT	0x08
#define SHOW_IO		0x10
#define SHOW_TIMEOUT	0x20		/* show wait */
#define SHOW_REGS	0x40
#define SHOW_OPEN	0x80

#define ISPEED B9600
